/****************************************************************************
    $Id: bitvect.h 501.0 1995/03/07 12:26:40 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:	Tarma Library for C++ V5.0
    Author:	Ron van der Wal

    Declaration of class TLBitVector.

    $Log: bitvect.h $
    Revision 501.0  1995/03/07 12:26:40  RON
    Updated for TLX 5.01
    Revision 1.5  1995/01/31 16:29:16  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.4  1994/11/16  15:19:24  ron
    Changed back to size_t indices

    Revision 1.3  1994/09/27  20:24:50  ron
    Changed path separator from / to \

    Revision 1.2  1994/09/26  15:14:52  ron
    Moved inline functions to the bottom of the file

    Revision 1.1  1994/08/16  18:06:44  ron
    Initial revision

****************************************************************************/

#ifndef _TLX_BITVECT_H
#define _TLX_BITVECT_H

#ifndef _TLX_TLX_H
#include <tlx\501\tlx.h>
#endif

class _RTLCLASS ostream;

/*---------------------------------------------------------------------------
    TLBitVector -

    Represents a resizable vector of bits. Individual bit indexing starts
    at 0 and continues up to Size() - 1.
---------------------------------------------------------------------------*/

class _TLXCLASS TLBitVector
{
    // The bitvector is stored as a byte array.

    byte_t *		mVector;	// Actual bit vector
    size_t		mVectSize;	// Size in bytes
    size_t		mBitSize;	// Size in bits

public:
    // Constructors and destructor

    TLBitVector(size_t = 0);
    TLBitVector(const char *);
    TLBitVector(const TLBitVector &);
    ~TLBitVector();

    // Operator overloadings for BitVectors. Unary/assignment versions are
    // member functions and return a reference to the current TLBitVector;
    // binary operations are implemented as friends returning a new
    // TLBitVector. If you care about efficiency, you should use the
    // assignment versions.

    TLBitVector &	operator =(const TLBitVector &);
    TLBitVector &	operator &=(const TLBitVector &);
    TLBitVector &	operator ^=(const TLBitVector &);
    TLBitVector &	operator |=(const TLBitVector &);
    bool 		operator [](size_t bit) const { return Test(bit); }

    friend TLBitVector 	_TLXFUNC operator ~(const TLBitVector &);
    friend TLBitVector 	_TLXFUNC operator &(const TLBitVector &,
    					    const TLBitVector &);
    friend TLBitVector 	_TLXFUNC operator ^(const TLBitVector &,
    					    const TLBitVector &);
    friend TLBitVector 	_TLXFUNC operator |(const TLBitVector &,
    					    const TLBitVector &);
    friend bool	       	_TLXFUNC operator ==(const TLBitVector &,
    					     const TLBitVector &);
    friend bool	       	_TLXFUNC operator !=(const TLBitVector &,
    					     const TLBitVector &);

    // Operations on the bits in the TLBitVector. Each operation comes in
    // three flavors:
    //
    // - without arguments: operates on the entire bitvector
    // - with a single argument: operates on that bit only
    // - with two arguments: operates on that bit range (inclusive)
    //
    // - Invert() inverts bits
    // - Reset() sets bits to 0
    // - Set() sets bits to 1
    // - Test() returns the number of '1' bits in the given range

    void		Invert();
    void		Invert(size_t);
    void		Invert(size_t, size_t);
    void		Reset();
    void		Reset(size_t);
    void		Reset(size_t, size_t);
    void		Set();
    void		Set(size_t);
    void		Set(size_t, size_t);
    size_t		Test() const;
    size_t		Test(size_t) const;
    size_t		Test(size_t, size_t) const;

    // Functions to obtain the index of the lowest and highest '1' bits

    size_t      		First() const;
    size_t      		Last() const;
    bool		IsEmpty() const;

    // Functions to get the current size of the vector, and to resize it.
    // The size is expressed in number of bits.

    size_t		Size() const { return mBitSize; }
    void		Resize(size_t);
    bool 		IsValidIndex(size_t) const;

    friend ostream & 	_TLXFUNC operator <<(ostream &, const TLBitVector &);
};

#endif	// _TLX_BITVECT_H
