/****************************************************************************
    $Id: assoc.h 501.0 1995/03/07 12:26:40 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:	Tarma Library for C++ V5.0
    Author:	Ron van der Wal

    Declarations of classes TLAssoc<K,V> and TLDictionary<K,V>.

    $Log: assoc.h $
    Revision 501.0  1995/03/07 12:26:40  RON
    Updated for TLX 5.01
    Revision 1.7  1995/01/31 16:29:14  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.6  1994/10/12  10:06:57  ron
    Moved template source code to a separate file
    Changed base for TLDictIter<K,V>

    Revision 1.5  1994/10/11  19:06:33  ron
    Added dictionary iterator
    Made dictionary keys and values private

    Revision 1.4  1994/09/28  14:25:05  ron
    Removed Macintosh-style #include references

    Revision 1.3  1994/09/27  20:24:49  ron
    Changed path separator from / to \

    Revision 1.2  1994/09/26  15:14:30  ron
    Changed include file references

    Revision 1.1  1994/08/16  18:06:44  ron
    Initial revision

****************************************************************************/

#ifndef _TLX_ASSOC_H
#define _TLX_ASSOC_H

#ifndef _TLX_ARRAYS_H
#include <tlx\501\arrays.h>
#endif
#ifndef _TLX_ITER_H
#include <tlx\501\iter.h>
#endif

/*---------------------------------------------------------------------------
    TLAssoc<K,V> -

    Association between a key type K and a value type V.
---------------------------------------------------------------------------*/

template<class K, class V> class TLAssoc
{
    K 			mKey;
    V 			mValue;

public:
    TLAssoc() {}
    TLAssoc(const K &k, const V &v): mKey(k), mValue(v) {}

    K &			Key() { return mKey; }
    const K &		Key() const { return mKey; }
    V &			Value() { return mValue; }
    const V &		Value() const { return mValue; }

    friend int 		operator ==(const TLAssoc<K,V> &, const TLAssoc<K,V> &);
    friend int 		operator ==(const TLAssoc<K,V> &, const K &);
    friend int 		operator ==(const K &, const TLAssoc<K,V> &);

    friend ostream &	operator <<(ostream &, const TLAssoc<K,V> &);
};

/*---------------------------------------------------------------------------
    TLDictionary<K,V> -

    TLDictionary with keys of type K and values of type V.
---------------------------------------------------------------------------*/

template<class K, class V> class TLDictIter;

template<class K, class V> class TLDictionary
{
    friend class TLDictIter<K,V>;

    TLSeq<K> 		mKeys;
    TLSeq<V> 		mValues;

public:
    TLDictionary(size_t size, size_t delta);

    size_t		Count() const;
    bool 		Contains(const K &) const;
    void 		Insert(const K &, const V &);
    void		RemoveAll();
    V &			operator [](const K &);
    const V &		operator [](const K &) const;

    friend ostream &	operator <<(ostream &, const TLDictionary<K,V> &);
};

/*---------------------------------------------------------------------------
    TLDictionary<K,V> -

    TLDictionary with keys of type K and values of type V.
---------------------------------------------------------------------------*/

template<class K, class V> class TLDictIter: public TLValueIter<V>
{
    TLDictionary<K,V> &	mDict;
    index_t		mPos;

public:
    TLDictIter(TLDictionary<K,V> &);

    // A dictionary iterator allows access to both the key and the value
    // at the current iterator position; the inherited Peek() function
    // corresponds to the value.

    K &			PeekKey() const;
    virtual V &		Peek() const;

    // Overridden iterator functions

    virtual size_t	Count() const;
    virtual bool	Contains(V &);

private:
    // Overridden implementation functions

    virtual bool	FirstPos();
    virtual bool	NextPos();
};

#endif	// _TLX_ASSOC_H
