/****************************/ 
/*  CMD DE CONEXION TCP/IP  */
/****************************/ 

Main:

signal on Halt

/* Cargar el paquete de funciones si es necesario */
if RxFuncQuery("SysLoadFuncs") then
   do
      rc = RxFuncAdd("SysLoadFuncs", "RexxUtil", "SysLoadFuncs")
      rc = SysLoadFuncs()
   end

/* Cargar el paquete de sockets si es necesario */
if RxFuncQuery("SockLoadFuncs") then
   do
      rc = RxFuncAdd("SockLoadFuncs", "RxSock", "SockLoadFuncs")
      rc = SockLoadFuncs()
   end

/* Cargar el paquete de funciones COMPAQ si es necesario */
if RxFuncQuery("CpqLoadFuncs") then
do
   rc = RxFuncAdd("CpqLoadFuncs", "BBVA_CTI", "CpqLoadFuncs")
   rc = CpqLoadFuncs()
end

/* Inicializar Sockets */
rc = SockInit()
if (rc = -1) then
   do
     rc = REXXWriteLOG("Error en la llamada a SockInit: " || errno)
     return -1
   end

/* Crear el socket */
s = SockSocket("AF_INET", "SOCK_STREAM", 0)
if (s = -1) then
   do
     rc = REXXWriteLOG("Error en la llamada SockSocket:" || errno)
     return -1
   end

/* Asociar el puerto al socket */
client.!family = "AF_INET"
client.!addr = arg(1)   
client.!port = arg(2)   


/* Conectar a un servidor */
rc = SockConnect(s, "client.!")
if (rc = -1) then
   do
     rc = REXXWriteLOG("Error en llamada a SockConnect: " || errno)
     return -1
     Call Halt
   end

rc = SockSetSockOpt(s, "SOL_SOCKET", "SO_KEEPALIVE", 0)
if (rc = -1) then
   do
     rc = REXXWriteLOG("Escucha_MW: Error en llamada a SockSetSockOpt: " || errno)
   end

return s

Halt:

if datatype(s, "W") then
   rc = SockShutDown(s, 2)

if datatype(s, "W") then
   rc = SockSoClose(s)

return -1


