/*-----------------------------------------------------------------------*/
/*                                                                       */
/*  SI_1880.CMD                                                          */
/*                                                                       */
/*                                                                       */
/*  Graba el fichero \TFMAPPL\SERVERS\FILES\OFIC1880.CFG                 */
/*  con "000000000" para que la oficina en cuestin s tenga             */
/*  control de colas, esto es, que ejecute automticamente la            */
/*  transaccin 1880.                                                    */
/*                                                                       */
/*                                                                       */
/*  PARMETROS:                                                          */
/*     No hay parmetros.                                                */
/*                                                                       */
/*  RETORNOS:                                                            */
/*     0 - Finalizacin correcta                                         */
/*     1 - Error de escritura                                            */
/*                                                                       */
/*  FORMATO FICHERO:                                                     */
/*          SALIDA:                                                      */
/*                  Nombre                                               */
/*                  $DIR_TFMAPPL&'\SERVERS\FILES\OFIC1880.CFG'           */
/*                  Formato:                                             */
/*                     bbbbooooc                                         */
/*                           controlador                              */
/*                          oficina                                    */
/*                        banco                                         */
/*                  Contenido:                                           */
/*                     000000000                                         */
/*                                                                       */
/*  FUNCIONALIDAD                                                        */
/*     - Obtener directorio "TFMAPPL"                                    */
/*     - Grabar "000000000" en $TFMAPPL\SERVERS\FILES\OFIC1880.CFG       */
/*     - Cerrar fichero                                                  */
/*                                                                       */
/*  VERSIONES:                                                           */
/*                                                                       */
/*    1.00 (13/03/98) - Versin inicial                                  */
/*                                                                       */
/*-----------------------------------------------------------------------*/

say '*******************************************************************************'
say '***                                                                         ***'
say '***  Procedimiento que habilita el tratamiento automtico de la transaccin ***'
say '***                     1880 para el control de colas.                      ***'
say '***                                                                         ***'
say '*******************************************************************************'

call rxfuncadd sysloadfuncs,rexxutil,sysloadfuncs
call sysloadfuncs

Version = '1.00'
ret_code = Initialize()


/***************************************/
/* Obtener unidad y directorio TFMAPPL */
/***************************************/

SourceFile=Value('DIR_TFMAPPL',,'OS2ENVIRONMENT')||'\SERVERS\FILES\OFIC1880.CFG'
say 'El fichero de control es 'SourceFile
say ''


/********************/
/* Comenzar proceso */
/********************/

call SysFileTree SourceFile,'archivo','F'
if archivo.0 <> 0 then '@del' SourceFile '1>nul 2>&1'
say 'Grabando ''000000000''... '
say

linea_salida='000000000'
if lineout( SourceFile, linea_salida ) = 1 then
      do
         say 'ERROR GRABANDO EN' SourceFile
         return RC_WRITE
      end


/*******************/
/* Cerrar ficheros */
/*******************/

call lineout SourceFile
say ''
say 'Esta oficina tendr control de colas.'
say ''
say ' Proceso terminado correctamente !!'
say ''


return RC_OK

/*----------------------------------------------------------------------*/

Initialize:

   say 'SI_1880' Version
   say ''

   /* Inicializar cdigos de retorno */
   RC_OK        = 0
   RC_WRITE     = 1
   return RC_OK
