/*-----------------------------------------------------------------------*/
/*                                                                       */
/*  QU_1880.CMD                                                          */
/*                                                                       */
/*                                                                       */
/*  Chequea si en el fichero \TFMAPPL\SERVERS\FILES\OFIC1880.CFG         */
/*  existe el "Banco-Oficina-Controlador" correspondiente a la oficina   */
/*  donde se ejecuta este procedimiento.  Si existe, esta oficina NO     */
/*  tendr control de colas; si no existe, tendr control de colas.      */
/*                                                                       */
/*                                                                       */
/*  PARMETROS:                                                          */
/*     No hay parmetros.                                                */
/*                                                                       */
/*  RETORNOS:                                                            */
/*     0 - Finalizacin correcta                                         */
/*         - Oficina CON control de colas (TRN 1880)                     */
/*         - Oficina SIN control de colas (TRN 1880)                     */
/*     1 - Error de lectura                                              */
/*     2 - Error.  Fichero no existe                                     */
/*                                                                       */
/*  FORMATO FICHERO:                                                     */
/*                  Nombre:                                              */
/*                  $DIR_TFMAPPL&'\SERVERS\FILES\OFIC1880.CFG'           */
/*                  Formato:                                             */
/*                     bbbbooooc                                         */
/*                           controlador                              */
/*                          oficina                                    */
/*                        banco                                         */
/*                                                                       */
/*  FUNCIONALIDAD                                                        */
/*     - Obtener directorio "TFMAPPL"                                    */
/*     - Leer $TFMAPPL\SERVERS\FILES\OFIC1880.CFG y buscar               */
/*       estos datos extrados del \TFMAPPL\SERVERS\FILES\BBV.INI:       */
/*                    codigo_banco_CSB                                   */
/*                    numero_oficina                                     */
/*                    numero_controlador                                 */
/*       - hasta fin de fichero o encontrar registro con estos datos.    */
/*     - Cerrar fichero                                                  */
/*                                                                       */
/*  VERSIONES:                                                           */
/*                                                                       */
/*    1.00 (17/03/98) - Versin inicial                                  */
/*                                                                       */
/*-----------------------------------------------------------------------*/

say '*******************************************************************************'
say '***                                                                         ***'
say '***      Procedimiento que chequea si esta oficina tiene contemplado el     ***'
say '*** tratamiento automtico de la transaccin 1880 para el control de colas. ***'
say '***                                                                         ***'
say '*******************************************************************************'

call rxfuncadd sysloadfuncs,rexxutil,sysloadfuncs
call sysloadfuncs

Version = '1.00'
ret_code = Initialize()


/***************************************/
/* Obtener unidad y directorio TFMAPPL */
/***************************************/

SourceFile=Value('DIR_TFMAPPL',,'OS2ENVIRONMENT')||'\SERVERS\FILES\OFIC1880.CFG'
say 'El fichero de control es 'SourceFile
say ''


/*********************************/
/* Obtener ubicacin del BBV.INI */
/*********************************/

ofi_ini=Value('CONFIG_OFIC',,'OS2ENVIRONMENT')
apl='GENERAL_OF'


/******************************************************/
/* Leer fichero BBV.INI para saber el codigo de banco */
/******************************************************/

banco=Sysini(ofi_ini,apl,"codigo_banco_CSB")
banco=left(banco,length(banco)-1)


/********************************************************/
/* Leer fichero BBV.INI para saber el nmero de oficina */
/********************************************************/

oficina=Sysini(ofi_ini,apl,"numero_oficina")
oficina=left(oficina,length(oficina)-1)


/************************************************************/
/* Leer fichero BBV.INI para saber el nmero de controlador */
/************************************************************/

controlador=Sysini(ofi_ini,apl,"numero_controlador")
controlador=left(controlador,length(controlador)-1)


/********************/
/* Comenzar proceso */
/********************/


rc=stream(SourceFile,'c','Query Exists')
if rc = '' then
   do
      say 'Fichero 'SourceFile 'no existe'
      return RC_OPEN
   end


say 'Buscando 'banco||oficina||controlador'...'
say

linea_buscada=banco||oficina||controlador
cont_lineas=0
control_de_colas='SI'

do while lines( SourceFile )

   linea_leida = linein( SourceFile )
   cont_lineas = cont_lineas + 1
   call charout ,'Procesando lnea nmero 'cont_lineas D2C(13)

   posicion = pos(linea_buscada,linea_leida)
   if posicion = 0 then iterate

   control_de_colas='NO'
   leave

end


/******************/
/* Cerrar fichero */
/******************/

call lineout SourceFile
say '                              '
say 'Esta oficina 'control_de_colas' tiene control de colas.'
say ''
say ' Proceso terminado correctamente !!'
say ''


return RC_OK

/*----------------------------------------------------------------------*/

Initialize:

   say 'QU_1880' Version
   say ''

   /* Inicializar cdigos de retorno */
   RC_OK        = 0
   RC_WRITE     = 1
   RC_OPEN      = 2
   return RC_OK
