/*-----------------------------------------------------------------------*/
/*                                                                       */
/*  NO_1880.CMD                                                          */
/*                                                                       */
/*                                                                       */
/*  Graba el fichero \TFMAPPL\SERVERS\FILES\OFIC1880.CFG                 */
/*  con "Banco-Oficina-Controlador" correspondiente a la oficina en      */
/*  cuestin para que no tenga control de colas, esto es, que no se      */
/*  ejecute automticamente la transaccin 1880.                         */
/*                                                                       */
/*                                                                       */
/*  PARMETROS:                                                          */
/*     No hay parmetros.                                                */
/*                                                                       */
/*  RETORNOS:                                                            */
/*     0 - Finalizacin correcta                                         */
/*     1 - Error de escritura                                            */
/*                                                                       */
/*  FORMATO FICHERO:                                                     */
/*          SALIDA:                                                      */
/*                  Nombre                                               */
/*                  $DIR_TFMAPPL&'\SERVERS\FILES\OFIC1880.CFG'           */
/*                  Formato:                                             */
/*                     bbbbooooc                                         */
/*                           controlador                              */
/*                          oficina                                    */
/*                        banco                                         */
/*                  Contenido:                                           */
/*                     Los propios de la oficina donde se ejecute        */
/*                     este procedimiento.                               */
/*                                                                       */
/*  FUNCIONALIDAD                                                        */
/*     - Obtener directorio "TFMAPPL"                                    */
/*     - Grabar en $TFMAPPL\SERVERS\FILES\OFIC1880.CFG                   */
/*       estos datos extrados del \TFMAPPL\SERVERS\FILES\BBV.INI:       */
/*                    codigo_banco_CSB                                   */
/*                    numero_oficina                                     */
/*                    numero_controlador                                 */
/*     - Cerrar fichero                                                  */
/*                                                                       */
/*  VERSIONES:                                                           */
/*                                                                       */
/*    1.00 (13/03/98) - Versin inicial                                  */
/*                                                                       */
/*-----------------------------------------------------------------------*/

say '*******************************************************************************'
say '***                                                                         ***'
say '***      Procedimiento que DEShabilita el tratamiento automtico de la      ***'
say '***               transaccin 1880 para el control de colas.                ***'
say '***                                                                         ***'
say '*******************************************************************************'

call rxfuncadd sysloadfuncs,rexxutil,sysloadfuncs
call sysloadfuncs

Version = '1.00'
ret_code = Initialize()


/***************************************/
/* Obtener unidad y directorio TFMAPPL */
/***************************************/

SourceFile=Value('DIR_TFMAPPL',,'OS2ENVIRONMENT')||'\SERVERS\FILES\OFIC1880.CFG'
say 'El fichero de control es 'SourceFile
say ''


/*********************************/
/* Obtener ubicacin del BBV.INI */
/*********************************/

ofi_ini=Value('CONFIG_OFIC',,'OS2ENVIRONMENT')
apl='GENERAL_OF'


/******************************************************/
/* Leer fichero BBV.INI para saber el codigo de banco */
/******************************************************/

banco=Sysini(ofi_ini,apl,"codigo_banco_CSB")
banco=left(banco,length(banco)-1)


/********************************************************/
/* Leer fichero BBV.INI para saber el nmero de oficina */
/********************************************************/

oficina=Sysini(ofi_ini,apl,"numero_oficina")
oficina=left(oficina,length(oficina)-1)


/************************************************************/
/* Leer fichero BBV.INI para saber el nmero de controlador */
/************************************************************/

controlador=Sysini(ofi_ini,apl,"numero_controlador")
controlador=left(controlador,length(controlador)-1)


/********************/
/* Comenzar proceso */
/********************/

call SysFileTree SourceFile,'archivo','F'
if archivo.0 <> 0 then '@del' SourceFile '1>nul 2>&1'
say 'Grabando 'banco||oficina||controlador'...'
say

linea_salida=banco||oficina||controlador
if lineout( SourceFile, linea_salida ) = 1 then
      do
         say 'ERROR GRABANDO EN' SourceFile
         return RC_WRITE
      end

/*******************/
/* Cerrar ficheros */
/*******************/

call lineout SourceFile
say ''
say 'Esta oficina NO tendr control de colas.'
say ''
say ' Proceso terminado correctamente !!'
say ''


return RC_OK

/*----------------------------------------------------------------------*/

Initialize:

   say 'NO_1880' Version
   say ''

   /* Inicializar cdigos de retorno */
   RC_OK        = 0
   RC_WRITE     = 1
   return RC_OK
