/***********************************/ 
/*     SERVIDOR LOCAL TCP/IP       */
/*    Recibe peticiones del MW     */
/***********************************/ 

Main:

/* trace('?I') */

signal on Halt

/* Cargar el paquete de funciones si es necesario */
if RxFuncQuery("SysLoadFuncs") then
do
   rc = RxFuncAdd("SysLoadFuncs", "RexxUtil", "SysLoadFuncs")
   rc = SysLoadFuncs()
end

/* Cargar el paquete de sockets si es necesario */
if RxFuncQuery("SockLoadFuncs") then
do
   rc = RxFuncAdd("SockLoadFuncs", "RxSock", "SockLoadFuncs")
   rc = SockLoadFuncs()
end

/* Cargar el paquete de funciones COMPAQ si es necesario */
if RxFuncQuery("CpqLoadFuncs") then
do                                                       
   rc = RxFuncAdd("CpqLoadFuncs", "BBVA_CTI", "CpqLoadFuncs")
   rc = CpqLoadFuncs()
end

/* Nivel de LOG definido en la DLL */
Verbose = REXXGetVerbose()

/* Identifica este proceso frente a los dems que acceden a la DLL */
/* y registra el PID del CMD */
rc = REXXInit()
if (rc = -1) then
do
  if Verbose >= 1 then
     rc = REXXWriteLOG("Escucha_MW: Ya hay una instancia de ESCUCHA_MW.CMD")
  exit
end


/*Linea = 'OFF'*/
Linea = 'INIT'

/* Inicializar Sockets */
rc = SockInit()
if (rc = -1) then
do
  if Verbose >= 1 then
     rc = REXXWriteLOG("Escucha_MW: Error en la llamada a SockInit: " || errno)
  exit
end

/* Datos del socket */
compaq.ini = value('DIR_CONFIGS', , 'OS2ENVIRONMENT')
compaq.ini = compaq.ini || 'COMPAQ.INI'

server.!port = LeerIni(compaq.ini, 'NETCALL', 'MW_IP_Port')
server.!addr = LeerIni(compaq.ini, 'NETCALL', 'MW_IP_Dir')

/*
server.!port = 10100
server.!addr = "10.0.199.223"
*/

if Verbose >= 5 then
do
   rc = REXXWriteLOG('Direccin IP: ' || server.!addr)
   rc = REXXWriteLOG('Puerto IP: ' || server.!port)
end

if ((server.!port = "ERROR:") | (server.!addr = "ERROR:")) then
do
  if Verbose >= 1 then
     rc = REXXWriteLOG("Escucha_MW: Error en la lectura del INI: " || compaq.ini)
  exit
end

rc = ReintentarConexion()

do forever
   rc = ProcesaRespuestas()

   /* Recibida trama vaca */
   if (rc = -97) then
   do
     if Verbose >= 1 then
        rc = REXXWriteLOG("Escucha_MW: Recv vaco")

     if datatype(s, "W") then
        rc = SockShutDown(s, 2)

     if datatype(s, "W") then
        rc = SockSoClose(s)

     rc = ReintentarConexion()
   end

   /* Error al procesar la trama */
   if (rc = -98) then
   do
     if Verbose >= 1 then
        rc = REXXWriteLOG("Escucha_MW: Error en el proceso de la trama: " || errno)
   end

   /* Error en el Receive */
   if (rc = -99) then
   do
     if Verbose >= 1 then
        rc = REXXWriteLOG("Escucha_MW: Error en Recv: " || errno)

     if datatype(s, "W") then
        rc = SockShutDown(s, 2)

     if datatype(s, "W") then
        rc = SockSoClose(s)

     rc = ReintentarConexion()
   end
end 

exit


/*****************************/
/* Rutina de cierre ordenado */
/*****************************/

Halt:

   rc = REXXWriteLOG('Escucha_MW: Entrando en Halt')

   if datatype(s, "W") then
      rc = SockShutDown(s, 2)

   if datatype(s, "W") then
      rc = SockSoClose(s)

   rc = REXXWriteLOG('Escucha_MW: Cerrado socket ' || rc)
   if (rc = -1) then 
      rc = REXXWriteLOG('Escucha_MW: Error Cierre del Socket: ' || errno)

   rc = SysDropFuncs()

   rc = CpqDropFuncs()

   rc = SockDropFuncs()

exit


/*****************************************/
/* Rutina de reintento de conexin al MW */
/*****************************************/

ReintentarConexion:

   do forever
      Logon = REXXEstadoLogon()
if Verbose >= 1 then
  rc = REXXWriteLOG('Escucha_MW: Estado de Logon: ' || Logon)
      if (Logon <> 'OFF') then
      do
         if Verbose >= 3 then
            rc = REXXWriteLOG('Escucha_MW: Reintentando la conexin...' || TIME())
   
         /* Crear el socket */
         s = REXXCreaSocket(server.!addr, server.!port)
         if (s = -1) then
         do
           if Linea <> 'OFF' then
           do
              /* Puede ser 'OFF'  '' */
              /* Slo cuando cambia el estado de la lnea, lo notifico a TFM */
              if Verbose >= 3 then
                 rc = REXXWriteLOG('Escucha_MW: Proceso OFF')
              rc = REXXNotifyOFF()
           end
  
           Linea = 'OFF'
           if Verbose >= 2 then
              rc = REXXWriteLOG("Escucha_MW: Error en llamada a CreaSocket: " || errno)
         end
         else 
         do
           if Linea = 'OFF' | Linea = 'INIT' then 
           do
              /* Slo cuando cambia el estado de la lnea, lo notifico a TFM */
              if Verbose >= 3 then
                 rc = REXXWriteLOG('Escucha_MW: Proceso ON')
              rc = REXXNotifyON()
           end
   
           Linea = 'ON'
           if Verbose >= 2 then
              rc = REXXWriteLOG("Escucha_MW: Socket creado: " || s)
           return 0
         end
      end

      call SysSleep(5)
   end 

return


/********************************************/
/* Rutina de procesamiento de tramas del MW */
/********************************************/

ProcesaRespuestas:

   do forever
      if Verbose >= 5 then
         rc = REXXWriteLOG("Escucha_MW: Antes de recibir " || data)

      rc = SockRecv(s, "data", 4096)
      if (rc <= 0) then 
      do
        if Linea <> 'OFF' then
        do
           /* Puede ser 'OFF'  '' */
           /* Slo cuando cambia el estado de la lnea, lo notifico a TFM */
           if Verbose >= 3 then
              rc = REXXWriteLOG('Escucha_MW: Proceso OFF')
           rc = REXXNotifyOFF()
        end

        Linea = 'OFF'
        if Verbose >= 1 then
           rc = REXXWriteLOG("Escucha_MW: Error en llamada a SockRecv: " || errno)
        return -99
      end

      if Verbose >= 5 then
         rc = REXXWriteLOG("Escucha_MW: Recibido " || data)

      if data = '' then
         return -97

      /* Procesa la trama recibida del MiddleWare */
      rc = REXXProcesaTrama(data)
      if (rc = -1) then
      do
        if Verbose >= 1 then
           rc = REXXWriteLOG("Escucha_MW: Error en el proceso de la trama: " || errno)
        return -98
      end
      /* 28-9-2000 */
      if (rc = -2) then
      do
        if Verbose >= 1 then
           rc = REXXWriteLOG("Escucha_MW: Trama de desconexin. Se va a cerrar el socket...")
        Linea = 'OFF'
      end
      /* 28-9-2000 */

      if Verbose >= 5 then
         rc = REXXWriteLOG("Escucha_MW: ProcesaTrama: " || rc)

      data = ''
   end

return 0


/***********/
/* LeerIni */
/***********/

LeerIni: procedure
parse arg Fich, App, Key

  Asciiz = SysIni(Fich, App, Key)
  if Asciiz \= 'ERROR:' then
  do
     Asciiz = Left(Asciiz, Length(Asciiz) - 1)
  end

return Asciiz

