/*******************************************************************/
/* Programa: CCSOCKET.CMD                                          */
/* Autor: Olga Bravo                                               */
/* Fecha: Enero - 2000                                             */
/* Descripcion:                                                    */
/*    Programa CMD que se ejecuta en el comienzo.cmd y se queda    */
/* en ejecucion hasta la finalizacion del puesto.                  */
/* El programa abre un socket en el puerto 900 porque el que       */
/* recibir peticiones Html de la IVR. A travs de este sistema el  */
/* puesto recibe la identificacin y el pin del cliente proveniente*/
/* de la IVR. En caso de ir todo bien se devuelve una pgina html  */
/* con OK, pero en caso de que el nombre de la pgina pedida no sea*/
/* llamada.htm se devuelve error.                                  */
/*******************************************************************/
/*               Modificacin para perodo de Integracin          */
/* Autor: Victoria Gmez                                           */
/* Fecha: Marzo - 2000                                             */
/* Descripcin:                                                    */
/*   Se modifica el programa para tener en cuenta que se pueden    */
/* recibir mensajes de la IVR y de un puesto de Argentaria tras    */
/* identificar al cliente. Por esto es necesario controlar los     */
/* parametros que se reciben:                                      */
/* Identificacion (12) + ? + ? --> IVR BBV                         */
/* DNI(10)+ OKP + ?  --> Puesto Argentaria                         */
/* Una vez se determina de donde proviene el mensaje se grabar    */
/* tanto el tipo de este (BTB o BTA) como los datos asociados en   */
/* el buzon para que la aplicacin de Banca Telefonica recoja los  */
/* y lance las transacciones correspondientes.                     */
/*******************************************************************/

Main:

 signal on halt

 /*****************************
  Inicializar el fichero de log
  *****************************/
 Entorno    = 'OS2ENVIRONMENT'
 TMP = VALUE('TMP' ,, Entorno )
 FicheroLOG = TMP || '\CCSOCKET.LOG'

 /*************************************************
  Si existe el fichero log lo borramos para empezar
  de nuevo.
  *************************************************/
 existe = stream(FicheroLOG,'c','query exists')
 if (existe <> "") then
  'del '  FicheroLOG

 MensajeLOG = '--------------------------------- Inicio del programa--------------------------------- '
 Call EscribeLOG MensajeLOG

/********************************************
 Cargar el paquete de funciones si es necesario
 *********************************************/

if RxFuncQuery("SysLoadFuncs") then
   do
     rc = RxFuncAdd("SysLoadFuncs","RexxUtil","SysLoadFuncs")
     rc = RxFuncAdd("SysIni","RexxUtil","SysIni")
     rc = SysLoadFuncs()
   end



/*************************
 Puerto asociado al socket
 *************************/

port = 900
MensajeLOG = "Puerto asociado al socket" port
Call EscribeLOG MensajeLOG


/********************************************
 Cargar el paquete de sockets si es necesario
 *********************************************/

if RxFuncQuery("SockLoadFuncs") then
   do
   rc = RxFuncAdd("SockLoadFuncs","RxSock","SockLoadFuncs")
   rc = SockLoadFuncs()
   end


/***********************
 Crear el socket inicial
 ***********************/

s  = SockSocket("AF_INET","SOCK_STREAM",0)
if (s = -1) then
   do
   MensajeLOG = "Error en llamada SockSocket:" errno
   Call EscribeLOG MensajeLOG
   exit
   end


/***************************
 Asociar el socket al puerto
 ***************************/

server.!family = "AF_INET"
server.!port   = port
server.!addr   = "INADDR_ANY"


rc = SockBind(s,"server.!")
if (rc = -1) then
   do
   MensajeLOG = "Error en llamada SockBind:" errno
   Call EscribeLOG MensajeLOG
   exit
   end

/*******************************
 Establecer el tamao de la cola
 *******************************/

rc = SockListen(s,10)
if (rc = -1) then
   do
   MensajeLOG = "Error en llamada SockListen:" errno
   Call EscribeLOG MensajeLOG
   exit
   end


/************************************************************
 Escuchar en un bucle infinito las peticiones de los clientes
 ************************************************************/

do forever

   MensajeLOG = " "
   Call EscribeLOG MensajeLOG
   MensajeLOG = "Esperando un nuevo cliente"
   Call EscribeLOG MensajeLOG
   MensajeLOG = " "
   Call EscribeLOG MensajeLOG


   /**********************************
    Aceptar una conexin de un cliente
    **********************************/

   ns = SockAccept(s,"client.!")
   if (rc = -1) then
      do
      MensajeLOG = "Error en llamada SockAccept:" errno
      Call EscribeLOG MensajeLOG
      exit
      end

   MensajeLOG = "Cliente aceptado. Direccin IP:" client.!addr
   Call EscribeLOG MensajeLOG


   /*********************************
    Leer el nombre del socket cliente
    *********************************/

   rc = SockGetSockName(ns,"sock.!")
   if (rc = -1) then
      do
      MensajeLOG = "Error en llamada SockGetSockName:" errno
      Call EscribeLOG MensajeLOG
      exit
      end

   MensajeLOG = "Nombre del socket:" sock.!addr
   Call EscribeLOG MensajeLOG

   /*************************
    Recibir datos del cliente
    *************************/

   rc = SockRecv(ns,"data",2000)
   if (rc = -1) then
      do
      MensajeLOG = "Error en llamada SockRecv:" errno
      Call EscribeLOG MensajeLOG
      exit
      end

/* No se muestra la cadena recibida para no mostrar el pin */
/*   MensajeLOG = "Datos recibidos:" data
   Call EscribeLOG MensajeLOG
*/
   /***********************************************
    Extraer los datos de la cadena leida del socket
    ***********************************************/

   data=subword(data,2)
   posFinalParam=lastpos('HTTP/',data)
   if posFinalParam<>0 then
     data=substr(data,1,posFinalParam - 1)



  /***********************************************************
   Comprobar si el nombre de la pgina pedida por el navegador
   es vlida
   ***********************************************************/

  PaginaLlamada='llamada.htm'
  codigoError= ObtenerNombrePagina(data,PaginaLlamada)
  if codigoError <> 0 then
   resultadoHTML= DevolverPaginaHTML(codigoError)


  if codigoError = 0 then do
    codigoError = ObtenerParametros(data)
    if codigoError <> 0 then
      resultadoHTML= DevolverPaginaHTML(codigoError)
  end

  /*********************************************************/
  /* Modificacion necesaria para perodo Integracin BBVA **/
  /* Autor: Victoria Gmez Rodrguez                      **/
  /* Fecha: 16-03-2000                                    **/
  /* Se controla el segundo parametro ClienPin para deter **/
  /* minar el origen del mensaje VRU BBV o puesto Argen.  **/
  /*********************************************************/

   if codigoError = 0 then
     do
         Pto = CalcularPuesto()
         TipoMensaje=DeterminarTipo()


         /* grabamos en el buzon del puesto el mensaje tipo BTA */
         'call sndbuzon.exe buzon '||Pto||' '||TipoMensaje||' "'||ClienIden||','||ClienPin||','||ClienOper||'"'
         codigoError=rc

        /* Grabamos los datos en el log pero ocultando el PIN del cliente */
        if TipoMensaje='BTA' then
            MensajeLOG = "Datos del mensaje: "||buzon||", "||Pto||", "||TipoMensaje||","||ClienIden||","||ClienPin||","||ClienOper
        else
            MensajeLOG = "Datos del mensaje: "||buzon||", "||Pto||", "||TipoMensaje||","||ClienIden||",****,"||ClienOper
        Call EscribeLOG MensajeLOG

        if (codigoError <> 0) then
        do
            codigoError=9
            resultadoHTML= DevolverPaginaHTML(codigoError)
            MensajeLOG = "Error al escribir en buzon."
            Call EscribeLOG MensajeLOG
        end
     end


   /********************************************************
    Enviar datos de vuelta al cliente en forma de pgina web
    ********************************************************/

   if codigoError = 0 then
    do
      resultadoHTML= DevolverPaginaHTML(codigoError)
      MensajeLOG = "Datos enviados al buzon satisfactoriamente."
      Call EscribeLOG MensajeLOG
    end


  MensajeLOG = "Datos a enviar al cliente: " resultadoHTML
  Call EscribeLOG MensajeLOG

   rc = SockSend(ns,resultadoHTML)
   if (rc = -1) then
      do
      MensajeLOG = "Error en llamada SockSend:" errno
      Call EscribeLOG MensajeLOG
      exit
      end

   /*************************************
    Cerrar el nuevo socket con el cliente
    *************************************/

   rc = SockSoClose(ns)
   ns = ""
   if (rc = -1) then
      do
      MensajeLOG = "Error en llamada SockSoClose:" errno
      Call EscribeLOG MensajeLOG
      exit
      end

   MensajeLOG = "Cerrando conexin"
   Call EscribeLOG MensajeLOG

end

exit







/*:VRX         CalcularPuesto
*/
CalcularPuesto:
/* calculamos el numero de puesto en donde nos estamos ejecutando */
    bbv.ini=value('CONFIG_OFIC',,'OS2ENVIRONMENT')
    numero_controlador=LeerIni( bbv.ini, 'GENERAL_OF', 'numero_controlador' )
    pto=value('PTO',,'OS2ENVIRONMENT')
    puesto=pto+(numero_controlador-1)*20

    /* ajustamos variables 'puesto' y 'numero_banco' a dos caracteres con '0' a izda. */
    puesto=right(puesto,2,'0')

return puesto

/*:VRX         DeterminarTipo
*/
DeterminarTipo:

   /* Aqui solo llegan los casos correctos por lo que solo */
   /* es necesario comprobar que ClienPin=OKP --> BTA      */

   if (ClienPin='OKP')  then
        tipo='BTA'
    else
        tipo='BTB'

return tipo

/*:VRX         DevolverPaginaHTML
*/
/******************************************************************
*                                                                 *
* void DevolverPaginaHTML  ( char *, char * )                     *
*                                                                 *
* Parmetros: 0 si los datos del cliente han llegado bien         *
*             1 si el nombre de la pgina no es correcto          *
*             2 si es un BTA y no se recibe DNI u OKP             *
*             9 si el mensaje no se ha grabado bien en buzon      *
*                                                                 *
* Resultado : el texto a devolver en la pgina HTML               *
*                                                                 *
* Funcin : Generar la pgina HTML a devolver al navegdador       *
*                                                                 *
******************************************************************/

DevolverPaginaHTML:

  codigoError =  arg( 1 )

  resultado.1="ERROR 001 Nombre de p&aacute;gina inv&aacute;lido"
  resultado.2="ERROR 002 Par&aacute;metros inv&aacute;lidos, No se ha recibido OKP"
  resultado.3="ERROR 003 Par&aacute;metros inv&aacute;lidos, DNI Incorrecto"
  resultado.4="ERROR 003 Fallo en la grabaci&oacute;n del buz&oacute;n"

  /***************************
  Seleccin del texto de error
  ****************************/
  SELECT
     WHEN codigoError = 0
        THEN
        cadenaHTML = "OK"
     WHEN codigoError = 1
        THEN
        cadenaHTML = resultado.1
     WHEN codigoError = 2
        THEN
        cadenaHTML = resultado.2
     WHEN codigoError = 3
        THEN
        cadenaHTML =resultado.3
     WHEN codigoError = 9
        THEN
        cadenaHTML = resultado.4

  OTHERWISE
       cadenaHTML = "ERROR INDETERMINADO"

  END
  cadenaHTML= D2C(13) || D2C(10) || "<html>" cadenaHTML || "</html>"
return cadenaHTML


/*:VRX         EscribeLog
*/
EscribeLog:

/***********************************************************/
/*                                                         */
/* void EscribeLOG  ( char * )                             */
/*                                                         */
/* Retorno : No devuelve ningn valor                      */
/*                                                         */
/* Parmetros : La informacin sobre la ltima operacin   */
/*              efectuada.                                 */
/*                                                         */
/* Funcin : Escribe en el fichero de registro el texto    */
/*           pasado como argumento.                        */
/*                                                         */
/***********************************************************/

  TextoLOG = time() || ' ' || arg( 1 )
  rc = LineOut( FicheroLOG , TextoLOG )
  /*******************************************************
   Activar esta opcin para ver los mensajes en la ventana
   de VXRexx
   *******************************************************/
   /*say TextoLOG*/

return

/*:VRX         Halt
*/
Halt:

/*************
 Cerrar socket
 *************/
rc = SockSoClose(s)

if datatype(ns,"W") then
   rc = SockSoClose(ns)

exit

/*:VRX         LeerIni
*/
/*********************************************************************
LeerIni
----------
Rutina utilizada para leer el valor de una clave dentro de la configuracin de una
aplicacion en un fichero INI.
ARGUMENTOS:
<Fich> Nombre del fichero INI
<App> Nombre de la aplicacin
<Key> Nombre de la clave dentro de la aplicacin
DEVUELVE:
<ASCIIZ> ( el valor de la clave )
'ERROR:' si detectado algun error
*********************************************************************/
LeerIni: procedure
parse arg Fich, App, Key

 Asciiz = SysIni( Fich, App , Key )
 if Asciiz \= 'ERROR:' then do
   Asciiz = Left( Asciiz , Length( Asciiz ) - 1)
   end
return Asciiz


/*:VRX         ObtenerNombrePagina
*/
/***********************************************************
*                                                          *
* void ObtenerNombrePagina  ( char *, char * )             *
*                                                          *
* Retorno : 0 si los datos del cliente han llegado bien    *
*           1 si el nombre de la pgina no es correcto     *
*                                                          *
* Parmetros : cadena que contiene los datos del cliente   *
*              paginabuscada nombre de la pgina a buscar  *
*                                                          *
* Funcin : Busca el nombre de la pgina en cadena         *
*                                                          *
***********************************************************/

ObtenerNombrePagina:
  cadena =  arg( 1 )
  paginabuscada =  arg( 2 )

 posparamFin = pos('?',cadena)
 if posparamFin = 0 then
  cadena=substr(cadena,2)
 else
   cadena=substr(cadena,2,posparamFin -2)

 parse upper var cadena nombrePagina
 parse upper var paginabuscada paginabuscada

 if nombrePagina <> paginabuscada then
  return 1
return 0

/*:VRX         ObtenerParametros
*/
/***********************************************************
*                                                          *
* void ObtenerParametros  ( char * )                       *
*                                                          *
* Retorno : 0 si los datos del cliente han llegado bien    *
*           cdigo de error en caso contrario              *
*                                                          *
* Parmetros : cadena que contiene los datos del cliente   *
*                                                          *
* Funcin : Busca los datos del cliente en la cadena       *
*           leida del socket                               *
*                                                          *
***********************************************************/

 ObtenerParametros:

  cadena =  arg( 1 )


  /**************************
   obtener cdigo del cliente
   **************************/

  campo='ClienIden='
  codigoError=0
  ClienIden= ObtenerUnParametro(cadena,campo)

  /* quitar guiones */

  LongIden=LENGTH(ClienIden)

  if LongIden=14 then
  do
     parte1=substr(ClienIden,1,4)
     parte2=substr(ClienIden,6,4)
     parte3=substr(ClienIden,11,4)
     ClienIden=parte1||parte2||parte3
  end
  If ClienIden="--" then
     ClienIden=" "

  MensajeLOG = "Identificador del cliente:" ClienIden

  Call EscribeLOG MensajeLOG


  /**************************
   obtener pin del cliente
  **************************/

  campo='ClienPin='
  codigoError=0
  ClienPin= ObtenerUnParametro(cadena,campo)

  if ClienPin='OKP' then
      MensajeLOG = "Pin del cliente:" ClienPin
  else
      MensajeLOG = "Pin del cliente: ****"

  Call EscribeLOG MensajeLOG

  /**************************
   obtener tipo de  operacin
   **************************/

  campo='ClienOper='
  codigoError=0
  ClienOper= ObtenerUnParametro(cadena,campo)

  MensajeLOG = "Operacin del cliente:" ClienOper
  Call EscribeLOG MensajeLOG



  LongIden=LENGTH(ClienIden)

  /* Controlamos los datos recibidos:                        */
  /* si longiden<12 Y ClienIden<>"--" --> es DNI              */
  /* si es DNI Y ClienPin <>"OKP" --> ERROR, es BTA sin OKP  */

  if (LongIden<12) & (ClienIden<>" ") & (ClienPin<>"OKP") then
  do
     codigoError=2
     MensajeLOG = "Error en parametros, falta OKP : "||ClienIden||","||ClienPin||","||ClienOper
     Call EscribeLOG MensajeLOG

  end

  if (ClienPin="OKP") & ((LongIden>10) | (ClienIden=" ")) then
  do
     codigoError=3
     MensajeLOG = "Error en parmetros, DNI incorrecto : "||ClienIden||","||ClienPin||","||ClienOper
     Call EscribeLOG MensajeLOG
  end
return  codigoError

/*:VRX         ObtenerUnParametro
*/
/***********************************************************
*                                                          *
* void ObtenerUnParametro  ( char *, char *, short )       *
*                                                          *
* Retorno : valor del campo pedido , NULL si no se         *
*           encuentra                                      *
*                                                          *
* Parmetros : cadena que contiene los datos del cliente   *
*                                                          *
* Funcin : Busca un parmetro determinado campo en cadena *
*           devolver en cdigoError el error generado      *
*                                                          *
***********************************************************/

ObtenerUnParametro:
  cadena =  arg( 1 )
  campo =  arg( 2 )

  parse upper var cadena cadenaUpper
  parse upper var campo campoUpper
  posparamIni = pos(campoUpper,cadenaUpper)

  /**************************************************************
   puede ocurrir que el parmetro a buscar no venga en la cadena
   por lo tanto el parmetro se considera nulo
   **************************************************************/

  if posparamIni = 0 then do
    return " "
  end

  posparamIni = pos('=',cadena,posparamIni)

  posparamFin = pos('&',cadena,posparamIni)

  if posparamFin = 0 then
    valorcampo = substr(cadena,posparamIni+1)
  else
    valorcampo = substr(cadena,posparamIni+1,posparamFin -posparamIni- 1)
  /* si el valor esta vacio se mete un blanco */
  if valorcampo="" then
    valorcampo=' '

return  valorcampo


