/*******************************************************************************
********************************************************************************
**									      **
**		UPS and UPX interfaces					      **
**									      **
**		TFM release 4.1						      **
**    									      **
** COPYRIGHT (c) DIGITAL EQUIPMENT CORPORATION. 1992. ALL RIGHTS RESERVED.    **
**    									      **
** THIS SOFTWARE IS PROPRIETARY TO AND EMBODIES CONFIDENTIAL TECHNOLOGY OF    **
** DIGITAL. POSSESSION, USE OR COPYING OF THE SOFTWARE AND MEDIA IS AUTHORIZED**
** ONLY PURSUANT TO A VALID WRITTEN LICENSE FROM DIGITAL.                     **
**									      **
********************************************************************************
*******************************************************************************/

/*	SCCSID = %W%   %E%	*/

#ifndef	TFM_H
#define		TFM_H

#define		TFM_VERSION	4.1

/*
*/
/*******************************************************************************
*									       *
*	UPS - User Program Server interface				       *
*									       *
*******************************************************************************/

	/****************************************
	*					*
	*	UPS user coded functions	*
	*					*
	****************************************/

#undef		putenv
#define		putenv		tfm_putenv
#undef		getenv
#define		getenv		tfm_getenv

#if	defined(_NO_PROTOTYPE)
typedef	int	(TFM_UPSFUNC)();
typedef	void	(TFM_UPSINIT)();
typedef	void	(TFM_UPSOPEN)();
typedef	void	(TFM_UPSCLOSE)();
typedef	void	(TFM_UPSKILL)();
#else	/* !_NO_PROTOTYPE */
typedef	int	(TFM_UPSFUNC)( int, char **, int, char**);
typedef	void	(TFM_UPSINIT)( int, char **);
typedef	void	(TFM_UPSOPEN)( void);
typedef	void	(TFM_UPSCLOSE)( void);
typedef	void	(TFM_UPSKILL)( void);
#endif	/* _NO_PROTOTYPE */

extern	TFM_UPSFUNC	ups_func;
extern	TFM_UPSINIT	ups_init;
extern	TFM_UPSCLOSE	ups_close;

/*
*/
	/****************************************
	*					*
	*	UPS support routines		*
	*					*
	****************************************/

	/************************
	*	tfm_get_par	*
	*	tfm_gpar	*
	************************/

	/***	SUB FUNCTIONS:	***/

#define		TFM_FIRST	((unsigned long)0x0803)	/* get first parameter*/
#define		TFM_NEXT	((unsigned long)0x0802)	/* get next parameter */

	/***	TYPES:		***/

#define 	TFM_CHAR     	((unsigned long)0x02)	/* character string   */
#define		TFM_BUFFER	((unsigned long)0x10)	/* field data buffer  */

	/************************
	*	tfm_unpack	*
	************************/

	/***	SUB FUNCTIONS:	***/

#define		TFM_ALL		((unsigned long)0x04)	/* unpack whole buffer*/
#define		TFM_ITEM	((unsigned long)0x08)	/* unpack one buf item*/

	/************************
	*	tfm_pack	*
	************************/

	/***	SUB FUNCTIONS:	***/

#define		TFM_START	((unsigned long)0x80)	/* overwrite prev cont*/
#define		TFM_APP		((unsigned long)0x01)	/* append             */
#define		TFM_REPL	((unsigned long)0x02)	/* replace/append     */

#define 	TFM_RETD     	((unsigned long)0x0000)	/* return in retd buf */
#define 	TFM_RSTAT     	((unsigned long)0x0100)	/* return in stat buf */
#define 	TFM_USRBUF    	((unsigned long)0x0200)	/* return in user buf */

	/***	TYPES:		***/

#define 	TFM_CHAR     	((unsigned long)0x02)	/* character string   */
#define		TFM_LIST	((unsigned long)0x08)	/* field data list    */
#define		TFM_BUFFER	((unsigned long)0x10)	/* field data buffer  */

	/************************
	*	tfm_gfld	*
	************************/

	/***	SUB FUNCTIONS:	***/

#define 	TFM_RETD     	((unsigned long)0x0000)	/* search in retd buf */
#define 	TFM_RSTAT     	((unsigned long)0x0100)	/* search in stat buf */
#define 	TFM_USRBUF    	((unsigned long)0x0200)	/* search in user buf */

	/************************
	*	tfm_SendSignal	*
	************************/

#define	TFM_SIGHUP	1	/* TFM termination signal	*/
#define	TFM_SIGINT	2	/* TFM termination signal	*/
#define	TFM_SIGQUIT	3	/* TFM termination signal	*/
#define	TFM_SIGILL	4	/* TFM termination signal	*/
#define	TFM_SIGTRAP	5	/* TFM termination signal	*/
#define	TFM_SIGABRT	6	/* TFM termination signal	*/
#define	TFM_SIGBUS	10	/* TFM termination signal	*/
#define	TFM_SIGTERM	15	/* TFM termination signal	*/
#define	TFM_SIGUSER	16	/* lowest application specific signal	*/ 

	/************************
	*	tfm_ident	*
	*	upx_ident	*
	************************/

typedef	enum	tfm_id
{
	TFM_IDTXT    ,
	TFM_FAMILY   ,
	TFM_PRODUCT  ,
	TFM_PLATFORM ,
	TFM_RELEASE  ,
	TFM_TURNOVER ,
	TFM_GENDATE  ,
	TFM_GENTIME  ,
	TFM_GENSYS   ,
	TFM_CRTXT1   ,
	TFM_DESCR
};

#if	defined(_NO_PROTOTYPE)
extern	int		tfm_putenv();
extern	char *		tfm_getenv();
extern	char *		tfm_gcwd();
extern	char *		tfm_get_par();
extern	char *		tfm_gfld();
extern	int		tfm_ggid();
extern	char *		tfm_gname();
extern	char *		tfm_gndname();
extern	char *		tfm_gpar();
extern	int		tfm_gpid();
extern	int		tfm_GetOctetSize();
extern	int		tfm_GetOctetField();
extern	int		tfm_GetProfileInt();
extern	int		tfm_GetProfileString();
extern	char *		tfm_GetDomainName();
extern	char *		tfm_GetGroupName();
extern	char *		tfm_GetUserName();
extern	char *		tfm_GetNodeName();
extern	char *		tfm_gtty();
extern	int		tfm_guid();
extern	char *		tfm_gusage();
extern	unsigned	tfm_instance();
extern	int		tfm_pack();
extern	void		tfm_return();
extern	void		tfm_RegOpen();
extern	void		tfm_RegClose();
extern	void		tfm_RegFunc();
extern	void		tfm_RegKill();
extern	int		tfm_schedule();
extern	int		tfm_SendSignal();
extern	int		tfm_unpack();
extern	int		tfm_WriteOctetField();
extern	int		tfm_WriteProfileInt();
extern	int		tfm_WriteProfileString();
extern	unsigned char	tfm_pxpc();
extern	unsigned char	tfm_pcpx();
extern	char *		tfm_ident();
#else	/* !_NO_PROTOTYPE */
extern	int		tfm_putenv( char*);
extern	char *		tfm_getenv( const char*);
extern	char *		tfm_gcwd( void);
extern	char *		tfm_get_par( unsigned long, unsigned long *);
extern	char *		tfm_gfld( unsigned long, char *, char *);
extern	int		tfm_ggid( void);
extern	char *		tfm_gname( void);
extern	char *		tfm_gndname( void);
extern	char *		tfm_gpar( unsigned long, unsigned long *, char **, long *);
extern	int		tfm_gpid( void);
extern	int		tfm_GetOctetSize( char *, char *, unsigned short *);
extern	int		tfm_GetOctetField( char *, char *, char *, unsigned short *);
extern	int		tfm_GetProfileInt( char *, char *, int *);
extern	int		tfm_GetProfileString( char *, char *, char *, unsigned long);
extern	char *		tfm_GetDomainName( void);
extern	char *		tfm_GetGroupName( void);
extern	char *		tfm_GetUserName( void);
extern	char *		tfm_GetNodeName( void);
extern	char *		tfm_gtty( void);
extern	int		tfm_guid( void);
extern	char *		tfm_gusage( void);
extern	unsigned	tfm_instance( void);
extern	int		tfm_pack( unsigned long, unsigned long, char *, char *, char *);
extern	void		tfm_return( int);
extern	void		tfm_RegOpen( TFM_UPSOPEN*);
extern	void		tfm_RegClose( TFM_UPSCLOSE*);
extern	void		tfm_RegFunc( TFM_UPSFUNC*);
extern	void		tfm_RegKill( TFM_UPSKILL*);
extern	int		tfm_schedule( unsigned);
extern	int		tfm_SendSignal( int, int);
extern	int		tfm_unpack( unsigned long, char *, char **, char *);
extern	int		tfm_WriteOctetField( char *, char *, char *, unsigned short);
extern	int		tfm_WriteProfileInt( char *, char *, int);
extern	int		tfm_WriteProfileString( char *, char *, char *);
extern	unsigned char	tfm_pxpc( unsigned char);
extern	unsigned char	tfm_pcpx( unsigned char);
extern	char *		tfm_ident( enum tfm_id);
#endif	/* _NO_PROTOTYPE */

/*
*/
	/************************************************
	*						*
	*	UPS hash buffer support routines	*
	*						*
	************************************************/

typedef	long	TFM_HBID;
typedef	enum	{ TFM_HBALPHANUM=0, TFM_HBNUMERIC=1, TFM_HBEMPTY=2 } TFM_HBTYPE;

#if	defined(_NO_PROTOTYPE)
extern	TFM_HBID	tfm_hbOpenBuf();
extern	void		tfm_hbCloseBuf();
extern	int		tfm_hbResetBuf();
extern	int		tfm_hbAppendItem();
extern	int		tfm_hbPack();
#else	/* !_NO_PROTOTYPE */
extern	TFM_HBID	tfm_hbOpenBuf( unsigned, unsigned, unsigned);
extern	void		tfm_hbCloseBuf( TFM_HBID);
extern	int		tfm_hbResetBuf( TFM_HBID, unsigned, unsigned);
extern	int		tfm_hbAppendItem( TFM_HBID, TFM_HBTYPE, char*, char*, unsigned);
extern	int		tfm_hbPack( TFM_HBID, char*);
#endif	/* _NO_PROTOTYPE */

/*
*/
/*******************************************************************************
*									       *
*	UPX - C-interface to User Program Servers			       *
*									       *
*******************************************************************************/

	/****************************************
	*					*
	*	UPX global data			*
	*					*
	****************************************/

#define		upx_errno	upx_get_errno()
/* extern	int	upx_errno;			 upx error	      */

	/****************************************
	*					*
	*	UPX function return values	*
	*					*
	****************************************/

#define		UPX_RC00_OK		 	 0	/* no error	      */
#define		UPX_RC01_UPS_NOT_FOUND		-1	/* UPS not found      */
#define		UPX_RC02_DC_ERROR		-2	/* communication error*/
#define		UPX_RC03_UPS_TERMINATED 	-3	/* UPS failed to compl*/
#define		UPX_RC04_FATAL_ERROR		-4	/* in UPX interface   */
#define		UPX_RC05_UPS_DISCONNECTED	-5	/* UPS disconnected   */

	/****************************************
	*					*
	*	UPX data types			*
	*					*
	****************************************/

#define		UPX_FBUF		char		/* field data buffer  */

	/****************************************
	*					*
	*	upx_call			*
	*					*
	****************************************/

#define		UPX_LAST_ARG		(char *)0	/* end of arg list    */

#if	defined(_NO_PROTOTYPE)
extern	int	upx_call();
extern	int	upx_close();
extern	void	upx_clr();
extern	void	upx_disc();
extern	int	upx_end();
extern	int	upx_exch();
extern	int	upx_gfbuf();
extern	int	upx_get_errno();
extern	int	upx_GetOctetSize();
extern	int	upx_GetOctetField();
extern	char *	upx_gfld();
extern	int	upx_glst();
extern	int	upx_pfbuf();
extern	int	upx_pfld();
extern	int	upx_preload();
extern	int	upx_pstr();
extern	void	upx_set_instance();
extern	int	upx_WriteOctetField();
extern	char *	upx_ident();
#else	/* !_NO_PROTOTYPE */
extern	int	upx_call( char *, ...);
extern	int	upx_close( char *);
extern	void	upx_clr( void);
extern	void	upx_disc( char *);
extern	int	upx_end( void);
extern	int	upx_exch( char *);
extern	int	upx_gfbuf( char *, UPX_FBUF **, long *);
extern	int	upx_get_errno( void);
extern	int	upx_GetOctetSize( char *, char *, unsigned short *);
extern	int	upx_GetOctetField( char *, char *, char *, unsigned short *);
extern	char *	upx_gfld( char *, char *);
extern	int	upx_glst( char *, char ***);
extern	int	upx_pfbuf( int, UPX_FBUF *);
extern	int	upx_pfld( int, char *, char *);
extern	int	upx_preload( char *);
extern	int	upx_pstr( int, char *);
extern	void	upx_set_instance( unsigned);
extern	int	upx_WriteOctetField( int, char *, char *, unsigned short);
extern	char *	upx_ident( enum tfm_id);
#endif	/* _NO_PROTOTYPE */


/*
*/
/*******************************************************************************
*									       *
*	TFM error codes							       *
*									       *
*******************************************************************************/

		/***	Return codes in normal situations:	***/

#define	TFM_RC00_NO_ER		0	/* ok, Data transferred		*/
#define	TFM_RC01_NO_ER		1	/* ok, Data transferred		*/
#define	TFM_RC03_NO_DATA	3	/* ok, but no data transferred	*/

		/***	I/O errors:				***/

#define	TFM_ER44_DC_ERR		44	/* data communication error	*/
#define	TFM_ER70_BROKEN_LINE	70	/* data communication error	*/

		/***	Miscellaneous errors:			***/

#define	TFM_ER51_MEM_OF		51	/* memory overflow 		*/
#define TFM_ER90_ILL_PARAM	90	/* illegal parameter		*/
#define TFM_ER92_BUFFER_OF	92	/* user buffer overflow 	*/
#define TFM_ER93_ITEM_OF	93	/* user item overflow 		*/
#define TFM_ER95_NOT_FOUND	95	/* item not found 		*/
#define	TFM_ER97_INSTR_SEQ	97	/* bad calling sequence		*/
#define	TFM_ER99_NOT_IMPL	99	/* function not implemented 	*/

/*
*/
#endif	/* TFM_H */
