/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.examples.lib.timerbean;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Vector;
import org.netbeans.examples.lib.timerbean.TimerListener;

public class Timer
implements Serializable {
    public static final String PROP_ONCE_ONLY = "onceOnly";
    public static final String PROP_DELAY = "delay";
    public static final long DEFAULT_DELAY = 1000L;
    public static final boolean DEFAULT_ONLY_ONCE = false;
    private transient TimerThread timerThread;
    private transient Vector listeners;
    private PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);
    private boolean running;
    private boolean onceOnly = false;
    private long delay = 1000L;

    public Timer() {
        this.start();
    }

    static /* synthetic */ boolean access$3(Timer timer) {
        return timer.running;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void addTimerListener(TimerListener timerListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(timerListener);
    }

    private void fireTimerEvent() {
        Vector vector;
        if (this.listeners == null) {
            return;
        }
        Object object = this;
        synchronized (object) {
            vector = (Vector)this.listeners.clone();
        }
        object = vector.elements();
        while (object.hasMoreElements()) {
            TimerListener timerListener = (TimerListener)object.nextElement();
            timerListener.onTime(new ActionEvent(this, 1001, "onTime"));
        }
    }

    public long getDelay() {
        return this.delay;
    }

    public boolean getOnceOnly() {
        return this.onceOnly;
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeTimerListener(TimerListener timerListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(timerListener);
    }

    public void setDelay(long l) {
        if (this.delay == l) {
            return;
        }
        long l2 = this.delay;
        this.delay = l;
        this.propertySupport.firePropertyChange(PROP_DELAY, new Long(l2), new Long(this.delay));
    }

    public void setOnceOnly(boolean bl) {
        if (this.onceOnly == bl) {
            return;
        }
        this.onceOnly = bl;
        this.propertySupport.firePropertyChange(PROP_ONCE_ONLY, new Boolean(this.onceOnly ^ true), new Boolean(this.onceOnly));
    }

    public synchronized void start() {
        if (this.running) {
            return;
        }
        this.timerThread = new TimerThread();
        this.running = true;
        this.timerThread.start();
    }

    public synchronized void stop() {
        if (!this.running) {
            return;
        }
        this.timerThread.stop();
        this.timerThread = null;
        this.running = false;
    }

    class TimerThread
    extends Thread {
        TimerThread() {
        }

        public void run() {
            do {
                try {
                    Thread.sleep(Timer.this.delay);
                }
                catch (InterruptedException interruptedException) {}
                Timer.this.fireTimerEvent();
            } while (!Timer.this.onceOnly);
            Timer.this.running = false;
        }
    }
}

