/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleHyperlink;
import javax.accessibility.AccessibleHypertext;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.swing.HeaderParser;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.ChangedCharSetException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.WrappedPlainView;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class JEditorPane
extends JTextComponent {
    private EditorKit kit;
    private Hashtable pageProperties;
    private Hashtable typeHandlers;
    private String charSetName = "8859_1";
    private static final Object kitRegistryKey = new StringBuffer("JEditorPane.kitRegistry");
    private static final Object kitTypeRegistryKey = new StringBuffer("JEditorPane.kitTypeRegistry");
    private static final Object kitLoaderRegistryKey = new StringBuffer("JEditorPane.kitLoaderRegistry");
    private static final String uiClassID = "EditorPaneUI";
    static /* synthetic */ Class class$javax$swing$event$HyperlinkListener;

    static {
        JEditorPane.registerEditorKitForContentType("text/plain", "javax.swing.JEditorPane$PlainEditorKit");
        JEditorPane.registerEditorKitForContentType("text/html", "javax.swing.text.html.HTMLEditorKit");
        JEditorPane.registerEditorKitForContentType("text/rtf", "javax.swing.text.rtf.RTFEditorKit");
        JEditorPane.registerEditorKitForContentType("application/rtf", "javax.swing.text.rtf.RTFEditorKit");
    }

    public JEditorPane() {
    }

    public JEditorPane(String string) throws IOException {
        this();
        this.setPage(string);
    }

    public JEditorPane(String string, String string2) {
        this();
        this.setContentType(string);
        this.setText(string2);
    }

    public JEditorPane(URL uRL) throws IOException {
        this();
        this.setPage(uRL);
    }

    public synchronized void addHyperlinkListener(HyperlinkListener hyperlinkListener) {
        this.listenerList.add(class$javax$swing$event$HyperlinkListener != null ? class$javax$swing$event$HyperlinkListener : (class$javax$swing$event$HyperlinkListener = JEditorPane.class$("javax.swing.event.HyperlinkListener")), hyperlinkListener);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected EditorKit createDefaultEditorKit() {
        return new PlainEditorKit();
    }

    public static EditorKit createEditorKitForContentType(String string) {
        EditorKit editorKit = null;
        Hashtable<String, EditorKit> hashtable = (Hashtable<String, EditorKit>)SwingUtilities.appContextGet(kitRegistryKey);
        if (hashtable == null) {
            hashtable = new Hashtable<String, EditorKit>();
            SwingUtilities.appContextPut(kitRegistryKey, hashtable);
        } else {
            editorKit = (EditorKit)hashtable.get(string);
        }
        if (editorKit == null) {
            String string2 = (String)JEditorPane.getKitTypeRegistry().get(string);
            ClassLoader classLoader = (ClassLoader)JEditorPane.getKitLoaderRegistry().get(string);
            try {
                Class<?> clazz = classLoader != null ? classLoader.loadClass(string2) : Class.forName(string2);
                editorKit = (EditorKit)clazz.newInstance();
                hashtable.put(string, editorKit);
            }
            catch (Throwable throwable) {
                editorKit = null;
            }
        }
        if (editorKit != null) {
            return (EditorKit)editorKit.clone();
        }
        return null;
    }

    public void fireHyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$HyperlinkListener != null ? class$javax$swing$event$HyperlinkListener : JEditorPane.class$("javax.swing.event.HyperlinkListener"))) {
                ((HyperlinkListener)objectArray[n + 1]).hyperlinkUpdate(hyperlinkEvent);
            }
            n -= 2;
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = this.getEditorKit() instanceof HTMLEditorKit ? new AccessibleJEditorPaneHTML() : new AccessibleJEditorPane();
        }
        return this.accessibleContext;
    }

    public final String getContentType() {
        return this.kit != null ? this.kit.getContentType() : null;
    }

    public final EditorKit getEditorKit() {
        if (this.kit == null) {
            this.kit = this.createDefaultEditorKit();
        }
        return this.kit;
    }

    public EditorKit getEditorKitForContentType(String string) {
        EditorKit editorKit;
        if (this.typeHandlers == null) {
            this.typeHandlers = new Hashtable(3);
        }
        if ((editorKit = (EditorKit)this.typeHandlers.get(string)) == null && (editorKit = JEditorPane.createEditorKitForContentType(string)) != null) {
            this.setEditorKitForContentType(string, editorKit);
        }
        if (editorKit == null) {
            editorKit = this.createDefaultEditorKit();
        }
        return editorKit;
    }

    private static Hashtable getKitLoaderRegistry() {
        Hashtable hashtable = (Hashtable)SwingUtilities.appContextGet(kitLoaderRegistryKey);
        if (hashtable == null) {
            hashtable = new Hashtable();
            SwingUtilities.appContextPut(kitLoaderRegistryKey, hashtable);
        }
        return hashtable;
    }

    private static Hashtable getKitTypeRegistry() {
        Hashtable hashtable = (Hashtable)SwingUtilities.appContextGet(kitTypeRegistryKey);
        if (hashtable == null) {
            hashtable = new Hashtable();
            SwingUtilities.appContextPut(kitTypeRegistryKey, hashtable);
        }
        return hashtable;
    }

    public URL getPage() {
        return (URL)this.getDocument().getProperty("stream");
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.getParent() instanceof JViewport) {
            Dimension dimension2;
            Dimension dimension3;
            int n;
            JViewport jViewport = (JViewport)this.getParent();
            TextUI textUI = this.getUI();
            if (!this.getScrollableTracksViewportWidth()) {
                n = jViewport.getWidth();
                dimension3 = textUI.getMinimumSize(this);
                dimension2 = textUI.getMaximumSize(this);
                if (n < dimension3.width) {
                    dimension.width = dimension3.width;
                }
            }
            if (!this.getScrollableTracksViewportHeight()) {
                n = jViewport.getHeight();
                dimension3 = textUI.getMinimumSize(this);
                dimension2 = textUI.getMaximumSize(this);
                if (n < dimension3.height) {
                    dimension.height = dimension3.height;
                }
            }
        }
        return dimension;
    }

    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            JViewport jViewport = (JViewport)this.getParent();
            TextUI textUI = this.getUI();
            int n = jViewport.getHeight();
            Dimension dimension = textUI.getMinimumSize(this);
            Dimension dimension2 = textUI.getMaximumSize(this);
            if (n >= dimension.height && n <= dimension2.height) {
                return true;
            }
        }
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        if (this.getParent() instanceof JViewport) {
            JViewport jViewport = (JViewport)this.getParent();
            TextUI textUI = this.getUI();
            int n = jViewport.getWidth();
            Dimension dimension = textUI.getMinimumSize(this);
            Dimension dimension2 = textUI.getMaximumSize(this);
            if (n >= dimension.width && n <= dimension2.width) {
                return true;
            }
        }
        return false;
    }

    protected InputStream getStream(URL uRL) throws IOException {
        Object object;
        URLConnection uRLConnection = uRL.openConnection();
        if (uRLConnection instanceof HttpURLConnection) {
            boolean bl;
            object = (HttpURLConnection)uRLConnection;
            HttpURLConnection.setFollowRedirects(false);
            int n = ((HttpURLConnection)object).getResponseCode();
            boolean bl2 = bl = n >= 300 && n <= 399;
            if (bl) {
                String string = uRLConnection.getHeaderField("Location");
                uRL = string.startsWith("http", 0) ? new URL(string) : new URL(uRL, string);
                return this.getStream(uRL);
            }
        }
        if (this.pageProperties == null) {
            this.pageProperties = new Hashtable();
        }
        if ((object = uRLConnection.getContentType()) != null) {
            this.setContentType((String)object);
            this.pageProperties.put("content-type", object);
        }
        this.pageProperties.put("stream", uRL);
        String string = uRLConnection.getContentEncoding();
        if (string != null) {
            this.pageProperties.put("content-encoding", string);
        }
        InputStream inputStream = uRLConnection.getInputStream();
        return inputStream;
    }

    public String getText() {
        String string;
        try {
            StringWriter stringWriter = new StringWriter();
            this.write(stringWriter);
            string = stringWriter.toString();
        }
        catch (IOException iOException) {
            string = null;
        }
        return string;
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public boolean isManagingFocus() {
        return true;
    }

    protected String paramString() {
        String string = this.charSetName != null ? this.charSetName : "";
        String string2 = this.kit != null ? this.kit.toString() : "";
        String string3 = this.typeHandlers != null ? this.typeHandlers.toString() : "";
        return String.valueOf(super.paramString()) + ",charSetName=" + string + ",kit=" + string2 + ",typeHandlers=" + string3;
    }

    protected void processComponentKeyEvent(KeyEvent keyEvent) {
        super.processComponentKeyEvent(keyEvent);
        if (this.isManagingFocus() && (keyEvent.getKeyCode() == 9 || keyEvent.getKeyChar() == '\t')) {
            keyEvent.consume();
        }
    }

    public void read(InputStream inputStream, Object object) throws IOException {
        if (object instanceof HTMLDocument && this.kit instanceof HTMLEditorKit) {
            HTMLDocument hTMLDocument = (HTMLDocument)object;
            this.setDocument(hTMLDocument);
            this.read(inputStream, hTMLDocument);
        } else {
            super.read(new InputStreamReader(inputStream, this.charSetName), object);
        }
    }

    void read(InputStream inputStream, Document document) throws IOException {
        try {
            this.kit.read(new InputStreamReader(inputStream, this.charSetName), document, 0);
        }
        catch (BadLocationException badLocationException) {
            throw new IOException(badLocationException.getMessage());
        }
        catch (ChangedCharSetException changedCharSetException) {
            String string = changedCharSetException.getCharSetSpec();
            if (changedCharSetException.keyEqualsCharSet()) {
                this.charSetName = string;
            } else {
                this.setCharsetFromContentTypeParameters(string);
            }
            inputStream.close();
            URL uRL = (URL)document.getProperty("stream");
            URLConnection uRLConnection = uRL.openConnection();
            inputStream = uRLConnection.getInputStream();
            try {
                document.remove(0, document.getLength());
            }
            catch (BadLocationException badLocationException) {}
            document.putProperty("IgnoreCharsetDirective", new Boolean(true));
            this.read(inputStream, document);
        }
    }

    public static void registerEditorKitForContentType(String string, String string2) {
        JEditorPane.getKitLoaderRegistry().remove(string);
        JEditorPane.getKitTypeRegistry().put(string, string2);
    }

    public static void registerEditorKitForContentType(String string, String string2, ClassLoader classLoader) {
        JEditorPane.getKitTypeRegistry().put(string, string2);
        JEditorPane.getKitLoaderRegistry().put(string, classLoader);
    }

    public synchronized void removeHyperlinkListener(HyperlinkListener hyperlinkListener) {
        this.listenerList.remove(class$javax$swing$event$HyperlinkListener != null ? class$javax$swing$event$HyperlinkListener : (class$javax$swing$event$HyperlinkListener = JEditorPane.class$("javax.swing.event.HyperlinkListener")), hyperlinkListener);
    }

    public void replaceSelection(String string) {
        if (!this.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        EditorKit editorKit = this.getEditorKit();
        if (editorKit instanceof StyledEditorKit) {
            try {
                Document document = this.getDocument();
                Caret caret = this.getCaret();
                int n = Math.min(caret.getDot(), caret.getMark());
                int n2 = Math.max(caret.getDot(), caret.getMark());
                if (n != n2) {
                    document.remove(n, n2 - n);
                }
                if (string != null && string.length() > 0) {
                    document.insertString(n, string, ((StyledEditorKit)editorKit).getInputAttributes());
                }
            }
            catch (BadLocationException badLocationException) {
                this.getToolkit().beep();
            }
        } else {
            super.replaceSelection(string);
        }
    }

    protected void scrollToReference(String string) {
        Document document = this.getDocument();
        if (document instanceof HTMLDocument) {
            HTMLDocument hTMLDocument = (HTMLDocument)document;
            HTMLDocument.Iterator iterator = hTMLDocument.getIterator(HTML.Tag.A);
            while (iterator.isValid()) {
                AttributeSet attributeSet = iterator.getAttributes();
                String string2 = (String)attributeSet.getAttribute(HTML.Attribute.NAME);
                if (string2 != null && string2.equals(string)) {
                    try {
                        Rectangle rectangle = this.modelToView(iterator.getStartOffset());
                        if (rectangle != null) {
                            Rectangle rectangle2 = this.getVisibleRect();
                            rectangle.y -= rectangle2.height / 2;
                            rectangle.height = rectangle2.height;
                            this.scrollRectToVisible(rectangle);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        this.getToolkit().beep();
                    }
                }
                iterator.next();
            }
        }
    }

    private void setCharsetFromContentTypeParameters(String string) {
        String string2 = null;
        try {
            int n = string.indexOf(59);
            if (n > -1 && n < string.length() - 1) {
                string = string.substring(n + 1);
            }
            if (string.length() > 0) {
                HeaderParser headerParser = new HeaderParser(string);
                this.charSetName = string2 = headerParser.findValue("charset");
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Exception exception) {
            System.err.println("JEditorPane.getCharsetFromContentTypeParameters failed on: " + string);
            exception.printStackTrace();
        }
    }

    public final void setContentType(String string) {
        Object object;
        int n = string.indexOf(";");
        if (n > -1) {
            object = string.substring(n);
            if ((string = string.substring(0, n).trim()).toLowerCase().startsWith("text/")) {
                this.setCharsetFromContentTypeParameters((String)object);
            }
        }
        if (!(this.kit != null && string.equals(this.kit.getContentType()) || (object = this.getEditorKitForContentType(string)) == null)) {
            this.setEditorKit((EditorKit)object);
        }
    }

    public void setEditorKit(EditorKit editorKit) {
        EditorKit editorKit2 = this.kit;
        if (editorKit2 != null) {
            editorKit2.deinstall(this);
        }
        this.kit = editorKit;
        if (this.kit != null) {
            this.kit.install(this);
            this.setDocument(this.kit.createDefaultDocument());
        }
        this.firePropertyChange("editorKit", editorKit2, editorKit);
    }

    public void setEditorKitForContentType(String string, EditorKit editorKit) {
        if (this.typeHandlers == null) {
            this.typeHandlers = new Hashtable(3);
        }
        this.typeHandlers.put(string, editorKit);
    }

    public void setPage(String string) throws IOException {
        if (string == null) {
            throw new IOException("invalid url");
        }
        URL uRL = new URL(string);
        this.setPage(uRL);
    }

    public void setPage(URL uRL) throws IOException {
        Object object;
        if (uRL == null) {
            throw new IOException("invalid url");
        }
        URL uRL2 = this.getPage();
        this.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
        boolean bl = false;
        if (uRL2 == null || !uRL2.sameFile(uRL)) {
            object = this.getStream(uRL);
            if (this.kit != null) {
                int n;
                Object object2;
                Document document = this.kit.createDefaultDocument();
                if (this.pageProperties != null) {
                    object2 = this.pageProperties.keys();
                    while (object2.hasMoreElements()) {
                        Object k = object2.nextElement();
                        document.putProperty(k, this.pageProperties.get(k));
                    }
                    this.pageProperties.clear();
                }
                if (document.getProperty("stream") == null) {
                    document.putProperty("stream", uRL);
                }
                if (document instanceof AbstractDocument && (n = ((AbstractDocument)(object2 = (AbstractDocument)document)).getAsynchronousLoadPriority()) >= 0) {
                    this.setDocument(document);
                    PageLoader pageLoader = new PageLoader((InputStream)object, n, uRL2, uRL);
                    pageLoader.start();
                    return;
                }
                this.read((InputStream)object, document);
                this.setDocument(document);
                bl = true;
            }
        }
        if ((object = uRL.getRef()) != null) {
            if (!bl) {
                this.scrollToReference((String)object);
            } else {
                SwingUtilities.invokeLater(new Runnable((String)object, this){
                    private final /* synthetic */ JEditorPane this$0;
                    private final /* synthetic */ String val$reference;
                    {
                        this.val$reference = string;
                        this.this$0 = jEditorPane;
                    }

                    public void run() {
                        this.this$0.scrollToReference(this.val$reference);
                    }
                });
            }
        }
        this.firePropertyChange("page", uRL2, uRL);
    }

    public void setText(String string) {
        try {
            Document document = this.getDocument();
            document.remove(0, document.getLength());
            StringReader stringReader = new StringReader(string);
            EditorKit editorKit = this.getEditorKit();
            editorKit.read(stringReader, document, 0);
        }
        catch (IOException iOException) {
            this.getToolkit().beep();
        }
        catch (BadLocationException badLocationException) {
            this.getToolkit().beep();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.ui != null && this.getUIClassID().equals(uiClassID)) {
            this.ui.installUI(this);
        }
    }

    class PageLoader
    extends Thread {
        InputStream in;
        URL old;
        URL page;

        PageLoader(InputStream inputStream, int n, URL uRL, URL uRL2) {
            this.setPriority(n);
            this.in = inputStream;
            this.old = uRL;
            this.page = uRL2;
        }

        static /* synthetic */ JEditorPane access$0(PageLoader pageLoader) {
            return pageLoader.JEditorPane.this;
        }

        public void run() {
            Document document = JEditorPane.this.getDocument();
            try {
                try {
                    JEditorPane.this.read(this.in, document);
                    URL uRL = (URL)document.getProperty("stream");
                    String string = uRL.getRef();
                    if (string != null) {
                        Runnable runnable = new Runnable(this){
                            private final /* synthetic */ PageLoader this$1;
                            {
                                this.this$1 = pageLoader;
                            }

                            public void run() {
                                URL uRL = (URL)PageLoader.access$0(this.this$1).getDocument().getProperty("stream");
                                String string = uRL.getRef();
                                PageLoader.access$0(this.this$1).scrollToReference(string);
                            }
                        };
                        SwingUtilities.invokeLater(runnable);
                    }
                }
                catch (IOException iOException) {
                    JEditorPane.this.getToolkit().beep();
                }
                Object var3_5 = null;
                JEditorPane.this.firePropertyChange("page", this.old, this.page);
            }
            catch (Throwable throwable) {
                Object var3_6 = null;
                JEditorPane.this.firePropertyChange("page", this.old, this.page);
                throw throwable;
            }
        }
    }

    protected class AccessibleJEditorPane
    extends JTextComponent.AccessibleJTextComponent {
        protected AccessibleJEditorPane() {
            super(JEditorPane.this);
        }

        public String getAccessibleDescription() {
            if (this.accessibleDescription != null) {
                return this.accessibleDescription;
            }
            return JEditorPane.this.getContentType();
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            accessibleStateSet.add(AccessibleState.MULTI_LINE);
            return accessibleStateSet;
        }
    }

    protected class AccessibleJEditorPaneHTML
    extends AccessibleJEditorPane {
        protected AccessibleJEditorPaneHTML() {
        }

        public AccessibleText getAccessibleText() {
            return new JEditorPaneAccessibleHypertextSupport();
        }
    }

    protected class JEditorPaneAccessibleHypertextSupport
    extends AccessibleJEditorPane
    implements AccessibleHypertext {
        LinkVector hyperlinks = new LinkVector();
        boolean linksValid = false;

        public JEditorPaneAccessibleHypertextSupport() {
            Document document = JEditorPane.this.getDocument();
            if (document != null) {
                document.addDocumentListener(new DocumentListener(this){
                    private final /* synthetic */ JEditorPaneAccessibleHypertextSupport this$1;
                    {
                        this.this$1 = jEditorPaneAccessibleHypertextSupport;
                    }

                    public void changedUpdate(DocumentEvent documentEvent) {
                        this.this$1.linksValid = false;
                    }

                    public void insertUpdate(DocumentEvent documentEvent) {
                        this.this$1.linksValid = false;
                    }

                    public void removeUpdate(DocumentEvent documentEvent) {
                        this.this$1.linksValid = false;
                    }
                });
            }
        }

        private void buildLinkTable() {
            this.hyperlinks.removeAllElements();
            Document document = JEditorPane.this.getDocument();
            if (document != null) {
                Element element;
                ElementIterator elementIterator = new ElementIterator(document);
                while ((element = elementIterator.next()) != null) {
                    String string;
                    if (!element.isLeaf()) continue;
                    AttributeSet attributeSet = element.getAttributes();
                    AttributeSet attributeSet2 = (AttributeSet)attributeSet.getAttribute(HTML.Tag.A);
                    String string2 = string = attributeSet2 != null ? (String)attributeSet2.getAttribute(HTML.Attribute.HREF) : null;
                    if (string == null) continue;
                    this.hyperlinks.addElement(new HTMLLink(element));
                }
            }
            this.linksValid = true;
        }

        public AccessibleHyperlink getLink(int n) {
            if (!this.linksValid) {
                this.buildLinkTable();
            }
            if (n >= 0 && n < this.hyperlinks.size()) {
                return (AccessibleHyperlink)this.hyperlinks.elementAt(n);
            }
            return null;
        }

        public int getLinkCount() {
            if (!this.linksValid) {
                this.buildLinkTable();
            }
            return this.hyperlinks.size();
        }

        public int getLinkIndex(int n) {
            if (!this.linksValid) {
                this.buildLinkTable();
            }
            Element element = null;
            Document document = JEditorPane.this.getDocument();
            if (document != null) {
                element = document.getDefaultRootElement();
                while (!element.isLeaf()) {
                    int n2 = element.getElementIndex(n);
                    element = element.getElement(n2);
                }
            }
            return this.hyperlinks.baseElementIndex(element);
        }

        public String getLinkText(int n) {
            Document document;
            Element element;
            if (!this.linksValid) {
                this.buildLinkTable();
            }
            if ((element = (Element)this.hyperlinks.elementAt(n)) != null && (document = JEditorPane.this.getDocument()) != null) {
                try {
                    return document.getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset());
                }
                catch (BadLocationException badLocationException) {
                    return null;
                }
            }
            return null;
        }

        public class HTMLLink
        extends AccessibleHyperlink {
            Element element;

            public HTMLLink(Element element) {
                this.element = element;
            }

            public boolean doAccessibleAction(int n) {
                URL uRL;
                if (n == 0 && this.isValid() && (uRL = (URL)this.getAccessibleActionObject(n)) != null) {
                    HyperlinkEvent hyperlinkEvent = new HyperlinkEvent(JEditorPane.this, HyperlinkEvent.EventType.ACTIVATED, uRL);
                    JEditorPane.this.fireHyperlinkUpdate(hyperlinkEvent);
                    return true;
                }
                return false;
            }

            public Object getAccessibleActionAnchor(int n) {
                return this.getAccessibleActionDescription(n);
            }

            public int getAccessibleActionCount() {
                return 1;
            }

            public String getAccessibleActionDescription(int n) {
                Document document;
                if (n == 0 && this.isValid() && (document = JEditorPane.this.getDocument()) != null) {
                    try {
                        return document.getText(this.getStartIndex(), this.getEndIndex() - this.getStartIndex());
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                }
                return null;
            }

            public Object getAccessibleActionObject(int n) {
                if (n == 0 && this.isValid()) {
                    String string;
                    AttributeSet attributeSet = this.element.getAttributes();
                    AttributeSet attributeSet2 = (AttributeSet)attributeSet.getAttribute(HTML.Tag.A);
                    String string2 = string = attributeSet2 != null ? (String)attributeSet2.getAttribute(HTML.Attribute.HREF) : null;
                    if (string != null) {
                        URL uRL;
                        try {
                            uRL = new URL(JEditorPane.this.getPage(), string);
                        }
                        catch (MalformedURLException malformedURLException) {
                            uRL = null;
                        }
                        return uRL;
                    }
                }
                return null;
            }

            public int getEndIndex() {
                return this.element.getEndOffset();
            }

            public int getStartIndex() {
                return this.element.getStartOffset();
            }

            public boolean isValid() {
                return JEditorPaneAccessibleHypertextSupport.this.linksValid;
            }
        }

        private class LinkVector
        extends Vector {
            LinkVector() {
            }

            public int baseElementIndex(Element element) {
                int n = 0;
                while (n < this.elementCount) {
                    HTMLLink hTMLLink = (HTMLLink)this.elementAt(n);
                    if (hTMLLink.element == element) {
                        return n;
                    }
                    ++n;
                }
                return -1;
            }
        }
    }

    static class PlainEditorKit
    extends DefaultEditorKit
    implements ViewFactory {
        PlainEditorKit() {
        }

        public Object clone() {
            return new PlainEditorKit();
        }

        public View create(Element element) {
            return new WrappedPlainView(element);
        }

        public ViewFactory getViewFactory() {
            return this;
        }
    }
}

