program rdate;

{$F+}

uses OS2Def,OS2Base,DOS,
     Socket,U_DateTime;

{$L IBMTCPIP.LIB}

const
  Version    = '00.90';
  TimServPort: ULong = 10037;
  UseString:  string = '@(#)remote date via timeserver2 on Port 10037'+#0;
  CopyRight1: string = '@(#)rdate for OS/2  Version '+Version+' - 10.10.96'+#0;
  CopyRight2: string = '@(#)(C) Chr.Hohmann BfS ST2.2 1996'+#0;
var
  rc:      ApiRet;
  Count,
  SleepT,
  ActSleep,
  ActTime: ULong;
  ValError,
  SDescr:  longint;
  SAddr:   SockAddr_In_Ptr;
  BufFlag: ULong;
  TempStr: string;
  TempDT:  OS2Base.DateTime;
  Lang:    LanguageType;
begin
  TempStr := getenv('TimeService2');
  if (TempStr > '') then begin
    val(TempStr,TimServPort,ValError);
    if (ValError <> 0) and (TimServPort > 0) then begin
      writeln('timserv2 error - not a value ',TempStr);
      halt(99);
    end;
  end;
  if (ParamCount = 0) then begin
    writeln('usage: rdate2 host [Minutes]');
    writeln('       default port is ',TimServPort);
    writeln('       or via environment set TimeService2 = PortNo');
    halt(1);
  end else begin
    TempStr := ParamStr(1);
    if (TempStr[1] = '\') or (TempStr[1] = '-') then begin
      writeln('usage: rdate2 host [Minutes]');
      halt(1);
    end;
    if (ParamCount > 1) then begin
      TempStr := ParamStr(2);
      val(TempStr,SleepT,ValError);
      if (ValError = 0) and (SleepT > 0) then begin
        write  ('--------------------------------------------------------------------------------');
        writeln('Startup rdate2 - Port ',TimServPort,' - Server ',ParamStr(1),' - New request every ',SleepT,' minutes');
        write  ('--------------------------------------------------------------------------------');
      end else begin
        writeln;
        writeln('rdate2: error - not a value ',TempStr);
        halt(99);
      end;
    end else begin
      SleepT := 0;
    end;
  end;
  TempStr := getenv('LANG');
  if (pos('de',TempStr) = 1) or
     (pos('DE',TempStr) = 1) then
    Lang := German
  else
    Lang := Default;
  new(SAddr);
  Count    := 0;
  ActSleep := SleepT;
  repeat
    fillchar(SAddr^,sizeof(SAddr^),#0);
    rc := socksocket(AF_INET,SOCK_STREAM,IPPROTO_NULL);
    if (rc <> -1) then begin
      SDescr := rc;
      rc     := SockGetHostAddrByName(paramstr(1));
      if (rc <> 0) then begin
        SAddr^.Sin_Addr.IPAddr := rc;
        SAddr^.Sin_Port        := htons(TimServPort);
        SAddr^.Sin_Family      := AF_INET;
        rc := SockConnect(SDescr,
                          SAddr,
                          SockAddr_Len);
        if (rc <> -1) then begin
          BufFlag := 0;
          rc := SockRecv(SDescr,
                         @TempDT,
                         sizeof(TempDT),
                         BufFlag);
          if (rc = sizeof(TempDT)) then begin
            rc := DosSetDateTime(TempDT);
            if (rc = 0) then begin
              writeln(Long_DateString(Lang,TempDT));
              inc(Count);
            end else begin
              write('DosSetDateTime failed   rc = ',rc);
            end;
          end else begin
            write('incorrect data received from server');
          end;
          rc := SockClose(SDescr);
        end else begin
          write('server ',paramstr(1),' not responding');
        end;
        if (rc <> 0) then begin
          if (SleepT > 0) then begin
            rc := 0;
            writeln(' - trying again in 5 minutes');
            ActSleep := 5;
          end else writeln;
        end;
      end else begin
        writeln;
        writeln('server ',paramstr(1),' not found');
        rc := -1;
      end;
    end;
    if (rc <> -1) then DosSleep(ActSleep*60000);
    ActSleep := SleepT;
  until (rc = -1) or (SleepT = 0);
  dispose(SAddr);
  UseString  := UseString;
  CopyRight1 := CopyRight1;
  CopyRight2 := CopyRight2;
end.
