/***********************************************************
  Verbesserter Zufallsgenerator nach Knuth / Sedgewick
  fr ANSI-C-Compiler, weitgehend plattformunabhngig
  (c) 1998, 2000 Heinz Repp
***********************************************************/

#include <limits.h>
#include <stdlib.h>

#undef RAND_MAX
#define RAND_MAX INT_MAX

static int lastrand[55], randlast = -1;


void srand (unsigned int seed) /* Methode: lineare Kongruenz */
{
  unsigned int gen1, gen2;
  randlast = -1;
  gen2 = seed;
  do
  {
    gen1 = ((UINT_MAX / 3137) * 200 + 21) * gen2 + 1;
    gen2 = ((UINT_MAX / 3137) * 200 + 21) * gen1 + 1;
    lastrand[++randlast] = (int) (((gen1 >> 10) ^ gen2) & INT_MAX);
  } while (randlast < 54);
}


int rand (void)      /* Generator mit additiver Kongruenz */
{
  if (randlast < 0)
    srand (1);
  randlast = (randlast + 1) % 55;
  return lastrand[randlast] =
    (lastrand[randlast] + lastrand[(randlast + 24) % 55]) & INT_MAX;
}


int irand (int range)
{
  unsigned int rng, sav, lft, res; /* we need one bit more */

  rng = (unsigned) range;
  sav = (unsigned) rand ();
  lft = sizeof (int) * 8 - 1;      /* int bits without sign */
  res = rng >> 1;                  /* preload with range / 2 */

  while (rng)                      /* add range * rand () */
  {
    if (rng & 1)
      res += sav;
    res >>= 1;
    rng >>= 1;
    lft--;
  }
  return (int) (res >> lft);
}

double frand (void)
{
  return (double) rand() / (INT_MAX + 1.0);
}
