/* VLOG.rex - PVCS VLOG on the current workfile

  This macro does a VLOG on the current viewed work file and SLSTARTs
  the output to SourceLink.

  Customizations necessary:
  1. PVCSVLOG specs where the VLOG executable is.
  2. sLogFile is the directory where your log file in question is.
     Remember the final '\'.
*/

/* -------------------------- Alias list ----------------------------*/

/* Setup full path to VLOG */
pvcsvlog = 'e:\pvcs\vlog'

      /* The directory path where the logfile can be found */
sLogFile = 'e:\pvcs\macros\test\src\'

/* ---------------------------- Begin ------------------------------ */

/* Get the currently viewed work file */
's_get_curr_filename sCurrFile'
 if \(RC = 0) then
   do
   's_msg "Could not get the currently viewed file","Error Code is:",' rc ',resp'
   exit
   end
   
/* Build the file path strings */
sDrv = filespec("drive",sCurrFile)
sFileName = filespec("name",sCurrFile)
sPath = filespec("path",sCurrFile)
  
iLp = lastpos('.',sFileName)
sNameOnly = substr(sFileName,1,iLp-1)
  
iLp = lastpos('.',sCurrFile)
sExtension = substr(sCurrFile,iLp+1)
  
/* Make the extension into PVCS standard form, adding a 'V' in the 3rd position */
if (length(sExtension) = 1) then
  sLFExt = insert(sExtension,'_V')
else if (length(sExtension) = 2) then
   sLFExt = insert(sExtension,'V')
else if (length(sExtension) = 3) then
  sLFExt = overlay('V',sExtension,3)
else
  sLFExt = '__V'
  
/* Build the logfile name */
sLogFile = insert(sLogFile,sNameOnly)
sLogFile = insert(sLogFile,'.')
sLogFile = insert(sLogFile,sLFExt)
 
cmd = pvcsvlog '-xeerr -xooutput' sLogFile
cmd

if (rc=0) then
  slstart output
else
  do
  's_msg "VLOG did not work","Error Code was:",' rc ',resp'
  'slstart err'
  end

/* fini */