/* PUT.REX - PVCS PUT the currently viewed work file.

  This macro PUTs the current file that you are viewing to a logfile.
  If the log file does not exist, one is created and a file comment
  can be entered.

  A revision comment is prompted for. 

  CANCELing the comment is transparent to functionality of this macro.
  Your work file will still be PUT into the log file.

  Customizations necessary:
  1. PVCSPUT specs where the PUT executable is.
  2. sLogFile is the directory where your log file in question is.
     Remember the final '\'.
*/

/* -------------------------- Alias list ----------------------------*/

      /* Setup full path to PUT */
pvcsput = 'e:\pvcs\put'

      /* Set the Log File directory */
sLogFile = 'e:\pvcs\macros\test\src\'
      
/* ---------------------------- Begin ------------------------------ */

's_get_curr_filename sCurrFile'
 if \(RC = 0) then
   do
   's_msg "Could not obtain the current file name","Error Code is:",' rc ',resp'
   exit
   end

/* Build the string for the files */    
sDrv = filespec("drive",sCurrFile)
sFileName = filespec("name",sCurrFile)
sPath = filespec("path",sCurrFile)
  
iLp = lastpos('.',sFileName)
sNameOnly = substr(sFileName,1,iLp-1)
  
iLp = lastpos('.',sCurrFile)
sExtension = substr(sCurrFile,iLp+1)
  
/* Make the extension into PVCS standard form, adding a 'V' in the 3rd position */
if (length(sExtension) = 1) then
  sLFExt = insert(sExtension,'_V')
else if (length(sExtension) = 2) then
   sLFExt = insert(sExtension,'V')
else if (length(sExtension) = 3) then
  sLFExt = overlay('V',sExtension,3)
else
  sLFExt = '__V'
  
/* Build the logfile name */
sLogFile = insert(sLogFile,sNameOnly)
sLogFile = insert(sLogFile,'.')
sLogFile = insert(sLogFile,sLFExt)
  
/* Get Revision Comment */
's_prompt "Revision Comment?",' sComment
if \(sComment='CANCEL') then
do
  sComment = insert('-m"',sComment)
  sComment = insert(sComment,'"')
end
else
  sComment = ''

/* Build path parameter. Create: logfile(workfile */   
sPathParam = insert(sLogFile,'(')
sPathParam = insert(sPathParam,sCurrFile)

/* If the LogFile exists, PUT the file.
   If the LofFile DOES NOT EXIST, ask for a LogFile comment too! Then PUT the file.
*/       
resp = stream(sLogFile,'c','query exists')
if (length(resp) > 0) then
  cmd = pvcsput sComment '-q -xeerr' sPathParam
else
  do
  's_prompt "Comment for NEW LogFile",'  sFileComment
  if \(sFileComment='CANCEL') then
    do
    sFileComment = insert('-t"',sFileComment)
    sFileComment = insert(sFileComment,'"')
    end
  else
    sComment = ''
  cmd = pvcsput  sComment sFileComment '-q -xeerr' sPathParam
  end
cmd  /* PUT here */    

/* If the PUT went ok, close the current file ( the workfile ).
   If the PUT went bad, tell us and SLSTART the error file.
*/       
if (rc=0) then
  do
  's_msg "File has been PUT",,,resp'
  's_close_curr_file'
  end
else
  do
  's_msg "There was an error:",' rc ',"Report it please",resp'
  'slstart err'
  end

exit

/* fini */