/* GETWLCK.REC - PVCS GET current file With LoCK

  This macro GETs the current file that you are viewing from the logfile
  and locks the logfile.

  Customizations necessary:
  1. PVCSGET specs where the GET executable is.
  2. sLogFile is the directory where your log file in question is.
     Remember the final '\'.
*/

/* -------------------------- Alias list ----------------------------*/

      /* GET */
PVCSGET = 'e:\pvcs\get'

      /* The directory path where the logfile can be found */
sLogFile = 'e:\pvcs\macros\test\src\'

/* ---------------------------- Begin ------------------------------ */

     /* Get the current file */
's_get_curr_filename sCurrFile'
 if \(RC = 0) then
   do
   's_msg "Could not obtain the current file name","Error Code is:",' rc ',resp'
   exit
   end

  /* Build all strings we will use about the work file and log file. */   
  sDrv = filespec("drive",sCurrFile)
  sFileName = filespec("name",sCurrFile)
  sPath = filespec("path",sCurrFile)
  
  iLp = lastpos('.',sFileName)
  sNameOnly = substr(sFileName,1,iLp-1)
  
  iLp = lastpos('.',sCurrFile)
  sExtension = substr(sCurrFile,iLp+1)
  
  /* Make the extension into PVCS standard form, adding a 'V' in the 3rd position */
  if (length(sExtension) = 1) then
    sLFExt = insert(sExtension,'_V')
  else if (length(sExtension) = 2) then
     sLFExt = insert(sExtension,'V')
  else if (length(sExtension) = 3) then
    sLFExt = overlay('V',sExtension,3)
  else
    sLFExt = '__V'
  
  /* Build the logfile name */
  sLogFile = insert(sLogFile,sNameOnly)
  sLogFile = insert(sLogFile,'.')
  sLogFile = insert(sLogFile,sLFExt)
      
  
  cmd = pvcsget '-l -q -xeerr' sLogFile
  cmd

  /* If the command to do the get failed, give the user the ERR file */
  if \(rc=0) then
    do
    's_msg "GET failed, error code is:",' rc ',,resp'
    'slstart err'
    end
  else
    do
      's_close_curr_file'
      's_open_sl_file 0 E N' sCurrFile
      's_msg "GET w/Lock succeeded",,,resp'
    end

/* fini */