/* GAFRLSTU.REX - Get All FRom LiST Unlocked

   This macro GETs all files in an LST file generated from either
   an os tool or SourceLink
   
   Customizations necessary:
     1. Create a list of PVCS logfiles using SourceLink's Maintain 
        List-Of-File.
     2. Edit the list, removing the 1st line, the '\\#'.
     3. Alter the alias' herein to suite.
     4. Edit all Alias' below to suit.
*/

/* -------------------------- Alias list ----------------------------*/

      /* The path to PVCS GET.EXE */
GetPath = 'e:\pvcs\get'

      /* The path to the group file */
GroupPath = 'e:\pvcs\macros\test\eric.grp'   

      /* The directory that will be the destination for the workfiles */
DestDir = 'e:\pvcs\macros\test'

      /* This is the Configuration File parameter */
      /* create pattern: -c\..\..\vcs.dir */
CfgParam = insert('-c',DestDir)
CfgParam = insert(CfgParam,'\vcs.cfg')

      /* This is the Error Output path */
      /* create pattern: -xe\..\..\err */
ErrPath = insert(DestDir,'\err')

      /* This is the Error Output parameter */
      /* create pattern: \..\..\err */      
ErrParam = insert('-xe',ErrPath)

      /* This is the Group file parameter */
      /* create pattern: @\..\..\file.grp(destDir) */
GroupParam = insert('@',GroupPath)

/* ---------------------------- Begin ------------------------------ */


's_cd' DestDir
cmd = GetPath '-w -q ' ErrParam CfgParam GroupParam
cmd

if \(rc=0) then
  do
  's_msg "GET ALL failed","Error Code was:",' RC ',resp'
  slstart ErrPath
  end
else
  's_msg "GET ALL succeeded",,,resp'

/* end */