/* CHECKOUT.CMD - Checks the current SourceLink file out of SourceSafe */

'S_SAVE_POS'                                            /* Save off current position in file */

'S_GET_BUFF_FILENAME' 0 OrigName                        /* Get current file name */

'S_CLOSE_SL_FILE' 0                                     /* Close the current file */

/* Change directory to the directory of the current SourceLink file */

LastSlashPos = LASTPOS('\',OrigName)                    /* Find the position of last slash */
PathName = LEFT(OrigName,LastSlashPos-1)                /* Trim off filename at the end of the string */
's_cd "'PathName'"'                                     /* Change directory to current file directory */

NoDriveName = RIGHT(OrigName,LENGTH(OrigName)-2)        /* Strip off the drive: from the name */

'S_OPEN_SL_FILE 1 E Y TEMP.TMP'                         /* Open a temp file in SourceLink */

'S_INSERT_LINE   '                                      /* Put out wait message */
'S_INSERT_LINE   '
'S_INSERT_LINE               Please wait while SourceSafe retrieves your file.'

'l:\ss\os2\ss checkout' NoDriveName '2> out.out'        /* Ask SourceSafe to check out the name into current dir */

IF rc \= 0 THEN DO
   ErrorCode = rc
   
   'S_OPEN_SL_FILE 0 R N' out.out                       /* Have SourceLink show the error file */
   
   'S_MSG SourceSafe got an error:,' ErrorCode ',,' UserResult  /* Report error to user */

   'S_CLOSE_SL_FILE' 0                                  /* Close the error file */
END

'del out.out'                                           /* Delete SourceSafe output file */

'S_CLOSE_SL_FILE' 0                                     /* Close the wait message file */

'del temp.tmp'                                          /* Delete temp file */

'S_OPEN_SL_FILE 0 D N' OrigName                         /* Have SourceLink edit the checked out file */

'S_GOTO_POS'                                            /* Go back to saved position */