//
// Project: Digitalk Parts like Toolbar and SOMObjects Demo
// File:    Somparts.hpp
// Author:  Stewart Hyde
// Created: Dec   17, 1993
// Updated: Jan   10, 1993
//
// Description:
//

#ifndef _SOMPARTS_HPP_
	#define _SOMPARTS_HPP_
  
#ifndef _IFRAME_
  #include <iframe.hpp>
#endif

#ifndef _ISTATTXT_
  #include <istattxt.hpp>
#endif

#ifndef _ICMDHDR_
  #include <icmdhdr.hpp>
#endif

#ifndef _IMENUBAR_
  #include <imenubar.hpp>
#endif

#ifndef _ITITLE_
  #include <ititle.hpp>
#endif

#ifndef _SOMACT_HPP_
	#include "somact.hpp"
#endif

class IString;
class PartsWindow;

// ------------------------------------------------------------------------
//  Class:			PartsWindow
//  Derived:		IFrameWindow
//						ICommandHander
//                
//  Description:	This class describes the main application window in
//						this demo
//
// ------------------------------------------------------------------------


class PartsWindow : public IFrameWindow,
                    public ICommandHandler
{
	typedef IFrameWindow Inherited;
  	public:
    	PartsWindow(IWindow *parent, IWindow *owner=0);
    	~PartsWindow();
  
  protected:
    	virtual Boolean command(ICommandEvent &evt);
		void DoPartsNoteBook();
	   void DoPartsListBox();
		void DoProdInformation();
		void DSOM_DebugMessage(Boolean Status);
           
  private:
    	IStaticText clientWin;
    	IMenuBar    menuBar;
    	ITitle      title;
		SomAction   *somAction;
		Boolean		DebugStatus;

    	// default exception handler class
    	class ExceptionHandler : public IWindow::ExceptionFn
    	{
      	public:
        		virtual Boolean handleException(IException &exception, 
                                        	  IEvent     &event);
    	};
    	ExceptionHandler                      excHandler;
};

//
// inline functions
//

inline PartsWindow::~PartsWindow()
{
	delete somAction;
}
 
#endif // _SOMPARTS_HPP_
