//
// Project: Digitalk Parts like Toolbar and SOMObjects Demo
// File:    Somparts.cpp
// Author:  Stewart Hyde
// Created: Dec   17, 1993
// Updated: Jan   10, 1994
//
// Description:
//

#include <iapp.hpp>
#include <icolor.hpp>
#include <istring.hpp>
#include <imsgbox.hpp>
#include "somparts.hpp"
#include "somparts.h"
#include "parts.hpp"
#include "listbox.hpp"
#include "infodlg.hpp"
  

// ------------------------------------------------------------------------
//  Class:				N/A
//  Function:			main
//                
//  Description:		main program entry point
//       
//  Input:				int argc  	- no of command line arguments
//							char **argv - pointer to arguments
//
//  Output:
//
//  Notes:
//
// ------------------------------------------------------------------------

int main(int argc, char **argv)
{
  	PartsWindow    *pPartsWindow;
	int result = 0;

	// --------------------------------------------------------------------  
  	// Create the main application's window for this demo program
	// --------------------------------------------------------------------  

  	try
  	{
		// -----------------------------------------------------------------
    	// create an instance of the PartsWindow window class
		// -----------------------------------------------------------------

    	pPartsWindow = new PartsWindow(IFrameWindow::desktopWindow(), 0);

		// -----------------------------------------------------------------
    	// tell the object to delete itself when its window is destroyed.
		// -----------------------------------------------------------------

    	pPartsWindow->setAutoDeleteObject();

		// -----------------------------------------------------------------
		// set the input focus to the object's window and display it.
		// -----------------------------------------------------------------

    	pPartsWindow->setFocus();
    	pPartsWindow->show();
                                         
		// -----------------------------------------------------------------
    	// execute the application, processing its events
		// -----------------------------------------------------------------

    	IApplication::current().run();
	}
  	catch (IException &exc)
  	{
		result = -1;
  	}
 
	return (result);
}
 
// ------------------------------------------------------------------------
//  Class:				PartsWindow				
//  Function:			PartsWindow (constructor)
//                
//  Description:		This is contructor for the main parts window
//       
//  Input:				IWindow *parentWin - parent Window
//							IWindow *ownerWin  - owner Window
//
//  Output:
//
//  Notes:
//
// ------------------------------------------------------------------------


PartsWindow::PartsWindow(IWindow *parentWin, IWindow *ownerWin)
  : IFrameWindow(WND_PARTS_WINDOW, 
                   parentWin, ownerWin,
                   IRectangle(),
						 IFrameWindow::defaultStyle() | shellPosition),
       clientWin(WND_PARTS_WINDOW, this, this),
       menuBar(WND_PARTS_WINDOW, this),
       title(this, WND_PARTS_WINDOW)
{
	// ---------------------------------------------------------------------
	// Handle command events
	// ---------------------------------------------------------------------

  	ICommandHandler::handleEventsFor(this);
  
	// ---------------------------------------------------------------------
  	// Set up the client window
	// ---------------------------------------------------------------------

  	setClient(&clientWin);
  
  	setExceptionFunction(&excHandler);

	somAction = new SomAction();

	// ---------------------------------------------------------------------
   // Initial debuging to false and setup menus approviately
	// ---------------------------------------------------------------------

	DebugStatus=true;
	DSOM_DebugMessage(false);
}                             

// ------------------------------------------------------------------------
//  Class:				PartsWindow
//  Function:			DoPartsNoteBook
//                
//  Description:		process parts notebook
//       
//  Input:				N/A
//
//  Output:				N/A
//
//  Notes:
//
// ------------------------------------------------------------------------

void PartsWindow::DoPartsNoteBook()
{
   // ---------------------------------------------------------------------
	//  Create a frame window to wrap around our Parts NoteBook 
   // ---------------------------------------------------------------------
      
   IFrameWindow *frameWin = 
          new IFrameWindow(WND_PARTS_NOTE_BOOK, 
                           desktopWindow(), 
                           this, 
                           IRectangle(),
									IFrameWindow::dialogBorder |
                           IFrameWindow::defaultStyle() &
                           ~IFrameWindow::shellPosition &
									~IFrameWindow::sizingBorder &
                           ~IFrameWindow::windowList);
   frameWin->setAutoDeleteObject();

	// ---------------------------------------------------------------------
	// Create a PartsNoteTool notebook
	// ---------------------------------------------------------------------
	
   PartsNoteTool *notebk = new PartsNoteTool(frameWin, frameWin, somAction);
   notebk->setAutoDeleteObject();

	// ---------------------------------------------------------------------
   // Set the notebook as the client window for the frame window
	// ---------------------------------------------------------------------

   frameWin->setClient(notebk);

	// ---------------------------------------------------------------------
   // size the window to the notebook and display it
	// ---------------------------------------------------------------------

   frameWin->sizeTo(frameWin->frameRectFor(notebk->rect()).size());
   frameWin->setFocus();
   frameWin->show();
}

 
// ------------------------------------------------------------------------
//  Class:				PartsWindow
//  Function:			DoPartsListBox
//                
//  Description:		process parts notebook
//       
//  Input:				N/A
//
//  Output:				N/A
//
//  Notes:
//
// ------------------------------------------------------------------------

void PartsWindow::DoPartsListBox()
{
   // ---------------------------------------------------------------------
	//  Create a frame window to wrap around our Parts Listbox dialog 
   // ---------------------------------------------------------------------

   IFrameWindow *frameWin = new IFrameWindow(WND_PARTS_LISTBOX, 
             desktopWindow(), this,
             IRectangle(),
             IFrameWindow::shellPosition | IFrameWindow::systemMenu |
				 IFrameWindow::titleBar| IWindow::clipSiblings |
             IFrameWindow::dialogBorder| IWindow::clipChildren);

   // ---------------------------------------------------------------------
	//  Create a PartListBoxObject
   // ---------------------------------------------------------------------

   PartsListbox *listbox = new PartsListbox(frameWin, frameWin, somAction);
   frameWin->setClient(listbox);

	// ---------------------------------------------------------------------
   // size the dialog to the notebook and display it
	// ---------------------------------------------------------------------

   frameWin->sizeTo(frameWin->frameRectFor(listbox->rect()).size());
   listbox->setColor(listbox->background, IGUIColor(IGUIColor::dialogBgnd));
	frameWin->setAutoDeleteObject();
	listbox->setAutoDeleteObject();
   frameWin->setFocus();
	frameWin->show();
}

// ------------------------------------------------------------------------
//  Class:				PartsWindow
//  Function:			DoProdInformation
//                
//  Description:		Display information about this program
//       
//  Input:				N/A
//
//  Output:				N/A
//
//  Notes:
//
// ------------------------------------------------------------------------

void PartsWindow::DoProdInformation()
{
	InfoDialog ProdInfo(WND_PROD_INFORMATION,desktopWindow(),this);

	ProdInfo.DisplayDialog();
}


// ------------------------------------------------------------------------
//  Class:				PartsWindow
//  Function:			DSOM_DebugMessage
//                
//  Description:		Enable or Disable DSOM debug messages which are sent
//							to the server's window
//       
//  Input:				Boolean Status - Enable or Disable flag
//
//  Output:				N/A
//
//  Notes:
//
// ------------------------------------------------------------------------

void PartsWindow::DSOM_DebugMessage(Boolean Status)
{
	// --------------------------------------------------------------------
	//  Save status for later
	// --------------------------------------------------------------------

	DebugStatus = Status;


	// --------------------------------------------------------------------
	//  Set up menus approviately
	// --------------------------------------------------------------------

	if (Status)
	{
	   menuBar.enableItem(MI_DISABLE_DEBUG);	 
	   menuBar.disableItem(MI_ENABLE_DEBUG);	 
	}
	else
	{
	   menuBar.enableItem(MI_ENABLE_DEBUG);	 
	   menuBar.disableItem(MI_DISABLE_DEBUG);	 
	}

	// --------------------------------------------------------------------
	//  Change state via SomAction (DSOM)
	// --------------------------------------------------------------------
	
	somAction->DebugMessage(Status);	
}

// ------------------------------------------------------------------------
//  Class:				PartsWindow
//  Function:			command
//                
//  Description:		Main applications windows command event handler
//       
//  Input:				ICommandEvent &evt - command event
//
//  Output:				Boolean - result
//
//  Notes:
//
// ------------------------------------------------------------------------

Boolean PartsWindow::command(ICommandEvent &evt)
{
  	switch(evt.commandId())
  	{
         
    	case MI_PARTS_NOTEBOOK:  
			DoPartsNoteBook();
			break;

    	case MI_PARTS_LISTBOX:  
			DoPartsListBox();
			break;

    	case MI_PROD_INFORMATION:  
			DoProdInformation();
			break;

		case MI_DISABLE_DEBUG:
			DSOM_DebugMessage(false);
			break;

		case MI_ENABLE_DEBUG:
			DSOM_DebugMessage(true);
			break;

    	default:
			return false;
  }
  return true;
}

// ------------------------------------------------------------------------
//  Class:				PartsWindow
//  Function:	 		handleException
//                
//  Description:		nested ExceptionHandler function to intercept 
//							uncaught exceptions while windows is dispatching
//							events
//       
//  Input:				IException &exception - exception 
//							IEvent     &event		 - event that cause this exception		
//
//  Output:
//
//  Notes:
//
// ------------------------------------------------------------------------

Boolean PartsWindow::ExceptionHandler::handleException(IException &exception, 
                                                       IEvent     &event)
{

	// ---------------------------------------------------------------------
	// Create text to display in message box
	// ---------------------------------------------------------------------
  	IString str("SOMPARTS Exception:\n\n");
  	if (exception.textCount() == 0)
    	str += "undefined exception";
  	else
    	str += exception.text(exception.textCount()-1);


	// ---------------------------------------------------------------------
	// Create and display a message box to user for exception
	// ---------------------------------------------------------------------

  	IMessageBox msgBox(event.window());
  	msgBox.setTitle(exception.name());
  	IMessageBox::Response result = 
	 	msgBox.show(str, IMessageBox::okCancelButton   |
                       IMessageBox::informationIcon  |
                       IMessageBox::applicationModal |
                       IMessageBox::moveable);

	// ---------------------------------------------------------------------
	// if user press ok, return true otherwise false
	// ---------------------------------------------------------------------

  	if (result == IMessageBox::ok)
    	return true;
  	else
    	return false;
}
