//
// Project: Digitalk Parts like Toolbar and SOMObjects Demo
// File:    Somact.hpp
// Author:  Stewart Hyde
// Created: Dec   18, 1993
// Updated: Jan   10, 1993
//
// Description:
//

#ifndef _SOMACT_HPP_
	#define _SOMACT_HPP_

#ifndef _IBASE_
	#include <ibase.hpp>
#endif

#include <somd.xh>
#include <istack.h>
#include "Part.xh"


typedef unsigned long ULONG;

// ------------------------------------------------------------------------
//  Class:			SetAction
//  Derived:		IBase
//                
//  Description:	This is a class use for storing Sets and Actions on list
//
// ------------------------------------------------------------------------


class SetAction : public IBase
{
	public:
		SetAction(ULONG ulSet, ULONG ulAction, Boolean UpdateFlag)
				 {Action = ulAction; Set = ulSet; Update = UpdateFlag; };
		~SetAction() {};
		ULONG getSet() {return Set; };
		ULONG getAction() {return Action; };
		Boolean getUpdate() {return Update; };
	private:
		ULONG Set;
		ULONG Action;
		Boolean Update;
};
  
// -----------------------------------------------------------------------
//	define a stack of SetAction class's
// -----------------------------------------------------------------------

typedef IStack<SetAction>  SetActionStack;

// ------------------------------------------------------------------------
//  Class:			SomAction
//  Derived:		IBase
//                
//  Description:	This is SOMObject action object in C++
//
// ------------------------------------------------------------------------

class SomAction : public IBase
{
	public:
		SomAction();
		~SomAction();
		void Process(ULONG ulSet, ULONG ulAction);
		Boolean Next();
		void DebugMessage(Boolean Status);
		ULONG getSet() { return Set; };
		ULONG getAction() { return Action; };
		ULONG getCount() { return Count; };
		ULONG getIndex() { return Index; };
	   Boolean getUpdate() {return UpdateFlag; };
		Boolean getAvailable() {return Available; };
	protected:
		Boolean Search(ULONG ulSet, ULONG ulAction);
		Boolean Add(ULONG ulSet, ULONG ulAction);
		Boolean Update(ULONG ulSet, ULONG ulAction);
		Boolean NextUpdateList(ULONG *pulSet, ULONG *pulAction);
		Boolean AddToUpdateList(ULONG ulSet, ULONG ulAction);
	private:
  		Environment *ev;
		Part *part;
		Boolean UpdateListCreated;
		Boolean Available;
		Boolean UpdateFlag;
		ULONG Index;
		ULONG Set;
		ULONG Action;
		ULONG Count;
		SetActionStack Stack;
};

#endif // _SOMACT_HPP_
