//
// Project: Digitalk Parts like Toolbar and SOMObjects Demo
// File:    Somact.cpp
// Author:  Stewart Hyde
// Created: Dec   19, 1993
// Updated: Jan   10, 1993
//
// Description:
//

#include <stdio.h>
#include "somact.hpp"

#define checkEv(ev) ((ev)->_major != NO_EXCEPTION)

// ------------------------------------------------------------------------
//  Class:				SomAction
//  Function:			SomAction  (Constructor)
//                
//  Description:		This is the contructor for SomAction
//       
//  Input:				N/A
//
//  Output:				N/A
//
//  Notes:
//
// ------------------------------------------------------------------------

SomAction::SomAction()
{
	UpdateListCreated = false;
	Available = false;

	// --------------------------------------------------------------------
	//  Initialize Local and DSOM enviroments
	// --------------------------------------------------------------------

  	ev = SOM_CreateLocalEnvironment();
 	SOMD_Init(ev);	

	// --------------------------------------------------------------------
	//  Register Part Class with SOMClassMgr
	// --------------------------------------------------------------------

	PartNewClass(0,0);	
	if (checkEv(ev))
	{
		// -----------------------------------------------------------------
		//  Cleanup Local and DSOM enviroments
		// -----------------------------------------------------------------

		SOMD_Uninit(ev);
		SOM_DestroyLocalEnvironment(ev);
		return;
	}	

	// --------------------------------------------------------------------
	//  Allocate a Part class
	// --------------------------------------------------------------------

	part = (Part *) SOMD_ObjectMgr->somdNewObject(ev, "Part", NULL);
	if (checkEv(ev))
	{
		// -----------------------------------------------------------------
		//  Cleanup Local and DSOM enviroments
		// -----------------------------------------------------------------

		SOMD_Uninit(ev);
		SOM_DestroyLocalEnvironment(ev);
	}	
	else
		Available = true;
}


// ------------------------------------------------------------------------
//  Class:				SomAction
//  Function:			~SomAction  (destructor)
//                
//  Description:		This is the destructor for SomAction
//       
//  Input:				N/A
//
//  Output:				N/A
//
//  Notes:
//
// ------------------------------------------------------------------------

SomAction::~SomAction()
{
	// ---------------------------------------------------------------------
	//  If update list is active, destroy it
	// ---------------------------------------------------------------------
	
	if (UpdateListCreated)
	{
		Stack.removeAll();
	}

	// ---------------------------------------------------------------------
	//  If SOM is availabe than free up SOM
	// ---------------------------------------------------------------------
	
	if (Available)
	{
		// -----------------------------------------------------------------
		//  Cleanup Local and DSOM enviroments
		// -----------------------------------------------------------------

		SOMD_Uninit(ev);
		SOM_DestroyLocalEnvironment(ev);
	}
}

// ------------------------------------------------------------------------
//  Class:				SomAction
//  Function:			Process
//                
//  Description:		Process a SomAction, add a new one if not present
//							otherwise update the current one
//       
//  Input:				ULONG ulSet - set #
//              		ULONG ulAction - function #
//
//  Output:				N/A
//
//  Notes:
//
// ------------------------------------------------------------------------

void SomAction::Process(ULONG ulSet, ULONG ulAction)
{
		if (!Add(ulSet, ulAction))
			Update(ulSet, ulAction);
}

// ------------------------------------------------------------------------
//  Class:				SomAction
//  Function:			Next
//                
//  Description:		Find next updated or added SomAction
//       
//  Input:				N/A
//
//  Output:				TRUE if SomAction is available
//
//  Notes:
//
// ------------------------------------------------------------------------

Boolean SomAction::Next()
{
	ULONG ulSet, ulAction;

	// ---------------------------------------------------------------------
	//  If SOM is not available return false
	// ---------------------------------------------------------------------

	if (!Available)
		return false;

	// ---------------------------------------------------------------------
	//  Get Next Item on the list if available
	// ---------------------------------------------------------------------

	if (!NextUpdateList(&ulSet,&ulAction))
		return false;

	// ---------------------------------------------------------------------
	//  Search for Set and Action found above and return result
	// ---------------------------------------------------------------------

	return(Search(ulSet,ulAction));
}

// ------------------------------------------------------------------------
//  Class:				SomAction
//  Function:			Search
//                
//  Description:		Search for a SomAction with out update
//       
//  Input:				ULONG ulSet - set #
//              		ULONG ulAction - function #
//
//  Output:				TRUE if SomAction is found
//
//  Notes:
//
// ------------------------------------------------------------------------

Boolean SomAction::Search(ULONG ulSet, ULONG ulAction)
{
	long nIndex, nCount;

	// ---------------------------------------------------------------------
	//  If SOM is not available return false
	// ---------------------------------------------------------------------

	if (!Available)
		return false;

	// ---------------------------------------------------------------------
	//  Search for a Part SOM object using the Search method
	// ---------------------------------------------------------------------

	part->Search(ev, ulSet, ulAction, &nIndex, &nCount);
	if (checkEv(ev))
		return false;
	else
	{
		Set = ulSet;
		Action = ulAction;
		Index = (ULONG) nIndex;
		Count = (ULONG) nCount;
		return true;
	}
}	

// ------------------------------------------------------------------------
//  Class:				SomAction
//  Function:			Add
//                
//  Description:		Add a new SomAction
//       
//  Input:				ULONG ulSet - set #
//              		ULONG ulAction - function #
//
//  Output:		 		TRUE if successful
//
//  Notes:				This addes a new action and initializes count to 1
//
// ------------------------------------------------------------------------

Boolean SomAction::Add(ULONG ulSet, ULONG ulAction)
{
	long nIndex, nCount;
	boolean returnVal;

	// ---------------------------------------------------------------------
	//  If SOM is not available return false
	// ---------------------------------------------------------------------

	if (!Available)
		return false;

	// ---------------------------------------------------------------------
	//  Add a Part SOM object using the Add method
	// ---------------------------------------------------------------------

	returnVal = part->Add(ev, ulSet, ulAction, &nIndex, &nCount);
	if ((checkEv(ev)) || (returnVal == FALSE))
		return false;
	else
	{
		Set = ulSet;
		Action = ulAction;
		UpdateFlag = false;
		AddToUpdateList(ulSet,ulAction);
		Index = (ULONG) nIndex;
		Count = (ULONG) nCount;
		return true;
	}
}

// ------------------------------------------------------------------------
//  Class:				SomAction
//  Function:			Update	
//                
//  Description:	   Update a SomAction 
//       
//  Input:				ULONG ulSet - set #
//              		ULONG ulAction - function #
//
//  Output:				TRUE if successful
//
//  Notes:				This basically increase the SomAction Count
//
// ------------------------------------------------------------------------

Boolean SomAction::Update(ULONG ulSet, ULONG ulAction)
{
	long nIndex, nCount;

	// ---------------------------------------------------------------------
	//  If SOM is not available return false
	// ---------------------------------------------------------------------

	if (!Available)
		return false;

	// ---------------------------------------------------------------------
	//  Update a Part SOM object using the Update method
	// ---------------------------------------------------------------------

	part->Update(ev, ulSet, ulAction, &nIndex, &nCount);
	if (checkEv(ev))
		return false;
	else
	{
		Set = ulSet;
		Action = ulAction;
		UpdateFlag = true;
		AddToUpdateList(ulSet,ulAction);
		Index = (ULONG) nIndex;
		Count = (ULONG) nCount;
		return true;
	}
}


// ------------------------------------------------------------------------
//  Class:				SomAction
//  Function:			NextUpdateList
//                
//  Description:	   get next update list item
//       
//  Input:				ULONG *pulSet - set #
//              		ULONG *pulAction - function #
//							Boolean pUpdate - true if this just an update
//
//  Output:				TRUE if successful
//
//  Notes:				Retrived next item on update list
//
// ------------------------------------------------------------------------

Boolean SomAction::NextUpdateList(ULONG *pulSet,
										    ULONG *pulAction)
{
	SetAction setAction(0,0,false);

	// ---------------------------------------------------------------------
	//  If stack is empty, return false
	// ---------------------------------------------------------------------
	
	if (Stack.isEmpty())
		return false;

	// ---------------------------------------------------------------------
	//  Poo Set and Action off of stack
	// ---------------------------------------------------------------------

	Stack.pop(setAction);
	(*pulSet) = setAction.getSet();
	(*pulAction) = setAction.getAction();
	UpdateFlag = setAction.getUpdate();	
	return true;
}

// ------------------------------------------------------------------------
//  Class:				SomAction
//  Function:			AddToUpdateList
//                
//  Description:	   Add item to update list
//       
//  Input:				ULONG ulSet - set #
//              		ULONG ulAction - function #
//
//  Output:				TRUE if successful
//
//  Notes:				Retrived next item on update list
//
// ------------------------------------------------------------------------

Boolean SomAction::AddToUpdateList(ULONG ulSet,
											  ULONG ulAction)
{
	SetAction  setAction(ulSet,ulAction,UpdateFlag);

	// ---------------------------------------------------------------------
	//  If Update List is not created than create one
	// ---------------------------------------------------------------------
	
	if (!UpdateListCreated)
	{
		// ------------------------------------------------------------------
		//  We only need to create it once
		// ------------------------------------------------------------------
		
		Stack.removeAll();
		UpdateListCreated = true;
	}

	// ---------------------------------------------------------------------
	//  Push Set and Action onto stack
	// ---------------------------------------------------------------------

	Stack.push(setAction);
	return true;
}



// ------------------------------------------------------------------------
//  Class:				SomAction
//  Function:			DebugMessage
//                
//  Description:	   Enable or Disable Debug Messages
//       
//  Input:				Boolean Status - enable or disable status
//
//  Output:				N/A
//
//  Notes:				
//
// ------------------------------------------------------------------------

void SomAction::DebugMessage(Boolean Status)
{
	// ---------------------------------------------------------------------
	//  If DSOM is not available return
	// ---------------------------------------------------------------------

	if (!Available)
		return;

	// ---------------------------------------------------------------------
	//  Enable or Disable Debug Message by calling DSOM object
	// ---------------------------------------------------------------------
	
	if (Status)
		part->Debug(ev, TRUE);
	else
		part->Debug(ev, FALSE);
		
}
