/* @(#) somx/initterm.c 2.2 6/2/93 01:18:05 [6/9/93 16:18:32] */

/*
 * 96F8647, 96F8648 (C) Copyright IBM Corp. 1992, 1993
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * DISCLAIMER OF WARRANTIES.
 * The following [enclosed] code is sample code created by IBM
 * Corporation. This sample code is not part of any standard or IBM
 * product and is provided to you solely for the purpose of assisting
 * you in the development of your applications.  The code is provided
 * "AS IS". IBM MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT
 * NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE, REGARDING THE FUNCTION OR PERFORMANCE OF
 * THIS CODE.  IBM shall not be liable for any damages arising out of
 * your use of the sample code, even if they have been advised of the
 * possibility of such damages.
 *
 * DISTRIBUTION.
 * This sample code can be freely distributed, copied, altered, and
 * incorporated into other software, provided that it bears the above
 * Copyright notice and DISCLAIMER intact.
 */


#define INCL_DOSMODULEMGR
#define INCL_DOSPROCESS
#include <os2.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#define STATIC_LINK


extern long SOMD_DebugFlag;
extern long SOMD_TraceLevel;

// If you want to include DSOM tracing uncomment the following #define

// #define DSOM_TRACING_ENABLE	



/* _CRT_init is the C run-time environment initialization function.  It   */
/* will return 0 to indicate success and -1 to indicate failure.          */

int _CRT_init( void );

#ifdef STATIC_LINK
/* _CRT_term is the C run-time environment termination function.  It      */
/* only needs to be called when the C run-time functions are statically   */
/* linked.                                                                */

void _CRT_term( void );
#else
/* A clean up routine registered with DosExitList must be used if runtime */
/* calls are required and the runtime is dynamically linked.  This will   */
/* guarantee that this clean up routine is run before the library DLL is  */
/* terminated.                                                            */

static void _System cleanup( ULONG ulReason );
#endif

/* _DLL_InitTerm is the function that gets called by the operating system */
/* loader when it loads and frees this DLL for each process that accesses */
/* this DLL.  However, it only gets called the first time the DLL is      */
/* loaded and the last time it is freed for a particular process.  The    */
/* system linkage convention MUST be used because the operating system    */
/* loader is calling this function.                                       */

unsigned long _System _DLL_InitTerm( unsigned long hModule,
				     unsigned long ulFlag )
{ 
   /* If ulFlag is zero then the DLL is being loaded so initialization */
   /* should be performed.  If ulFlag is 1 then the DLL is being freed */
   /* so termination should be performed.                              */

   switch( ulFlag )
      {
      case 0:
         /* The C run-time environment initialization function must be */
         /* called before any calls to C run-time functions that are   */
	 /* not inlined.                                               */

         if ( _CRT_init( ) == -1 )
            return 0UL;

      #ifndef STATIC_LINK
         /* A DosExitList routine must be used to clean up if runtime */
         /* call are required and the runtime is dynamically linked.  */

         if ( rc = DosExitList( 0x0000FF00 | EXLST_ADD, cleanup ) )
            printf( "DosExitList returned %lu\n", rc );
      #endif

         /**************************************************/
         /* place DLL initialization customization here    */
         /**************************************************/

	   #ifdef DSOM_TRACING_ENABLE	
			SOMD_TraceLevel = 1;
			SOMD_DebugFlag = 1;
		#endif


         break;

      case 1:
      #ifdef STATIC_LINK

         /**************************************************/
         /* place DLL termination customization here       */
         /**************************************************/

         _CRT_term( );
      #endif
         break;

      default:
         return 0UL; /* indicates failure */
      }

   /* A non-zero value must be returned to indicate success. */

   return 1UL;
   }

#ifndef STATIC_LINK

static void cleanup( ULONG ulReason )
{
   if ( !ulReason )
      {
         /**************************************************/
         /* place DLL termination customization here       */
         /**************************************************/
      }

   DosExitList( EXLST_EXIT, cleanup );

   return;
}
#endif
