//
// Project: Digitalk Parts like Toolbar and SOMObjects Containers Demo
// File:    Client.cpp
// Author:  Stewart Hyde
// Created: Dec   18, 1993
// Updated: Dec   18, 1993
//
// Description:
//		This is a test program for DSOM Part.dll
//


#include <stdio.h>
#include <somd.xh>
#include <Part.xh>

#define checkEv(ev) ((ev)->_major != NO_EXCEPTION)

void ErrorReport(Environment *ev)
{
	somPrintf("Error Occured\n");
	// --------------------------------------------------------------------
	//  Cleanup Local and DSOM enviroments
	// --------------------------------------------------------------------

	SOMD_Uninit(ev);
	SOM_DestroyLocalEnvironment(ev);
}

PrintStatus(long x, long y, long Index, long Count)
{
	somPrintf("Set #%d, Function #%d, Index= %d, Count = %d\n",x,y,Index,Count);
}


int main(int argc, char *argv[])
{
  	Environment *ev;
	Part *part = (Part *) NULL;
	Part *part2 = (Part *) NULL;
	long nIndex, nCount;

	// --------------------------------------------------------------------
	//  Initialize Local and DSOM enviroments
	// --------------------------------------------------------------------

  	ev = SOM_CreateLocalEnvironment();
 	SOMD_Init(ev);	

	// --------------------------------------------------------------------
	//  Register Part Class with SOMClassMgr
	// --------------------------------------------------------------------

	PartNewClass(0,0);	


	// --------------------------------------------------------------------
	//  Allocate a Part class
	// --------------------------------------------------------------------

	part = (Part *) SOMD_ObjectMgr->somdNewObject(ev, "Part", NULL);
	if (checkEv(ev))
	{
		ErrorReport(ev);
		return(-1);
	}	

	// --------------------------------------------------------------------
	//  Allocate a Part class
	// --------------------------------------------------------------------

	part2 = (Part *) SOMD_ObjectMgr->somdNewObject(ev, "Part", NULL);
	if (checkEv(ev))
	{
		ErrorReport(ev);
		return(-1);
	}	

	part->Add(ev, 1, 1, &nIndex, &nCount);
	if (checkEv(ev))
	{
		ErrorReport(ev);
		return(-1);
	}	
	else
		PrintStatus(1,1,nIndex,nCount);

	part2->Add(ev, 1, 1, &nIndex, &nCount);
	if (checkEv(ev))
	{
		ErrorReport(ev);
		return(-1);
	}	
	else
		PrintStatus(1,1,nIndex,nCount);


	part->Update(ev, 1, 1, &nIndex, &nCount);
	if (checkEv(ev))
	{
		ErrorReport(ev);
		return(-1);
	}	
	else
		PrintStatus(1,1,nIndex,nCount);

	part->Add(ev, 1, 2, &nIndex, &nCount);
	if (checkEv(ev))
	{
		ErrorReport(ev);
		return(-1);
	}	
	else
		PrintStatus(1,2,nIndex,nCount);

	part2->Add(ev, 1, 2, &nIndex, &nCount);
	if (checkEv(ev))
	{
		ErrorReport(ev);
		return(-1);
	}	
	else
		PrintStatus(1,2,nIndex,nCount);


	part->Add(ev, 2, 1, &nIndex, &nCount);
	if (checkEv(ev))
	{
		ErrorReport(ev);
		return(-1);
	}	
	else
		PrintStatus(2,1,nIndex,nCount);

	part->Update(ev, 2, 1, &nIndex, &nCount);
	if (checkEv(ev))
	{
		ErrorReport(ev);
		return(-1);
	}	
	else
		PrintStatus(2,1,nIndex,nCount);

	part->Update(ev, 1, 2, &nIndex, &nCount);
	if (checkEv(ev))
	{
		ErrorReport(ev);
		return(-1);
	}	
	else
		PrintStatus(1,2,nIndex,nCount);


	part->Update(ev, 1, 1, &nIndex, &nCount);
	if (checkEv(ev))
	{
		ErrorReport(ev);
		return(-1);
	}	
	else
		PrintStatus(1,1,nIndex,nCount);

	part2->Update(ev, 1, 1, &nIndex, &nCount);
	if (checkEv(ev))
	{
		ErrorReport(ev);
		return(-1);
	}	
	else
		PrintStatus(1,1,nIndex,nCount);

	
	part->Update(ev, 1, 2, &nIndex, &nCount);
	if (checkEv(ev))
	{
		ErrorReport(ev);
		return(-1);
	}	
	else
		PrintStatus(1,2,nIndex,nCount);

	part->Update(ev, 1, 2, &nIndex, &nCount);
	if (checkEv(ev))
	{
		ErrorReport(ev);
		return(-1);
	}	
	else
		PrintStatus(1,2,nIndex,nCount);

	part2->Update(ev, 1, 2, &nIndex, &nCount);
	if (checkEv(ev))
	{
		ErrorReport(ev);
		return(-1);
	}	
	else
		PrintStatus(1,2,nIndex,nCount);

	part->Add(ev, 2, 2, &nIndex, &nCount);
	if (checkEv(ev))
	{
		ErrorReport(ev);
		return(-1);
	}	
	else
		PrintStatus(2,2,nIndex,nCount);

	part->Add(ev, 2, 3, &nIndex, &nCount);
	if (checkEv(ev))
	{
		ErrorReport(ev);
		return(-1);
	}	
	else
		PrintStatus(2,3,nIndex,nCount);


	part->Add(ev, 2, 4, &nIndex, &nCount);
	if (checkEv(ev))
	{
		ErrorReport(ev);
		return(-1);
	}	
	else
		PrintStatus(2,4,nIndex,nCount);


	part2->Add(ev, 2, 5, &nIndex, &nCount);
	if (checkEv(ev))
	{
		ErrorReport(ev);
		return(-1);
	}	
	else
		PrintStatus(2,5,nIndex,nCount);


	// --------------------------------------------------------------------
	//  Cleanup Local and DSOM enviroments
	// --------------------------------------------------------------------

	SOMD_Uninit(ev);
	SOM_DestroyLocalEnvironment(ev);

	return(0);
}
