//
// Project: Digitalk Parts like Toolbar and SOMObjects Demo
// File:    SetPages.hpp
// Author:  Stewart Hyde
// Created: Dec   17, 1993
// Updated: Jan    6, 1993
//
// Description:
//

#ifndef _SETPAGES_HPP_
  #define _SETPAGES_HPP_

#ifndef _ICANVAS_
  #include <icanvas.hpp>
#endif

#ifndef _IFONT_
  #include <ifont.hpp>
#endif

#ifndef _ICMDHDR_
  #include <icmdhdr.hpp>
#endif
    
#ifndef _IPUSHBUT_
  #include <ipushbut.hpp>
#endif
   
#ifndef _IENTRYFD_
  #include <ientryfd.hpp>
#endif
   
#ifndef _ISTATTXT_
  #include <istattxt.hpp>
#endif
   
#ifndef _IGROUPBX_
  #include <igroupbx.hpp>
#endif

#ifndef _IGRAPHBT_
  #include <igraphbt.hpp>
#endif

#ifndef _SOMACT_HPP_
	#include "somact.hpp"
#endif

class IFrameWindow;

// ------------------------------------------------------------------------
//  Class:			DialogPage
//  Derived:		ICanvas
//						ICommandHandler
//                
//  Description:	This class describes the based dialog page class use 
//						by the pages in Parts style notebook.
//
// ------------------------------------------------------------------------

class DialogPage : public ICanvas,
                	 public ICommandHandler
{
	typedef ICanvas Inherited;
  	public:
    	DialogPage(IWindow *parentWin, IWindow *ownerWin,
					  int nIndex, SomAction *somAction);
    	~DialogPage();
    	virtual IRectangle mapDialogRect(const IRectangle &rect);
		void setStatusEntry(unsigned long resId);
  
  protected:
    	virtual Boolean command(ICommandEvent &evt);
		virtual void pageAction(unsigned long ulAction);
		
           
  private:
    	void setupControls();
		SomAction						 *somAct;
    	IGraphicPushButton          gbtn101;
    	IGraphicPushButton          gbtn102;
    	IGraphicPushButton          gbtn103;
    	IGraphicPushButton          gbtn104;
    	IGraphicPushButton          gbtn105;
    	IGraphicPushButton          gbtn106;
    	IGraphicPushButton          gbtn107;
    	IGraphicPushButton          gbtn108;
    	IEntryField                 edt109;
    	IStaticText                 txt110;
    	IGroupBox                   grp112;
		int					  			 nPageIndex;

};

// ------------------------------------------------------------------------
//  Class:			Set1Page
//  Derived:		DialogPage
//                
//  Description:	This class describes the Page #1 dialog in notebook
//
// ------------------------------------------------------------------------

  
class Set1Page : public DialogPage
{
  	public:
	  	Set1Page(IWindow *parentWin, IWindow *ownerWin, SomAction *somAction);
    	~Set1Page();
  	protected:
   	 virtual Boolean command(ICommandEvent &evt);
};

// ------------------------------------------------------------------------
//  Class:			Set2Page
//  Derived:		DialogPage
//                
//  Description:	This class describes the Page #2 dialog in notebook
//
// ------------------------------------------------------------------------

class Set2Page : public DialogPage
{
	public:
	  	Set2Page(IWindow *parentWin, IWindow *ownerWin, SomAction *somAction);
    	~Set2Page();
  	protected:
    	virtual Boolean command(ICommandEvent &evt);
 				
};

// ------------------------------------------------------------------------
//  Class:			Set3Page
//  Derived:		DialogPage
//                
//  Description:	This class describes the Page #3 dialog in notebook
//
// ------------------------------------------------------------------------

class Set3Page : public DialogPage
{
	public:
	  	Set3Page(IWindow *parentWin, IWindow *ownerWin, SomAction *somAction);
    	~Set3Page();
  protected:
    	virtual Boolean command(ICommandEvent &evt);
};

// ------------------------------------------------------------------------
//  Class:			Set4Page
//  Derived:		DialogPage
//                
//  Description:	This class describes the Page #4 dialog in notebook
//
// ------------------------------------------------------------------------

class Set4Page : public DialogPage
{
	public:
	  	Set4Page(IWindow *parentWin, IWindow *ownerWin, SomAction *somAction);
    	~Set4Page();
  	protected:
    	virtual Boolean command(ICommandEvent &evt);
};

//
// INLINE functions
//

inline DialogPage::~DialogPage()
{
}

inline Set1Page::~Set1Page()
{
}

inline Set2Page::~Set2Page()
{
}

inline Set3Page::~Set3Page()
{
}

inline Set4Page::~Set4Page()
{
}
 

 



#endif // _SETPAGES_HPP
