//				
// Project: Digitalk Parts like Toolbar and SOMObjects Demo
// File:    Setpages.cpp
// Author:  Stewart Hyde
// Created: Dec   17, 1993
// Updated: Dec   19, 1993
//
// Description:
//

#include <ireslib.hpp>
#include <iframe.hpp>
#include <istring.hpp>
#include <icolor.hpp>
#include "setpages.hpp"
#include "somparts.h"

// ------------------------------------------------------------------------
//  Class:				DialogPage
//  Function:			DialogPage (constructor)
//                
//  Description:		This is the contructor for the base dialog class
//       
//  Input:				IWindow *parentWin 	- parent window
//							IWindow *ownerWin  	- owner window
//							int		nIndex    	- page index (for resources)
//							SomAction *somAction	- pointer to SomActions class
//
//  Output:				N/A
//
//  Notes:
//
// ------------------------------------------------------------------------

DialogPage::DialogPage(IWindow *parentWin,
							 IWindow *ownerWin,
							 int nIndex,
							 SomAction *somAction)
  : ICanvas(WND_FIRST_DIALOG+nIndex, 
            parentWin,
            ownerWin,
            IRectangle(),
            IWindow::noStyle),
  	 gbtn101(101, this, this, ID_SET1_FUN1,
                   mapDialogRect(IRectangle(0, 103, 40, 127)),
                   IGraphicPushButton::defaultStyle() | IControl::tabStop),
  	 gbtn102(102, this, this, ID_SET1_FUN2, 
                   mapDialogRect(IRectangle(41, 103, 81, 127)),
                   IGraphicPushButton::defaultStyle()  | IControl::tabStop),
  	 gbtn103(103, this, this, ID_SET1_FUN3, 
                   mapDialogRect(IRectangle(0, 78, 40, 102)),
                   IGraphicPushButton::defaultStyle()  | IControl::tabStop),
  	 gbtn104(104, this, this, ID_SET1_FUN4, 
                   mapDialogRect(IRectangle(41, 78, 81, 102)),
                   IGraphicPushButton::defaultStyle()  | IControl::tabStop),
  	 gbtn105(105, this, this, ID_SET1_FUN5, 
                   mapDialogRect(IRectangle(0, 52, 40, 76)),
                   IGraphicPushButton::defaultStyle()  | IControl::tabStop),
  	 gbtn106(106, this, this, ID_SET1_FUN6, 
                   mapDialogRect(IRectangle(41, 52, 81, 76)),
                   IGraphicPushButton::defaultStyle()  | IControl::tabStop),
  	 gbtn107(107, this, this, ID_SET1_FUN7, 
                   mapDialogRect(IRectangle(0, 26, 40, 50)),
                   IGraphicPushButton::defaultStyle()  | IControl::tabStop),
  	 gbtn108(108, this, this, ID_SET1_FUN8, 
                   mapDialogRect(IRectangle(41, 26, 81, 50)),
                   IGraphicPushButton::defaultStyle()  | IControl::tabStop),
  	 edt109(109, this, this, 
                   mapDialogRect(IRectangle(3, 130, 80, 142)),
                   IEntryField::defaultStyle()  | IEntryField::readOnly),
  	 txt110(110, this, this, 
                   mapDialogRect(IRectangle(7, 9, 77, 17)),
                   IStaticText::defaultStyle()  | IStaticText::top  |
						 IStaticText::left),
  	 grp112(112, this, this, 
                   mapDialogRect(IRectangle(1, 3, 82, 27)),
                   IGroupBox::defaultStyle())
{
	nPageIndex = nIndex;

	// ---------------------------------------------------------------------
  	// Save pointer to SomActions class
	// ---------------------------------------------------------------------

	somAct= somAction;

	
	// ---------------------------------------------------------------------
	//  Handle command events so that pushbuttons can cause events
	// ---------------------------------------------------------------------
	
  	ICommandHandler::handleEventsFor(this);
  
	// ---------------------------------------------------------------------
	// translate the dialog rectange to size approviate for system font
	// ---------------------------------------------------------------------

  	IRectangle sizeRect(82, 144);
  	sizeTo(mapDialogRect(sizeRect).size());
  
	// ---------------------------------------------------------------------
  	// setup all controls in dialog
	// ---------------------------------------------------------------------

  	setupControls();
}                             

// ------------------------------------------------------------------------
//  Class:				DialogPage
//  Function:			mapDialogRect
//                
//  Description:		translates dialog units to pels
//       
//  Input:				IRectangle &oldRect
//
//  Output:				IRectangle
//
//  Notes:
//
// ------------------------------------------------------------------------

IRectangle DialogPage::mapDialogRect(const IRectangle &oldRect)
{
  	IFont font("System Proportional");

	// ---------------------------------------------------------------------
	// create a new rect that for each X dialog unit is equal to average 
	// character width / 4 and for each Y dialog unit is equal to maximum
	// character height / 8
	// ---------------------------------------------------------------------

  	IRectangle newRect(oldRect.left() * font.avgCharWidth() / 4,
                	    oldRect.bottom() * font.maxCharHeight() / 8,
                		 oldRect.right() * font.avgCharWidth() / 4,
                		 oldRect.top() * font.maxCharHeight() / 8);

	// ---------------------------------------------------------------------
	// return the new translated rectange to caller
	// ---------------------------------------------------------------------

  	return(newRect);
}
 
// ------------------------------------------------------------------------
//  Class:				DialogPage
//  Function:			setupControls
//                
//  Description:		initializes each control and sets approvate values
//       
//  Input:				N/A
//
//  Output:				N/A
//
//  Notes:
//
// ------------------------------------------------------------------------

void DialogPage::setupControls()
{
  txt110.setText(STR_FIRST_ACTIONS+nPageIndex);
  refresh();	
}
// ------------------------------------------------------------------------
//  Class:				DialogPage
//  Function:			command
//                
//  Description:		base dialog page command event handler
//       
//  Input:				ICommandEvent &evt
//
//  Output:				Boolean
//
//  Notes:
//
// ------------------------------------------------------------------------

Boolean DialogPage::command(ICommandEvent &evt)
{
  return false;
}

// ------------------------------------------------------------------------
//  Class:				DialogPage
//  Function:			setStatusEntry
//                
//  Description:		set up readonly status entry
//       
//  Input:				unsigned long resId - resource id
//
//  Output:				N/A
//
//  Notes:
//
// ------------------------------------------------------------------------


void DialogPage::setStatusEntry(unsigned long resId)
{
	edt109.setText(resId);
}


// ------------------------------------------------------------------------
//  Class:				DialogPage
//  Function:			pageAction
//                
//  Description:		handle Page action for this page
//       
//  Input:				unsigned long ulAction - action
//
//  Output:				N/A
//
//  Notes:
//
// ------------------------------------------------------------------------

void DialogPage::pageAction(unsigned long ulAction)
{
	somAct->Process(nPageIndex,ulAction); 
}

// ------------------------------------------------------------------------
//  Class:				Set1Page
//  Function:			Set1Page (constructor)
//                
//  Description:		This is the contructor for Set #1 dialog Page
//       
//  Input:				IWindow *parentWin - parent window
//							IWindow *ownerWin  - owner window
//							SomAction *somAction	- pointer to SomActions class
//
//  Output:				N/A
//
//  Notes:
//
// ------------------------------------------------------------------------

Set1Page::Set1Page(IWindow *parentWin,
						 IWindow *ownerWin,
						 SomAction *somAction)	
	: DialogPage(parentWin,ownerWin,0,somAction)
{
}

// ------------------------------------------------------------------------
//  Class:				Set1Page
//  Function:			command
//                
//  Description:		Set #1 dialog page command event handler
//       
//  Input:				ICommandEvent &evt
//
//  Output:				Boolean
//
//  Notes:
//
// ------------------------------------------------------------------------

Boolean Set1Page::command(ICommandEvent &evt)
{
  unsigned long cmdId = evt.commandId();	

  switch(cmdId)
  {
    case 101:  // selected Push
    case 102:  // selected Push
    case 103:  // selected Push
    case 104:  // selected Push
    case 105:  // selected Push
    case 106:  // selected Push
    case 107:  // selected Push
    case 108:  // selected Push
    {
  		unsigned long resId = (cmdId - 101) + STR_SET1_FUN1;		

		setStatusEntry(resId);
		pageAction(cmdId - 101);
      break;
    }
     
    default:
		return false;
  }
  return true;
}

// ------------------------------------------------------------------------
//  Class:				Set2Page
//  Function:			Set2Page (constructor)
//                
//  Description:		This is the contructor for Set #2 dialog Page
//       
//  Input:				IWindow *parentWin - parent window
//							IWindow *ownerWin  - owner window
//							SomAction *somAction	- pointer to SomActions class
//
//  Output:				N/A
//
//  Notes:
//
// ------------------------------------------------------------------------

Set2Page::Set2Page(IWindow *parentWin,
						 IWindow *ownerWin,
						 SomAction *somAction)	
	: DialogPage(parentWin,ownerWin,1,somAction)
{
}

// ------------------------------------------------------------------------
//  Class:				Set2Page
//  Function:			command
//                
//  Description:		Set #2 dialog page command event handler
//       
//  Input:				ICommandEvent &evt
//
//  Output:				Boolean
//
//  Notes:
//
// ------------------------------------------------------------------------

Boolean Set2Page::command(ICommandEvent &evt)
{
  unsigned long cmdId = evt.commandId();	

  switch(cmdId)
  {
    case 101:  // selected Push
    case 102:  // selected Push
    case 103:  // selected Push
    case 104:  // selected Push
    case 105:  // selected Push
    case 106:  // selected Push
    case 107:  // selected Push
    case 108:  // selected Push
    {
  		unsigned long resId = (cmdId - 101) + STR_SET2_FUN1;		

		setStatusEntry(resId);
		pageAction(cmdId - 101);
      break;
    }
     
    default:
		return false;
  }
  return true;
}



// ------------------------------------------------------------------------
//  Class:				Set3Page
//  Function:			Set3Page (constructor)
//                
//  Description:		This is the contructor for Set #3 dialog Page
//       
//  Input:				IWindow *parentWin - parent window
//							IWindow *ownerWin  - owner window
//							SomAction *somAction	- pointer to SomActions class
//
//  Output:				N/A
//
//  Notes:
//
// ------------------------------------------------------------------------

Set3Page::Set3Page(IWindow *parentWin,
						 IWindow *ownerWin,
						 SomAction *somAction)	
	: DialogPage(parentWin,ownerWin,2,somAction)
{
}

// ------------------------------------------------------------------------
//  Class:				Set3Page
//  Function:			command
//                
//  Description:		Set #3 dialog page command event handler
//       
//  Input:				ICommandEvent &evt
//
//  Output:				Boolean
//
//  Notes:
//
// ------------------------------------------------------------------------

Boolean Set3Page::command(ICommandEvent &evt)
{
  unsigned long cmdId = evt.commandId();	

  switch(cmdId)
  {
    case 101:  // selected Push
    case 102:  // selected Push
    case 103:  // selected Push
    case 104:  // selected Push
    case 105:  // selected Push
    case 106:  // selected Push
    case 107:  // selected Push
    case 108:  // selected Push
    {
  		unsigned long resId = (cmdId - 101) + STR_SET3_FUN1;		

		setStatusEntry(resId);
		pageAction(cmdId - 101);
      break;
    }
    
    default:
		return false;
  }
  return true;
}

// ------------------------------------------------------------------------
//  Class:				Set4Page
//  Function:			Set4Page (constructor)
//                
//  Description:		This is the contructor for Set #4 dialog Page
//       
//  Input:				IWindow *parentWin - parent window
//							IWindow *ownerWin  - owner window
//							SomAction *somAction	- pointer to SomActions class
//
//  Output:				N/A
//
//  Notes:
//
// ------------------------------------------------------------------------

Set4Page::Set4Page(IWindow *parentWin,
						 IWindow *ownerWin,
						 SomAction *somAction)	
	: DialogPage(parentWin,ownerWin,3,somAction)
{
}


// ------------------------------------------------------------------------
//  Class:				Set4Page
//  Function:			command
//                
//  Description:		Set #4 dialog page command event handler
//       
//  Input:				ICommandEvent &evt
//
//  Output:				Boolean
//
//  Notes:
//
// ------------------------------------------------------------------------

Boolean Set4Page::command(ICommandEvent &evt)
{
  unsigned long cmdId = evt.commandId();	

  switch(cmdId)
  {
    case 101:  // selected Push
    case 102:  // selected Push
    case 103:  // selected Push
    case 104:  // selected Push
    case 105:  // selected Push
    case 106:  // selected Push
    case 107:  // selected Push
    case 108:  // selected Push
    {
  		unsigned long resId = (cmdId - 101) + STR_SET4_FUN1;		

		setStatusEntry(resId);
		pageAction(cmdId - 101);
      break;
    }
     
    default:
		return false;
  }
  return true;
}

