//
// Project: Digitalk Parts like Toolbar and SOMObjects Demo
// File:    Parts.hpp
// Author:  Stewart Hyde
// Created: Dec   17, 1993
// Updated: Jan    7, 1994
//
// Description:
//

#ifndef _PARTS_HPP_
	#define _PARTS_HPP_

#ifndef _INOTEBK_
  #include <inotebk.hpp>
#endif
   
#ifndef _IPAGEHDR_
  #include <ipagehdr.hpp>
#endif

#ifndef _SOMACT_HPP_
	#include "somact.hpp"
#endif

  
// ------------------------------------------------------------------------
//  Class:			PartsNoteTool
//  Derived:		INotebook
//						IPageHandler
//                
//  Description:	This class describes the Notebook Toolbar that is like
//						the one included in the Digitalk Parts package
//
// ------------------------------------------------------------------------

class PartsNoteTool : public INotebook,
                      public IPageHandler
{
   typedef INotebook Inherited;
   
   public:
		PartsNoteTool(IWindow *parentWin, IWindow *ownerWin, SomAction *somAction);
     	~PartsNoteTool();
 
   protected:
     	virtual void initNoteBookPages();
     	virtual Boolean select(IPageSelectEvent &evt);
 
   private:
		SomAction *somAct;
     	Boolean constructing;
    	IPageHandle page1;
    	IPageHandle page2;
    	IPageHandle page3;
    	IPageHandle page4;
    
};
  
//
// Inline functions
//

inline PartsNoteTool::~PartsNoteTool()
{
}
 

#endif // _PARTS_HPP_
