//
// Project: Digitalk Parts like Toolbar and SOMObjects Demo
// File:    Parts.cpp
// Author:  Stewart Hyde
// Created: Dec   17, 1993
// Updated: Dec   19, 1993
//
// Description:
//

#include <stdlib.h>
#include <icolor.hpp>
#include <ifont.hpp>
#include <istring.hpp>
#include <ireslib.hpp>
#include "somparts.h"
#include "parts.hpp"
#include "setpages.hpp"

// ------------------------------------------------------------------------
//  Class:				PartsNoteTool		
//  Function:			PartsNoteTool	(constructor)
//                
//  Description:		This is the contructor for Parts Style Notebook
//       
//  Input:				IWindow *parentWin - parent window
//							IWindow *ownerWin  - owner window
//
//  Output:				N/A
//
//  Notes:
//
// ------------------------------------------------------------------------

PartsNoteTool::PartsNoteTool(IWindow *parentWin, 
                             IWindow *ownerWin,
									  SomAction *somAction)	
  		: INotebook(WND_PARTS_NOTE_BOOK, 
                  parentWin,
                  ownerWin, 
                  IRectangle(),
                  backPagesBottomRight | majorTabsLeft |
						squareTabs | spiralBinding |
						tabTextCenter| statusTextCenter)
{
	// ---------------------------------------------------------------------
  	// Save pointer to SomActions class
	// ---------------------------------------------------------------------

	somAct= somAction;

	// ---------------------------------------------------------------------
  	// Set the font for the notebook
	// ---------------------------------------------------------------------

  	IFont font("Helv", 10);
  	setFont(font);
  
	// ---------------------------------------------------------------------
  	// Set the page button size to be the maximum character height 
	// ---------------------------------------------------------------------

  	setPageButtonSize(ISize(font.maxCharHeight(),font.maxCharHeight()));
  
  
	// ---------------------------------------------------------------------
  	// Set background to pale gray
	// ---------------------------------------------------------------------

   setColor(pageBackground, IColor(IColor::paleGray));
  

	// ---------------------------------------------------------------------
  	// start handling notebook page events
	// ---------------------------------------------------------------------

  	IPageHandler::handleEventsFor(this);
  
	// ---------------------------------------------------------------------
 	// Initialize the notebook pages, this function is use to create the
	// notebook pages, initialize its associated data and size its tabs
	// and sets the note books position and size if necessary
	// ---------------------------------------------------------------------

	initNoteBookPages();

	// ---------------------------------------------------------------------
  	// Size the notebook to its minimum size
	// ---------------------------------------------------------------------

  	sizeTo(calcMinimumSize());
}

// ------------------------------------------------------------------------
//  Class:		  		PartsNoteTool
//  Function:			initNoteBookPages
//                
//  Description:		Initialize the notebook pages, this function is use
//							to create the notebook pages, initialize its associated
//							data and size its tabs and sets the note books position
//							and size if necessary
//       
//  Input:		 		N/A
//
//  Output:				N/A
//
//  Notes:
//
// ------------------------------------------------------------------------

void PartsNoteTool::initNoteBookPages()
{
	INotebook::PageSettings settings;
  	IFont font(this);
  	int majorLength = 0;
  	INotebook::Cursor cursor(*this);


	// ---------------------------------------------------------------------
   // setup PageSettings for the notebook page for Set #1
	// ---------------------------------------------------------------------

   settings = INotebook::PageSettings(INotebook::PageSettings::majorTab |
         								     INotebook::PageSettings::statusTextOn |
        										  INotebook::PageSettings::autoPageSize);

   settings.setStatusText(IResourceId(STR_SET1_PAGE_STATUS));
   settings.setTabText(IResourceId(STR_SET1_PAGE_TAB));
      
	// ---------------------------------------------------------------------
   // add the Set #1 page to the notebook 
	// ---------------------------------------------------------------------

   page1 = addLastPage(settings);
      
	{
   	// ------------------------------------------------------------------
		//  Create a Set #1 class instance and use it as the window for the 
		//  this page in the notebook
   	// ------------------------------------------------------------------

   	Set1Page *pSet1Page = new Set1Page(this, this, somAct);

   	// ------------------------------------------------------------------
		//  Let the page window manage its destruction, so set it to
		//  autodelete
   	// ------------------------------------------------------------------

   	pSet1Page->setAutoDeleteObject();

   	// ------------------------------------------------------------------
   	// Set the window background to paleGray
   	// ------------------------------------------------------------------

   	pSet1Page->setColor(pSet1Page->background, IColor(IColor::paleGray));

		// ------------------------------------------------------------------
      // Attach the window to the notebook page Set #1
      // ------------------------------------------------------------------

  		setWindow(page1, pSet1Page);
	}

	// ---------------------------------------------------------------------
   // setup PageSettings for the notebook page for Set #2
	// ---------------------------------------------------------------------

   settings = INotebook::PageSettings(INotebook::PageSettings::majorTab |
         								     INotebook::PageSettings::statusTextOn |
        										  INotebook::PageSettings::autoPageSize);

   settings.setStatusText(IResourceId(STR_SET2_PAGE_STATUS));
   settings.setTabText(IResourceId(STR_SET2_PAGE_TAB));
      
	// ---------------------------------------------------------------------
   // add the Set #2 page to the notebook 
	// ---------------------------------------------------------------------

   page2 = addLastPage(settings);

	{      
   	// ------------------------------------------------------------------
		//  Create a Set #2 class instance and use it as the window for the 
		//  this page in the notebook
   	// ------------------------------------------------------------------

   	Set2Page *pSet2Page = new Set2Page(this, this, somAct);

   	// ------------------------------------------------------------------
		//  Let the page window manage its destruction, so set it to
		//  autodelete
   	// ------------------------------------------------------------------

   	pSet2Page->setAutoDeleteObject();

   	// ------------------------------------------------------------------
   	// Set the window background to paleGray
   	// ---------------------------------------------------------------------

   	pSet2Page->setColor(pSet2Page->background, IColor(IColor::paleGray));

		// ------------------------------------------------------------------
      // Attach the window to the notebook page Set #2
      // ------------------------------------------------------------------

  		setWindow(page2, pSet2Page);
	}

	// ---------------------------------------------------------------------
   // setup PageSettings for the notebook page for Set #3
	// ---------------------------------------------------------------------

   settings = INotebook::PageSettings(INotebook::PageSettings::majorTab |
         								     INotebook::PageSettings::statusTextOn |
        										  INotebook::PageSettings::autoPageSize);

   settings.setStatusText(IResourceId(STR_SET3_PAGE_STATUS));
   settings.setTabText(IResourceId(STR_SET3_PAGE_TAB));
      
	// ---------------------------------------------------------------------
   // add the Set #3 page to the notebook 
	// ---------------------------------------------------------------------

   page3 = addLastPage(settings);
    
	{  
   	// ------------------------------------------------------------------
		//  Create a Set #3 class instance and use it as the window for the 
		//  this page in the notebook
   	// ------------------------------------------------------------------

   	Set3Page *pSet3Page = new Set3Page(this, this, somAct);

   	// ------------------------------------------------------------------
		//  Let the page window manage its destruction, so set it to
		//  autodelete
   	// ------------------------------------------------------------------

   	pSet3Page->setAutoDeleteObject();

   	// ------------------------------------------------------------------
   	// Set the window background to paleGray
   	// ------------------------------------------------------------------

   	pSet3Page->setColor(pSet3Page->background, IColor(IColor::paleGray));

		// ------------------------------------------------------------------
      // Attach the window to the notebook page Set #3
      // ------------------------------------------------------------------

  		setWindow(page3, pSet3Page);
	}

	// ---------------------------------------------------------------------
   // setup PageSettings for the notebook page for Set #4
	// ---------------------------------------------------------------------

   settings = INotebook::PageSettings(INotebook::PageSettings::majorTab |
         								     INotebook::PageSettings::statusTextOn |
        										  INotebook::PageSettings::autoPageSize);

   settings.setStatusText(IResourceId(STR_SET4_PAGE_STATUS));
   settings.setTabText(IResourceId(STR_SET4_PAGE_TAB));
      
	// ---------------------------------------------------------------------
   // add the Set #4 page to the notebook 
	// ---------------------------------------------------------------------

   page4 = addLastPage(settings);
      
	{
   	// ------------------------------------------------------------------
		//  Create a Set #4 class instance and use it as the window for the 
		//  this page in the notebook
   	// ------------------------------------------------------------------

   	Set4Page *pSet4Page = new Set4Page(this, this, somAct);

   	// ------------------------------------------------------------------
		//  Let the page window manage its destruction, so set it to
		//  autodelete
   	// ------------------------------------------------------------------

   	pSet4Page->setAutoDeleteObject();

   	// ------------------------------------------------------------------
   	// Set the window background to paleGray
   	// ------------------------------------------------------------------

   	pSet4Page->setColor(pSet4Page->background, IColor(IColor::paleGray));

		// ------------------------------------------------------------------
      // Attach the window to the notebook page Set #4
      // ------------------------------------------------------------------

  		setWindow(page4, pSet4Page);
	}

   // ---------------------------------------------------------------------
  	// Set the page button size to the maximum character height in notebook
   // ---------------------------------------------------------------------

  	setPageButtonSize(ISize(font.maxCharHeight(),font.maxCharHeight()));
  

   // ---------------------------------------------------------------------
  	// traverse the notebook pages to find out long major tag in notebook
   // ---------------------------------------------------------------------

  	for (cursor.setToFirst(); cursor.isValid(); cursor.setToNext())
  	{
    	INotebook::PageSettings settings = pageSettings(cursor.current());
    	if (settings.isMajorTab())
      	majorLength = max(majorLength, settings.tabText().length());
  	}

   // ---------------------------------------------------------------------
	// use the font size to calculate height for tab
   // ---------------------------------------------------------------------

  	unsigned long height = font.avgUppercase() +
                         font.internalLeading()*2 +
                         font.maxLowercaseAscender();

   // ---------------------------------------------------------------------
	//	 Not set the settab to approviate value
   // ---------------------------------------------------------------------

  	try
  	{
    	setMajorTabSize(ISize((font.avgCharWidth()+4)*majorLength,
                        height));
  	} catch (IAccessError &acc)
  	{
  	}

	// ---------------------------------------------------------------------
  	// Size the notebook to its minimum size
	// ---------------------------------------------------------------------

  	sizeTo(calcMinimumSize());
}

// ------------------------------------------------------------------------
//  Class:			 	PartsNoteTool
//  Function:			select
//                
//  Description:		Notebook select handler which basically pasts focus
//							on to the notebook page if page is availabele
//       
//  Input:				IPageSelectEvent &evt - page select even
//
//  Output:				Boolean true if page window is valid
//
//  Notes:
//
// ------------------------------------------------------------------------

Boolean PartsNoteTool::select(IPageSelectEvent &evt)
{
  	IWindow *pageWindow = window(evt.pageHandle());

   // ---------------------------------------------------------------------
	//  If page window is valid, setfocus and return true
   // ---------------------------------------------------------------------

  	if (pageWindow)
  	{	
    	pageWindow->setFocus();
	 	return true;
	}
  	else
		return false;
}
