//
// Project: Digitalk Parts like Toolbar and SOMObjects Demo
// File:    Listbox.hpp
// Author:  Stewart Hyde
// Created: Dec   18, 1993
// Updated: Jan    6, 1993
//
// Description:
//

#ifndef _LISTBOX_HPP_
  #define _LISTBOX_HPP_

#ifndef _ICANVAS_
  #include <icanvas.hpp>
#endif

#ifndef _IFONT_
  #include <ifont.hpp>
#endif

#ifndef _ICTLEVT_
  #include <ictlevt.hpp>
#endif

#ifndef _ISELHDR__
  #include <iselhdr.hpp>
#endif
    
#ifndef _ILISTBOX_
  #include <ilistbox.hpp>
#endif
   
#ifndef _IENTRYFD_
  #include <ientryfd.hpp>
#endif
   
#ifndef _IGROUPBX_
  #include <igroupbx.hpp>
#endif

#ifndef _SOMACT_HPP_
	#include "somact.hpp"
#endif

#include "atimehdr.hpp"
   
class IFrameWindow;

// ------------------------------------------------------------------------
//  Class:			PartsListBox
//  Derived:		ICanvas
//                
//  Description:	This class describes the Parts Listbox dialog which
//						displays status of actions done in Parts Note Tool
//
// ------------------------------------------------------------------------


class PartsListbox : public ICanvas,
							public ATimeHandler
{
	typedef ICanvas Inherited;
  	public:
    	PartsListbox(IWindow *parentWin, IWindow *ownerWin, SomAction *somAction);
    	~PartsListbox();
    	virtual IRectangle mapDialogRect(const IRectangle &rect);
  
  	protected:
    	virtual Boolean tick(IEvent& evt);  //Send Tick for every WM_TIMER       
  	private:
    	void setupControls();
		long				LastStatus;
		long				ActionCount;
		SomAction		*somAct;
    	IListBox       lst101;
    	IEntryField    edt102;
    	IGroupBox      grp103;
    	IEntryField    edt104;
    	IGroupBox      grp105;
};
  
//
// Inline functions
//

inline PartsListbox::~PartsListbox()
{
  	ATimeHandler::stopHandlingEventsFor(this);//Stop Timer                       .
}
 
#endif // _LISTBOX_HPP_
