//
// Project: Digitalk Parts like Toolbar and SOMObjects Demo
// File:    Listbox.hpp
// Author:  Stewart Hyde
// Created: Dec   18, 1993
// Updated: Jan    7, 1993
//
// Description:
//

#include <stdio.h>
#include <ireslib.hpp>
#include <iframe.hpp>
#include <istring.hpp>
#include <icolor.hpp>
#include "listbox.hpp"
#include "somparts.h"

// ------------------------------------------------------------------------
//  Class: 				PartsListbox
//  Function:			PartsListBox (constructor)
//                
//  Description:		This is the constructor for Parts Actions list box
//       
//  Input:				IWindow *parentWin 	- parent window
//							IWindow *ownerWin  	- owner window
//							SomAction *somAction	- pointer to SomActions class
//
//  Output:				N/A
//
//  Notes:
//
// ------------------------------------------------------------------------

PartsListbox::PartsListbox(IWindow *parentWin,
									IWindow *ownerWin,
									SomAction *somAction)
  : ICanvas(WND_PARTS_LISTBOX_WINDOW, 
            parentWin,
            ownerWin,
            IRectangle(),
            IWindow::noStyle),
  lst101(101, this, this, 
                   mapDialogRect(IRectangle(0, 0, 147, 108)),
                   IWindow::visible  | IControl::tabStop),
  edt102(102, this, this, 
                   mapDialogRect(IRectangle(8, 119, 42, 127)),
                   IEntryField::defaultStyle() | IEntryField::readOnly |
						 IControl::tabStop),
  grp103(103, this, this, 
                   mapDialogRect(IRectangle(0, 111, 50, 139)),
                   IGroupBox::defaultStyle()),
  edt104(104, this, this, 
                   mapDialogRect(IRectangle(59, 119, 138, 127)),
                   IEntryField::defaultStyle() | IEntryField::readOnly |
					    IControl::tabStop),
  grp105(105, this, this, 
                   mapDialogRect(IRectangle(53, 111, 148, 139)),
                   IGroupBox::defaultStyle())
{

	// ---------------------------------------------------------------------
  	// Initialize variables 
	// ---------------------------------------------------------------------
	
	LastStatus = -1;		  			// LastStatus is not set 
	ActionCount = 0;					// No Actions yet

	// ---------------------------------------------------------------------
  	// Save pointer to SomActions class
	// ---------------------------------------------------------------------

	somAct= somAction;

	// ---------------------------------------------------------------------
	// translate the dialog rectange to size approviate for system font
	// ---------------------------------------------------------------------

  	IRectangle sizeRect(148, 147);
  	sizeTo(mapDialogRect(sizeRect).size());

	// ---------------------------------------------------------------------
  	// setup all controls in dialog
	// ---------------------------------------------------------------------

  	setupControls();

	// ---------------------------------------------------------------------
  	// start handling timer events
	// ---------------------------------------------------------------------

  	ATimeHandler::handleEventsFor(this);  //Set self as time handler            v6
}                             

// ------------------------------------------------------------------------
//  Class:				PartsListBox
//  Function:			mapDialogRect
//                
//  Description:		translates dialog units to pels
//       
//  Input:				IRectangle &oldRect
//
//  Output:				IRectangle
//
//  Notes:
//
// ------------------------------------------------------------------------

IRectangle PartsListbox::mapDialogRect(const IRectangle &oldRect)
{
  	IFont font("System Proportional");

	// ---------------------------------------------------------------------
	// create a new rect that for each X dialog unit is equal to average 
	// character width / 4 and for each Y dialog unit is equal to maximum
	// character height / 8
	// ---------------------------------------------------------------------

  	IRectangle newRect(oldRect.left() * font.avgCharWidth() / 4,
                	    oldRect.bottom() * font.maxCharHeight() / 8,
                		 oldRect.right() * font.avgCharWidth() / 4,
                		 oldRect.top() * font.maxCharHeight() / 8);

	// ---------------------------------------------------------------------
	// return the new translated rectange to caller
	// ---------------------------------------------------------------------

  	return(newRect);
}
 

// ------------------------------------------------------------------------
//  Class:				PartsListbox
//  Function:			setupControls
//                
//  Description:		initializes each control and sets approvate values
//       
//  Input:				N/A
//
//  Output:				N/A
//
//  Notes:
//
// ------------------------------------------------------------------------

void PartsListbox::setupControls()
{
  	IFont font("System Proportional");

	//----------------------------------------------------------------------
  	// change the position of this dialog
	//----------------------------------------------------------------------

  	IPoint origin(175 * font.avgCharWidth() / 4,
                56 * font.maxCharHeight() / 8);
  	IPoint extent(329 * font.avgCharWidth() / 4,
                205 * font.maxCharHeight() / 8);
  	moveSizeTo(IRectangle(origin, extent));
  	grp103.setText(STR_COUNT);
  	grp105.setText(STR_ACTIONS);
}
 

// ------------------------------------------------------------------------
//  Class:				PartsListbox
//  Function:			tick
//                
//  Description:		timer handler for listbox
//       
//  Input:				IEvent& evt - event 
//
//  Output:				
//
//  Notes:
//
// ------------------------------------------------------------------------


Boolean PartsListbox::tick(IEvent& evt) 
{        
	long NewStatus = STR_LIST_WAITING;
	Boolean FirstTime = false;
	char szLine[60];
    
	// ---------------------------------------------------------------------
	// On each Tick check our update list to see if any items are on the
	// Update list, if so check to see if if update or new item	
	// ---------------------------------------------------------------------
        
	if (somAct->Next())
	{
		if (somAct->getUpdate())
			NewStatus = STR_LIST_UPDATE;
		else
			NewStatus = STR_LIST_ADD;
	}	                  

	// ---------------------------------------------------------------------
	// If not the same as last status, upstate status listbox
	// ---------------------------------------------------------------------
 
	if (NewStatus != LastStatus)
	{
		if (LastStatus == -1)
			FirstTime = true;

		LastStatus = NewStatus;
		edt104.setText(NewStatus);
	}

	// ---------------------------------------------------------------------
	// If nothing in list and still waiting, then return 
	// ---------------------------------------------------------------------
 
	if ((NewStatus == STR_LIST_WAITING) && (!FirstTime))
		return true;

	// ---------------------------------------------------------------------
	// If this is a new item, then update count item
	// ---------------------------------------------------------------------

	if ((NewStatus == STR_LIST_ADD) || (FirstTime))
	{	
		char szBuffer[8];

		// ------------------------------------------------------------------
		//  if adding new item, then update count
		// ------------------------------------------------------------------

		if (NewStatus == STR_LIST_ADD)
			ActionCount++;

		// ------------------------------------------------------------------
		//  Update edit control	
		// -----------------------------------------------------------------

		sprintf(szBuffer,"%d",ActionCount);
		edt102.setText(szBuffer);

		// ------------------------------------------------------------------
		//  if still waiting then return, we are done
		// ------------------------------------------------------------------

		if (NewStatus == STR_LIST_WAITING)				
			return true;
	}	


	// ---------------------------------------------------------------------
	//  Update the list box, by adding item as first item
	// ---------------------------------------------------------------------
 
	sprintf(szLine,"Set #%d, Fun #%d, Count %d",somAct->getSet()+1,
						somAct->getAction()+1,somAct->getCount());
	lst101.addAsFirst(szLine);

  	return true;                       
} /* end PartsListBox :: Tick() */                           
