//
// Project: Digitalk Parts like Toolbar and SOMObjects Demo
// File:    Infodlg.hpp
// Author:  Stewart Hyde
// Created: Jan    7, 1994
// Updated: Jan    7, 1994
//
// Description:
//

#include <ireslib.hpp>
#include <istring.hpp>
#include <os2.h>
#include "infodlg.hpp"

// ------------------------------------------------------------------------
//  Class:				InfoDialog		
//  Function:			InfoDialog	(constructor)
//                
//  Description:		This is the contructor for Information Dialog
//       
//  Input:				unsigned long DialogId - resource ID for dialog
//							IWindow *parentWin - parent window
//							IWindow *ownerWin  - owner window
//
//  Output:				N/A
//
//  Notes:
//
// ------------------------------------------------------------------------

InfoDialog::InfoDialog(unsigned long DialogId, IWindow * parentWnd, IWindow * ownerWnd)
	: IFrameWindow(DialogId,parentWnd,ownerWnd)
{
	// ---------------------------------------------------------------------
	//  Set default return value to false
	// ---------------------------------------------------------------------

	DialogReturn=false;

	// ---------------------------------------------------------------------
	//  setup command handler
	// ---------------------------------------------------------------------

	handleEventsFor(this);
}


// ------------------------------------------------------------------------
//  Class:				InfoDialog		
//  Function:			DisplayDialog
//                
//  Description:		Display a Modal Information dialog
//       
//  Input:				N/A
//
//  Output:				Boolean - flag if command is process or not
//
//  Notes:
//
// ------------------------------------------------------------------------

Boolean InfoDialog::DisplayDialog()
{
	// ---------------------------------------------------------------------
	//  Set focus and display the dialog (modal)
	// ---------------------------------------------------------------------

	setFocus();
	showModally();

	// ---------------------------------------------------------------------
	//  return the result from command handler
	// ---------------------------------------------------------------------

	return(DialogReturn);
}

// ------------------------------------------------------------------------
//  Class:				InfoDialog		
//  Function:			comand
//                
//  Description:		dialog command event handler
//       
//  Input:				ICommandEvent &evt
//
//  Output:				Boolean
//
//  Notes:
//							Handles only OK and CANCEL
//
// ------------------------------------------------------------------------

Boolean InfoDialog :: command(ICommandEvent & cmdEvent)                   	  
{                                                                          
  	switch (cmdEvent.commandId()) {       

		// ------------------------------------------------------------------
		// OK Button - dialog return value is true and dismiss the dialog
		// ------------------------------------------------------------------

		case DID_OK:   
	   	DialogReturn=true;
	   	dismiss(DID_OK);								    
	   	break;							   

		// ------------------------------------------------------------------
		// CANCEL Button - dialog return value is true and dismiss the dialog
		// ------------------------------------------------------------------

		case DID_CANCEL:	
	   	DialogReturn=false;
	   	dismiss(DID_CANCEL);								    
	   	break;							    
	
       default:
  	   	return(false);               //Return command not processed        
  } 

  return(true);                       
} 												  // end InfoDialog :: command(...) 
