#define INCL_WIN

#include <os2.h>
#include <stdio.h>
#include <string.h>
#include <malloc.h>

#include "owner.h"
#include "..\mdi.h"


MRESULT EXPENTRY wpClientWndProc (HWND hwnd, ULONG msg,
                                  MPARAM   mp1, MPARAM   mp2)

{
          MRESULT       mr = (MRESULT) FALSE;
          HPS           hps;

   static HWND          hwndList, hwndEntry1, hwndEntry2, hwndPush;
          USHORT        usX, usY;
          POWNERITEM    pOwnerItem;
          RECTL         rectlItem;
          PLISTBOXINFO  plbiLineItem;
          USHORT        usIndex;
          LONG          clrForeGround, clrBackGround;
          PUSERBUTTON   pUserButton;

          RECTL         rectlClientWindow;

   switch (msg)
      {
        case UM_REGISTERCLASS:
        {
            HAB     hab = (HAB) hwnd;
            if (  WinRegisterClass (hab, szClientClass, wpClientWndProc, CS_SIZEREDRAW, 0) )
            {
                return (MRESULT) TRUE;
            }
            return (MRESULT) FALSE;
        }
       case WM_CREATE:

          hwndList = WinCreateWindow (hwnd, WC_LISTBOX, NULL, LS_OWNERDRAW,
                                      0, 0, 0, 0, hwnd, HWND_TOP,
                                      ID_LISTBOX, NULL, NULL);

          hwndEntry1 = WinCreateWindow (hwnd, WC_ENTRYFIELD,
                                        NULL, ES_MARGIN,
                                        0, 0, 0, 0, hwnd, HWND_TOP,
                                        ID_ENTRY1, NULL, NULL);

          hwndEntry2 = WinCreateWindow (hwnd, WC_ENTRYFIELD,
                                        NULL, ES_MARGIN,
                                        0, 0, 0, 0, hwnd, HWND_TOP,
                                        ID_ENTRY2, NULL, NULL);

/***********************************************************************
          hwndPush = WinCreateWindow (hwnd, WC_BUTTON, NULL,
                                      BS_PUSHBUTTON | BS_USERBUTTON |
                                      WS_DISABLED,
                                      0, 0, 0, 0, hwnd, HWND_TOP,
                                      ID_PUSH, NULL, NULL);
 ***********************************************************************/
          hwndPush = WinCreateWindow (hwnd, WC_BUTTON, "DO IT",
                                      BS_PUSHBUTTON, 0, 0, 0, 0,
                                      hwnd, HWND_TOP, ID_PUSH,
                                      NULL, NULL);

          plbiLineItem = (PLISTBOXINFO) malloc (sizeof (LISTBOXINFO));
          strcpy (plbiLineItem -> szString1, "Kraay");
          strcpy (plbiLineItem -> szString2, "Feite");

          usIndex = (USHORT) WinSendMsg (hwndList, LM_INSERTITEM,
                                         MPFROMSHORT (LIT_END),
                                         MPFROMP ("dummy"));

          WinSendMsg (hwndList, LM_SETITEMHANDLE, MPFROMSHORT (usIndex),
                      MPFROMP (plbiLineItem));

          plbiLineItem = (PLISTBOXINFO) malloc (sizeof (LISTBOXINFO));
          strcpy (plbiLineItem -> szString1, "Bush");
          strcpy (plbiLineItem -> szString2, "George");

          usIndex = (USHORT) WinSendMsg (hwndList, LM_INSERTITEM,
                                         MPFROMSHORT (LIT_END),
                                         MPFROMP ("dummy"));

          WinSendMsg (hwndList, LM_SETITEMHANDLE, MPFROMSHORT (usIndex),
                      MPFROMP (plbiLineItem));

          plbiLineItem = (PLISTBOXINFO) malloc (sizeof (LISTBOXINFO));
          strcpy (plbiLineItem -> szString1, "Mulroney");
          strcpy (plbiLineItem -> szString2, "Brian");

          usIndex = (USHORT) WinSendMsg (hwndList, LM_INSERTITEM,
                                         MPFROMSHORT (LIT_END),
                                         MPFROMP ("dummy"));

          WinSendMsg (hwndList, LM_SETITEMHANDLE, MPFROMSHORT (usIndex),
                      MPFROMP (plbiLineItem));

          plbiLineItem = (PLISTBOXINFO) malloc (sizeof (LISTBOXINFO));
          strcpy (plbiLineItem -> szString1, "Akers");
          strcpy (plbiLineItem -> szString2, "John");

          usIndex = (USHORT) WinSendMsg (hwndList, LM_INSERTITEM,
                                         MPFROMSHORT (LIT_END),
                                         MPFROMP ("dummy"));

          WinSendMsg (hwndList, LM_SETITEMHANDLE, MPFROMSHORT (usIndex),
                      MPFROMP (plbiLineItem));

          plbiLineItem = (PLISTBOXINFO) malloc (sizeof (LISTBOXINFO));
          strcpy (plbiLineItem -> szString1, "Etherington");
          strcpy (plbiLineItem -> szString2, "Bill");

          usIndex = (USHORT) WinSendMsg (hwndList, LM_INSERTITEM,
                                         MPFROMSHORT (LIT_END),
                                         MPFROMP ("dummy"));

          WinSendMsg (hwndList, LM_SETITEMHANDLE, MPFROMSHORT (usIndex),
                      MPFROMP (plbiLineItem));

          plbiLineItem = (PLISTBOXINFO) malloc (sizeof (LISTBOXINFO));
          strcpy (plbiLineItem -> szString1, "Rae");
          strcpy (plbiLineItem -> szString2, "Bob");

          usIndex = (USHORT) WinSendMsg (hwndList, LM_INSERTITEM,
                                         MPFROMSHORT (LIT_END),
                                         MPFROMP ("dummy"));

          WinSendMsg (hwndList, LM_SETITEMHANDLE, MPFROMSHORT (usIndex),
                      MPFROMP (plbiLineItem));

          WinSendMsg (hwndList, LM_SELECTITEM, MPFROMSHORT(0),
                      MPFROMSHORT (TRUE));

          break;

       case WM_PAINT:

          WinQueryWindowRect (hwnd, &rectlClientWindow);

          hps = WinBeginPaint (hwnd, 0L, 0L);

          WinFillRect (hps, &rectlClientWindow, clrBackground);

          WinEndPaint (hps);

          break;

       case WM_SIZE:

          usX = SHORT1FROMMP (mp2);
          usY = SHORT2FROMMP (mp2);

          WinSetWindowPos (hwndList, HWND_TOP,
                           usX / 4, usY * 3 / 8,
                           usX / 2, usY / 2,
                           SWP_SIZE | SWP_MOVE | SWP_SHOW);

          WinSetWindowPos (hwndEntry1, HWND_TOP,
                           usX / 8, usY / 4,
                           usX / 4, usY / 16,
                           SWP_SIZE | SWP_MOVE | SWP_SHOW);

          WinSetWindowPos (hwndEntry2, HWND_TOP,
                           usX * 5 / 8, usY / 4,
                           usX / 4, usY / 16,
                           SWP_SIZE | SWP_MOVE | SWP_SHOW);

          WinSetWindowPos (hwndPush, HWND_TOP,
                           usX * 3 / 8, usY / 16,
                           usX / 4, usY / 8,
                           SWP_SIZE | SWP_MOVE | SWP_SHOW);

          WinSetFocus (HWND_DESKTOP, hwndList);

          break;

       case WM_DRAWITEM:

          pOwnerItem = (POWNERITEM) PVOIDFROMMP (mp2);

          if (pOwnerItem -> fsState)
             {
              clrForeGround = CLR_WHITE;
              clrBackGround = CLR_BLACK;
             }
          else
             {
              clrForeGround = CLR_BLACK;
              clrBackGround = CLR_WHITE;
             }

          pOwnerItem -> fsState = pOwnerItem -> fsStateOld = FALSE;

          rectlItem = pOwnerItem -> rclItem;
          rectlItem.xRight = rectlItem.xRight / 2;
          plbiLineItem = (PLISTBOXINFO) pOwnerItem -> hItem;

          WinDrawText (pOwnerItem -> hps, -1,
                       plbiLineItem -> szString1,
                       &rectlItem, clrForeGround, clrBackGround,
                       DT_VCENTER | DT_ERASERECT);

          rectlItem = pOwnerItem -> rclItem;
          rectlItem.xLeft = rectlItem.xRight / 2;
          WinDrawText (pOwnerItem -> hps, -1,
                       plbiLineItem -> szString2,
                       &rectlItem, clrForeGround, clrBackGround,
                       DT_VCENTER | DT_ERASERECT);

          mr = (MRESULT) TRUE;

          break;

       case WM_MEASUREITEM:

          mr = MRFROM2SHORT (40, 100);
          break;

       case WM_CONTROL:

          switch (SHORT1FROMMP (mp1))
             {
              case ID_LISTBOX:

                 if (SHORT2FROMMP (mp1) == LN_ENTER)
                    {
                     usIndex = (USHORT) WinSendMsg (hwndList,
                                             LM_QUERYSELECTION,
                                             MPFROMSHORT (LIT_FIRST), 0L);

                     plbiLineItem = (PLISTBOXINFO) WinSendMsg (hwndList,
                                              LM_QUERYITEMHANDLE,
                                              MPFROMSHORT (usIndex), 0L);

                     WinSetWindowText (hwndEntry1, plbiLineItem -> szString2);
                     WinSetWindowText (hwndEntry2, plbiLineItem -> szString1);

                     WinEnableWindow (hwndPush, TRUE);
                    }
                 break;

              case ID_PUSH:

                 if (SHORT2FROMMP (mp1) == BN_PAINT)
                    {
                     pUserButton = PVOIDFROMMP (mp2);

                     switch (pUserButton -> fsState)
                        {
                         case BDS_DEFAULT:
                            fnDrawBitmap (pUserButton -> hwnd,
                                          pUserButton -> hps,
                                          IDBMP_DEFAULT);
                            break;

                         case BDS_HILITED:
                            fnDrawBitmap (pUserButton -> hwnd,
                                          pUserButton -> hps,
                                          IDBMP_HILITE);
                            break;

                         case BDS_DISABLED:
                            fnDrawBitmap (pUserButton -> hwnd,
                                          pUserButton -> hps,
                                          IDBMP_DISABLE);
                            break;

                         default:
                            fnDrawBitmap (pUserButton -> hwnd,
                                          pUserButton -> hps,
                                          IDBMP_DEFAULT);

                            break;
                        }
                    }

                 break;

              default:
                 break;
             }
          break;

       case WM_COMMAND:

          switch (SHORT1FROMMP (mp1))
             {
              case ID_PUSH:

                 usIndex = (USHORT) WinSendMsg (hwndList, LM_QUERYSELECTION,
                                             MPFROMSHORT (LIT_FIRST), 0L);

                 plbiLineItem = (PLISTBOXINFO) WinSendMsg (hwndList,
                                              LM_QUERYITEMHANDLE,
                                              MPFROMSHORT (usIndex), 0L);

                 WinQueryWindowText (hwndEntry1, 20,
                                     plbiLineItem -> szString2);

                 WinQueryWindowText (hwndEntry2, 20,
                                     plbiLineItem -> szString1);

                 WinInvalidateRect (hwndList, 0L, 0L);

                 break;

              default:
                 break;
             }
          break;

       case WM_CLOSE:

          WinPostMsg (hwnd, WM_QUIT, 0L, 0L);
          break;
      }

   return WinDefMDIDocumentProc ( hwnd, msg, mp1, mp2 );
}

VOID fnDrawBitmap (HWND hwnd, HPS hps, ULONG ulBitmapID)

{
 RECTL rectlWindow;
 HBITMAP hbmBitmap;
 POINTL ptlBitmap;

 WinQueryWindowRect (hwnd, &rectlWindow);

 hbmBitmap = GpiLoadBitmap (hps, 0L, ulBitmapID,
                            rectlWindow.xRight, rectlWindow.yTop);

 ptlBitmap.x = ptlBitmap.y = 0;

 WinDrawBitmap (hps, hbmBitmap, 0L, &ptlBitmap, 0L, 0L, DBM_NORMAL);

 GpiDeleteBitmap (hbmBitmap);
}
