#define INCL_WIN
#define INCL_DOS
#define INCL_GPILCIDS
#include <os2.h>

#include "main.rh"
#include "main.h"
#include "..\mdi.h"
#include "owner.h"

#include <malloc.h>
#include <memory.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

MRESULT EXPENTRY fnwpGeneric ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 );
static const PSZ mkpszGeneric = "Generic";

MRESULT EXPENTRY fnwpNoQuit ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 );
static const PSZ mkpszNoQuit = "NoQuit";
LONG   lTotalLines ;
LONG   lMaxChars ;

main ()
{
    HAB     hab;
    HMQ     hmq;
    QMSG    qmsg;
    HWND    hwndFrame;

    hab = WinInitialize ( 0 );
    hmq = WinCreateMsgQueue ( hab, 0 );

//    WinRegisterMDIClasses ( hab );

    fnwpGeneric    ( (HWND)hab, UM_REGISTERCLASS, 0, 0 );
    fnwpNoQuit     ( (HWND)hab, UM_REGISTERCLASS, 0, 0 );
    wpText         ( (HWND)hab, UM_REGISTERCLASS, 0, 0 );
    wpClientWndProc( (HWND)hab, UM_REGISTERCLASS, 0, 0 );

    // create the frame window
    {
        HWND        hwndClient;
        ULONG       ulFlags = FCF_ICON | FCF_MENU | FCF_ACCELTABLE | FCF_SHELLPOSITION |
                    FCF_SIZEBORDER | FCF_SYSMENU | FCF_MINMAX | FCF_TITLEBAR | FCF_TASKLIST;
        hwndFrame = WinCreateStdWindow ( HWND_DESKTOP, WS_VISIBLE, &ulFlags,
                    mkpszGeneric, "MDI Application", WS_VISIBLE,
                    0, MAIN_RESOURCE_ID, &hwndClient );
    }

    while ( WinGetMsg ( hab, &qmsg, 0, 0, 0 ) )
        WinDispatchMsg ( hab, &qmsg );

    WinDestroyWindow ( hwndFrame );
    WinDestroyMsgQueue ( hmq );
    WinTerminate ( hab );

    return 0;
}

BOOL IsChecked ( HWND hwndClient, USHORT id, BOOL inc, BOOL flip )
{
    HWND    hwndFrame = WinQueryWindow ( hwndClient, QW_PARENT );
    HWND    hwndMenu = WinWindowFromID ( hwndFrame, FID_MENU );
    USHORT  usAttr = MenuQueryItemAttr ( hwndMenu, id, inc, MIA_CHECKED );
    if ( flip )
        MenuSetItemAttr ( hwndMenu, id, inc, MIA_CHECKED, usAttr^MIA_CHECKED );
    return (BOOL) usAttr;
}

MRESULT EXPENTRY fnwpGeneric ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
    switch ( msg )
    {
        case UM_REGISTERCLASS:
        {
            HAB     hab = (HAB) hwnd;
            if ( WinRegisterClass( hab, mkpszGeneric, fnwpGeneric, CS_CLIPCHILDREN, 8 ) )
            {
                return (MRESULT) TRUE;
            }
            return (MRESULT) FALSE;
        }

        case WM_COMMAND :
        {
            switch ( SHORT1FROMMP(mp1) )
            {
                case WINDOWS_INCDIS_ID :
                    IsChecked ( hwnd, WINDOWS_INCDIS_ID, TRUE, TRUE );
                    return (MRESULT) 0;

                case WINDOWS_TILE_SQUARE_ID :
                {
                    ULONG   ulFlags = 0;
                    if ( !IsChecked ( hwnd, WINDOWS_INCDIS_ID, TRUE, FALSE ) )
                        ulFlags |= MDITILE_SKIPDISABLED;
                    return WinSendMsg ( hwnd, WM_MDITILE, MPFROMLONG(ulFlags), 0 );
                }

                case WINDOWS_TILE_HORZ_ID :
                {
                    ULONG   ulFlags = MDITILE_HORIZONTAL;
                    if ( !IsChecked ( hwnd, WINDOWS_INCDIS_ID, TRUE, FALSE ) )
                        ulFlags |= MDITILE_SKIPDISABLED;
                    return WinSendMsg ( hwnd, WM_MDITILE, MPFROMLONG(ulFlags), 0 );
                }

                case WINDOWS_TILE_VERT_ID :
                {
                    ULONG   ulFlags = MDITILE_VERTICAL;
                    if ( !IsChecked ( hwnd, WINDOWS_INCDIS_ID, TRUE, FALSE ) )
                        ulFlags |= MDITILE_SKIPDISABLED;
                    return WinSendMsg ( hwnd, WM_MDITILE, MPFROMLONG(ulFlags), 0 );
                }

                case WINDOWS_CASCADE_ID :
                {
                    ULONG   ulFlags = 0;
                    if ( !IsChecked ( hwnd, WINDOWS_INCDIS_ID, TRUE, FALSE ) )
                        ulFlags |= MDITILE_SKIPDISABLED;
                    return WinSendMsg ( hwnd, WM_MDICASCADE, MPFROMLONG(ulFlags), 0 );
                }

                case WINDOWS_MAXIMIZE_ID :
                    return WinSendMsg ( hwnd, WM_MDIMAXIMIZE, MPFROMLONG(WinQueryActiveWindow ( hwnd )), 0 );

                case WINDOWS_RESTORE_ID :
                    return WinSendMsg ( hwnd, WM_MDIRESTORE, MPFROMLONG(WinQueryActiveWindow ( hwnd )), 0 );

                case WINDOWS_ARRANGE_ID :
                    return WinSendMsg ( hwnd, WM_MDIICONARRANGE, 0, 0 );

                case FOCUS_NEXT_ID :
                    return WinSendMsg ( hwnd, WM_MDINEXT, 0, FALSE );

                case FOCUS_PREV_ID :
                    return WinSendMsg ( hwnd, WM_MDINEXT, 0, MPFROMLONG(TRUE) );

                case FILE_NEW_ID :
                {
                    INT     id = (INT) WinQueryWindowULong ( hwnd, 0 ) + 1;
                    HWND    hwndDoc;
                    MDICREATESTRUCT mcs;
                    CHAR    szTitle[64];
                    memset ( &mcs, 0, sizeof mcs );
                    mcs.cbSize = sizeof mcs;
                    mcs.pszClass = mkpszNoQuit;
                    mcs.pszTitle = "";
                    mcs.hwndOwner = hwnd;
                    mcs.x = mcs.y = mcs.cx = mcs.cy = CW_USEDEFAULT;
                    mcs.fFrameStyle = mcs.fClientStyle = WS_VISIBLE | FS_NOBYTEALIGN;
                    mcs.fFrameFlags = FCF_STANDARD;
                    mcs.id = CHILD_RESOURCE_ID;
                    hwndDoc = LONGFROMMR ( WinSendMsg ( hwnd, WM_MDICREATE, 0, MPFROMP( &mcs ) ) );
                    WinSetWindowULong ( hwnd, 0, (ULONG) id );
                    WinSetWindowUShort ( hwndDoc, QWS_ID, (USHORT) id );
                    WinQueryWindowUShort ( hwndDoc, QWS_ID );
                    sprintf ( szTitle, "%04d, %08lx, Mdi Document", id, hwndDoc );
                    WinSetWindowText ( hwndDoc, szTitle );
                    return (MRESULT) 0;
                }

                case FILE_NEW_SCROLL_ID :
                {
                    INT     id = (INT) WinQueryWindowULong ( hwnd, 0 ) + 1;
                    HWND    hwndDoc;
                    MDICREATESTRUCT mcs;
                    CHAR    szTitle[64];

                    memset ( &mcs, 0, sizeof mcs );
                    mcs.cbSize      = sizeof mcs;
                    mcs.pszClass    = "WC_TEXT";
                    mcs.pszTitle    = "CONFIG.SYS";
                    mcs.hwndOwner   = hwnd;
                    mcs.x = mcs.y   = mcs.cx = mcs.cy = CW_USEDEFAULT;
                    mcs.fFrameStyle = mcs.fClientStyle = WS_VISIBLE | FS_NOBYTEALIGN;
                    mcs.fFrameFlags = FCF_HORZSCROLL  | FCF_VERTSCROLL  | FCF_STANDARD;
                    mcs.id          = CHILD_RESOURCE_ID;

                    hwndDoc = LONGFROMMR ( WinSendMsg ( hwnd, WM_MDICREATE, 0, MPFROMP( &mcs ) ) );
                    WinSetWindowULong ( hwnd, 0, (ULONG) id );
                    WinSetWindowUShort ( hwndDoc, QWS_ID, (USHORT) id );
                    return (MRESULT) 0;
                }
                case FILE_NEW_CONT_ID :
                {
                    INT     id = (INT) WinQueryWindowULong ( hwnd, 0 ) + 1;
                    HWND    hwndDoc;
                    MDICREATESTRUCT mcs;
                    CHAR    szTitle[64];

                    memset ( &mcs, 0, sizeof mcs );
                    mcs.cbSize      = sizeof mcs;
                    mcs.pszClass    = szClientClass;
                    mcs.pszTitle    = "OWNER DRAWN CONTROLS";
                    mcs.hwndOwner   = hwnd;
                    mcs.x = mcs.y   = mcs.cx = mcs.cy = CW_USEDEFAULT;
                    mcs.fFrameStyle = mcs.fClientStyle = WS_VISIBLE | FS_NOBYTEALIGN;
                    mcs.fFrameFlags = FCF_STANDARD & ~FCF_MENU;
                    mcs.id          = CHILD_RESOURCE_ID;

                    hwndDoc = LONGFROMMR ( WinSendMsg ( hwnd, WM_MDICREATE, 0, MPFROMP( &mcs ) ) );
                    WinSetWindowULong ( hwnd, 0, (ULONG) id );
                    WinSetWindowUShort ( hwndDoc, QWS_ID, (USHORT) id );
                    return (MRESULT) 0;
                }

            }
            break;
        }
    }
    return WinDefMDIServerProc ( hwnd, msg, mp1, mp2 );
}

MRESULT EXPENTRY fnwpNoQuit ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
static RefCount; //kpk
                  //reference count of the number of windows created

    switch ( msg )
    {
        case UM_REGISTERCLASS:
        {
            HAB     hab = (HAB) hwnd;
            if ( WinRegisterClass( hab, mkpszNoQuit, fnwpNoQuit, CS_SIZEREDRAW | CS_CLIPSIBLINGS, 0) )
            {
                return (MRESULT) TRUE;
            }
            return (MRESULT) FALSE;
        }

        case WM_CREATE: // Kpk
        {
            RefCount++;
            WinPostMsg(hwnd, WM_ACTIVATE, MPFROMSHORT(TRUE), MPFROMHWND(hwnd));

       }
        break;

//      case WM_CLOSE: //kpk
//      {
//         RefCount--;
//
//         break;
//      }

       case WM_DESTROY: //kpk
       // Perhaps it is "better" to decrement RefCount at WM_CLOSE,
       // then, at WM_ACTIVATE(inactive), check if the reference count if zero and reload the org. menu.
       // I think this is equivalent.
       {
        HWND  hwndMain;

        HWND hwndClient = WinQueryWindow( WinQueryWindow (hwnd, QW_PARENT), QW_PARENT );

          if (--RefCount == 0) {

            hwndMain = WinLoadMenu( hwnd, NULLHANDLE, MAIN_RESOURCE_ID );

            WinSendMsg (hwndClient, WM_MDISETMENU, (MPARAM)hwndMain, 0 ) ;

          }
          break;
       }

        case WM_PAINT :
        {
            HPS     hps;
            RECTL   rec;
            HWND    hwndFrame = WinQueryWindow ( hwnd, QW_PARENT );
            LONG    lColor = (LONG) WinQueryWindowUShort ( hwndFrame, QWS_ID );

            hps = WinBeginPaint ( hwnd, 0, &rec );
            if ( WinIsWindowEnabled ( hwnd ) )
                WinFillRect ( hps, &rec, lColor%8 );
            else
                WinFillRect ( hps, &rec, lColor%8 + 8 );
            WinEndPaint ( hps );
            return (MRESULT) FALSE;
        }

        case WM_COMMAND :
        {
            switch ( SHORT1FROMMP(mp1) )
            {
                case ENABLE_ID :
                    if ( WinIsWindowEnabled ( hwnd ) )
                        break;
                    WinEnableWindow ( hwnd, TRUE );
                    WinInvalidateRect ( hwnd, NULL, FALSE );
                    break;

                case DISABLE_ID :
                    if ( !WinIsWindowEnabled ( hwnd ) )
                        break;
                    WinEnableWindow ( hwnd, FALSE );
                    WinInvalidateRect ( hwnd, NULL, FALSE );
                    break;
            }
            break;
        }

        case WM_ACTIVATE: // kpk
        {
           HWND hwndClient = WinQueryWindow( WinQueryWindow (hwnd, QW_PARENT), QW_PARENT );
           static HWND hwndMenu = NULLHANDLE;

               // Set the menu if gaining focus

           if( !hwndMenu )
              hwndMenu = WinLoadMenu( hwnd, NULLHANDLE, CHILD_RESOURCE_ID );

           if (mp1)
              WinSendMsg (hwndClient, WM_MDISETMENU, (MPARAM)hwndMenu, 0) ;

        }
        break;


    }

    return WinDefMDIDocumentProc ( hwnd, msg, mp1, mp2 );
}
MRESULT APIENTRY wpText( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
 MRESULT         mr = (MRESULT) 0L ;
 static CHAR     *pBuffer ;
 static ULONG    ulFileSize ;
 static ULONG    cxChar, cyLine ;
 static LONG     lNumLines=0 ;
 static LONG     lVPos ;
 static USHORT   cxClient ;
 static USHORT   cyClient ;
 static LONG     lHPos ;
 static HWND     hwndVertScroll, hwndHorzScroll ;

  switch (msg)
   {
     case UM_REGISTERCLASS:
     {
        HAB     hab = (HAB) hwnd;
        if( WinRegisterClass ( hab, "WC_TEXT", (PFNWP)wpText , CS_SIZEREDRAW, 0 ) )
        {
           return (MRESULT) TRUE;
        }
        return (MRESULT) FALSE;
     }

   case WM_CREATE:
    {
     HPS          hpsMicroPS ;
     FONTMETRICS  fm ;
     ULONG        rc ;
     hpsMicroPS = WinGetPS(
                              hwnd
                                     ) ;

     rc = GpiQueryFontMetrics ( hpsMicroPS , sizeof (FONTMETRICS) , &fm ) ;
     cxChar = fm.lAveCharWidth ;
     cyLine = fm.lMaxBaselineExt ;
     pBuffer = AppGetBuffer(STR_FILENAME, &ulFileSize);
     hwndVertScroll = WinWindowFromID(WinQueryWindow(hwnd, QW_PARENT), FID_VERTSCROLL) ;
     hwndHorzScroll = WinWindowFromID(WinQueryWindow(hwnd, QW_PARENT), FID_HORZSCROLL) ;
     WinSendMsg (hwndVertScroll, SBM_SETSCROLLBAR, MPFROMSHORT (0), MPFROM2SHORT (0, lTotalLines - 1)) ;
     WinSendMsg (hwndVertScroll, SBM_SETTHUMBSIZE, MPFROM2SHORT (cyClient / cyLine, lTotalLines), NULL);
     WinSendMsg (hwndHorzScroll, SBM_SETSCROLLBAR, MPFROMSHORT (0), MPFROM2SHORT (0, lMaxChars - 1)) ;
     WinSendMsg (hwndHorzScroll, SBM_SETTHUMBSIZE, MPFROM2SHORT (cxClient / cxChar, lMaxChars), NULL);

      //kpk
     WinPostMsg(hwnd, WM_ACTIVATE, MPFROMSHORT(TRUE), MPFROMHWND(hwnd));
    }
    break;

   case WM_SIZE:
     cxClient = SHORT1FROMMP (mp2) ;
     cyClient = SHORT2FROMMP (mp2) ;
     WinSendMsg (hwndVertScroll, SBM_SETTHUMBSIZE, MPFROM2SHORT (cyClient / cyLine, lTotalLines), NULL);
     WinSendMsg (hwndHorzScroll, SBM_SETTHUMBSIZE, MPFROM2SHORT (cxClient / cxChar, lMaxChars), NULL);
    break;
   case WM_VSCROLL:
    {
     switch (SHORT2FROMMP (mp2))
        {
          case SB_LINEUP:
           lVPos -= 1;
           break;
          case SB_LINEDOWN:
           lVPos += 1;
           break;
          case SB_PAGEUP:
           lVPos -= (ULONG)cyClient / cyLine;
           break;
          case SB_PAGEDOWN:
           lVPos += (ULONG)cyClient / cyLine;
           break;
          case SB_SLIDERPOSITION:
           lVPos = SHORT1FROMMP (mp2);
           break;
          case SB_SLIDERTRACK:
           lVPos = SHORT1FROMMP (mp2);
           break;
          default:
           break;
        }
     lVPos = max (0, min (lVPos, lTotalLines - 1));
     if (lVPos != SHORT1FROMMR (WinSendMsg ( hwndVertScroll , SBM_QUERYPOS , NULL , NULL )))
        {
         WinSendMsg ( hwndVertScroll , SBM_SETPOS , MPFROMSHORT (lVPos) , NULL );
         WinInvalidateRect ( hwnd , NULL , FALSE );
        }
    }
    break;

   case WM_HSCROLL:
     {
      switch (SHORT2FROMMP (mp2))
        {
         case SB_LINELEFT:
           lHPos -= 1;
           break;
         case SB_LINERIGHT:
           lHPos += 1;
           break;
         case SB_PAGELEFT:
           lHPos -= cxClient / cxChar;
           break;
         case SB_PAGERIGHT:
           lHPos += cxClient / cxChar;
           break;
         case SB_SLIDERPOSITION:
           lHPos = SHORT1FROMMP (mp2);
           break;
         case SB_SLIDERTRACK:
           lHPos = SHORT1FROMMP (mp2);
           break;
          default:
           break;
        }
      lHPos = max (0, min (lHPos, lMaxChars - 1));
      if (lHPos != SHORT1FROMMR (WinSendMsg ( hwndHorzScroll, SBM_QUERYPOS, NULL, NULL )))
       {
         WinSendMsg (hwndHorzScroll, SBM_SETPOS, MPFROMSHORT (lHPos), NULL);
         WinInvalidateRect (hwnd, NULL, FALSE);
       }
     }
    break;

   case WM_PAINT:
    {
     CHAR  *pWorkBuffer, *pEndLine ;
     RECTL  rclClient ;
     HPS    hpsMicroPS ;
     POINTL  ptlDraw ;
     ULONG   ulCharCount=0 ;
     ULONG   ulVTemp ;

     WinQueryWindowRect( hwnd , &rclClient );
     hpsMicroPS = WinBeginPaint ( hwnd , (HPS)NULL , (PRECTL)NULL ) ;
     GpiErase ( hpsMicroPS ) ;
     pWorkBuffer = pBuffer ;
     ulVTemp = lVPos ;
     do
      {
        pEndLine = strpbrk(pWorkBuffer , "\n\r\0X1A") ;
        if (ulVTemp == 0)
           break ;
        ulCharCount = pEndLine - pWorkBuffer ;
        pWorkBuffer += ulCharCount ;
        while (*pWorkBuffer == '\r' || *pWorkBuffer == '\n')
         {
           pWorkBuffer++ ;
         }
      } while (ulVTemp--);

     for (lNumLines = 1 ; *pWorkBuffer != 0X1A ; lNumLines++)
      {
        ptlDraw.x =  cxChar ;
        ptlDraw.y =  rclClient.yTop - ( cyLine * lNumLines) ;
        if (ptlDraw.y < 0)
          break ;
        ulCharCount = pEndLine - pWorkBuffer ;
        GpiCharStringAt (
                          hpsMicroPS
                        , &ptlDraw
                        , ulCharCount - lHPos
                        , pWorkBuffer + lHPos
                                        ) ;
        pWorkBuffer += ulCharCount ;
        while (*pWorkBuffer == '\r' || *pWorkBuffer == '\n')
         {
           pWorkBuffer++ ;
         }
        pEndLine = strpbrk(pWorkBuffer , "\n\r\0X1A") ;
      }
     lNumLines -= 1 ;
     WinEndPaint (
                   hpsMicroPS
                                ) ;

    }
    break ;

    case WM_ACTIVATE: //kpk
    {
         HWND hwndClient = WinQueryWindow( WinQueryWindow (hwnd, QW_PARENT), QW_PARENT );
         static HWND hwndMain = NULLHANDLE;

             // Set the menu if gaining focus

         if ( !hwndMain )
            hwndMain = WinLoadMenu( hwnd, NULLHANDLE, MAIN_RESOURCE_ID );

         if (mp1) {

            WinSendMsg (hwndClient, WM_MDISETMENU, (MPARAM)hwndMain, 0 ) ;

        }
    }
    break;


    case WM_DESTROY:
     free (pBuffer) ;
     break;

   default:
    mr = WinDefMDIDocumentProc ( hwnd , msg , mp1 , mp2 ) ;
    break ;
  }
 return mr ;
}


PCH AppGetBuffer (PSZ pszFileName, PULONG pulFileSize)
{
         HFILE         hFile;
         PCH           pBuf, pWorkBuffer, pEndLine;
struct   _FILEFINDBUF3 InfoBuf;
         ULONG         ulByteCount;
         ULONG         ulAction;
         HDIR          hDir      = HDIR_SYSTEM ;
         ULONG         ulSearch   = 1;
         ULONG         ulAttrib  = FILE_NORMAL ;
         ULONG         flOpen    = OPEN_ACTION_OPEN_IF_EXISTS |
                                   OPEN_ACTION_FAIL_IF_NEW ;
         ULONG         flMode    = OPEN_SHARE_DENYNONE |
                                   OPEN_ACCESS_READONLY ;
         LONG          lCharCount ;
  DosFindFirst( pszFileName , &hDir , ulAttrib , &InfoBuf , (ULONG) ( sizeof(InfoBuf) * ulSearch ) , &ulSearch , FIL_STANDARD ) ;
  *(pulFileSize) = InfoBuf.cbFile;
  DosOpen( (PSZ) pszFileName , &hFile , &ulAction , 0L , ulAttrib , flOpen , flMode , (ULONG)NULL ) ;
  pBuf = (PCH) malloc (*pulFileSize + 1) ;
  DosRead( hFile , pBuf , *(pulFileSize) , &ulByteCount );
  *(pBuf + *(pulFileSize)) = 0X1A ;
  DosClose( hFile );
  pWorkBuffer = pBuf ;
  lTotalLines = 0 ;
  while (*pWorkBuffer != 0X1A)
   {
    pEndLine = strpbrk(pWorkBuffer , "\n\r\0X1A") ;
    lCharCount = pEndLine - pWorkBuffer ;
    pWorkBuffer += lCharCount ;
    while (*pWorkBuffer == '\r' || *pWorkBuffer == '\n')
    {
     pWorkBuffer++ ;
    }
     if (lCharCount > lMaxChars)
     lMaxChars = lCharCount ;
     lTotalLines++ ;
   }
  return (pBuf);
}
