#define INCL_DOSPROCESS
#define INCL_DEV
#define INCL_GPIBITMAPS
#define INCL_GPILOGCOLORTABLE
#define INCL_WIN
#include <os2.h>
#include "internal.h"
#include "mdi.h"

#include <malloc.h>
#include <stdio.h>
#include <string.h>

extern const PSZ mkpszMDIDocument;
extern const ACCELTABLE * const mkpatMDIDocument;

#define UM_QUERYMAXHWND (WM_USER+2048)
#define UM_SETMAXHWND   (WM_USER+2049)

#define SC_FIRST    SC_SIZE
#define SC_LAST    (SC_HIDE+0x100) // to allow for user added system entries
#define FID_FIRST   FID_SYSMENU
#define FID_LAST   (FID_DBE_KKPOPUP+0x100) // see SC_LAST

MRESULT EXPENTRY fnwpMDIDocument ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 );
const PSZ mkpszMDIDocument = "MDIDocument";
static HWND ActivateMDIDocument ( HWND hwnd, HWND hwndDoc, BOOL boolBottom );

MRESULT EXPENTRY MenuSubProc(HWND, ULONG, MPARAM, MPARAM) ;     //kk

//      Register the MDI Classes  fnwpMDIDocument is the frame window
//  for the Document ( child or secondary ) window.  The client space for
//  the MDI child is supplied by the MDI programmer; however, the function
//  WinDefMDIDocument should be called instead of the WinDefWindowProc for
//  all unprocessed messages.
//      WinDefMDIServerProc is the Client function for the MDI Application
//  ( primary ) window.  The programmer should call this procedure for all
//  unprocessed window messages.
//      The frame procecure for the MDI Application is
//  the standard frame window procedure.

VOID WinRegisterMDIClasses ( HAB hab )
{
    fnwpMDIDocument     ( (HWND)hab, UM_REGISTERCLASS, 0, 0 );
    WinDefMDIServerProc ( (HWND)hab, UM_REGISTERCLASS, 0, 0 );
}


HWND WinCreateMDIDocument ( HWND hwnd, MDICREATESTRUCT *pmcs  )
{
    HWND        hwndMDIDocument;
    HWND        hwndClient;

    FRAMECDATA  fcdata;
    SWP         swp, swpMax;

    HWND        hwndServer = WinQueryWindow ( hwnd, QW_PARENT );

    CLASSINFO   ciExists;
    BOOL        flClassExists = WinQueryClassInfo( WinQueryAnchorBlock(hwnd),
                                    WC_MDISERVER, &ciExists );

    if( ! flClassExists )
      WinRegisterMDIClasses( WinQueryAnchorBlock(hwnd) );

    GetNewMDIChildSWP ( hwnd, &swp, -1 ); // default location for new window
    if ( pmcs->x  != CW_USEDEFAULT )  swp.x  = pmcs->x;
    if ( pmcs->y  != CW_USEDEFAULT )  swp.y  = pmcs->y;
    if ( pmcs->cx != CW_USEDEFAULT )  swp.cx = pmcs->cx;
    if ( pmcs->cy != CW_USEDEFAULT )  swp.cy = pmcs->cy;
 

    fcdata.cb            = sizeof fcdata;
    fcdata.flCreateFlags = pmcs->fFrameFlags;
    fcdata.hmodResources = pmcs->hmod;
    fcdata.idResources   = pmcs->id;

    hwndMDIDocument = WinCreateWindow ( hwnd, mkpszMDIDocument,
            pmcs->pszTitle, pmcs->fFrameStyle | WS_CLIPCHILDREN,
            swp.x, swp.y ,swp.cx, swp.cy,
            pmcs->hwndOwner, HWND_BOTTOM, pmcs->id, &fcdata, NULL );

    hwndClient = WinCreateWindow ( hwndMDIDocument, pmcs->pszClass, NULL,
                    pmcs->fClientStyle, 0,0,0,0, hwndMDIDocument, HWND_TOP,
                    FID_CLIENT, pmcs->pCreateStruct, pmcs->pPresParams );

    ActivateMDIDocument ( hwnd, hwndMDIDocument, FALSE );
    WinSendMsg ( hwndMDIDocument, WM_UPDATEFRAME, MPFROMLONG(-1), 0 );

    return hwndMDIDocument;
}


// --------------------------------------------------------------------------
// stuff that has to do with z-ordering and activating document windows
// --------------------------------------------------------------------------

static HWND ActivateMDIDocument ( HWND hwnd, HWND hwndDoc, BOOL boolBottom )
{
    HWND    hwndTop = WinQueryWindow ( hwnd, QW_TOP );

    // if there is a maximized Document window, then there will always be a
    // special case handling for it.  Since Windows** allows only one
    // maximized window at a time and this set of functions is intended to
    // closely mimic the MDI functionality of Windows** then this set of
    // funtions will only allow one maximized window.
    if ( WinSendMsg ( hwnd, UM_QUERYMAXHWND, 0, 0 ) )
    {
        HWND    hwndMenu = WinWindowFromID ( WinQueryWindow ( hwnd, QW_PARENT ), FID_MENU );
        WinEnableWindowUpdate ( hwndMenu, FALSE );
        WinEnableWindowUpdate ( hwnd, FALSE );
      // both windows need to be in restore state
      // WM_ACTIVATE Messages are knocked out if maximized
      // see fnwpMDIDocument.
        WinSetWindowPos ( hwndDoc, HWND_TOP, 0,0,0,0, SWP_ZORDER | SWP_MAXIMIZE | SWP_ACTIVATE );
        WinSetWindowPos ( hwndTop, 0,0,0,0,0, SWP_RESTORE );
        WinEnableWindowUpdate ( hwnd, TRUE );
        WinEnableWindowUpdate ( hwndMenu, TRUE );
    }
    else
        WinSetWindowPos ( hwndDoc, HWND_TOP, 0,0,0,0, SWP_ZORDER | SWP_ACTIVATE );

    if ( boolBottom && hwndTop != hwndDoc )
        WinSetWindowPos ( hwndTop, HWND_BOTTOM, 0,0,0,0, SWP_ZORDER );

    WinSetWindowPos ( hwndDoc, HWND_TOP, 0,0,0,0, SWP_ACTIVATE );

    return hwndDoc;
}

// front end function for ActivateMDIDocument
HWND WinActivateMDIDocument ( HWND hwnd, HWND hwndDoc )
{
    return ActivateMDIDocument ( hwnd, hwndDoc, TRUE );
}

// another front end function for ActivateMDIDocument
HWND WinActivateNextMDIDocument ( HWND hwnd, BOOL boolNext )
{
    HWND    hwndNext;
    HWND    hwndTop   = WinQueryWindow ( hwnd, QW_TOP );

    if (! boolNext )
    {
        hwndNext = WinQueryWindow ( hwndTop, QW_NEXT );
        return ActivateMDIDocument ( hwnd, hwndNext, TRUE );
    }
    else
    {
        hwndNext = WinQueryWindow ( hwnd, QW_BOTTOM );
        return ActivateMDIDocument ( hwnd, hwndNext, FALSE );
    }
}


// --------------------------------------------------------------------------
// stuff that sizes or positions document windows
// --------------------------------------------------------------------------

// Will only count child windows that respond TRUE to the message
// UM_ISCHILDMDI.  If a window does not respond TRUE then it is
// ignored.  ulSizeOptions can be used to filter the returned count
// there by including only those windows of interest as defined by
// the size state. ( ie SWP_RESTORE | SWP_MAXIMIZE | SWP_MINIMIZE )
// There is a slight kludge in that SWP_SIZE ( this was picked quite
// arbitrarily so don't ask why ) can be used to exclude disabled
// windows ( ie any window that has been diabled with the WinDisableWindow
// function. )  If pphwnd is provided then an array of hwnd's are generated.
INT CountMDIDocuments ( HWND hwnd, ULONG ulSizeOptions, HWND **pphwnd )
{
    INT     iWindowCount = 0;
    HENUM   henum;
    HWND    hwndMDIDocument;
    SWP     swp;
    BOOL    boolSkipDisabled = FALSE;

    // ALERT -- pseudo kludge ahead -- ALERT
    // The flag for MDITILE_SKIPDISABLED is masquerading as SWP_SIZE
    if ( ulSizeOptions & SWP_SIZE )
    {
        ulSizeOptions &= ~SWP_SIZE;
        boolSkipDisabled = TRUE;
    }
    if ( pphwnd ) // does the caller want a list of window handles ?
        *pphwnd = malloc ( sizeof(HWND) );

    henum = WinBeginEnumWindows ( hwnd );
    while ( ( hwndMDIDocument = WinGetNextWindow(henum) ) != 0 )
    {

        if ( WinSendMsg(hwndMDIDocument,UM_ISCHILDMDI,0,0) == 0 ) // not an mdi
            continue;                                           // client

        WinQueryWindowPos ( hwndMDIDocument, &swp );
        if ( (swp.fl & ulSizeOptions ) == 0 )                // not the right style
            continue;

        if ( boolSkipDisabled & !WinIsWindowEnabled ( WinWindowFromID ( hwndMDIDocument, FID_CLIENT ) ) )
        {
            WinSetWindowPos ( hwndMDIDocument, HWND_BOTTOM, 0,0,0,0, SWP_ZORDER );
            continue;
        }

        if ( pphwnd ) // up date the window list
        {
            *pphwnd = realloc ( *pphwnd, (iWindowCount+2) * sizeof(HWND) );
            (*pphwnd)[iWindowCount] = hwndMDIDocument;
        }
        iWindowCount++;
    }
    WinEndEnumWindows ( henum );
    if ( pphwnd )
        (*pphwnd)[iWindowCount] = 0;
    return iWindowCount;
}

// based on the number of windows in the restore state and the current
// size of the application client a set valuse that correspond to the
// positioning of a new window are generated and returned.
VOID GetNewMDIChildSWP ( HWND hwndMDIServer, SWP *pswp, INT iWindowCount )
{
    RECTL   rec;
    LONG    cySysMenu = WinQuerySysValue ( HWND_DESKTOP, SV_CYMINMAXBUTTON );
    LONG    cxSysMenu = WinQuerySysValue ( HWND_DESKTOP, SV_CXMINMAXBUTTON )/2;
    INT     iMaxYCount;
    INT     iMaxXCount;
    INT     iXOffset;
    INT     cyIcon = WinQuerySysValue ( HWND_DESKTOP, SV_CYICON );

    if ( iWindowCount == -1 )
        iWindowCount = CountMDIDocuments( hwndMDIServer, SWP_RESTORE | SWP_MAXIMIZE, NULL );
    WinQueryWindowRect ( hwndMDIServer, &rec );
    rec.yBottom = rec.yTop>cyIcon*4 ? cyIcon*3 : 0;

    rec.yTop -= rec.yBottom;
    // calculate the max number of window spots
    iMaxXCount = (rec.xRight/2) / cxSysMenu;
    iMaxYCount = (rec.yTop/2)   / cySysMenu;
    // there will always be at least one
    iMaxXCount = iMaxXCount < 1 ? 1 : iMaxXCount;
    iMaxYCount = iMaxYCount < 1 ? 1 : iMaxYCount;
    // modulo the count so it will always fit in viewable area
    iWindowCount %= iMaxXCount * iMaxYCount;
    // to determine the column
    iXOffset = iWindowCount / iMaxYCount;
    // to determine the row
    iWindowCount %= iMaxYCount;

    (*pswp).x  =              cxSysMenu*(iWindowCount+iXOffset);
    (*pswp).y  = rec.yTop/2 - cySysMenu*iWindowCount + rec.yBottom;
    (*pswp).cx = rec.xRight / 2;
    (*pswp).cy = rec.yTop   / 2;
}


// current not in use
VOID InsertMenuMDIDocumentNames ( HWND hwndMDIServer, HWND hwndSubMenu, USHORT usStartPos, USHORT usStartId )
{
    MENUITEM    menuitem;
    INT         iName;
    PSZ         pszName;

    HWND        *phwndList;
    HWND        *phwndMDIDocument;

    if ( CountMDIDocuments( hwndMDIServer,
            SWP_MAXIMIZE | SWP_RESTORE | SWP_MINIMIZE, &phwndList ) == 0 )
    {
        free ( phwndList );  // no MDI child windows, then nothing to do !
        return;
    }

    menuitem.hwndSubMenu = 0;
    menuitem.afAttribute = 0;
    menuitem.hItem = 0;

    menuitem.afStyle = MIS_TEXT;
    menuitem.iPosition = usStartPos;
    if ( usStartId )
        menuitem.id = usStartId;

    for ( phwndMDIDocument = phwndList ; *phwndMDIDocument ; phwndMDIDocument++ )
    {
        // the name of the child window will also be it's menu name.
        iName = WinQueryWindowTextLength ( *phwndMDIDocument );

        if ( iName == 0 ) // if no name then no entry !
            continue;

        iName++;
        pszName = malloc ( iName );
        WinQueryWindowText ( *phwndMDIDocument, iName, pszName );

        if ( !usStartId )
            menuitem.id = WinQueryWindowUShort ( *phwndMDIDocument, QWS_ID );
        MenuInsertItem ( hwndSubMenu, &menuitem,  pszName );
        if ( usStartId )
            menuitem.id++;
        menuitem.iPosition++;
        free ( pszName );
    }
    free ( phwndList );
}

// currently not in use
VOID DeleteMenuMDIDocumentName ( HWND hwndMenu, SHORT sStartPos, SHORT sCountPos )
{
    SHORT   sMenuId;
    SHORT   sPosition;
    sStartPos--;
    sCountPos += sStartPos;
    for ( sPosition = sCountPos ; sPosition > sStartPos ; sPosition-- )
    {
        sMenuId = MenuIdFromPos ( hwndMenu, sPosition );
        MenuDeleteItem ( hwndMenu, sMenuId, FALSE );
    }
}

// provied for consistancy in the WinDefMDIServerProc proc.
BOOL WinMaximizeMDIDocument ( HWND hwnd, HWND hwndDoc )
{
    return WinSetWindowPos ( hwndDoc, HWND_TOP, 0,0,0,0, SWP_MAXIMIZE | SWP_ZORDER | SWP_ACTIVATE );
}

// it does just what is says it does
BOOL WinRestoreMDIDocument  ( HWND hwnd, HWND hwndDoc )
{
    SWP     swp;
    WinQueryWindowPos ( hwndDoc, &swp );
    if ( swp.fl & (SWP_MINIMIZE|SWP_MAXIMIZE) )
    {
        WinSetWindowPos ( hwndDoc, 0,0,0,0,0, SWP_RESTORE );
        return TRUE;
    }
    return FALSE;
}

// before tiling or cascading, the maximized window is restored
BOOL RestoreMaximized ( HWND hwnd )
{
    HWND    hwndMax;
    hwndMax = LONGFROMMR ( WinSendMsg ( hwnd, UM_QUERYMAXHWND, 0, 0 ) );
    if ( hwndMax )
        WinSetWindowPos ( hwndMax, 0,0,0,0,0, SWP_RESTORE );
    return (BOOL) hwndMax ? TRUE : FALSE;
}

// this will tile a single row.  It is a work horse function for
// WinTileMDIDocuments
INT TileCurrentRow ( INT iRow, INT iCount, HWND *phwndMDIDocuments, RECTL rec )
{
    INT     iCurrentCol;
    INT     iCol = iCount/iRow;
    INT     x, y, cx, cy;

    if ( iCol > iCount )
        iCol = iCount;

    cx  = rec.xRight / iCol;
    cy  = rec.yBottom;
    x = 0;
    y = rec.yTop;

    for ( iCurrentCol = 0 ; iCurrentCol < iCol ; iCurrentCol++, x+= cx )
    {
        WinSetWindowPos ( phwndMDIDocuments[iCurrentCol], 0, x, y, cx, cy,
                                SWP_MOVE | SWP_SIZE | SWP_RESTORE );
    }
    return iCol;
}

// Will sqaure tile ( minimum number of rows and columns ), Horizontraly
// or Verticaly tile all the restore state windows.
INT WinTileMDIDocuments ( HWND hwnd, ULONG ulFlags )
{
    HWND    *phwnd;
    INT     iCount;

    RestoreMaximized ( hwnd );
    iCount =CountMDIDocuments( hwnd, SWP_RESTORE |
                          // if the flag for skip diabled is set then pass
                          // in the swp_size ( yes it is a kludge ) so that
                          // the count function will not include disabled
                          // windows ( actually Windows is disabled )
                        (ulFlags & MDITILE_SKIPDISABLED ? SWP_SIZE : 0),
                        &phwnd );

    if ( iCount )
    {
        HWND    *phwndCurrent = phwnd;
        RECTL   rec;
        INT     iRow, iCurrentRow;
        INT     iPlaced;
        INT     cyIcon = WinQuerySysValue ( HWND_DESKTOP, SV_CYICON );

        if ( ulFlags &      MDITILE_HORIZONTAL )
            iRow = iCount;
        else if ( ulFlags & MDITILE_VERTICAL )
            iRow = 1;
        else            //  MDITILE_SQUARE
            for ( iRow = 1 ; iRow*iRow < iCount ; ) iRow++;

        WinQueryWindowRect ( hwnd, &rec );
        rec.yBottom = (rec.yTop>cyIcon*4 ? rec.yTop-cyIcon*3 : rec.yTop) /iRow;

        for ( iCurrentRow = iRow ; iCurrentRow > 0 ; iCurrentRow-- )
        {
            rec.yTop -= rec.yBottom;
            iPlaced = TileCurrentRow ( iCurrentRow, iCount, phwndCurrent, rec );
            iCount       -= iPlaced;
            phwndCurrent += iPlaced;
        }
        WinSetActiveWindow ( HWND_DESKTOP, phwnd[iRow-1] );
    }
    free ( phwnd );
    return iCount;
}

// Just what is says
INT WinCascadeMDIDocuments ( HWND hwnd, ULONG ulFlags )
{
    HWND    *phwnd;
    INT     iCount;

    RestoreMaximized ( hwnd );
    iCount =CountMDIDocuments( hwnd, SWP_RESTORE |
                          // if the flag for skip diabled is set then pass
                          // in the swp_size ( yes it is a kludge ) so that
                          // the count function will not include disabled
                          // windows ( actually Windows is disabled )
                        (ulFlags & MDITILE_SKIPDISABLED ? SWP_SIZE : 0),
                        &phwnd );
    if ( iCount)
    {
        INT     iNdx;
        SWP     swp;

        phwnd[iCount] = HWND_TOP;
        for ( iNdx = iCount ; iNdx > 0 ; )
        {
            GetNewMDIChildSWP ( hwnd, &swp, iCount - iNdx );
            iNdx--;
            WinSetWindowPos ( phwnd[iNdx], HWND_TOP, // phwnd[iNdx+1],
                swp.x, swp.y, swp.cx, swp.cy,
                SWP_MOVE | SWP_SIZE | SWP_RESTORE | SWP_ZORDER );
        }
    }
    free ( phwnd );
    return iCount;
}

// taken from real world programming.  It is a good book highly recomend it.
INT WinArrangeIconicMDIDocuments ( HWND hwnd )
{    HWND    *phwnd;
    INT     iCount = CountMDIDocuments( hwnd, SWP_MINIMIZE, &phwnd );
    if ( iCount )
    {
        SWP *pswp = malloc ( sizeof *pswp * iCount );
        INT i;
        for ( i = 0 ; i < iCount ; i++ )
        {
            pswp[i].hwnd = phwnd[i];
            pswp[i].fl   = SWP_MOVE | SWP_FOCUSDEACTIVATE;
            pswp[i].x    = 0;
            pswp[i].y    = 0;
            WinSetWindowUShort (phwnd[i], QWS_XMINIMIZE, (USHORT)-1 );
            WinSetWindowUShort (phwnd[i], QWS_YMINIMIZE, (USHORT)-1 );
        }
        free ( phwnd );
        WinSetMultWindowPos ( HABOF(hwnd), pswp, iCount );
        free ( pswp );
        return (INT) WinQuerySysValue ( HWND_DESKTOP, SV_CYICON );
    }
    return 0;
}

// stretch the restore values for minimize/maximize state windows.
VOID WinStretchRestorePos ( HWND hwnd, LONG xr, LONG yr )
{
    LONG    x,y,cx,cy;
    x  = WinQueryWindowUShort ( hwnd, QWS_XRESTORE  );
    y  = WinQueryWindowUShort ( hwnd, QWS_YRESTORE  );
    cx = WinQueryWindowUShort ( hwnd, QWS_CXRESTORE );
    cy = WinQueryWindowUShort ( hwnd, QWS_CYRESTORE );
    WinSetWindowUShort ( hwnd, QWS_XRESTORE,  ( x*xr)>>8 );
    WinSetWindowUShort ( hwnd, QWS_YRESTORE,  ( y*yr)>>8 );
    WinSetWindowUShort ( hwnd, QWS_CXRESTORE, (cx*xr)>>8 );
    WinSetWindowUShort ( hwnd, QWS_CYRESTORE, (cy*yr)>>8 );
}


// will stretch the maximized window ( if there is one ) to fill the
// client space  and then stretch the restore state windows so that
// they occupy the same realative size and postion
VOID WinStretchMDIDocuments ( HWND hwnd, LONG lStart, LONG lFinish )
{
    SHORT   x,y;
    // calculate stretch ratio and fixup the maximized window
    {
        HWND    hwndMax = LONGFROMMR ( WinSendMsg ( hwnd, UM_QUERYMAXHWND, 0, 0 ) );

        LONG  x1 = (LONG)SHORT1FROMMP(lStart);
        LONG  y1 = (LONG)SHORT2FROMMP(lStart);
        LONG  x2 = (LONG)SHORT1FROMMP(lFinish);
        LONG  y2 = (LONG)SHORT2FROMMP(lFinish);

        if ( !x1 || !x2 || !y1 || !y2 ) return;
        x = (x2 << 8) / x1;
        y = (y2 << 8) / y1;

        if ( hwndMax )
        {
            WinStretchRestorePos ( hwndMax, x, y );
            WinSetWindowPos ( hwndMax, 0,0,0, x2,y2, SWP_MOVE | SWP_SIZE );
        }
    }

    // stretch all restore windows if they have the style set.
    {
        SWP     swp;
        HWND    *phwnd;
        INT     i, iCount = CountMDIDocuments ( hwnd, SWP_RESTORE, &phwnd );

        for ( i = 0 ; i < iCount ; i ++ )
        {
            ULONG ulStyle = WinQueryWindowULong( phwnd[i], QWL_STYLE );
            if( ulStyle & WS_MDIAUTORESIZE )
            {
               WinQueryWindowPos ( phwnd[i], &swp );
               WinSetWindowPos ( phwnd[i], 0, (swp.x * x)>>8, (swp.y * y)>>8,
                                (swp.cx * x)>>8, (swp.cy * y)>>8, SWP_MOVE | SWP_SIZE );
            }
        }
        free ( phwnd );
    }

    // need to add a threaded stretch restore pos for minimized winodws

}


// --------------------------------------------------------------------------
// stuff that has to do with maximizing and un-maximizing Document windows
// --------------------------------------------------------------------------

/* Makes a bitmap half the size of the standard icon.  The bit map is   */
/* generated from the WM_QUERYICON message so that it looks like the    */
/* minimized icon for the frame window.  After creating 3 hdc and hps's */
/* we will bit blit the masks for - 1. Combined transparent / inverse,  */
/* 2. Inverse only, 3. The actual bitmap (Icon).  Finally we return the */
/* handle to the bitmap we created.                                     */

HBITMAP GetSmallBitmapFromFrameIcon ( HWND hwndFrame )
{
    HBITMAP     hbmColor, hbm, hbmMask;

    // ask the frame window for it's icon
    {
        HPOINTER    hpt;
        POINTERINFO pi;
        hpt = LONGFROMMR(WinSendMsg ( hwndFrame, WM_QUERYICON, 0, 0 ));
        WinQueryPointerInfo ( hpt, &pi );
        hbmMask = pi.hbmPointer;
        hbmColor  = pi.hbmColor;
    }

    // make a memory hdc/hps for generating a smaller version of the
    // file icon/bitmap.
    {
        HAB     hab;
        HDC     hdc, hdcMask, hdcColor;
        HPS     hps, hpsMask, hpsColor;
        RECTL   rcl, rclM;
        INT     iSize, iData, iIndex = 7;
        LONG    lrgbMenu, lMixMode;
        PBYTE   pbBitmap;
        RGB2    *prgb;
        POINTL  aptlTrgSrc[8];

        static const SIZEL          szl = { 0, 0 };
        static const DEVOPENSTRUC   dop = { NULL, "DISPLAY", NULL, NULL,
                                            NULL, NULL, NULL, NULL, NULL };
        BITMAPINFOHEADER    bmih, bmihMask;
        BITMAPINFO2         *pbmi, *pbmiBig;

        hab = HABOF ( hwndFrame );

        GpiQueryBitmapParameters ( hbmColor, &bmih );
        rcl.xLeft  = rcl.yBottom = 0;
        rcl.xRight = bmih.cx; // /= 2;                  // half the bit map size
        rcl.yTop   = bmih.cy; // /= 2;                  // half the bit map size

        bmih.cx /= 2;                   // half the bit map size
        bmih.cy /= 2;                   // half the bit map size
        hdc = DevOpenDC   ( hab, OD_MEMORY, "*", 5L, (PDEVOPENDATA)&dop, 0 );
        hps = GpiCreatePS ( hab, hdc, (SIZEL*) &szl, GPIA_ASSOC | PU_PELS | GPIT_MICRO );
        hbm = GpiCreateBitmap ( hps, (BITMAPINFOHEADER2*)&bmih, 0, 0, 0 );
        GpiSetBitmap  ( hps, hbm );
        WinFillRect ( hps, &rcl, SYSCLR_MENU );

        hdcMask = DevOpenDC   ( hab, OD_MEMORY, "*", 5L, (PDEVOPENDATA)&dop, 0 );
        hpsMask = GpiCreatePS ( hab, hdcMask, (SIZEL*) &szl, GPIA_ASSOC | PU_PELS | GPIT_MICRO );
        GpiSetBitmap  ( hpsMask, hbmMask );
        
        hdcColor = DevOpenDC   ( hab, OD_MEMORY, "*", 5L, (PDEVOPENDATA)&dop, 0 );
        hpsColor = GpiCreatePS ( hab, hdcColor, (SIZEL*) &szl, GPIA_ASSOC | PU_PELS | GPIT_MICRO );
        GpiSetBitmap  ( hpsColor, hbmColor );
        
        GpiQueryBitmapParameters ( hbmMask, &bmihMask );
        rclM.xLeft  = rclM.yBottom = 0;
        rclM.xRight = bmihMask.cx; // /= 2;         // half the bit map size
        rclM.yTop   = bmihMask.cy; // /= 2;         // half the bit map size

        /* First we will bit blit the Full mask ( transparent or inverse )     */
        /* The mask is two images stacked one above the other. On the top half */
        /* we have the Full mask, on the bottom we have the Inverted mask.     */

        aptlTrgSrc[0].x = rcl.xLeft;
        aptlTrgSrc[0].y = rcl.yBottom;
        
        aptlTrgSrc[1].x = rcl.xRight / 2;
        aptlTrgSrc[1].y = rcl.yTop / 2;

        aptlTrgSrc[2].x = rclM.xLeft;
        aptlTrgSrc[2].y = rclM.yTop / 2;  // This is equal to the bottom of the Top mask!
        
        aptlTrgSrc[3].x = rclM.xRight;
        aptlTrgSrc[3].y = rclM.yTop;

        lMixMode = ROP_NOTSRCERASE ;     /* NOT(SRC) AND NOT(DST)   */                                     
        GpiBitBlt( hps, hpsMask, 4, aptlTrgSrc, lMixMode, BBO_IGNORE );
        GpiBitBlt( hps, hpsMask, 4, aptlTrgSrc, lMixMode, BBO_IGNORE );

        /* Next we will blit in the inverse mask! */

        aptlTrgSrc[2].x = rclM.xLeft;
        aptlTrgSrc[2].y = rclM.yBottom;

        aptlTrgSrc[3].x = rclM.xRight;
        aptlTrgSrc[3].y = rclM.yTop /2; // This one is on the bottom half!
        lMixMode = ROP_SRCINVERT   ;     /* SRC XOR DST             */ 
        GpiBitBlt( hps, hpsMask, 4, aptlTrgSrc, lMixMode, BBO_IGNORE );
        lMixMode = ROP_DSTINVERT   ;     /* NOT(DST)                */ 
        GpiBitBlt( hps, hpsMask, 4, aptlTrgSrc, lMixMode, BBO_IGNORE );

        /* Next we will blit in the Color Bitmap over the background color */

        aptlTrgSrc[2].x = rcl.xLeft;
        aptlTrgSrc[2].y = rcl.yBottom;

        aptlTrgSrc[3].x = rcl.xRight;
        aptlTrgSrc[3].y = rcl.yTop;
        
        lMixMode = ROP_SRCPAINT    ;     /* SRC OR DST              */ 
        GpiBitBlt( hps, hpsColor, 4, aptlTrgSrc, lMixMode, BBO_IGNORE );


        
        GpiSetBitmap    ( hpsMask, 0 );
        GpiDestroyPS    ( hpsMask );
        DevCloseDC      ( hdcMask );

        GpiSetBitmap    ( hpsColor, 0 );
        GpiDestroyPS    ( hpsColor );
        DevCloseDC      ( hdcColor );
        
        GpiSetBitmap  ( hps, 0 );
        GpiDestroyPS  ( hps );
        DevCloseDC    ( hdc );
    }
    return hbm;
}

//  copies the system menu of the about to be maximized document window.
//  also makes a "restore button" menuitem for the far right for the
//  application menu.

VOID BuildMaximizedDocumentMenus ( HWND hwndServer, HWND hwndDocument )
{
    HWND    hwndServerFrame = WinQueryWindow  ( hwndServer,      QW_PARENT   );
    HWND    hwndServerMenu  = WinWindowFromID ( hwndServerFrame, FID_MENU    );
    HWND    hwndMinMaxMenu  = WinWindowFromID ( hwndDocument,    FID_MINMAX  );
    HWND    hwndSysMenu     = WinWindowFromID ( hwndDocument,    FID_SYSMENU );
    HWND    hwndMax         = LONGFROMMR ( WinSendMsg ( hwndServer, UM_QUERYMAXHWND, 0, 0 ));
    INT     iMenuCount, iMenuIndex, iMenuId;
    MENUITEM    mi, mis, miQ;
    RECTL   rctMenu, rctItem;
    HBITMAP hbmRestore;
    HWND    hwndSubMenu, hwndMenuItem;
    CHAR    szText[64];
    RECTL  rectlMenu;             //kk
    ULONG  cyRestore, cxRestore; //kk
    HWND   hwndRestore;         //kk
    PFNWP fnwpActionBar;       //kk
    HPS     hpsTmp = WinGetPS(hwndServerMenu);

    WinEnableWindowUpdate ( hwndServerMenu, FALSE );
    iMenuId = MenuIdFromPos ( hwndSysMenu, 0 );
    WinSendMsg ( hwndSysMenu, MM_QUERYITEM, MPFROM2SHORT( iMenuId, FALSE ), &mi );
    mi.iPosition = 0;
    mi.hItem = GetSmallBitmapFromFrameIcon ( hwndMax );
    mi.afStyle = MIS_BITMAP;

    hwndSubMenu = WinCreateWindow ( hwndServerMenu, WC_MENU, NULL, 0,
                0,0,0,0, hwndServerFrame, HWND_TOP, iMenuId, NULL, NULL );
    iMenuCount = MenuQueryCount ( mi.hwndSubMenu );
    for ( iMenuIndex = 0 ; iMenuIndex < iMenuCount ; iMenuIndex++ )
    {
        iMenuId = MenuIdFromPos ( mi.hwndSubMenu, iMenuIndex );
        WinSendMsg ( mi.hwndSubMenu, MM_QUERYITEM, MPFROM2SHORT( iMenuId, FALSE ), &mis );
        if ( mis.id == SC_MAXIMIZE
          || mis.id == SC_HIDE
          || mis.id == SC_MOVE
          || mis.id == SC_SIZE )
            mis.afAttribute |=  MIA_DISABLED;
        else
        if ( mis.id == SC_RESTORE
          || mis.id == SC_MINIMIZE )
            mis.afAttribute &= ~MIA_DISABLED;
        mis.afStyle &= ~MIS_SYSCOMMAND;
        MenuQueryItemText ( mi.hwndSubMenu, iMenuId, sizeof szText, szText );
        MenuInsertItem ( hwndSubMenu, &mis, szText );
    }
    mi.hwndSubMenu = hwndSubMenu;
    WinSendMsg (hwndServerMenu,MM_INSERTITEM,(PMENUITEM)&mi,NULL);

//kk hbmRestore = WinGetSysBitmap ( HWND_DESKTOP, SBMP_RESTOREBUTTON );
//kk mi.iPosition   = MIT_END;    
//kk mi.afStyle     = MIS_BITMAP | MIS_BUTTONSEPARATOR;
//kk mi.id          = SC_RESTORE;
//kk mi.hwndSubMenu = NULLHANDLE;
//kk mi.hItem       = hbmRestore;
//kk mi.afAttribute = 0;
//kk WinSendMsg (hwndServerMenu,MM_INSERTITEM,(PMENUITEM)&mi,NULL);

          // kk start
      mi.iPosition           = MIT_END;
      mi.afStyle             = MIS_STATIC;
      mi.id                  = PHANTOM_BUTTON;
      mi.hwndSubMenu      = NULLHANDLE;
      mi.hItem              = NULLHANDLE; 
      mi.afAttribute         = 0;

      WinSendMsg(hwndServerMenu, MM_INSERTITEM,  &mi, " ");

                // calculate position
   
      WinQueryWindowRect(hwndServerMenu, &rectlMenu);
 
      cyRestore = WinQuerySysValue(HWND_DESKTOP, SV_CYMINMAXBUTTON);
 
      cxRestore = WinQuerySysValue(HWND_DESKTOP, SV_CYMINMAXBUTTON);

      WinQueryWindowRect (hwndServerMenu, &rectlMenu);

              //subclass the action bar
      fnwpActionBar = WinSubclassWindow(hwndServerMenu,  (PFNWP)  MenuSubProc);

               // create button
       hwndRestore = WinCreateWindow(hwndServerMenu,    //parent
                           WC_BUTTON,
                           NULL,
                           WS_VISIBLE | BS_USERBUTTON,
                           rectlMenu.xRight - cxRestore,       //   x
                           1,                                 //   y
                           cxRestore,                        //  cx  (+9 seems good)
                           cyRestore,                       //  cy
                           hwndServerMenu,                 // owner(appears on the foreground of owner)
                           HWND_TOP,
                           (ULONG)   RESTORE_BUTTON_ID,
                           NULL,
                           NULL);

    WinSendMsg (hwndServerMenu, UM_SETUPBUTTON, (PVOID)fnwpActionBar,
                   MPFROMSHORT(0) );
    // kk end

    WinEnableWindowUpdate ( hwndServerMenu, TRUE );
    WinSendMsg( hwndServerFrame, WM_UPDATEFRAME, (MPARAM)FCF_MENU, 0 );
}


// un-does the damaged done by buildmaxdocmenus
VOID DestroyMaximizedDocumentMenus ( HWND hwndServer )
{
    HWND     hwndServerFrame = WinQueryWindow  ( hwndServer,      QW_PARENT );
    HWND     hwndServerMenu  = WinWindowFromID ( hwndServerFrame, FID_MENU  );
    INT      iMenuCount, iMenuId;
    MENUITEM mi;
    HWND    hwndRestore;     //kk
    RestoreButtonWW   *pww; //kk


    if( WinSendMsg ( hwndServerMenu, MM_QUERYITEM, MPFROM2SHORT( SC_SYSMENU, FALSE ), &mi ) )
    {
       GpiDeleteBitmap ( mi.hItem );
       MenuDeleteItem ( hwndServerMenu, SC_SYSMENU, FALSE );
    }

        // kk start
     // restore original  subclassing of action bar

     hwndRestore = WinWindowFromID(hwndServerMenu, RESTORE_BUTTON_ID);

     // This if-test is needed in case DestroyMaximizedDocumentMenus() is called
     // a second time without an intervening call to BuildMaximizedDocumentMenus().
     if (hwndRestore != NULLHANDLE) {

         pww = (RestoreButtonWW *) WinQueryWindowULong(hwndRestore, QWL_USER);
         WinSendMsg(hwndRestore, UM_REMOVEBUTTON, 0, 0);

         WinSubclassWindow(hwndServerMenu, pww->fnwpActionBar);

         // destroy the restore button.
         WinDestroyWindow(hwndRestore);

         // remove phatom menu item used to force proper spacing between restore button
         // and the last item

          (USHORT) WinSendMsg(hwndServerMenu,
                                  MM_DELETEITEM,
                                  MPFROM2SHORT(PHANTOM_BUTTON, TRUE),
                                  NULL);
     }
        // kk end

}

VOID ShowFrameControls ( HWND hwnd, BOOL bShow )
{
    HENUM       henum = WinBeginEnumWindows ( hwnd );
    HWND        hwndChild;
    USHORT      usId;

    WinEnableWindowUpdate( hwnd, FALSE );
    while ( (hwndChild=WinGetNextWindow(henum)) != 0 )
    {
        usId = WinQueryWindowUShort ( hwndChild, QWS_ID );
        if ( usId != FID_CLIENT &&  ( usId >= FID_FIRST && usId <= FID_LAST ) )
            WinShowWindow ( hwndChild, bShow );
    }
    WinEndEnumWindows ( henum );
    WinEnableWindowUpdate( hwnd, TRUE );
    if ( bShow )
        WinInvalidateRect ( hwnd, NULL, TRUE );
}

// --------------------------------------------------------------------------
// acctual window functionns
// --------------------------------------------------------------------------

// MDI Server proc for the client space
MRESULT EXPENTRY WinDefMDIServerProc ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
    switch ( msg )
    {

        case UM_REGISTERCLASS:
        {
            HAB     hab = (HAB) hwnd;
            if ( WinRegisterClass( hab, WC_MDISERVER, WinDefMDIServerProc, 0, 8) )
            {
                return (MRESULT) TRUE;
            }
            return (MRESULT) FALSE;
        }

// default window messages altered by WinDefMDIServerProc

        case WM_CREATE :
        {
            HWND    hwndFrame = WinQueryWindow ( hwnd, QW_PARENT );
            ACCELTABLE  *patQueue;
            ACCELTABLE  *patFrame;
            ACCELTABLE  *patMerged;

            patQueue = GetAccelTable ( HABOF(hwnd), 0 );
            patFrame = GetAccelTable ( HABOF(hwnd), hwndFrame );
            patMerged = MergeAccelTable ( patQueue, patFrame );

            ReplaceAccelTable ( HABOF(hwnd), hwndFrame, patMerged );
            ReplaceAccelTable ( HABOF(hwnd), 0, NULL );

            free ( patQueue );
            free ( patFrame );
            free ( patMerged );

            break;
        }

        case WM_PAINT :
        {
            HPS     hps;
            RECTL   rec;
            hps = WinBeginPaint ( hwnd, 0, &rec );
            WinFillRect ( hps, &rec, SYSCLR_WINDOW );
            WinEndPaint ( hps );
            return (MRESULT) FALSE;

        }

        case WM_COMMAND :
        {
            INT id = (INT) SHORT1FROMMP(mp1);
            if ( (id >= SC_FIRST) && (id <= SC_LAST) )
            {
                HWND hwndTop = WinQueryWindow ( hwnd, QW_TOP );
                WinSendMsg ( hwndTop, WM_SYSCOMMAND, mp1, mp2 );
            }
            break;
        }

        case WM_SIZE :
            WinStretchMDIDocuments ( hwnd, LONGFROMMR(mp1), LONGFROMMR(mp2) );
            return (MRESULT) FALSE;

        case WM_CALCVALIDRECTS :
            return MRFROMLONG ( CVR_ALIGNBOTTOM | CVR_ALIGNBOTTOM );
        
        /* This message is generated when the menu is created, if you have an OwnerDraw item! */
        case WM_MEASUREITEM :
        {
            OWNERITEM   *poi = (OWNERITEM*) mp2;
            switch ( poi->idItem )
            {
                case SC_RESTORE :
                {
                    SHORT   x = (SHORT) WinQuerySysValue ( HWND_DESKTOP, SV_CXMINMAXBUTTON );
                    SHORT   y = (SHORT) WinQuerySysValue ( HWND_DESKTOP, SV_CYMINMAXBUTTON );
                    return MRFROM2SHORT( x, y );
                }
            }
            break;
        }

        case WM_DRAWITEM :
        {
            OWNERITEM   *poi = (OWNERITEM*) mp2;
            switch ( poi->idItem )
            {
                case SC_RESTORE :
                {
                   HBITMAP hbmRestore;
                   
                   if( poi->fsAttribute )
                   {
                     /* We must be in a depressed state, so get the correct BMP */
                      hbmRestore = WinGetSysBitmap ( HWND_DESKTOP, SBMP_RESTOREBUTTONDEP );
                   }
                   else
                   {
                     /* We're not depressed, get the restore button BMP. */
                      hbmRestore = WinGetSysBitmap ( HWND_DESKTOP, SBMP_RESTOREBUTTON );
                   }
                    WinDrawBitmap ( poi->hps, hbmRestore, NULL,
                                   (POINTL*)&poi->rclItem, 0, 0, DBM_NORMAL );
                    GpiDeleteBitmap( hbmRestore );
                    
                    /* Lets reset the attributes so the menu won't invert the colors */
                    poi->fsAttribute = poi->fsAttributeOld = 0;
                    return (MRESULT) TRUE;
                }
            }
            break;
        }

// Support messages for WinDefMDIServerProc

        case UM_SETMAXHWND :
            WinSetWindowULong ( hwnd, 4, LONGFROMMP(mp1) );
            return (MRESULT) 0;

        case UM_QUERYMAXHWND :
            return MRFROMLONG( WinQueryWindowULong ( hwnd, 4 ) );

// MDI messages for WinDefMDIServerProc

        case WM_MDIMAXIMIZE :
            return (MRESULT) WinSetWindowPos ( (HWND) LONGFROMMP(mp1), 0,0,0,0,0, SWP_MAXIMIZE );

        case WM_MDIRESTORE :
            return (MRESULT) WinSetWindowPos ( (HWND) LONGFROMMP(mp1), 0,0,0,0,0, SWP_RESTORE );

        case WM_MDITILE :
            WinTileMDIDocuments ( hwnd, LONGFROMMP(mp1) );
            return (MRESULT) 0;
 
        case WM_MDICASCADE :
            WinCascadeMDIDocuments ( hwnd, LONGFROMMP(mp1)  );
            return (MRESULT) 0;

        case WM_MDIICONARRANGE :
            return (MRESULT) WinArrangeIconicMDIDocuments ( hwnd );

        case WM_MDIDESTROY :
            return (MRESULT) WinDestroyWindow ( (HWND) mp2 );

        case WM_MDIGETACTIVE :
            return (MRESULT) WinQueryWindow ( hwnd, QW_TOP );

        case WM_MDIACTIVATE :
            return (MRESULT) WinActivateMDIDocument ( hwnd, (HWND) mp2 );

        case WM_MDICREATE :
            return (MRESULT) WinCreateMDIDocument ( hwnd, (MDICREATESTRUCT*) mp2 );

        case WM_MDINEXT :
            if (mp1)
                WinActivateMDIDocument( hwnd, (HWND)mp1);
            return (MRESULT) WinActivateNextMDIDocument ( hwnd, (BOOL) LONGFROMMP(mp2) );

        case WM_MDISETMENU :
        if ( mp1 )
        {
           SWP     swp;
           HWND    hwndFrame = WinQueryWindow ( hwnd, QW_PARENT );
           HWND    hwndMenu  = WinWindowFromID ( hwndFrame, FID_MENU );
           ULONG   ulStyle;

           /* Find the Window handle to the top MDI child window ( active one ).*/

           WinQueryWindowPos( WinQueryWindow( hwnd, QW_TOP ), &swp );

           /* If the MDI window is maximized in the application window, we must */
           /* remove the system menu and the restore button.                    */

           if( swp.fl & SWP_MAXIMIZE )
              DestroyMaximizedDocumentMenus( hwnd );

           /* First we must get rid of (hide) the current menu if it exists. */
           if( hwndMenu )
              {
                 WinSetParent ( hwndMenu, HWND_OBJECT, FALSE );
                 WinSetOwner  ( hwndMenu, HWND_OBJECT );
              }

           /* Next we will make sure all the right styles and ID's are set */

           ulStyle = WinQueryWindowULong ( (HWND) mp1, QWL_STYLE );
           ulStyle |=  MS_ACTIONBAR | WS_CLIPSIBLINGS;
           ulStyle &= ~WS_SAVEBITS;
           WinSetWindowULong ( (HWND) mp1, QWL_STYLE, ulStyle );
           WinSetWindowUShort ( (HWND) mp1, QWS_ID, FID_MENU );

           /* Set the frame as owner and parent and tell it somethings up! */

           WinSetParent ( (HWND) mp1, hwndFrame, TRUE );
           WinSetOwner  ( (HWND) mp1, hwndFrame );
           WinSendMsg( hwndFrame, WM_UPDATEFRAME, (MPARAM)FCF_MENU, NULL );
           if( swp.fl & SWP_MAXIMIZE )
           {
              HWND    hwndDoc = WinQueryWindow ( hwnd, QW_TOP );
              BuildMaximizedDocumentMenus( hwnd, hwndDoc );
           }
           return ( (MRESULT)hwndMenu );
        }

        case WM_CONTEXTMENU :
        {
            HWND    hwndTop = WinQueryWindow ( hwnd, QW_TOP );
            WinSendMsg ( hwndTop, WM_CONTEXTMENU, mp1, mp2 );
            return (MRESULT) 0;
        }


    }
    return WinDefWindowProc ( hwnd, msg, mp1, mp2 );
}

// MDIDocument frame
MRESULT EXPENTRY fnwpMDIDocument ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
    static PFNWP    pfnwpOldFrameProc   = NULL;
    static INT      iWWOffset           = 0;

    // if the document window is maximized then the following frame window
    // message handling should not occur.
    if ( msg >= WM_MOUSEFIRST && msg <= WM_MOUSELAST || msg == WM_HITTEST )
    {
        SWP     swp;
        WinQueryWindowPos ( hwnd, &swp );
        if ( swp.fl & SWP_MAXIMIZE )
            return WinDefWindowProc  ( hwnd, msg, mp1, mp2 );
        else
            return pfnwpOldFrameProc ( hwnd, msg, mp1, mp2 );
    }

    switch ( msg )
    {
 
        case UM_REGISTERCLASS:
        {
            CLASSINFO   classinfo;
            HAB         hab = (HAB) hwnd;
            if ( WinQueryClassInfo ( hab, WC_FRAME, &classinfo ) &&
                 WinRegisterClass ( hab, mkpszMDIDocument, fnwpMDIDocument,
                            classinfo.flClassStyle & ~CS_PUBLIC,
                            classinfo.cbWindowData + 4 ) )
            {
                pfnwpOldFrameProc = classinfo.pfnWindowProc;
                iWWOffset         = classinfo.cbWindowData;
                return (MRESULT) TRUE;
            }
            return (MRESULT) FALSE;
        } // um_registerclass


        // Fixing a whole where the frame controls leak in.

        case WM_CREATE :
        {
            MRESULT mr = pfnwpOldFrameProc ( hwnd, msg, mp1, mp2 );
            ULONG   ulStyle = WinQueryWindowULong ( hwnd, QWL_STYLE );
            WinSetWindowULong ( hwnd, iWWOffset, ulStyle );
            // fix the accel table and system menu text
            {
                HWND    hwndSysMenu = WinWindowFromID ( hwnd, FID_SYSMENU );
                HWND    hwndMinMax = WinWindowFromID ( hwnd, FID_MINMAX );
                if ( hwndSysMenu )
                {
                    { // replace the accel table
                        HAB     hab = HABOF ( hwnd );
                        ACCELTABLE  *patPrev, *patNew;
                        patPrev = GetAccelTable ( hab, hwnd );
                        patNew  = MergeAccelTable ( patPrev, mkpatMDIDocument );
                        free ( patPrev );
                        ReplaceAccelTable ( hab, hwnd, patNew );
                        free ( patNew );
                    }
                    { // replace "Alt+" text in the system menu
                        SHORT       sMenuId;
                        MENUITEM    menuitem;
                        SHORT       sMenuCount, sIndex;
                        PSZ         pszMenu;
                        INT         iMenu;
 
                        sMenuId = MenuIdFromPos ( hwndSysMenu, 0 );
                        MenuQueryItem ( hwndSysMenu, sMenuId, FALSE, &menuitem );
                        sMenuCount = MenuQueryCount(menuitem.hwndSubMenu);
 
                        for ( sIndex = 0 ; sIndex < sMenuCount ; sIndex++ )
                        {
                            sMenuId = MenuIdFromPos ( menuitem.hwndSubMenu, sIndex );
                            iMenu = MenuQueryItemTextLength (
                                        menuitem.hwndSubMenu, sMenuId );
                            if ( iMenu )
                            {
                                PSZ     pszAlt;
                                iMenu+=2;
                                pszMenu = malloc ( iMenu );
                                MenuQueryItemText ( menuitem.hwndSubMenu,
                                            sMenuId, iMenu, pszMenu );
                                pszAlt = strstr ( pszMenu, "Alt+" );
                                if ( pszAlt )
                                {
                                    CHAR    *pchrEnd, *pchrStop;
                                    pchrStop = pszAlt+sizeof "Alt+" - 1;
                                    pchrEnd  = pchrStop + strlen ( pchrStop ) + 1;
                                    while ( pchrEnd > pchrStop )
                                    {
                                        pchrEnd--;
                                        pchrEnd[1] = pchrEnd[0];
                                    }
                                    strncpy ( pszAlt, "Ctrl+", sizeof "Ctrl+" -1 );
                                    MenuSetItemText ( menuitem.hwndSubMenu,
                                                sMenuId, pszMenu );
                                }
                            }
                        } // for
                    }
                } // if
            }
            return mr;
        } // wm_create
       

        // Any window that wants to be an MDI Document window
        // needs to answer true to this message.  All other windows
        // will not be included in MDI manipulations.

        case UM_ISCHILDMDI:
            return (MRESULT) TRUE;


        // By using the windowposchanged message the document windows
        // are self regulating in regard to maintaining which window
        // is the maximized window.  If a document window is maximized
        // and there is already a maximized window, then the currently
        // maximized window is restored first.

        case WM_WINDOWPOSCHANGED :
        {
            SWP *pswp1 = (SWP*) mp1;

        // if being maximized
            if ( pswp1->fl & SWP_MAXIMIZE )
            {
                HWND    hwndServer = WinQueryWindow ( hwnd, QW_PARENT );
                HWND    hwndMax    = LONGFROMMR ( WinSendMsg ( hwndServer,
                                UM_QUERYMAXHWND, 0, 0 ) );
                HWND    hwndServerMenu = 0;
                if ( hwndMax )
                    WinSetWindowPos ( hwndMax, 0,0,0,0,0, SWP_RESTORE );
                    
                WinSendMsg ( hwndServer, UM_SETMAXHWND, MPFROMLONG(hwnd), 0 );
                ShowFrameControls ( hwnd, FALSE );
                BuildMaximizedDocumentMenus ( hwndServer, hwnd );
            }

        // if being restored or minimized
            else if ( pswp1->fl & (SWP_MINIMIZE|SWP_RESTORE) )
            {
                HWND    hwndServer = WinQueryWindow ( hwnd, QW_PARENT );
                HWND    hwndMax    = LONGFROMMR ( WinSendMsg ( hwndServer,
                            UM_QUERYMAXHWND, 0, 0 ) );
                if ( hwndMax == hwnd ) // the maximized window is this window
                {
                    MRESULT mr = pfnwpOldFrameProc ( hwnd, msg, mp1, mp2 );
                    WinSendMsg ( hwndServer, UM_SETMAXHWND, 0, 0 );
                    DestroyMaximizedDocumentMenus ( hwndServer );
                    ShowFrameControls ( hwnd, TRUE );
                    return mr;
                }
            }
          break;
        } // wm_windowposchanged


        // if the document window is maximized then the client space is
        // enlarged to fill the entire frame window.  If the frame controls
        // do not have the clipsibling style then they will show through
        // the client space in certain conditions.

        case WM_ADJUSTFRAMEPOS:
        {
           SWP     *pswp = (SWP*) mp1;
           if ( pswp->fl & SWP_MAXIMIZE )
           {
                pswp->cx = (SHORT)pswp->cx + ((SHORT)pswp->x)*2;
                pswp->cy = (SHORT)pswp->cy + ((SHORT)pswp->y)*2;
                pswp->x = 0;
                pswp->y = 0;
           }
           break;
        }

        case WM_FORMATFRAME :
        {
            SWP     swp;
            ULONG   ulCount = 0; // The count of how many swp structs are being returned
            ULONG   ulHorzScrollCY = 0, ulVertScrollCX = 0,
                    ulBorderWidth  = 0, ulBorderHeight = 0;

            WinQueryWindowPos ( hwnd, &swp );
            if ( swp.fl & SWP_MAXIMIZE )
            {
                HWND    hwndClient   = WinWindowFromID ( hwnd, FID_CLIENT );
                HWND    hwndHorz     = WinWindowFromID ( hwnd, FID_HORZSCROLL );
                HWND    hwndVert     = WinWindowFromID ( hwnd, FID_VERTSCROLL );
                HWND    hwndAppFrame = WinQueryWindow( WinQueryWindow ( hwnd,
                                                       QW_PARENT ), QW_PARENT );
                SWP     *pswp = (SWP*) mp1;

                /* We have to allow for scroll bars.  If they are present, */
                /* we will have to adjust the positioning of the client as */
                /* well as positioning one or both scroll bars.            */
                
                if( hwndHorz )
                {
                   ulCount++;
                   ulHorzScrollCY = WinQuerySysValue( HWND_DESKTOP, SV_CYHSCROLL);
                }
                if( hwndVert )
                {
                   ulCount++;
                   ulVertScrollCX = WinQuerySysValue( HWND_DESKTOP, SV_CXVSCROLL);
                }

                /* First we will fill in information for the client window.  */
                /* We do allow for offsetting in case there are scroll bars. */

                pswp[0].x = 0;
                pswp[0].y = ulHorzScrollCY;
                pswp[0].cx = swp.cx - ulVertScrollCX;
                pswp[0].cy = swp.cy - ulHorzScrollCY;
                pswp[0].hwndInsertBehind = HWND_TOP;
                pswp[0].fl =  SWP_MOVE | SWP_SIZE | SWP_SHOW;
                pswp[0].hwnd = hwndClient;

                /* If we have a horizontal scroll bar, fill in the information */

                if( hwndHorz )
                {
                   pswp[1].x = 0;
                   pswp[1].y = 0;
                   pswp[1].cx = swp.cx - ulVertScrollCX;
                   pswp[1].cy = ulHorzScrollCY;
                   pswp[1].hwndInsertBehind = HWND_TOP;
                   pswp[1].fl =  SWP_MOVE | SWP_SIZE | SWP_SHOW;
                   pswp[1].hwnd = hwndHorz;
                }

                /* Finally, if we have a vertical scroll bar, fill in the info */

                if( hwndVert )
                {
                   pswp[ulCount].x = swp.cx - ulVertScrollCX;
                   pswp[ulCount].y = ulHorzScrollCY;
                   pswp[ulCount].cx = ulVertScrollCX;
                   pswp[ulCount].cy = swp.cy - ulHorzScrollCY;
                   pswp[ulCount].hwndInsertBehind = HWND_TOP;
                   pswp[ulCount].fl =  SWP_MOVE | SWP_SIZE | SWP_SHOW;
                   pswp[ulCount].hwnd = hwndVert;
                }
                return (MRESULT)( ulCount + 1 );
            }
            break;
        } // wm_formatframe

    }
    return pfnwpOldFrameProc ( hwnd, msg, mp1, mp2 );
}

MRESULT EXPENTRY WinDefMDIDocumentProc ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
    switch ( msg )
    {
        case WM_CLOSE :  // destroy the document not quit the application !
        {
            HWND    hwndFrame  = WinQueryWindow ( hwnd, QW_PARENT );
            HWND    hwndServer = WinQueryWindow ( hwndFrame, QW_PARENT );
            HWND    hwndMax    = (HWND) LONGFROMMR(
                            WinSendMsg(hwndServer,UM_QUERYMAXHWND,0,0));
            if ( hwndMax == hwndFrame )
            {
                DestroyMaximizedDocumentMenus ( hwndServer );
                WinSendMsg ( hwndServer, UM_SETMAXHWND, 0, 0 );
            }
            WinDestroyWindow ( hwndFrame );
            return (MRESULT) FALSE;
        }
    }
    return WinDefWindowProc ( hwnd, msg, mp1, mp2 );
}
      //kk start
MRESULT EXPENTRY MenuSubProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{

//  Note: There is no danger with these static variables with code intended to be reentrant.
//  These variables never change value after initialization.

static  HBITMAP   hbmRestore;
static  HBITMAP   hbmRestoreDep;
static  LONG       cxRestore;
static PFNWP      fnwpActionBar;

      switch(msg)
      {

        case UM_SETUPBUTTON:
        {
           HPS hps;
           USERBUTTON       UserButton;
           HWND               hwndMenu;
           RestoreButtonWW *pww;
           MENUITEM          mi;
           HWND               hwndRestore;
 

           fnwpActionBar =  (PFNWP) mp1;
 
           hbmRestoreDep  =  WinGetSysBitmap ( HWND_DESKTOP, SBMP_RESTOREBUTTONDEP);
           hbmRestore      =  WinGetSysBitmap ( HWND_DESKTOP, SBMP_RESTOREBUTTON);
           cxRestore        =  WinQuerySysValue(HWND_DESKTOP, SV_CYMINMAXBUTTON);
           hwndRestore     =  WinWindowFromID(hwnd, RESTORE_BUTTON_ID);

           hps = WinGetPS(hwndRestore);

           UserButton.hwnd      = hwndRestore;
           UserButton.hps        = hps;
           UserButton.fsState    = BDS_DEFAULT;
           UserButton.fsStateOld = BDS_DEFAULT;


           // setup static(s)
           cxRestore = WinQuerySysValue(HWND_DESKTOP, SV_CYMINMAXBUTTON);
 
           // allocate window words memory 

           pww = (RestoreButtonWW *) malloc(sizeof(RestoreButtonWW));

           pww->delta_cy = 0;
           pww->fnwpActionBar = fnwpActionBar;

           // save pointer to window words 

           WinSetWindowULong ( hwndRestore, QWL_USER, (ULONG) pww);

           // cause initial drawing of button
           WinSendMsg (hwnd, WM_CONTROL, MPFROM2SHORT(RESTORE_BUTTON_ID, BN_PAINT),
                                 (PVOID) &UserButton);
 
           WinReleasePS(hps);
           return  0;
        }

        case UM_REMOVEBUTTON:
        {
          ULONG style;

           // remove clip children style
           style = WinQueryWindowULong(hwnd, QWL_STYLE);

           style &= ~WS_CLIPCHILDREN;

           WinSetWindowULong(hwnd, QWL_STYLE, style);

           // delete the bitmaps
           GpiDeleteBitmap ( hbmRestoreDep );
           GpiDeleteBitmap ( hbmRestore );

          return 0;
        }

        case WM_CONTROL:        // handle drawing of restore button
        {
            USERBUTTON *pUB; 
    
            if ( SHORT1FROMMP(mp1) == RESTORE_BUTTON_ID && SHORT2FROMMP(mp1) == BN_PAINT)
            {
              HBITMAP hbitMap;
              POINTL pt = { 0, 0 };

              if (SHORT2FROMMP(mp1) != BN_PAINT)
                 return;

              pUB = (USERBUTTON *) mp2;
    
              switch(pUB->fsState) {
    
                case  BDS_DISABLED:

                         hbitMap = hbmRestore;
                         break;
    
                case  BDS_HILITED:

                         hbitMap = hbmRestoreDep;
                         break;
    
                  // use default for undocumented msg's

                case BDS_DEFAULT: default:

                         hbitMap =  hbmRestore;
                         break;

              }  // endswitch


             WinDrawBitmap(pUB->hps,
                          hbitMap,
                          NULL,
                          &pt,
                          DBM_IMAGEATTRS,
                          DBM_IMAGEATTRS,
                          DBM_NORMAL);

              return  0;      

           } // endif
        }    // endcase WM_CONTROL
        break;

       case WM_ADJUSTWINDOWPOS:
       {
        SWP  *pswp;
        LONG  cy1, cy2, org_cy ;
        MRESULT mr;
        HWND hwndRestore;
        RestoreButtonWW *pww;
 
 
        // Check vertical spacing of menu:
        // First, call original menu proc with a huge cy and then with the cy given us by PM.
        // The delta tells us whether menu will be clipped.

        pswp = (SWP *)  mp1;
        org_cy = pswp->cy ;

        pswp->cy = 0x7FFF;    // now pass a huge value as cy, see what the default proc returns.
 
        fnwpActionBar(hwnd, msg,  mp1, mp2);

        cy1 = ((SWP *) mp1)->cy;

        pswp->cy = org_cy;                 // now call with orignial cy passed by PM

        mr = fnwpActionBar(hwnd, msg,  mp1, mp2);

        cy2 = ((SWP *) mp1)->cy;

        pww = (RestoreButtonWW *) WinQueryWindowULong(
                                        WinWindowFromID(hwnd, RESTORE_BUTTON_ID), QWL_USER);

        pww->delta_cy = cy2 - cy1;

        return mr;

       }
       break;
                                                                                                                                                                                                                                                              
                                                                                                                                                                                                                                                     
       case WM_WINDOWPOSCHANGED:
       {
        SWP     *pSWP;
        RestoreButtonWW *pww;
        HWND     hwndRestore;

            pSWP = (SWP *) mp1;

            if (pSWP->fl & SWP_SIZE || pSWP->fl & SWP_MAXIMIZE)   {

                 hwndRestore = WinWindowFromID(hwnd, RESTORE_BUTTON_ID);

                 pww = (RestoreButtonWW *) WinQueryWindowULong(hwndRestore, QWL_USER);

                 // Use delta_cy from WM__ADJUSTWINDOWPOS to position button.
                 // delta_cy will be negative when the window is so small and narrow that
                 // only the menu appears, and the last line of the menu is only partially visible.
                 // In most other cases delta_cy will be zero.

                 WinSetWindowPos(hwndRestore,
                                   HWND_TOP,
                                   pSWP->cx - cxRestore,
                                   1 + pww->delta_cy,
                                   0,
                                   0,
                                   SWP_MOVE );
            }

       }
       break;
      case MM_INSERTITEM:
      {
         // keep the PHANTOM_TEXT last

         PMENUITEM  pmi;
         LONG         count;
         MENUITEM    mi;
         SHORT        ItemsLeft;
         BOOL          bRC;
         MRESULT      mRC;

         pmi =  (PMENUITEM)  mp1;

         // query number of menu items

         count = (LONG) fnwpActionBar (hwnd, MM_QUERYITEMCOUNT,
                                          MPFROMSHORT(0),  MPFROMSHORT(0) );

         if (pmi->iPosition == MIT_END ||  pmi->iPosition == count)  {

          // don't cover over our phantom static text, used for proper horizontal spacing
            pmi->iPosition = count - 1;
   
          break;

        }

    }
    break;


     } // end main switch

     return fnwpActionBar(hwnd, msg, mp1,  mp2);
}
  // end kk
