#define INCL_WIN
#include <os2.h>
#include "mdi.h"

#include <malloc.h>
#include <memory.h>

const static USHORT mkausMDIDocument[] =
{
    21, 850,
    AF_CONTROL | AF_HELP,                       VK_F1,       0,
    AF_CONTROL | AF_VIRTUALKEY | AF_SYSCOMMAND, VK_F4,       SC_CLOSE,
    AF_CONTROL | AF_VIRTUALKEY | AF_SYSCOMMAND, VK_ENTER,    SC_RESTORE,
    AF_CONTROL | AF_VIRTUALKEY | AF_SYSCOMMAND, VK_NEWLINE,  SC_RESTORE,
    AF_CONTROL | AF_VIRTUALKEY | AF_SYSCOMMAND, VK_F5,       SC_RESTORE,
    AF_CONTROL | AF_VIRTUALKEY | AF_SYSCOMMAND, VK_F6,       SC_NEXTFRAME,
    AF_CONTROL | AF_VIRTUALKEY | AF_SYSCOMMAND, VK_F7,       SC_MOVE,
    AF_CONTROL | AF_VIRTUALKEY | AF_SYSCOMMAND, VK_F8,       SC_SIZE,
    AF_CONTROL | AF_VIRTUALKEY | AF_SYSCOMMAND, VK_F9,       SC_MINIMIZE,
    AF_CONTROL | AF_VIRTUALKEY | AF_SYSCOMMAND, VK_F10,      SC_MAXIMIZE,
    AF_CONTROL | AF_VIRTUALKEY | AF_SYSCOMMAND, VK_F11,      SC_HIDE,
    AF_CONTROL | AF_VIRTUALKEY | AF_SYSCOMMAND, VK_SPACE,    SC_SYSMENU,
    AF_CONTROL | AF_VIRTUALKEY | AF_SYSCOMMAND, VK_SPACE,    SC_SYSMENU,
    AF_SHIFT   | AF_VIRTUALKEY | AF_SYSCOMMAND, VK_SCRLLOCK, SC_BEGINDRAG,
    AF_SHIFT   | AF_VIRTUALKEY | AF_SYSCOMMAND, VK_F24,      SC_ENDDRAG,
    AF_SHIFT   | AF_VIRTUALKEY | AF_SYSCOMMAND, VK_PRINTSCRN,SC_SELECT,
    AF_SHIFT   | AF_VIRTUALKEY | AF_SYSCOMMAND, VK_ENTER,    SC_OPEN,
    AF_SHIFT   | AF_VIRTUALKEY | AF_SYSCOMMAND, VK_F10,      SC_CONTEXTMENU,
    AF_SHIFT   | AF_VIRTUALKEY | AF_SYSCOMMAND, VK_F1,       SC_CONTEXTHELP,
    AF_SHIFT   | AF_VIRTUALKEY | AF_SYSCOMMAND, VK_F9,       SC_TEXTEDIT,
    AF_CONTROL | AF_VIRTUALKEY | AF_SYSCOMMAND, VK_SPACE,    SC_SYSMENU
};

const ACCELTABLE * const mkpatMDIDocument = (const ACCELTABLE* const) mkausMDIDocument;

ACCELTABLE *GetAccelTable ( HAB hab, HWND hwnd )
{
    ULONG       ulCopy;
    ACCELTABLE  *pat;
    HACCEL      haccel;

    haccel = WinQueryAccelTable ( hab, hwnd );
    ulCopy = WinCopyAccelTable ( haccel, NULL, 0 );
    pat = (ACCELTABLE*) malloc ( ulCopy );
    WinCopyAccelTable ( haccel, pat, ulCopy );
    return pat;
}

ACCELTABLE *MergeAccelTable ( const ACCELTABLE *patOne,
                              const ACCELTABLE *patTwo )
{
    ACCELTABLE  *patMerge;
    INT         iOne, iMaxOne;
    INT         iTwo, iMaxTwo, iMerge;
    ACCEL       *paOne, *paTwo, *paMerge;

//  if ( patOne->codepage != patTwo->codepage )
//      return NULL;

    iMaxOne = patOne->cAccel;
    iMaxTwo = patTwo->cAccel;

    patMerge = malloc(sizeof *patMerge+ sizeof *paMerge*(iMaxOne+iMaxTwo-1));

    paOne   = patOne->aaccel;
    paTwo   = patTwo->aaccel;
    paMerge = patMerge->aaccel;

    patMerge->codepage = patOne->codepage;
    patMerge->cAccel = iMaxOne + iMaxTwo;
    memcpy ( paMerge, paOne, sizeof *paOne * iMaxOne );

    iMerge = iMaxOne;
    for ( iTwo=0 ; iTwo<iMaxTwo ; iTwo++ )
    {
        SHORT   fs  = paTwo[iTwo].fs;
        SHORT   key = paTwo[iTwo].key;
        for ( iOne=0 ; iOne<iMaxOne ; iOne++ )
        {
            if ( paOne[iOne].fs == fs && paOne[iOne].key == key )
                break;
        }
        if ( iOne == iMaxOne )
        {
            paMerge[iMerge] = paTwo[iTwo];
            iMerge++;
        }
    }
    if ( patMerge->cAccel > iMerge )
    patMerge = realloc(patMerge,(sizeof *patMerge)+(sizeof *paMerge)*(iMerge-1));
    return patMerge;
}

VOID ReplaceAccelTable ( HAB hab, HWND hwnd, ACCELTABLE *pat )
{
    HACCEL  haccel;
    haccel = WinQueryAccelTable ( hab, hwnd );
    WinDestroyAccelTable ( haccel );
    if ( pat )
        haccel = WinCreateAccelTable ( hab, pat );
    else
        haccel = 0;
    WinSetAccelTable ( hab, haccel, hwnd );
}
