#include <windows.h>
#include "list.h"

HFONT    hFont;

int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance,
                    LPSTR lpszCmdLine, int nCmdShow)
{
    WNDCLASS    wndClass;
    HWND        hWnd;
    MSG         msg;

    if (!hPrevInstance)
    {
        wndClass.style          = CS_HREDRAW | CS_VREDRAW;
        wndClass.lpfnWndProc    = MainWndProc;
        wndClass.cbClsExtra     = 0;
        wndClass.cbWndExtra     = DLGWINDOWEXTRA;
        wndClass.hInstance      = hInstance;
        wndClass.hIcon          = LoadIcon(hInstance, "AppIcon");
        wndClass.hCursor        = LoadCursor(NULL, IDC_ARROW);
        wndClass.hbrBackground  = COLOR_WINDOW + 1;
        wndClass.lpszMenuName   = NULL;
        wndClass.lpszClassName  = "AppClass";

        if (!RegisterClass (&wndClass))
            return FALSE;
    }


    hWnd = CreateDialog (hInstance, "AppClass", 0, NULL);

    ShowWindow (hWnd, nCmdShow);
    UpdateWindow (hWnd);

    while (GetMessage (&msg, NULL, 0,0 ))
    {
        if (!IsDialogMessage (hWnd, &msg))
        {
            TranslateMessage (&msg);
            DispatchMessage (&msg);
        }
    }

    return (msg.wParam);
}

long FAR PASCAL MainWndProc (HWND hWnd, unsigned iMessage,
                             WPARAM wParam, LPARAM lParam)
{
    HWND            hList;
    WORD            iSel;
    PAINTSTRUCT     ps;
    HDC             hDC;
    RECT            Rect;

    switch (iMessage)
    {
        case WM_CREATE:
            hFont = CreateFont (24,0,0,0,0,TRUE,0,0,0,0,0,0,
                          VARIABLE_PITCH | FF_ROMAN,(LPSTR)"Roman");
            SendDlgItemMessage (hWnd, ID_LISTBOX, WM_SETFONT, hFont, 1L);
            break;

        case WM_PAINT:
            hDC = BeginPaint (hWnd,(LPPAINTSTRUCT)&ps);
            GetClientRect (hWnd,(LPRECT)&Rect);
            FillRect (hDC, (LPRECT)&Rect, GetStockObject(LTGRAY_BRUSH) );
            EndPaint (hWnd,(LPPAINTSTRUCT)&ps);
            break;

        case WM_DESTROY:
            DeleteObject (hFont);
            PostQuitMessage (0);
            break;

        case WM_COMMAND:
            hList = GetDlgItem (hWnd, ID_LISTBOX);
            hWndPrevParent = SetParent (hWnd, hWndParent);
            switch (wParam)
            {
                case ID_DELETE:
                    iSel = SendMessage (hList, LB_GETCURSEL, 0, 0L);
                    if (iSel != LB_ERR)
                        SendMessage (hList, LB_DELETESTRING, iSel, 0L);
                    break;
            }
            break;

        default:
            return (DefWindowProc (hWnd, iMessage, wParam, lParam));
    }

    return (0);
}
