;************************************************************************
.CODE

		PUBLIC	DIVIDE2
		PUBLIC	STREET
		PUBLIC	FINDS
		PUBLIC	SETUP
		PUBLIC	COPY4
		PUBLIC	COPYEND


;************************************************************************
DIVIDE2	PROC	NEAR
		LLA_ENTRY

		mov	ax, parm2
		mov	bx, parm1
		imul	bx		; m2 * m1
		mov	si, 1
		and	dx, dx
		jns	smul_div_1
		neg	si
smul_div_1:
		mov	bx, parm3
		idiv	bx		; m2 * m1 / d1
		and	bx, bx		; test if divisor is negative
		jns	smul_div_2
		neg	si
		neg	bx		; make it positive
smul_div_2:
		and	dx, dx		; test if remainder is negative
		jns	smul_div_3
		neg	dx		; make remainder positive
smul_div_3:
		shl	dx, 1		; see if 2 * remainder is > divisor
		cmp	dx, bx
		jl	smul_div_4
		add	ax, si

smul_div_4:
		LLA_EXIT
DIVIDE2	ENDP

;************************************************************************
STREET		PROC	NEAR
		LLA_ENTRY

		mov	bx, parm1		; pop low word of addr
		mov	ax,ds			; set hi word of addr

		LLA_EXIT
STREET		ENDP


;************************************************************************
FINDS		PROC	NEAR
		LLA_ENTRY

		les	bx, dparm1
		mov	ax, es:[bx]

		LLA_EXIT
FINDS		ENDP


;************************************************************************
SETUP		PROC	NEAR
		LLA_ENTRY

		les	bx, dparm1
		mov	ax, parm3
		mov	es:[bx], ax

		LLA_EXIT
SETUP		ENDP


;************************************************************************
COPYEND		PROC	NEAR
		LLA_ENTRY

		cld			; assume forward
		les	di, dparm1	; dest off & seg
		lds	si, dparm2	; src off & seg
		xor	cx, cx
		xor	ah, ah
lsc_loop:
		lodsb
		cmp	al, 0
		je	lsc_done
		inc	cx
		stosb
		JMPS	lsc_loop
lsc_done:
		stosb
		mov	ax, cx

		LLA_EXIT
COPYEND		ENDP


;************************************************************************
COPY4		PROC	NEAR
		LLA_ENTRY

		les	di, dparm1		; dest off
		lds	si, dparm2		; src off
		mov	cx, parm5		; count
		cld
	rep	movsb

		LLA_EXIT
COPY4		ENDP

		END
