/* This header file does all the necessary includes and defines all the
   structures and constants needed for the link program                 */

#define INCL_WIN
#define INCL_WINHXRP
#define INCL_WINDIALOGS
#define INCL_GPIPRIMITIVES

#include <os2.h>
#include <dos.h>
#include <malloc.h>
#include <stdio.h>
#include <string.h>

struct _HoldFXR
{
   BYTE       fXR;       /* Flag byte */
   BYTE       cbName;
   USHORT     cbValue;
   CHAR      *szName;
   CHAR      *aValue;
   struct _HoldFXR *next;
};
typedef struct _HoldFXR HOLDFXR;

struct _DeleteList
{
   CHAR *XRName;
   struct _DeleteList *next;
};
typedef struct _DeleteList DELETELIST;

struct _PassData
{
   CHAR   *Point;
   USHORT cbMulti;
   USHORT usMultiOffset;
   USHORT usIndex;
   BYTE   fFlag;
};
typedef struct _PassData PASSDATA;


struct _ReEnter
{
   HOLDFXR *pFXR;
   PASSDATA FAR *pPDat;
   struct _ReEnter *next;
};
typedef struct _ReEnter REENTER;

struct _XRDATA
{
   USHORT usPrefix;
   CHAR   szFormat[36];
   USHORT usFldType;
};
typedef struct _XRDATA XRDATA;

BOOL OpenFile(HWND,USHORT);
BOOL AddXR(HWND);
BOOL QueryXRs(HWND,CHAR *);
BOOL EditXRValue(HWND, PASSDATA *);
BOOL XRExists(CHAR *);
BOOL EditXR(HWND);
BOOL CheckXRIntegrity(CHAR *,USHORT);
MRESULT EXPENTRY OpenFileProc  (HWND, USHORT, MPARAM, MPARAM);
MRESULT EXPENTRY MainDlgProc   (HWND, USHORT, MPARAM, MPARAM);
MRESULT EXPENTRY AddXRProc     (HWND, USHORT, MPARAM, MPARAM);
MRESULT EXPENTRY AsciiEditProc (HWND, USHORT, MPARAM, MPARAM);
MRESULT EXPENTRY IconDlgProc   (HWND, USHORT, MPARAM, MPARAM);
MRESULT EXPENTRY MultiTypeProc (HWND, USHORT, MPARAM, MPARAM);
VOID  FillDirListBox  (HWND,CHAR *);
VOID  FillFileListBox (HWND);
VOID  Free_FXRList(HOLDFXR *,DELETELIST *);
VOID  ShowXRType(HWND);
VOID  DeleteCurXR(HWND);
VOID  WriteXRs(HWND);
VOID  ChangeName(HWND,HOLDFXR *,CHAR *);
VOID  MultiAdd(HWND, HOLDFXR *, PASSDATA FAR *);
SHORT ParseFileName (CHAR *, CHAR *);
USHORT LookupXRType(USHORT);
USHORT CurXRType(HOLDFXR *);
USHORT GetUSHORT(HOLDFXR *,USHORT);
HOLDFXR *GetCurFXR(HWND, HOLDFXR *);
CHAR *MultiTypeIndex(CHAR *, USHORT);
CHAR *XRValueString(HWND, CHAR *);

#define ARGFILE             1
#define MAX_GXR             500L /* Max size for a GXR List              */
#define Ref_ASCIIZ          1    /* Reference type for DosEnumAttribute  */
#define MAXXRNAME           255  /* Maximum length an XR Name can be     */
#define MAXXRVALUE         2048  /* Arbitrary max edit fld len of XR Val */
#define XRTABLESIZE          12  /* Number of entries in ConvTable       */
#define GROWSIZE            512  /* Minimum size to increase the heap by */
#define FILE_ALL         0x0007  /* Read-only, sys, hidden, & normal     */
#define MAXSHOWSIZE          34  /* Number of chars to place in desc lbox*/
#define LENUSHORTBUF          6  /* Buf size needed to for ascii USHORT  */

/* Return values from ParseFileName */
#define FILE_INVALID          0  /* The filename was invalid */
#define FILE_PATH             1  /* The filename was a path  */
#define FILE_VALID            2  /* The filename was valid   */

/* definition of level specifiers. required for File Info */

#define GetInfoLevel1   1                   /* Get info from SFT */
#define GetInfoLevel2   2                   /* Get size of FXRlist */
#define GetInfoLevel3   3                   /* Get FXRlist given the GXRlist */
#define GetInfoLevel4   4                   /* Get whole FXRlist */
#define GetInfoLevel5   5                   /* Get FSDname */

#define SetInfoLevel1   1                   /* Set info in SFT */
#define SetInfoLevel2   2                   /* Set FXRlist */

#define     OPENMODE    OM_DENY_NONE+OM_RXRD_WRITE
#define     OPENFLAG    OF_OPEN_FILE
#define     CRXRTFLAG   OF_CRXRTE_FILE+OF_FAIL
#define     REPLFLG     OF_REPLACE_FILE

#define XR_LPBINARY     0xfffe /* Length preceeded binary            */
#define XR_LPASCII      0xfffd /* Length preceeded ascii             */
#define XR_ASCIIZ       0xfffc /* Asciiz                             */
#define XR_LPBITMAP     0xfffb /* Length preceeded bitmap            */
#define XR_LPMETAFILE   0xfffa /* metafile                           */
#define XR_LPICON       0xfff9 /* Length preceeded icon              */
#define XR_ASCIIZFN     0xffef /* Asciiz file name of associated dat */
#define XR_ASCIIZXR     0xffee /* Asciiz XR of associated data       */
#define XR_MVMT         0xffdf /* Multi-value multi-typed field      */
#define XR_MVST         0xffde /* Multy value single type field      */
#define XR_ASN1         0xffdd /* ASN.1 field                        */

#define  HM_VALIDFLAGS  0x0003

/****** Resource IDs *****/

#define IDR_XRD             1
#define IDD_MULTILIST       2
#define IDD_BITMAP          3
#define IDD_ASCIIZ          4
#define ID_MENU_MAIN        5
#define IDD_OPENBOX         6
#define IDD_PATH            7
#define IDD_FILEEDIT        8
#define IDD_DIRLIST         9
#define IDD_FILELIST       10
#define IDD_MAIN           11
#define IDD_FNAME          12
#define IDD_LBOX           13
#define IDD_XRTYPE         14
#define IDD_ADD            15
#define IDD_DELETE         16
#define IDD_COPY           17
#define IDD_EDIT           18
#define IDD_PASTE          19
#define IDD_NEWFILE        20
#define IDD_WRITE          21
#define IDD_QUIT           22
#define IDD_ADDXR          23
#define IDD_XRNAME         24
#define IDD_NEW            25
#define IDD_EXISTING       26
#define IDD_ASCIIEDIT      27
#define IDD_XRVALUE        28
#define IDD_ICONWIN        29
#define BMP_EMPTY          30
#define IDD_ICON           31
#define IDD_MULTIBOX       32
#define DID_DONE           33
#define IDD_TITLE          34
#define IDD_LPDATA         35
#define IDD_NEEDBIT        36
#define IDD_CODEPAGE       37


/* Macros for allocating and deallocating memory from the heap.  They
   include a crude memory check and assume that the variable hwnd is
   defined in the environment the macro is executed in.               */

#define GetMem(x,y) x=(VOID *) WinAllocMem(hhp,y);       \
                    if(!x)                               \
                       WinMessageBox(HWND_DESKTOP, hwnd, \
                       "Sorry, Not enough memory",       \
                       NULL, 0, MB_OK);

#define ResizeMem(x,y,z) x=(VOID *) WinReallocMem(hhp,x,y,z); \
                         if(!x)                               \
                            WinMessageBox(HWND_DESKTOP, hwnd, \
                            "Sorry, Not enough memory",       \
                            NULL, 0, MB_OK);


#define FreeMem(x,y) WinFreeMem(hhp,(NPBYTE) x,(USHORT) y);

