/* smart c template  */
'S_GET_CURR_WORD CCODE'

SELECT
	
	WHEN abbrev( 'if', CCode, 1 ) THEN
	   do
		call insertcode( "if( )" )
		'S_PREV_CHAR'
		end

	WHEN abbrev( 'while', CCode, 1 ) THEN 
		do
		call insertcode( "while( )" )
		'S_PREV_CHAR'
		end
		
	WHEN abbrev( 'switch', CCode, 1 ) THEN 
		do
		call insertcode( "switch( )" )
		'S_PREV_CHAR'
		end

	WHEN abbrev( 'case', CCode, 1 ) THEN
	   do
		call insertcode( "case :" )
		'S_PREV_CHAR'
		end

	WHEN abbrev( 'for', CCode, 1 ) THEN
	   do
		call insertcode( "for( ; ; )" )
		'S_PREV_CHAR'
		'S_PREV_CHAR'
		'S_PREV_CHAR'
		'S_PREV_CHAR'
		'S_PREV_CHAR'
		end

	WHEN abbrev( 'do', CCode, 1 ) THEN 
		do
		call insertline( "do" ) 			/* do 				*/
		ADDSTR = '{'  
		'S_INSERT_LINE' ADDSTR				/* {  				*/
		'S_INDENT'
		ADDSTR = ' '  
		'S_INSERT_LINE' ADDSTR				/* blank line 		*/
		'S_INDENT'
		'S_PREV_CHAR'
		ADDSTR = '} while( )'  
		'S_INSERT_LINE' ADDSTR				/* } while ()		*/
		'S_PREV_LINE'
		'S_PREV_LINE'
		'S_INDENT'
		ADDSTR = ' ' 
		'S_INSERT_STRING' ADDSTR  
		end
		
	WHEN CCode = 'b' | CCode = '{' THEN 
		do
		call insertline( "{" ) 				
		ADDSTR = ' '  
		'S_INSERT_LINE' ADDSTR		
		'S_INDENT' 
		'S_PREV_CHAR'
		ADDSTR = '}'  
		'S_INSERT_STRING' ADDSTR		
		'S_PREV_LINE'
		ADDSTR = ' ' 
		'S_INSERT_STRING' ADDSTR  
		end

 
	WHEN CCode = 'cl' THEN
		do
		'S_PROMPT' 'Enter Comment,' 'Comment' 
		NEWCODE = '/* ' || Comment '*/'
		call insertcode( NEWCODE ) 
		'S_INSERT_LINE' ' '
		'S_INDENT'	 
		end

	WHEN CCode = 'ce' THEN
		do
		'S_PROMPT' 'Enter Comment,' 'Comment' 
		'S_SELECT_WORD'
		'S_DEL_SELECTED'
		StrLen = LENGTH( Comment )
		Justify = 'LEFT'

		IF Justify = 'RIGHT'  THEN 
		   IF ( StrLen >= 70 ) THEN
		      CommentCol = 1
		   ELSE
		      CommentCol = 70 - StrLen + 1
		ELSE
		   CommentCol = 45

		'S_END_OF_LINE'
		IF rc \= 0 THEN DO
		   SAY 'S_ Error = ' rc
		   EXIT
		   END

		'S_GET_COL_NUM CURRCOL'
		IF rc \= 0 THEN DO
		   SAY 'S_ Error = ' rc
		   EXIT
		   END

		IF CurrCol < CommentCol THEN
		   DO
		   'S_GOTO_COL' CommentCol
		   'S_INSERT_STRING' '// ' || Comment
		   END
		ELSE
		   DO
		   'S_PREV_LINE'
		   'S_END_OF_LINE'
		   ForceNewLine = ' '
		   'S_INSERT_LINE' ForceNewLine
		   NewComment = COPIES(' ', CommentCol - 1 ) || '// ' || Comment 
		   'S_INSERT_STRING' NewComment
		   END

		end
		
	WHEN CCode = 'h' THEN
		do
		'S_SELECT_WORD'
		'S_DEL_SELECTED'
		'S_PROMPT' 'Enter Function Comments,' 'NEWFILENAME'
      
		comment = '/'|| copies('*',67)
		'S_INSERT_LINE' comment

		'S_INSERT_LINE' '*'
		'S_INSERT_LINE' '*  ' || NEWFILENAME 
		'S_INSERT_LINE' '*'
		comment = copies('*',67) || '/'
		'S_INSERT_LINE' comment

		end

   	OTHERWISE
		NOP
end 
exit		

insertcode: procedure
		parse arg CodeToAdd
		'S_SELECT_WORD'
		'S_DEL_SELECTED'
		'S_INSERT_STRING' CodeToAdd
		return	

insertline: procedure
		parse arg CodeToAdd
		'S_SELECT_WORD'
		'S_DEL_SELECTED'
		'S_INSERT_LINE' CodeToAdd
		'S_INDENT'
		return	


