/* SaveEnv.Rex - Rexx Macro to Save the SL environment    */
/* This saves each Sourcelink file and its col and offset */
/* edit mode and wrap                                     */
/* arg is filename to save the opened SL filenames        */
S_GET_NUM_SL_FILES NumOfSLFiles
if NumOfSLFiles = 0
then say "no files to save"
else do
    if ARG(1,'E') 
       then
          NEWFILENAME = ARG(1)
       else
          'S_PROMPT' 'Enter Environment Filename,' 'NEWFILENAME'
    if NEWFILENAME = CANCEL 
        then leave      
    'S_OPEN_FILE R C' NewFilename NewFNHandle
    if rc \= 0 
       then say 'open return code = ' rc
    else 
        do I=NumOfSLFiles-1 to 0 by -1 until I = -1 
            'S_GET_BUFF_FILENAME' I 'Filename'
            if rc = 0
                then do
                'S_GET_CURR_FILENAME CurrFilename'
                'S_GET_BUFF_LINE_NUM' I 'LineNum'
                'S_GET_BUFF_COL_NUM'  I 'ColNum'
                'S_GET_BUFF_EDITMODE' I 'EditMode'
                'S_GET_BUFF_WORDWRAP' I 'WrapMode'
                Record = Filename '('Linenum':'ColNum') ' EditMode' 'WrapMode
                S_WRITE_FILE NewFNHandle LENGTH(Record) Record BytesWritten
                S_WRITE_FILE NewFNHandle 1 '0a'x BytesWritten
                end
        end I

    S_CLOSE_FILE NewFNHandle
    end   
