/* Rexx Macro to Restore Environment */
if ARG(1,'E') 
   then
      OLDFILENAME = ARG(1)
   else
      'S_PROMPT' 'Enter Environment Filename,' 'OLDFILENAME'

S_DOES_FILE_EXIST OldFileName FileExists
if FileExists = 'FALSE'
   then say 'File does not exist'

do until LINES( OldFilename ) = 0
   CurrLine = LINEIN( OldFilename )
   Filename = WORD( CurrLine, 1 )
   
   Loc = WORD( CurrLine, 2 )
   PARSE VALUE Loc WITH '(' LineNum ':' ColNum ')'
   
   Editmode = WORD( CurrLine, 3 )
   if Editmode = EDIT
   	then EditOpen = 'E'
   else
   	EditOpen = 'R'
   	
   Wrapmode = WORD( CurrLine, 4 )
   if Wrapmode = WRAP
   	then WrapOpen = Y
   else
   	WrapOpen = N
   	
   'S_OPEN_SL_FILE 0' EditOpen WrapOpen Filename
   if rc = 0 
      then do  
         S_GOTO_LINE LineNum
         S_GOTO_COL ColNum
      end
end
   