/* Rexx command to merge reports resulting from analysis using tables:   */
/* W16DAPIE and DAPIE16.                                                 */
/* L.D. 8-7-95                                                           */
/* New Feature to add headings to the original reports and re-write them */
/* L.D. 8-8-95                                                           */

/* Load RexxUtils */
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

Parse Arg help .
if help = "?" then call DisplayHelp

/* Initialize running totals for effort calculations */
Subtotal = 0
Total    = 0

/* Ask all the annoying questions for report headings */
Call GetInitData

outfile  = pname".dap" /* W16DAPIE and DAPIE16 merged .rpt */

/* delete existing .dap if there is one */
if (stream(pname".dap",'c','query exists') \= "") then do
   say pname".dap file exists, Continue? y/n?"
   say "Note:  If you do continue, the existing" pname".dap file will be deleted."
   Parse UPPER pull answer .
   if answer = "N" then exit
     call SysFileDelete pname".dap"
end /* if */

say "Saving original files with the .rpt extensions:"  infile1 "and" infile2
say "Generating additional reports with headers:"  tmpfile1 "and" tmpfile2

/* open the outputfiles */
lineoutResult = LINEOUT(outfile,,)
lineoutResult = LINEOUT(tmpfile1,,) /* FileName entered in GetInitData */
lineoutResult = LINEOUT(tmpfile2,,) /* FileName entered in GetInitData */

/* Write esc sequence to print landscape */
lineoutResult = LINEOUT(outfile,'1b6c'x)
lineoutResult = LINEOUT(tmpfile1,'1b6c'x)
lineoutResult = LINEOUT(tmpfile2,'1b6c'x)

/* Call function to write Page Headers for all 3 reports */
PageNum = 1
Call PageHead dateDap timeDap outfile PageNum nameDap
Call WriteSum outfile

Call PageHead date1 time1 tmpfile1 PageNum name1
Call WriteSum tmpfile1

Call PageHead date2 time2 tmpfile2 PageNum name2
Call WriteSum tmpfile2

PageNum = 2
Call PageHead dateDap timeDap outfile PageNum nameDap
Call PageHead date1 time1 tmpfile1 PageNum name1
Call PageHead date2 time2 tmpfile2 PageNum name2
LineNum = 2

/* open the input files*/
noread = LINEIN(infile1,,0)
noread = LINEIN(infile2,,0)

Say "Processing file:" tmpfile2

noread = LINEIN(infile2,,0)
/* read the entire DAPIE16 .rpt into an array */

PageNum2 = PageNum
LineNum2 = LineNum

subby = 0
do while (LINES(infile2))

   if LineNum2 > 45 then do
      lineoutResult = LINEOUT(tmpfile2,'0C'x)
      PageNum2 = PageNum2 + 1
      Call PageHead date2 time2 tmpfile2 PageNum2 name2
      LineNum2 = 2
   end /* if */

   subby =  subby+1
   inline.subby = LINEIN(infile2)

   /* Write the line to the report */
   lineoutResult = LINEOUT(tmpfile2,inline.subby)
   if lineoutResult = 1 then say "error outputting line" inline.subby "to file" infile2
   if inline.subby = '0C'x then do
      totalLines = subby
      if LineNum2 > 3 then do
         PageNum2 = PageNum2 + 1
         Call PageHead date2 time2 tmpfile2 PageNum2 name2
         LineNum2 = 2
      end
   end /* if */

   else LineNum2 = LineNum2 + 1
end /* while */

Say "Processing file:" tmpfile1

/* Write headers */
Call WriteHeaders

PageNum1 = PageNum
LineNum1 = LineNum
ModuleEnd = 0

subby=1
/* parse each line of the WIN16T .rpt */
do while (LINES(infile1))
   inline1 = LINEIN(infile1)

   if LineNum1 > 45 then do
      lineoutResult = LINEOUT(tmpfile1,'0C'x)
      PageNum1 = PageNum1 + 1
      Call PageHead date1 time1 tmpfile1 PageNum1 name1
      LineNum1 = 2
   end /* if */

   /* Write the line to the report */
   lineoutResult = LINEOUT(tmpfile1,inline1)
   if lineoutResult = 1 then say "error outputting line" inline1 "to file" tmpfile1

   PARSE VAR inline1 searchKey size1 lines1 code1 hits1 pcthits1 inst1 pctinst1 effort1 .

   /* if we've reached the break character, then we are done with the DAP rpt */
   if searchKey = '0c'x then do
      ModuleEnd = 1
      totalLines = subby
      if LineNum1 > 3 then do
         PageNum1 = PageNum1 + 1
         Call PageHead date1 time1 tmpfile1 PageNum1 name1
         LineNum1 = 2
      end
   end /* if */

   else do
      LineNum1 = LineNum1 + 1
      if ModuleEnd = 0 then do
         /* skip the headings */
         if (searchKey \= " ") & (searchKey \= "PATH/FILENAME") & ,
            (searchKey \= "____________________") then do

            line2 = inline.subby
            PARSE VAR line2 searchKey2 size2 lines2 code2 hits2 pcthits2 inst2 pctinst2 effort2 .

            /* if this is a matching line, write the merged line */
            if (searchKey = searchKey2) then do
               if LineNum > 45 then do
                  lineoutResult = LINEOUT(outfile,'0C'x)
                  PageNum = PageNum + 1
                  Call PageHead dateDap timeDap outfile PageNum nameDap
                  LineNum = 2
               end /* if */
               if (searchKey = "*SubTotal*") then call GenSubs
               else if (searchKey = "**Total**") then call GenTots
               else call GenLine
            end /* if */
         end /* long if */
      end /* if ModuleEnd...*/
   end /* else */
   subby = subby + 1
end /* while */

/* Cleanup and exit */
Call CleanupAndGo

/*-------------------------------------------------------------------------*/
/*Sub routines follow                                                      */
/*-------------------------------------------------------------------------*/

/* Ask analyst for info regarding the initial set of SMART reports and */
/* other interesting input about the source code being analyzed        */
GetInitData:
say "Please enter a project name of 8 characters or less:"
Parse UPPER PULL pname .

say "Please enter your name:"
Parse PULL nameDap

dateDap = DATE('U')
timeDap = TIME('N')

say "Please enter the file specification for the .rpt file resulting from"
say "an analysis of the source for this project using the table W16DAPIE.TBL:"
say "The path need not be specified if the file resides in the current directory. "
parse PULL infile1

if (infile1="") then call BadFile
else do
   call SysFileTree infile1, 'file1', 'F'
   if file1.0 = 0 then call BadFile
end /* else */

say "Please enter the name of the person who ran the " infile1 "analysis:"
say "If you ran the" infile1 "analysis, you may leave this blank and press enter."
Parse PULL name1

if name1 = "" then name1 = nameDap

Parse Var file1.1 date1 time1 .

dot = POS(".",infile1)
tmpfile1 = SUBSTR(infile1,1,dot) || "rpd"

say "Please enter the file specification for the .rpt file resulting from"
say "an analysis of the source for this project using the table DAPIE16.TBL:"
say "The path need not be specified if the file resides in the current directory. "
parse PULL infile2

if (infile2="") then call BadFile
else do
   call SysFileTree infile2, 'file2', 'F'
   if file2.0 = 0 then call BadFile
end /* else */

say "Please enter the name of the person who ran the " infile2 "report:"
say "If you ran the" infile2 "analysis, you may leave this blank and press enter."
Parse PULL name2

if name2 = "" then name2 = nameDap

Parse Var file2.1 date2 time2 .

dot = POS(".",infile2)
tmpfile2 = SUBSTR(infile2,1,dot) || "rpd"

say "Were the two analyses," infile1 "and " infile2 "run with the same"
say "List-of-files and with the same EXCLUDE and IFDEF options?"
Parse PULL SameLst

say "Does this source code contain any 32 bit APIs?"
Parse PULL all16

say "Please enter any additional information about this source code, such as"
say "Libraries used, MFC, Borland Owl, etc., in 72 characters or less:"
Parse PULL Additional

say "If a source file contains mixed DAPIE and non-DAPIE code, the effort value"
say "may need to be increased for the first non-DAPIE hit to account for code re-"
say "structuring.  Please enter additional effort value now or press enter to default to 0."
Parse Pull firstHit
if firstHit = "" then firstHit = 0
if DATATYPE(firstHit,'N') = 0 then firstHit = 0

say "If a source file contains mixed DAPIE and non-DAPIE code, the effort value"
say "for each subsequent non-DAPIE hit in this file will be increased by 2.  To"
say "change this please enter a new value. Press enter to default to 2."
Parse Pull subsHit
if subsHit = "" then subsHit = 2
if DATATYPE(subsHit,'N') = 0 then subsHit = 2

return

/*  Write the headers for the report */
WriteHeaders:
   headerLine = RIGHT("WIN16",58)
   headerLine = headerLine RIGHT("DAPIE",8)
   headerLine = headerLine RIGHT("WIN16",8)
   headerLine = headerLine RIGHT("DAPIE",8)

   lineoutResult = LINEOUT(outfile,headerLine)
   if lineoutResult = 1 then say "error outputting line" headerLine

   headerLine = LEFT("PATH/FILENAME",20)
   headerLine = headerLine RIGHT("SIZE",10)
   headerLine = headerLine RIGHT("LINES",8)
   headerLine = headerLine RIGHT("CODE",8)
   headerLine = headerLine RIGHT("HITS",8)
   headerLine = headerLine RIGHT("HITS",8)
   headerLine = headerLine RIGHT("INSTS",8)
   headerLine = headerLine RIGHT("INSTS",8)
   headerLine = headerLine RIGHT("EFFORT",8)

   lineoutResult = LINEOUT(outfile,headerLine)
   if lineoutResult = 1 then say "error outputting line" headerLine

   headerLine = LEFT("_",20,"_")
   headerLine = headerLine RIGHT("_",10,"_")
   headerLine = headerLine RIGHT("_",8,"_")
   headerLine = headerLine RIGHT("_",8,"_")
   headerLine = headerLine RIGHT("_",8,"_")
   headerLine = headerLine RIGHT("_",8,"_")
   headerLine = headerLine RIGHT("_",8,"_")
   headerLine = headerLine RIGHT("_",8,"_")
   headerLine = headerLine RIGHT("_",8,"_")

   lineoutResult = LINEOUT(outfile,headerLine)
   if lineoutResult = 1 then say "error outputting line" headerLine

   headerLine = " "

   lineoutResult = LINEOUT(outfile,headerLine)
   if lineoutResult = 1 then say "error outputting line" headerLine

   LineNum = LineNum + 4
return

/* Generate a Merged line for the report and write it. */
GenLine:                                    
   LineNum = LineNum +1
   if (size1 = " ") then mergedLine = LEFT(searchKey,20)
   else do
      mergedLine = LEFT("  " searchKey,20)
      mergedLine = mergedLine RIGHT(size1,10)
      mergedLine = mergedLine RIGHT(lines1,8)
      mergedLine = mergedLine RIGHT(code1,8)

      /* WIN16 hits =  WIN16 Hits - DAPIE hits */
      Call StripCommas hits1
      hits1 = stripped
      Call StripCommas hits2
      hits2 = stripped
      if ( DATATYPE(hits1,'N') = 0 | DATATYPE(hits2,'N') = 0 ) then
         hits1 = "BADDATA"
      else
         hits1 = hits1-hits2

      mergedLine = mergedLine RIGHT(hits1,8)
      mergedLine = mergedLine RIGHT(hits2,8)

      /* WIN16 unique instances =  WIN16 unique instances - DAPIE unique instances */
      Call StripCommas inst1
      inst1 = stripped
      Call StripCommas inst2
      inst2 = stripped
      if ( DATATYPE(inst1,'N') = 0 | DATATYPE(inst2,'N') = 0 ) then
         inst1 = "BADDATA"
      else
         inst1 = inst1-inst2

      mergedLine = mergedLine RIGHT(inst1,8)
      mergedLine = mergedLine RIGHT(inst2,8)
      call CalcEffort
      mergedLine = mergedLine RIGHT(effort,8)
   end /* else do */

   /* Write the line to the report */
   lineoutResult = LINEOUT(outfile,mergedLine)
   if lineoutResult = 1 then say "error outputting line" mergedLine
 return


/* Generate the Merged Subtotal line for the report and write it.  */
GenSubs:                                    
   LineNum = LineNum +2
   PARSE VAR inline1 searchKey count size1 lines1 code1 hits1 pcthits1 effort1 .
   PARSE VAR line2  searchKey2 count size2 lines2 code2 hits2 pcthits2 effort2 .
   mergedLine = LEFT(searchKey count,20)
   mergedLine = mergedLine RIGHT(size1,10)
   mergedLine = mergedLine RIGHT(lines1,8)
   mergedLine = mergedLine RIGHT(code1,8)

   /* WIN16 hits =  WIN16 Hits - DAPIE hits */
   Call StripCommas hits1
   hits1 = stripped
   Call StripCommas hits2
   hits2 = stripped
   if ( DATATYPE(hits1,'N') = 0 | DATATYPE(hits2,'N') = 0 ) then
      hits1 = "BADDATA"
   else
      hits1 = hits1-hits2

   mergedLine = mergedLine RIGHT(hits1,8)
   mergedLine = mergedLine RIGHT(hits2,8)
   mergedLine = mergedLine RIGHT(" ",8)
   mergedLine = mergedLine RIGHT(" ",8)
   mergedLine = mergedLine RIGHT(Subtotal,8)

   /* Write the line to the report */
   lineoutResult = LINEOUT(outfile,mergedLine)
   if lineoutResult = 1 then say "error outputting line" mergedLine

   /* Write a blank line to the report */
   mergedLine = " "
   lineoutResult = LINEOUT(outfile,mergedLine)
   if lineoutResult = 1 then say "error outputting line" mergedLine

   /* Reset subtotal */
   Subtotal = 0
 return

/* Generate the Merged Total line for the report and write it.  */
GenTots:                                    
   LineNum = LineNum +1
   PARSE VAR inline1 searchKey count size1 lines1 code1 hits1 pcthits1 inst1 pctinst1 effort1 .
   PARSE VAR line2  searchKey2 count size2 lines2 code2 hits2 pcthits2 inst2 pctinst2 effort2 .
   mergedLine = LEFT(searchKey count,20)
   mergedLine = mergedLine RIGHT(size1,10)
   mergedLine = mergedLine RIGHT(lines1,8)
   mergedLine = mergedLine RIGHT(code1,8)

   /* WIN16 hits =  WIN16 Hits - DAPIE hits */
   Call StripCommas hits1
   hits1 = stripped
   Call StripCommas hits2
   hits2 = stripped
   if ( DATATYPE(hits1,'N') = 0 | DATATYPE(hits2,'N') = 0 ) then
      hits1 = "BADDATA"
   else
      hits1 = hits1-hits2

   mergedLine = mergedLine RIGHT(hits1,8)
   mergedLine = mergedLine RIGHT(hits2,8)

   /* WIN16 unique instances =  WIN16 unique instances - DAPIE unique instances */
   Call StripCommas inst1
   inst1 = stripped
   Call StripCommas inst2
   inst2 = stripped
   if ( DATATYPE(inst1,'N') = 0 | DATATYPE(inst2,'N') = 0 ) then
      inst1 = "BADDATA"
   else
      inst1 = inst1-inst2

   mergedLine = mergedLine RIGHT(inst1,8)
   mergedLine = mergedLine RIGHT(inst2,8)
   mergedLine = mergedLine RIGHT(Total,8)

   /* Write the line to the report */
   lineoutResult = LINEOUT(outfile,mergedLine)
   if lineoutResult = 1 then say "error outputting line" mergedLine
 return

/* Display help for this command and exit */
DisplayHelp:
   say "The DAPIEMRG.CMD will generate a detailed SMART report showing"
   say "side-by-side the keyword hits and unique instances for both DAPIE"
   say "keywords and non-DAPIE keywords, by source file.  This can be used to"
   say "determine where code restructuring will be needed to keep DAPIE and"
   say "non-DAPIE keywords in separate source files with appropriate headers."
   say " "
   say "This CMD will ask for inputs as as follows:"
   say " "
   say "1) A project name of 8 characters or less"
   say "2) Your name"
   say "3) The file specification for the .rpt file resulting from an"
   say "   analysis of the source for this project using the table W16DAPIE.TBL"
   say "4) The name of the person who ran the report"
   say "5) The file specification for the .rpt file resulting from an"
   say "   analysis of the source for this project using the table DAPIE16.TBL"
   say "6) The name of the person who ran that report"
   say "7) Were the previous two analyses,run with the same"
   say "   List-of-files and with the same EXCLUDE and IFDEF options?"
   say "8) Does this source code contain any 32 bit APIs?"
   say "9) Please enter any additional information about this source code, such"
   say "    as Libraries used, MFC, Borland Owl, etc., in 72 characters or less:"
   pause
   say "10) If a source file contains mixed DAPIE and non-DAPIE code, the effort value"
   say "may need to be increased for the first non-DAPIE hit to account for code re-"
   say "structuring.  Please enter additional effort value now or press enter to default to 0."
   say "11) If a source file contains mixed DAP and non-DaP code, the effort value"
   say "    for each subsequent non-DAPIE hit in this file will be increased by 2.  To"
   say "    change this please enter a new value. Press enter to default to 2."
   say " "
   say "This input must be provided in the order requested.  The resulting"
   say "report will be called Pname.dap, where Pname is the project name "
   say "entered in Number 1 above, and will be placed "
   say "in the current directory.  If the same List-of-files, EXCLUDE and"
   say "IFDEFS were not used for both analyses, the results will be unpredicatble."
exit

/* strips commas from the passed in arg --for numbers over 999, for example */
StripCommas:
   comma = POS(",",ARG(1))
   if comma = 0 then stripped = ARG(1)

   else do
      therest= LENGTH(ARG(1)) - comma
      stripped = SUBSTR(ARG(1),1,comma-1) || SUBSTR(ARG(1),comma+1, therest)
   end /* else */

   return

/* Write the heading for the specified file */
PageHead:
   Parse Arg ThisDate ThisTime ThisOutFile Num AnalystName

   PageHeadLine = "Project:  "pname "  Analyst:  "AnalystName "  Date:  "ThisDate ,
      " Time:  "ThisTime " FILE:" ThisOutFile "  Page: " Num

   lineoutResult = LINEOUT(ThisOutFile,PageHeadLine)
   lineoutResult = LINEOUT(ThisOutFile," ")
return

/* Write the Summary Info Page for the specified file */
WriteSum:
   Parse Arg ThisOutFile .
   SumLine="Project Name:           " pname
   lineoutResult = LINEOUT(ThisOutFile,SumLine)

   SumLine="Analyst Name:           " nameDap
   lineoutResult = LINEOUT(ThisOutFile,SumLine)

   SumLine="Date:                   " dateDap
   lineoutResult = LINEOUT(ThisOutFile,SumLine)

   SumLine="Time:                   " timeDap
   lineoutResult = LINEOUT(ThisOutFile,SumLine)
   lineoutResult = LINEOUT(ThisOutFile," ")

   SumLine="W16DAPIE RPT Filespec:  " infile1
   lineoutResult = LINEOUT(ThisOutFile,SumLine)

   SumLine="W16DAPIE RPT Analyst:   " name1
   lineoutResult = LINEOUT(ThisOutFile,SumLine)

   SumLine="W16DAPIE RPT Date:      " date1
   lineoutResult = LINEOUT(ThisOutFile,SumLine)

   SumLine="W16DAPIE RPT Time:      " time1
   lineoutResult = LINEOUT(ThisOutFile,SumLine)
   lineoutResult = LINEOUT(ThisOutFile," ")

   SumLine="DAPIE16 RPT Filespec:   " infile2
   lineoutResult = LINEOUT(ThisOutFile,SumLine)

   SumLine="DAPIE16 RPT Analyst:    " name2
   lineoutResult = LINEOUT(ThisOutFile,SumLine)

   SumLine="DAPIE16 RPT Date:       " date2
   lineoutResult = LINEOUT(ThisOutFile,SumLine)

   SumLine="DAPIE16 RPT Time:       " time2
   lineoutResult = LINEOUT(ThisOutFile,SumLine)
   lineoutResult = LINEOUT(ThisOutFile," ")

   SumLine="Were the two analyses," infile1 "and" infile2", run with the same .LST"
   lineoutResult = LINEOUT(ThisOutFile,SumLine)

   SumLine= "and with the same EXCLUDE and IFDEF options?"  SameLst
   lineoutResult = LINEOUT(ThisOutFile,SumLine)
   lineoutResult = LINEOUT(ThisOutFile," ")

   SumLine="Does this source code contain any 32 bit APIs?" all16
   lineoutResult = LINEOUT(ThisOutFile,SumLine)
   lineoutResult = LINEOUT(ThisOutFile," ")

   SumLine="Additional information about this source code:"
   lineoutResult = LINEOUT(ThisOutFile,SumLine)
   SumLine=Additional
   lineoutResult = LINEOUT(ThisOutFile,SumLine)

   lineoutResult = LINEOUT(ThisOutFile,'0C'x)
return

/* Display Error msg for an invalid file spec and exit */
BadFile:
   say "File does not exist.  Will Exit now -- a file spec for an existing"
   say "file is required."
   exit

/* Calculate the effort for this file, includes effort to fix salt & pepper code */
CalcEffort:
if hits1 = 0 | hits2 = 0 then effort = effort1
else effort = firstHit + (subsHit * (hits1- 1)) + effort1
Subtotal = Subtotal + effort
Total = Total + effort
return

CleanupAndGo:
   say "Creating file: " outfile

   /* Write esc sequence to print portrait */
   lineoutResult = LINEOUT(ThisOutFile,'1b6b'x)

   /* close the files */
   lineoutResult = LINEOUT(outfile)
   lineoutResult = LINEOUT(infile1)
   lineoutResult = LINEOUT(infile2)
   lineoutResult = LINEOUT(tmpfile1)
   lineoutResult = LINEOUT(tmpfile2)
exit
