/* $Id: uninstal.c,v 1.1 2000/03/27 04:53:00 ktk Exp $ */

/****************************************************************************
*
*                         SciTech Display Doctor
*
*               Copyright (C) 1991-1998 SciTech Software, Inc.
*                            All rights reserved.             
*
*  ======================================================================
*  |REMOVAL OR MODIFICATION OF THIS HEADER IS STRICTLY PROHIBITED BY LAW|
*  |                                                                    |
*  |This copyrighted computer code is a proprietary trade secret of     |
*  |SciTech Software, Inc., located at 505 Wall Street, Chico, CA 95928 |
*  |USA (www.scitechsoft.com).  ANY UNAUTHORIZED POSSESSION, USE,       |
*  |VIEWING, COPYING, MODIFICATION OR DISSEMINATION OF THIS CODE IS     |
*  |STRICTLY PROHIBITED BY LAW.  Unless you have current, express       |
*  |written authorization from SciTech to possess or use this code, you |
*  |may be subject to civil and/or criminal penalties.                  |
*  |                                                                    |
*  |If you received this code in error or you would like to report      |
*  |improper use, please immediately contact SciTech Software, Inc. at  |
*  |530-894-8400.                                                       |
*  |                                                                    |
*  |REMOVAL OR MODIFICATION OF THIS HEADER IS STRICTLY PROHIBITED BY LAW|
*  ======================================================================
*
* Language:		ANSI C
* Environment:	OS/2 Warp
*
* Description:	Program to uninstall SciTech Display Doctor components.
*
****************************************************************************/

#define	INCL_WIN
#define	INCL_WINWORKPLACE
#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "pmapi.h"

/*--------------------------- Global variables ----------------------------*/

const char *szUninstallTitle	= "Uninstall SDD/2?";
const char *szUninstall			= "Are you sure you wish to remove SciTech Display Doctor, and all it's components from your system?";
const char *szRebootTitle		= "Please reboot!";
const char *szReboot			= "In order to complete the removal of SciTech Display Doctor, you must reboot your system.";
const char *szSDDHELP			= "sddhelp.sys";
const char *szNoDDC				= "SET VCFG_NO_DDC=TRUE";
const char *szGREXT				= "SET GREEXT=SDDGREXT";
char szUNINSTALL[]				= "X:\\sdd\\uninstal.exe";
char szSDDDir[]					= "X:\\sdd";
char szSDDHELP_SYS[]			= "X:\\os2\\sddhelp.sys";
char szSVGADATA_PMI[]			= "X:\\os2\\svgadata.pmi";
char szPRIVATE_DIF[]			= "X:\\os2\\private.dif";
char szVIDEO_CFG[]				= "X:\\os2\\video.cfg";
char szSDDGRADD_DLL[]			= "X:\\os2\\dll\\sddgradd.dll";
char szSDDGREXT_DLL[]			= "X:\\os2\\dll\\sddgrext.dll";
char szSDDPMI_DLL[]				= "X:\\os2\\dll\\sddpmi.dll";
char szSDDCFG_DLL[]				= "X:\\os2\\dll\\sddcfg.dll";
char szSDDCFGI_DLL[]			= "X:\\os2\\dll\\sddcfgi.dll";
char szConfigSys[]				= "X:\\config.sys";
char szSETVGA[]					= "X:\\os2\\setvga.cmd";

/*-------------------------- Implementation -------------------------------*/

/* Undocumented functions */
APIRET APIENTRY DosReplaceModule(PSZ pszOldModule,PSZ pszNewModule,PSZ pszBackupModule);

/****************************************************************************
PARAMETERS:
str	- String to set boot drive for

RETURNS:
String with the boot drive letter updated

REMARKS:
Sets the boot drive letter for the string, and returns the updated string.
****************************************************************************/
char *SetBootDrive(
	char *str)
{
	str[0] = PM_getBootDrive();
	return str;
}

/****************************************************************************
PARAMETERS:
buf	- String to search
str	- String to search for

RETURNS:
true if buf contains str, false if not.

REMARKS:
Scans the string 'buf' looking for the string 'str'.
****************************************************************************/
static ibool ContainsString(
	const char *buf,
	const char *str)
{
	int 		len = strlen(str);
	const char	*p = buf;

	while (*p) {
		if (strnicmp(p, str, len) == 0)
			return true;
		p++;
		}
	return false;
}

/****************************************************************************
PARAMETERS:
sourceName	- Name for source file
destName	- Name for destination file

RETURNS:
true on success, false on failure.

REMARKS:
Copies the source file to the destination file.
****************************************************************************/
static int CopyBinaryFile(
	char *sourceName,
	char *destName)
{
	char    *data;
	FILE	*in,*out;
	size_t	size,blocksize,sizeleft,i,numblocks;

	/* Open the source and destination files */
	if ((in = fopen(sourceName, "rb")) == NULL)
		return false;
	if ((out = fopen(destName, "wb")) == NULL)
		return false;
	if ((data = (char*)malloc(blocksize = 0x7FFFU)) == NULL)
		return false;

	/* Get the size of the source file */
	fseek(in, 0, SEEK_END);
	size = ftell(in);
	fseek(in, 0, SEEK_SET);

	/* Now copy the contents of the file 32k at a time */
	if (size > 0) {
		if (size < blocksize)
			blocksize = size;
		numblocks = size / blocksize;
		sizeleft = size;
		for (i = 0; i < numblocks; i++) {
			if (fread(data, 1, blocksize, in) != blocksize)
				return false;
			if (fwrite(data, 1, blocksize, out) != blocksize)
				return false;
			sizeleft -= blocksize;
			}
		if (sizeleft > 0) {
			if (fread(data, 1, sizeleft, in) != sizeleft)
				return false;
			if (fwrite(data, 1, sizeleft, out) != sizeleft)
				return false;
			}
		}

	free(data);
	fclose(in);
	fclose(out);
	return true;
}

/****************************************************************************
PARAMETERS:
filename	- Filename of config file to update
searchKey	- Key string to search for in line

RETURNS:
true on success, false on failure.

REMARKS:
Searches for the specified search key in the configuration file and deletes
all lines that contains this key.
****************************************************************************/
static ibool DeleteLine(
	char *filename,
	char *searchKey)
{
	char	buf[255],tempName[_MAX_PATH];
	FILE	*oldfile,*newfile;

	oldfile = fopen(filename, "r");
	tmpnam(tempName);
	newfile = fopen(tempName, "w");
	if (newfile == NULL || oldfile == NULL)
		return false;

	// Find the starting line in the input file given search keys
	while (fgets(buf, 255, oldfile)) {
		if (ContainsString(buf, searchKey))
			continue;
		fputs(buf, newfile);
		}
	fclose(newfile);
	fclose(oldfile);
	if (!CopyBinaryFile(tempName, filename))
		return false;
	DosDelete(tempName);
	return true;
}

#define	CLEAR_MASK	(PM_FILE_READONLY | PM_FILE_HIDDEN | PM_FILE_SYSTEM)

/****************************************************************************
PARAMETERS:
path 		- path of directory to delete
fileMask	- Mask for files to remove

REMARKS:
Deletes all files and subdirectories in a directory, by recursively removing
all sub-directories.
****************************************************************************/
static ibool removeFiles(
	const char *path,
	const char *fileMask)
{
	PM_findData	findData;
	void		*hfile;
	int 		done;
	char 		files[PM_MAX_PATH];
	char 		name[PM_MAX_PATH];

	findData.dwSize = sizeof(findData);
	strcpy(files,path);
	if (strlen(path) > 0)
		PM_backslash(files);
	if (strcmp(fileMask,"*") == 0)
		strcat(files,"*.*");
	else
		strcat(files,fileMask);
	done = (hfile = PM_findFirstFile(files,&findData)) == PM_FILE_INVALID;
	while (!done) {
		if ((strcmp(findData.name,".") != 0) && (strcmp(findData.name,"..") != 0)) {
			strcpy(name,path);
			if (strlen(path) > 0)
				PM_backslash(name);
			strcat(name,findData.name);
			if (findData.attrib & PM_FILE_DIRECTORY) {
				/* This is a directory, so recursively delete it also */
				PM_findClose(hfile);
				if (stricmp(findData.name,fileMask) == 0) {
					if (!removeFiles(name,"*"))
						return false;
					}
				else if (!removeFiles(name,fileMask))
					return false;
				if (!PM_rmdir(name))
					return false;
				done = (hfile = PM_findFirstFile(files,&findData)) == PM_FILE_INVALID;
				continue;
				}
			if (findData.attrib & CLEAR_MASK)
				PM_setFileAttr(name,PM_FILE_NORMAL);
			remove(name);
			}
		done = !PM_findNextFile(hfile,&findData);
		}
	if (hfile != PM_FILE_INVALID)
		PM_findClose(hfile);
	return true;
}

/****************************************************************************
PARAMETERS:
filename	- Name of the file to delete

REMARKS:
Removed a module that is potentially in use. We use DosReplaceModule to
replace the module while it is in use, and then the file is closed. After
that we can simply delete the file.
****************************************************************************/
void RemoveModule(
	char *filename)
{
	DosReplaceModule(SetBootDrive(filename),NULL,NULL);
	DosDelete(filename);
}

int main(int argc,char *argv[])
{
	HAB	habAnchor;
	HMQ	hmqQueue;

	habAnchor = WinInitialize(0);
	hmqQueue = WinCreateMsgQueue(habAnchor,0);
	if (WinMessageBox(HWND_DESKTOP,0,(PSZ)szUninstall,(PSZ)szUninstallTitle,0,MB_OKCANCEL | MB_ICONQUESTION | MB_DEFBUTTON2 | MB_MOVEABLE) != MBID_CANCEL) {
		// Remove all Nucleus files
		removeFiles(PM_getNucleusPath(),"*.*");

		// Remove all SDD files
		DosReplaceModule(SetBootDrive(szUNINSTALL),NULL,NULL);
		removeFiles(SetBootDrive(szSDDDir),"*.*");

		// Remove all SDD driver files and DLL's
		DosDelete(SetBootDrive(szSDDHELP_SYS));
		DosDelete(SetBootDrive(szSVGADATA_PMI));
		DosDelete(SetBootDrive(szPRIVATE_DIF));
		DosDelete(SetBootDrive(szVIDEO_CFG));
		RemoveModule(szSDDGRADD_DLL);
		RemoveModule(szSDDGREXT_DLL);
		RemoveModule(szSDDPMI_DLL);
		RemoveModule(szSDDCFG_DLL);
		RemoveModule(szSDDCFGI_DLL);

		// Remove the Workplace Shell objects
		WinDestroyObject(WinQueryObject("<SCITECH_DESKTOP>"));

		// Revert to VGA mode
		system(SetBootDrive(szSETVGA));

		// Remove entries from CONFIG.SYS file
		DeleteLine(SetBootDrive(szConfigSys),(PSZ)szSDDHELP);
		DeleteLine(SetBootDrive(szConfigSys),(PSZ)szNoDDC);
		DeleteLine(SetBootDrive(szConfigSys),(PSZ)szGREXT);

		// Reboot the system
		WinMessageBox(HWND_DESKTOP,0,(PSZ)szReboot,(PSZ)szRebootTitle,0,MB_OK | MB_INFORMATION | MB_DEFBUTTON1 | MB_MOVEABLE);
		}
	WinDestroyMsgQueue(hmqQueue);
	WinTerminate(habAnchor);
	return 0;
}
