/* $Id: rexx.c,v 1.1 2000/03/27 04:52:57 ktk Exp $ */

/*
 *  rexx.c (C) 1999,2000 Brian Smith <dbsoft@technologist.com>
 *         (C) 2000 Achim Hasenmueller <achimha@innotek.de>
 */

#define INCL_WIN       /* Window Manager Functions     */
#define INCL_DOS
#define INCL_BASE
#define INCL_RXFUNC
#define INCL_RXMACRO
#define INCL_RXARI
#define INCL_RXSYSEXIT
#define INCL_RXSUBCOM
#define INCL_RXSHV

#include <os2.h>
#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <fcntl.h>
#include <process.h>
#include <sys/types.h>
#ifndef __EMX__
#include <rexxsaa.h>
#endif
#include "install.h"
#include "instsup.h"
#include "dw.h"
#include "picture.h"

extern HWND hwnddir, hwndentry, hwndcombo, hwndper, mainhwnd;
extern RexxCommands rexxcommands[];
extern char finishedscript[], installdir[], installdir2[];
extern int INSTALLER_PACKAGE_COUNT, packagesselected[], packagechosen;

RexxVar *root = NULL;

RexxVar *find_rexxvar(char *varname)
{
	RexxVar *tmp = root;

	while(tmp)
	{
		if(stricmp(tmp->varname, varname) == 0)
			return tmp;
		tmp = tmp->next;
	}
	return NULL;
}

int new_rexxvar(char *varname, RXSTRING rxstring)
{
	RexxVar *new = find_rexxvar(varname);

	if(new)
	{
		free(new->rxstring.strptr);
		memcpy(&new->rxstring, &rxstring, sizeof(RXSTRING));
		new->rxstring.strptr = strdup(rxstring.strptr);
        return TRUE;
	}
	else
	{
		new = malloc(sizeof(RexxVar));
		if(new)
		{
			new->varname = strdup(varname);
			memcpy(&new->rxstring, &rxstring, sizeof(RXSTRING));
			new->rxstring.strptr = strdup(rxstring.strptr);

			new->next = NULL;

			if (!root)
				root = new;
			else
			{
				RexxVar *prev = NULL, *tmp = root;
				while(tmp)
				{
					prev = tmp;
					tmp = tmp->next;
				}
				if(prev)
					prev->next = new;
				else
					root = new;
			}
			return TRUE;
		}
	}
	return FALSE;
}

int remove_rexxvar(char *varname)
{
	RexxVar *prev = NULL, *tmp = root;

	while(tmp)
	{
		if(stricmp(tmp->varname, varname) == 0)
		{
			if(!prev)
			{
                free(tmp->rxstring.strptr);
                free(tmp->varname);
				free(tmp);
				root = NULL;
				return 0;
			}
			else
			{
				prev->next = tmp->next;
                free(tmp->rxstring.strptr);
                free(tmp->varname);
				free(tmp);
				return 0;
			}
		}
		tmp = tmp->next;
	}
	return 0;
}

ULONG EXPENTRY rexx_dw_box_pack_start(PCSZ Name, ULONG ArgCount, RXSTRING Args[], PCSZ Queuename, PRXSTRING Retstr)
{
	if(ArgCount < 6)
		return 40;

	dw_box_pack_start((HWND)atol(Args[0].strptr),(HWND)atol(Args[1].strptr),(int)atoi(Args[2].strptr),
					  (int)atoi(Args[3].strptr),(int)atoi(Args[4].strptr),(int)atoi(Args[5].strptr));

	Retstr->strlength = 0;
	return 0;
}

ULONG EXPENTRY rexx_dw_box_pack_end(PCSZ Name, ULONG ArgCount, RXSTRING Args[], PCSZ Queuename, PRXSTRING Retstr)
{
	if(ArgCount < 6)
		return 40;

	dw_box_pack_end((HWND)atol(Args[0].strptr),(HWND)atol(Args[1].strptr),(int)atoi(Args[2].strptr),
					  (int)atoi(Args[3].strptr),(int)atoi(Args[4].strptr),(int)atoi(Args[5].strptr));

	Retstr->strlength = 0;
	return 0;
}

ULONG EXPENTRY rexx_dw_box_new(PCSZ Name, ULONG ArgCount, RXSTRING Args[], PCSZ Queuename, PRXSTRING Retstr)
{
	HWND handle;

	if(ArgCount < 2)
		return 40;

	handle = dw_box_new(atoi(Args[0].strptr),atoi(Args[1].strptr));

	sprintf(Retstr->strptr, "%lu", (ULONG)handle);

	Retstr->strlength = strlen(Retstr->strptr);
	return 0;
}

ULONG EXPENTRY rexx_dw_groupbox_new(PCSZ Name, ULONG ArgCount, RXSTRING Args[], PCSZ Queuename, PRXSTRING Retstr)
{
	HWND handle;

	if(ArgCount < 2)
		return 40;

	handle = dw_groupbox_new(atoi(Args[0].strptr),atoi(Args[1].strptr));

	sprintf(Retstr->strptr, "%lu", (ULONG)handle);

	Retstr->strlength = strlen(Retstr->strptr);
	return 0;
}

ULONG EXPENTRY rexx_dw_window_show(PCSZ Name, ULONG ArgCount, RXSTRING Args[], PCSZ Queuename, PRXSTRING Retstr)
{
	int ret;

	if(ArgCount < 1)
		return 40;

	ret = dw_window_show((HWND)atol(Args[0].strptr));

	sprintf(Retstr->strptr, "%d", ret);

	Retstr->strlength = strlen(Retstr->strptr);
	return 0;
}

ULONG EXPENTRY rexx_dw_window_hide(PCSZ Name, ULONG ArgCount, RXSTRING Args[], PCSZ Queuename, PRXSTRING Retstr)
{
	int ret;

	if(ArgCount < 1)
		return 40;

	ret = dw_window_hide((HWND)atol(Args[0].strptr));

	sprintf(Retstr->strptr, "%d", ret);

	Retstr->strlength = strlen(Retstr->strptr);
	return 0;
}

ULONG EXPENTRY rexx_dw_window_destroy(PCSZ Name, ULONG ArgCount, RXSTRING Args[], PCSZ Queuename, PRXSTRING Retstr)
{
	int ret;

	if(ArgCount < 1)
		return 40;

	ret = dw_window_destroy((HWND)atol(Args[0].strptr));

	sprintf(Retstr->strptr, "%d", ret);

	Retstr->strlength = strlen(Retstr->strptr);
	return 0;
}

ULONG EXPENTRY rexx_dw_window_set_font(PCSZ Name, ULONG ArgCount, RXSTRING Args[], PCSZ Queuename, PRXSTRING Retstr)
{
	int ret;

	if(ArgCount < 2)
		return 40;

	ret = dw_window_set_font((HWND)atol(Args[0].strptr), Args[1].strptr);

	sprintf(Retstr->strptr, "%d", ret);

	Retstr->strlength = strlen(Retstr->strptr);
	return 0;
}

ULONG EXPENTRY rexx_dw_window_set_color(PCSZ Name, ULONG ArgCount, RXSTRING Args[], PCSZ Queuename, PRXSTRING Retstr)
{
	int ret;

	if(ArgCount < 3)
		return 40;

	ret = dw_window_set_color((HWND)atol(Args[0].strptr), atol(Args[1].strptr), atol(Args[2].strptr));

	sprintf(Retstr->strptr, "%d", ret);

	Retstr->strlength = strlen(Retstr->strptr);
	return 0;
}

ULONG EXPENTRY rexx_dw_window_new(PCSZ Name, ULONG ArgCount, RXSTRING Args[], PCSZ Queuename, PRXSTRING Retstr)
{
	HWND handle;

	if(ArgCount < 3)
		return 40;

	handle = dw_window_new((HWND)atol(Args[0].strptr), Args[1].strptr, atol(Args[2].strptr));

	sprintf(Retstr->strptr, "%lu", (ULONG)handle);

	Retstr->strlength = strlen(Retstr->strptr);
	return 0;
}

ULONG EXPENTRY rexx_dw_bitmap_new(PCSZ Name, ULONG ArgCount, RXSTRING Args[], PCSZ Queuename, PRXSTRING Retstr)
{
	HWND handle;

	if(ArgCount < 1)
		return 40;

	handle = dw_bitmap_new(atol(Args[0].strptr));

	sprintf(Retstr->strptr, "%lu", (ULONG)handle);

	Retstr->strlength = strlen(Retstr->strptr);
	return 0;
}

ULONG EXPENTRY rexx_dw_slider_new(PCSZ Name, ULONG ArgCount, RXSTRING Args[], PCSZ Queuename, PRXSTRING Retstr)
{
	HWND handle;

	if(ArgCount < 1)
		return 40;

	handle = dw_slider_new(atol(Args[0].strptr));

	sprintf(Retstr->strptr, "%lu", (ULONG)handle);

	Retstr->strlength = strlen(Retstr->strptr);
	return 0;
}

ULONG EXPENTRY rexx_dw_container_new(PCSZ Name, ULONG ArgCount, RXSTRING Args[], PCSZ Queuename, PRXSTRING Retstr)
{
	HWND handle;

	if(ArgCount < 1)
		return 40;

	handle = dw_container_new(atol(Args[0].strptr));

	sprintf(Retstr->strptr, "%lu", (ULONG)handle);

	Retstr->strlength = strlen(Retstr->strptr);
	return 0;
}

ULONG EXPENTRY rexx_dw_text_new(PCSZ Name, ULONG ArgCount, RXSTRING Args[], PCSZ Queuename, PRXSTRING Retstr)
{
	HWND handle;

	if(ArgCount < 2)
		return 40;

	handle = dw_text_new(Args[0].strptr, atol(Args[1].strptr));

	sprintf(Retstr->strptr, "%lu", (ULONG)handle);

	Retstr->strlength = strlen(Retstr->strptr);
	return 0;
}

ULONG EXPENTRY rexx_dw_mle_new(PCSZ Name, ULONG ArgCount, RXSTRING Args[], PCSZ Queuename, PRXSTRING Retstr)
{
	HWND handle;

	if(ArgCount < 1)
		return 40;

	handle = dw_mle_new(atol(Args[0].strptr));

	sprintf(Retstr->strptr, "%lu", (ULONG)handle);

	Retstr->strlength = strlen(Retstr->strptr);
	return 0;
}

ULONG EXPENTRY rexx_dw_entryfield_new(PCSZ Name, ULONG ArgCount, RXSTRING Args[], PCSZ Queuename, PRXSTRING Retstr)
{
	HWND handle;

	if(ArgCount < 2)
		return 40;

	handle = dw_entryfield_new(Args[0].strptr, atol(Args[1].strptr));

	sprintf(Retstr->strptr, "%lu", (ULONG)handle);

	Retstr->strlength = strlen(Retstr->strptr);
	return 0;
}

ULONG EXPENTRY rexx_dw_combobox_new(PCSZ Name, ULONG ArgCount, RXSTRING Args[], PCSZ Queuename, PRXSTRING Retstr)
{
	HWND handle;

	if(ArgCount < 2)
		return 40;

	handle = dw_combobox_new(Args[0].strptr, atol(Args[1].strptr));

	sprintf(Retstr->strptr, "%lu", (ULONG)handle);

	Retstr->strlength = strlen(Retstr->strptr);
	return 0;
}

ULONG EXPENTRY rexx_dw_button_new(PCSZ Name, ULONG ArgCount, RXSTRING Args[], PCSZ Queuename, PRXSTRING Retstr)
{
	HWND handle;

	if(ArgCount < 2)
		return 40;

	handle = dw_button_new(Args[0].strptr, atol(Args[1].strptr));

	sprintf(Retstr->strptr, "%lu", (ULONG)handle);

	Retstr->strlength = strlen(Retstr->strptr);
	return 0;
}

ULONG EXPENTRY rexx_dw_spinbutton_new(PCSZ Name, ULONG ArgCount, RXSTRING Args[], PCSZ Queuename, PRXSTRING Retstr)
{
	HWND handle;

	if(ArgCount < 2)
		return 40;

	handle = dw_spinbutton_new(Args[0].strptr, atol(Args[1].strptr));

	sprintf(Retstr->strptr, "%lu", (ULONG)handle);

	Retstr->strlength = strlen(Retstr->strptr);
	return 0;
}

ULONG EXPENTRY rexx_dw_checkbox_new(PCSZ Name, ULONG ArgCount, RXSTRING Args[], PCSZ Queuename, PRXSTRING Retstr)
{
	HWND handle;

	if(ArgCount < 2)
		return 40;

	handle = dw_checkbox_new(Args[0].strptr, atol(Args[1].strptr));

	sprintf(Retstr->strptr, "%lu", (ULONG)handle);

	Retstr->strlength = strlen(Retstr->strptr);
	return 0;
}

ULONG EXPENTRY rexx_dw_listbox_new(PCSZ Name, ULONG ArgCount, RXSTRING Args[], PCSZ Queuename, PRXSTRING Retstr)
{
	HWND handle;

	if(ArgCount < 1)
		return 40;

	handle = dw_listbox_new(atol(Args[0].strptr));

	sprintf(Retstr->strptr, "%lu", (ULONG)handle);

	Retstr->strlength = strlen(Retstr->strptr);
	return 0;
}

ULONG EXPENTRY rexx_dw_window_set_usize(PCSZ Name, ULONG ArgCount, RXSTRING Args[], PCSZ Queuename, PRXSTRING Retstr)
{
	if(ArgCount < 3)
		return 40;

	dw_window_set_usize((HWND)atol(Args[0].strptr),atol(Args[1].strptr),atol(Args[2].strptr));

	Retstr->strlength = 0;
	return 0;
}

ULONG EXPENTRY rexx_dw_window_set_pos_size(PCSZ Name, ULONG ArgCount, RXSTRING Args[], PCSZ Queuename, PRXSTRING Retstr)
{
	if(ArgCount < 5)
		return 40;

	dw_window_set_pos_size((HWND)atol(Args[0].strptr),atol(Args[1].strptr),atol(Args[2].strptr),atol(Args[3].strptr),atol(Args[4].strptr));

	Retstr->strlength = 0;
	return 0;
}

ULONG EXPENTRY rexx_dw_window_set_style(PCSZ Name, ULONG ArgCount, RXSTRING Args[], PCSZ Queuename, PRXSTRING Retstr)
{
	if(ArgCount < 3)
		return 40;

	dw_window_set_style((HWND)atol(Args[0].strptr),atol(Args[1].strptr),atol(Args[2].strptr));

	Retstr->strlength = 0;
	return 0;
}

ULONG EXPENTRY rexx_dw_window_set_icon(PCSZ Name, ULONG ArgCount, RXSTRING Args[], PCSZ Queuename, PRXSTRING Retstr)
{
	if(ArgCount < 2)
		return 40;

	dw_window_set_icon((HWND)atol(Args[0].strptr),atol(Args[1].strptr));

	Retstr->strlength = 0;
	return 0;
}

ULONG EXPENTRY rexx_dw_window_set_bitmap(PCSZ Name, ULONG ArgCount, RXSTRING Args[], PCSZ Queuename, PRXSTRING Retstr)
{
	if(ArgCount < 2)
		return 40;

	dw_window_set_bitmap((HWND)atol(Args[0].strptr),atol(Args[1].strptr));

	Retstr->strlength = 0;
	return 0;
}

ULONG EXPENTRY rexx_dw_window_set_text(PCSZ Name, ULONG ArgCount, RXSTRING Args[], PCSZ Queuename, PRXSTRING Retstr)
{
	if(ArgCount < 2)
		return 40;

	dw_window_set_text((HWND)atol(Args[0].strptr),Args[1].strptr);

	Retstr->strlength = 0;
	return 0;
}

ULONG EXPENTRY rexx_dw_window_disable(PCSZ Name, ULONG ArgCount, RXSTRING Args[], PCSZ Queuename, PRXSTRING Retstr)
{
	if(ArgCount < 1)
		return 40;

	dw_window_disable((HWND)atol(Args[0].strptr));

	Retstr->strlength = 0;
	return 0;
}

ULONG EXPENTRY rexx_dw_window_enable(PCSZ Name, ULONG ArgCount, RXSTRING Args[], PCSZ Queuename, PRXSTRING Retstr)
{
	if(ArgCount < 1)
		return 40;

	dw_window_enable((HWND)atol(Args[0].strptr));

	Retstr->strlength = 0;
	return 0;
}

ULONG EXPENTRY rexx_dw_window_set_pos(PCSZ Name, ULONG ArgCount, RXSTRING Args[], PCSZ Queuename, PRXSTRING Retstr)
{
	if(ArgCount < 3)
		return 40;

	dw_window_set_pos((HWND)atol(Args[0].strptr),atol(Args[1].strptr),atol(Args[2].strptr));

	Retstr->strlength = 0;
	return 0;
}

ULONG EXPENTRY rexx_dw_screen_width(PCSZ Name, ULONG ArgCount, RXSTRING Args[], PCSZ Queuename, PRXSTRING Retstr)
{
	sprintf(Retstr->strptr, "%lu", (ULONG)dw_screen_width());

	Retstr->strlength = strlen(Retstr->strptr);
	return 0;
}

ULONG EXPENTRY rexx_dw_screen_height(PCSZ Name, ULONG ArgCount, RXSTRING Args[], PCSZ Queuename, PRXSTRING Retstr)
{
	sprintf(Retstr->strptr, "%lu", (ULONG)dw_screen_height());

	Retstr->strlength = strlen(Retstr->strptr);
	return 0;
}

ULONG EXPENTRY rexx_bitmapfile_new(PCSZ Name, ULONG ArgCount, RXSTRING Args[], PCSZ QueueName, PRXSTRING Retstr)
{
	HWND handle;
	if (ArgCount != 1)
		return 40;
	handle = dw_bitmapfile_new(atol(Args[0].strptr));
	sprintf(Retstr->strptr, "%lu", (ULONG)handle);

	Retstr->strlength = strlen(Retstr->strptr);
	return 0;
}

ULONG EXPENTRY rexx_bitmapfile_set_bitmap(PCSZ Name, ULONG ArgCount, RXSTRING Args[], PCSZ QueueName, PRXSTRING Retstr)
{
	if (ArgCount != 2)
		return 40;
	dw_bitmapfile_set_bitmap(atol(Args[0].strptr), Args[1].strptr);
	Retstr->strlength = 0;
	return 0;
}

ULONG EXPENTRY rexx_grabfile(PCSZ Name, ULONG ArgCount, RXSTRING Args[], PCSZ Queuename, PRXSTRING Retstr)
{
	if(ArgCount < 1)
		return 40;

	grabfile(Args[0].strptr);

	Retstr->strlength = 0;
	return 0;
}

ULONG EXPENTRY rexx_viewfile(PCSZ Name, ULONG ArgCount, RXSTRING Args[], PCSZ Queuename, PRXSTRING Retstr)
{
	static char viewfilename[1024];

	if(ArgCount < 1)
		return 40;

	strcpy(viewfilename, Args[0].strptr);
	_beginthread(readme, NULL, THREAD_STACK_SIZE, (void *)viewfilename);

	Retstr->strlength = 0;
	return 0;
}

ULONG EXPENTRY rexx_mleview(PCSZ Name, ULONG ArgCount, RXSTRING Args[], PCSZ Queuename, PRXSTRING Retstr)
{
	FILE *f;
	ULONG bytes, point = -1;
	char buffer[1024];
    HWND hwndMLE;

	if(ArgCount < 2)
		return 40;

	hwndMLE = (HWND)atol(Args[1].strptr);

	grabfile(Args[0].strptr);

	if((f = fopen(Args[0].strptr, "rb"))!= NULL)
	{
		WinSendMsg(hwndMLE, MLM_SETIMPORTEXPORT, MPFROMP(buffer), MPFROMLONG(1024L));
		while(!feof(f))
		{
			bytes = fread(buffer, 1, 1024, f);
			WinSendMsg(hwndMLE, MLM_IMPORT, MPFROMP(&point), MPFROMLONG(bytes));
		}
		fclose(f);
		remove(Args[0].strptr);
	}
	Retstr->strlength = 0;
    return 0;
}

ULONG EXPENTRY rexx_setwindow(PCSZ Name, ULONG ArgCount, RXSTRING Args[], PCSZ Queuename, PRXSTRING Retstr)
{
	if(ArgCount < 1)
		return 40;

	mainhwnd = (HWND)atol(Args[0].strptr);

	return 0;
}

ULONG EXPENTRY rexx_setdircontainer(PCSZ Name, ULONG ArgCount, RXSTRING Args[], PCSZ Queuename, PRXSTRING Retstr)
{
   int j, count = 0;
   unsigned long spacefree;
   char buffer[256];
   extern int drivelist[26];


	if(ArgCount < 3)
		return 40;

	hwnddir = (HWND)atol(Args[0].strptr);
	hwndentry = (HWND)atol(Args[1].strptr);
	hwndcombo = (HWND)atol(Args[2].strptr);

    setdir(hwnddir);
	populatedir(hwnddir);

	for(j=3;j<27;j++)
	{
		spacefree = drivefree(j);
		if(spacefree > 0)
		{
			drivelist[count] = j;
			count++;
			sprintf(buffer, "Drive %c: %lu megabytes free.", ('A'+j)-1, spacefree);
			WinSendMsg(hwndcombo, LM_INSERTITEM, MPFROMSHORT(LIT_END), MPFROMP(buffer));
		}
	}
	WinSendMsg(hwndcombo, LM_SELECTITEM, MPFROMSHORT(0), MPFROMSHORT(TRUE));

	Retstr->strlength = 0;
    return 0;
}

ULONG EXPENTRY rexx_setslider(PCSZ Name, ULONG ArgCount, RXSTRING Args[], PCSZ Queuename, PRXSTRING Retstr)
{

	if(ArgCount < 1)
		return 40;

	hwndper = (HWND)atol(Args[0].strptr);

	Retstr->strlength = 0;
    return 0;
}

ULONG EXPENTRY rexx_setbutton(PCSZ Name, ULONG ArgCount, RXSTRING Args[], PCSZ Queuename, PRXSTRING Retstr)
{
	int b;

	if(ArgCount < 2)
		return 40;

	for(b=0;b<COMMANDMAX;b++)
	{
		if(!rexxcommands[b].id)
		{
			rexxcommands[b].id = atoi(Args[0].strptr);
			strcpy(rexxcommands[b].file, Args[1].strptr);
            b = COMMANDMAX;
		}
	}

	Retstr->strlength = 0;
	return 0;
}

ULONG EXPENTRY rexx_start(PCSZ Name, ULONG ArgCount, RXSTRING Args[], PCSZ Queuename, PRXSTRING Retstr)
{
	if(ArgCount < 1)
		return 40;

	strcpy(finishedscript, Args[0].strptr);

	_beginthread(install_thread, NULL, THREAD_STACK_SIZE, NULL);

	Retstr->strlength = 0;
	return 0;
}

ULONG EXPENTRY rexx_packages(PCSZ Name, ULONG ArgCount, RXSTRING Args[], PCSZ Queuename, PRXSTRING Retstr)
{
	if(ArgCount < 0)
		return 40;

	if(INSTALLER_PACKAGE_COUNT > 2)
	{
		if(WinDlgBox(HWND_DESKTOP, HWND_DESKTOP, &PackageDlgProc, NULLHANDLE, DLG_PACKAGESTOINSTALL, NULL) == DID_ERROR || packagechosen == FALSE)
		{
			if(packagechosen == FALSE)
			{
				mesg("No packages selected for installation!");
			}
		}
	}
	else
		packagesselected[1] = TRUE;

	Retstr->strlength = 0;
	return 0;
}

ULONG EXPENTRY rexx_updateentry(PCSZ Name, ULONG ArgCount, RXSTRING Args[], PCSZ Queuename, PRXSTRING Retstr)
{
	if(ArgCount < 0)
		return 40;

	WinQueryWindowText(hwndentry, 400, installdir2);
	strcpy(installdir, installdir2);

	Retstr->strlength = 0;
	return 0;
}

ULONG EXPENTRY rexx_savevar(PCSZ Name, ULONG ArgCount, RXSTRING Args[], PCSZ Queuename, PRXSTRING Retstr)
{
	if(ArgCount < 2)
		return 40;

    new_rexxvar(Args[0].strptr, Args[1]);

	Retstr->strlength = 0;
	return 0;
}

ULONG EXPENTRY rexx_removevar(PCSZ Name, ULONG ArgCount, RXSTRING Args[], PCSZ Queuename, PRXSTRING Retstr)
{
	if(ArgCount < 1)
		return 40;

    remove_rexxvar(Args[0].strptr);

	Retstr->strlength = 0;
	return 0;
}

ULONG EXPENTRY rexx_findvar(PCSZ Name, ULONG ArgCount, RXSTRING Args[], PCSZ Queuename, PRXSTRING Retstr)
{
	RexxVar *tmp;

	if(ArgCount < 1)
		return 40;


    tmp = find_rexxvar(Args[0].strptr);
	if(tmp)
	{
		Retstr->strptr = tmp->rxstring.strptr;
		Retstr->strlength = tmp->rxstring.strlength;
	}
	else
	{
		Retstr->strptr = NULL;
		Retstr->strlength = 0;
	}

	return 0;
}

ULONG EXPENTRY rexx_mesg(PCSZ Name, ULONG ArgCount, RXSTRING Args[], PCSZ Queuename, PRXSTRING Retstr)
{
	if(ArgCount < 1)
		return 40;

    mesg(Args[0].strptr);

	Retstr->strlength = 0;
	return 0;
}

ULONG EXPENTRY rexx_querycheck(PCSZ Name, ULONG ArgCount, RXSTRING Args[], PCSZ Queuename, PRXSTRING Retstr)
{
	HWND checkbox;
	extern HAB hab;

	if(ArgCount < 1)
		return 40;

	checkbox  = (HWND)atol(Args[0].strptr);

	if(!WinIsWindow(hab, checkbox))
	{
		Retstr->strptr = strdup("-1");
		Retstr->strlength = 2;
        return 0;
	}
	if(WinSendMsg(checkbox,BM_QUERYCHECK,0,0))
        Retstr->strptr = strdup("1");
	else
        Retstr->strptr = strdup("0");

	Retstr->strlength = 1;
	return 0;
}

ULONG EXPENTRY rexx_setdir(PCSZ Name, ULONG ArgCount, RXSTRING Args[], PCSZ QueueName, PRXSTRING Retstr)
{
	if (ArgCount != 1)
		return 40;
	strcpy(installdir2, Args[0].strptr);
	Retstr->strptr = NULL;
	Retstr->strlength = 0;
	return 0;	
}

ULONG EXPENTRY rexx_querytext(PCSZ Name, ULONG ArgCount, RXSTRING Args[], PCSZ QueueName, PRXSTRING Retstr)
{
	if (ArgCount != 1)
		return 40;
	WinQueryWindowText(atol(Args[0].strptr), 254, Retstr->strptr);
	Retstr->strlength = strlen(Retstr->strptr);
	return 0;
}

void rexx_init(void)
{
	RexxRegisterFunctionExe("dw_box_pack_start", &rexx_dw_box_pack_start);
	RexxRegisterFunctionExe("dw_box_pack_end", &rexx_dw_box_pack_end);
	RexxRegisterFunctionExe("dw_box_new", &rexx_dw_box_new);
	RexxRegisterFunctionExe("dw_groupbox_new", &rexx_dw_groupbox_new);
	RexxRegisterFunctionExe("dw_window_hide", &rexx_dw_window_hide);
	RexxRegisterFunctionExe("dw_window_show", &rexx_dw_window_show);
	RexxRegisterFunctionExe("dw_window_destroy", &rexx_dw_window_destroy);
	RexxRegisterFunctionExe("dw_window_set_font", &rexx_dw_window_set_font);
	RexxRegisterFunctionExe("dw_window_set_color", &rexx_dw_window_set_color);
	RexxRegisterFunctionExe("dw_window_new", &rexx_dw_window_new);
	RexxRegisterFunctionExe("dw_bitmap_new", &rexx_dw_bitmap_new);
	RexxRegisterFunctionExe("dw_container_new", &rexx_dw_container_new);
	RexxRegisterFunctionExe("dw_text_new", &rexx_dw_text_new);
	RexxRegisterFunctionExe("dw_mle_new", &rexx_dw_mle_new);
	RexxRegisterFunctionExe("dw_entryfield_new", &rexx_dw_entryfield_new);
	RexxRegisterFunctionExe("dw_combobox_new", &rexx_dw_combobox_new);
	RexxRegisterFunctionExe("dw_button_new", &rexx_dw_button_new);
	RexxRegisterFunctionExe("dw_spinbutton_new", &rexx_dw_spinbutton_new);
	RexxRegisterFunctionExe("dw_slider_new", &rexx_dw_slider_new);
	RexxRegisterFunctionExe("dw_checkbox_new", &rexx_dw_checkbox_new);
	RexxRegisterFunctionExe("dw_listbox_new", &rexx_dw_listbox_new);
	RexxRegisterFunctionExe("dw_window_set_pos", &rexx_dw_window_set_pos);
	RexxRegisterFunctionExe("dw_window_set_usize", &rexx_dw_window_set_usize);
	RexxRegisterFunctionExe("dw_window_set_pos_size", &rexx_dw_window_set_pos_size);
	RexxRegisterFunctionExe("dw_window_set_style", &rexx_dw_window_set_style);
	RexxRegisterFunctionExe("dw_window_set_icon", &rexx_dw_window_set_icon);
	RexxRegisterFunctionExe("dw_window_set_bitmap", &rexx_dw_window_set_bitmap);
	RexxRegisterFunctionExe("dw_window_set_text", &rexx_dw_window_set_text);
	RexxRegisterFunctionExe("dw_window_enable", &rexx_dw_window_enable);
	RexxRegisterFunctionExe("dw_window_disable", &rexx_dw_window_disable);
	RexxRegisterFunctionExe("dw_screen_width", &rexx_dw_screen_width);
	RexxRegisterFunctionExe("dw_screen_height", &rexx_dw_screen_height);
	RexxRegisterFunctionExe("dw_bitmapfile_new", &rexx_bitmapfile_new);
	RexxRegisterFunctionExe("dw_bitmapfile_set_bitmap", &rexx_bitmapfile_set_bitmap);
	RexxRegisterFunctionExe("inst_grabfile", &rexx_grabfile);
	RexxRegisterFunctionExe("inst_viewfile", &rexx_viewfile);
	RexxRegisterFunctionExe("inst_mleview", &rexx_mleview);
	RexxRegisterFunctionExe("inst_setdircontainer", &rexx_setdircontainer);
	RexxRegisterFunctionExe("inst_setwindow", &rexx_setwindow);
	RexxRegisterFunctionExe("inst_setbutton", &rexx_setbutton);
	RexxRegisterFunctionExe("inst_setslider", &rexx_setslider);
	RexxRegisterFunctionExe("inst_start", &rexx_start);
	RexxRegisterFunctionExe("inst_packages", &rexx_packages);
	RexxRegisterFunctionExe("inst_updateentry", &rexx_updateentry);
	RexxRegisterFunctionExe("inst_savevar", &rexx_savevar);
	RexxRegisterFunctionExe("inst_removevar", &rexx_removevar);
	RexxRegisterFunctionExe("inst_findvar", &rexx_findvar);
	RexxRegisterFunctionExe("inst_mesg", &rexx_mesg);
	RexxRegisterFunctionExe("inst_querycheck", &rexx_querycheck);
	RexxRegisterFunctionExe("inst_setdir", &rexx_setdir);
	RexxRegisterFunctionExe("inst_querytext", &rexx_querytext);
}

void rexx_deinit(void)
{
	RexxDeregisterFunction("dw_box_pack_start");
	RexxDeregisterFunction("dw_box_pack_end");
	RexxDeregisterFunction("dw_box_new");
	RexxDeregisterFunction("dw_groupbox_new");
	RexxDeregisterFunction("dw_window_show");
	RexxDeregisterFunction("dw_window_hide");
	RexxDeregisterFunction("dw_window_destroy");
	RexxDeregisterFunction("dw_window_set_font");
	RexxDeregisterFunction("dw_window_set_color");
	RexxDeregisterFunction("dw_window_new");
	RexxDeregisterFunction("dw_bitmap_new");
	RexxDeregisterFunction("dw_container_new");
	RexxDeregisterFunction("dw_text_new");
	RexxDeregisterFunction("dw_mle_new");
	RexxDeregisterFunction("dw_entryfield_new");
	RexxDeregisterFunction("dw_combobox_new");
	RexxDeregisterFunction("dw_button_new");
	RexxDeregisterFunction("dw_spinbutton_new");
	RexxDeregisterFunction("dw_slider_new");
	RexxDeregisterFunction("dw_checkbox_new");
	RexxDeregisterFunction("dw_listbox_new");
	RexxDeregisterFunction("dw_window_set_pos");
	RexxDeregisterFunction("dw_window_set_usize");
	RexxDeregisterFunction("dw_window_set_pos_size");
	RexxDeregisterFunction("dw_window_set_style");
	RexxDeregisterFunction("dw_window_set_icon");
	RexxDeregisterFunction("dw_window_set_bitmap");
	RexxDeregisterFunction("dw_window_set_text");
	RexxDeregisterFunction("dw_window_enable");
	RexxDeregisterFunction("dw_window_disable");
	RexxDeregisterFunction("dw_screen_width");
	RexxDeregisterFunction("dw_screen_height");
	RexxDeregisterFunction("dw_bitmapfile_new");
	RexxDeregisterFunction("dw_bitmapfile_set_bitmap");
	RexxDeregisterFunction("inst_grabfile");
	RexxDeregisterFunction("inst_viewfile");
	RexxDeregisterFunction("inst_mleview");
	RexxDeregisterFunction("inst_setdircontainer");
	RexxDeregisterFunction("inst_setwindow");
	RexxDeregisterFunction("inst_setbutton");
	RexxDeregisterFunction("inst_setslider");
	RexxDeregisterFunction("inst_start");
	RexxDeregisterFunction("inst_packages");
	RexxDeregisterFunction("inst_updateentry");
	RexxDeregisterFunction("inst_savevar");
	RexxDeregisterFunction("inst_removevar");
	RexxDeregisterFunction("inst_findvar");
	RexxDeregisterFunction("inst_mesg");
	RexxDeregisterFunction("inst_querycheck");
	RexxDeregisterFunction("inst_setdir");
	RexxDeregisterFunction("inst_querytext");
}

int rexx_run(char *filename)
{
	LONG rc;
	SHORT retCode;
	RXSTRING rxString;
	RXSTRING args[1];
	char tmpbuffer[50];
	int b;

	if(stricmp(filename, "exit") == 0)
	{
        rexx_deinit();
		WinSendMsg(mainhwnd, WM_QUIT, 0, 0);
        exit(0);
		return 0;
	}

	for(b=0;b<COMMANDMAX;b++)
	{
		rexxcommands[b].id = 0;
		rexxcommands[b].file[0] = 0;
	}

	rxString.strlength = 0;
	rxString.strptr = NULL;

	sprintf(tmpbuffer, "%lu", (ULONG)mainhwnd);
	args[0].strlength = strlen(tmpbuffer);
	args[0].strptr = malloc(args[0].strlength+1);
	strcpy(args[0].strptr, tmpbuffer);

	grabfile(filename);

	rc = RexxStart(1, args, filename, NULL, NULL, RXCOMMAND, NULL, &retCode, &rxString);

	free(args[0].strptr);

	remove(filename);

	return retCode;
}