/* $Id: install.c,v 1.1 2000/03/27 04:52:54 ktk Exp $ */

/*
 *  install.c (c) 1998,1999 Brian Smith
 *  parts by Daniele Vistalli
 */

#define INCL_WIN       /* Window Manager Functions     */
#define INCL_DOS
#define INCL_BASE
#define INCL_RXFUNC
#define INCL_RXMACRO
#define INCL_RXARI
#define INCL_RXSYSEXIT
#define INCL_RXSUBCOM
#define INCL_RXSHV

#include <os2.h>
#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <fcntl.h>
#include <process.h>
#include <sys/types.h>
#ifndef __EMX__
#include <rexxsaa.h>
#endif
#include "install.h"
#include "instsup.h"
#include "dw.h"

#ifndef	OS2_VER
#define OS2_VER	"7.0.0"
#endif

#define ENABLE_LOGGING

/* My Global variables ;) unusually many due to multiple dialogs */
HAB hab = 0;
HMQ hmq = 0;
HPS hps = 0;
HDC hdc = 0;
HBITMAP hbm = 0;
POINTL bmppoint;
SIZEL sizl;
QMSG qmsg = { 0 };
HWND mainhwnd = 0, logohwnd = 0;
char tempPath[_MAX_PATH];
int installstate = NONE;
int installstage = 0;
int current_file=0, success=0;
unsigned long int acepos=0, aceoffset=0;
int pixels=0;
char confirmstring[1024];
/* I know I am being excessive but... better safe than sorry ;) */
char *configsys[8196];
int configfilecount=-1;
int files = 0, files_deleted=0, packagesize=0, packagesselected[20];
/* Global flags often set by the user */
int driveselected, packagechosen, express = 1, driverstatus = -1, no_update = 0;
int licensechecked = 0, custom = 0, checkforupdate = 1, downloadsite = 0;
int usescitech = 1, usecurrent = 0, checking = 0, checkerror = 0, newerver = 0;
char sddfilename[256] = "",  sddversion[256] = "",  sdddate[256] = "";
char sddurl[4][256] = { "", "", "", "" };

/* So these are accessible to REXX */
int drivelist[26];
HWND hwnddir, hwndentry, hwndcombo, hwndper;
FILE *self;
RexxCommands rexxcommands[COMMANDMAX];
char finishedscript[100] = "";

/* These get loaded in loadheader */
char *INSTALLER_APPLICATION;
char *INSTALLER_VERSION;
char *INSTALLER_TITLE;
char *INSTALLER_PATH;
char *INSTALLER_FOLDER;
char *INSTALLER_PROGRAM;
char *INSTALLER_SHADOW;
char *INSTALLER_OBJECT;
char *INSTALLER_SETS;
char *INSTALLER_SYSVAR;
char *INSTALLER_SYSLINE;
char *INSTALLER_PACKAGES[20];
char *INSTALLER_CONFIRM_WPS;
char *INSTALLER_CONFIRM_CONFIGSYS;
char *INSTALLER_CONFIRM_OVERWRITE;
int INSTALLER_PACKAGE_COUNT;

#define T_BINARY     3

int (*ftpget)(char *, char *, char *, char *, char *, char *, char *, int);
int ftpgetfound = 0;

/* Config.Sys -- Note the drive letter gets replaced with the boot drive letter
                 It is just a place holder. (For the next 3 entries)             */
char csfile[] = "C:\\CONFIG.SYS";
/* Backup Config.Sys filename */
char bufile[] = "C:\\CONFIG.SDD";
/* Installation Log Database -- Used for uninstallation and aborting */
char instlog[] = "C:\\OS2\\INSTALL\\DBINST.LOG";
#ifdef SDDINST
/* Where SDD will be installed */
char installdir[] = "C:\\";
#else
char installdir[400];
#endif

char bootdrive[2] = "C";
char winpath[400] = "C:\\OS2\\MDOS\\WINOS2";
char winjpath[400] = "C:\\OS2\\MDOS\\WINJOS2";
char wintpath[400] = "C:\\OS2\\MDOS\\WINTOS2";
char winhpath[400] = "C:\\OS2\\MDOS\\WINHOS2";
char browsedir[400] = "C:\\";
char installdir2[400] = "";
char empty_string[] = "";
char currentcf[400] = "";

#ifdef ENABLE_LOGGING
FILE *logfile;
#endif

/* Function prototypes */
int installer_unpack(CHAR * filename, int operation);
void MakeShadow(char Title[], char reference[], char dest[], char id[]);
void MakeProgram(char Title[], char Program[], char Icon[], char dest[], char id[], char setup[]);
void MakeFolder(char Title[], char Icon[], char dest[], char id[], char setup[]);
void MakeObject(char Title[], char oclass[], char dest[], char id[], char setup[]);
void resetglobals(void);
int detect(int argc, char *argv[]);

typedef struct _replacements {
	char *replacestring, *replacevar;
} Replacements;

/* The variables in this array must be static buffers */
Replacements InstRep[] = {
	{ "%INSTALLPATH%",   installdir },
	{ "%BOOTDRIVE%",     bootdrive },
	{ "%ANYSTRING%",     empty_string },
	{ "%WINPATH%",       winpath },
	{ "%WINJPATH%",      winjpath },
	{ "%WINTPATH%",      wintpath },
	{ "%WINHPATH%",      winhpath },
	{ "%USERPATH%",      installdir2 },
	{ "%VERSION%",       OS2_VER },
	{ "%WEB_VER%",       sddversion },
	{ "%WEB_DATE%",      sdddate },
	{ "%WEB_LOCATION1%", sddurl[0] },
	{ "%WEB_LOCATION2%", sddurl[1] },
	{ "%WEB_LOCATION3%", sddurl[2] },
	{ "%WEB_LOCATION4%", sddurl[3] },
	{ "%PRI%",           "SVGA" }
};
int replacemax = 16;

typedef struct _cnrentry {
   RECORDCORE   rc;
   HPOINTER hptrIcon;
   char *filename;
   } CnrEntry;

/* In str1, str2 gets replaced by str3 */
char *replacestr(char *str1, char *str2, char *str3)
{
	char bigbuffer[4096];
	int z, x=0, len1 = strlen(str1), len2 = strlen(str2), len3 = strlen(str3);

	for(z=0;z<len1;z++)
	{
		if(len2 > 0 && strncmp(&str1[z], str2, len2)==0)
		{
			int i;
			for(i=0;i<len3;i++)
			{
				bigbuffer[x] = str3[i];
				x++;
			}
			z=z+(len2-1);
		} else {
			bigbuffer[x] = str1[z];
			x++;
		}
	}
	bigbuffer[x] = 0;
	return (char *)strdup(bigbuffer);
}

/* This function parses a string and replaces all the text in the
 * Replacement array with the current dynamic text */
char *replaceem(char *orig)
{
	char *tmp1 = NULL, *tmp2 = (char *)strdup(orig);
	int z;

	for(z=0;z<replacemax;z++)
	{
		tmp1 = replacestr(tmp2, InstRep[z].replacestring, InstRep[z].replacevar);
		free(tmp2);
		tmp2 = tmp1;
        tmp1 = NULL;
	}
    return tmp2;
}

/*
 * Find the offset withing the executable of the ace data for use.
 */
int aceseek_entry(int num)
{
	long headerstart;
	char headerbuf[20], packageconfig[100];
	int z, start = 0, entry = 0, packageoffset=0;
	/* Decode DBSOFT-ACE - small memleak but
	 * install should not be running for very long. :) */
	sprintf(headerbuf, "%s%d", decode("EEECFDEPEGFECNEBEDEF"), num);
	if((headerstart = findtext(headerbuf)) < 0)
	{
		mesg("Could not find ACE header in executable.");
		exit(2);
	}

	fseek(self, headerstart+strlen(headerbuf), SEEK_SET);
	fread(packageconfig, 1, 100, self);

	for(z=0;z<100;z++)
	{
		if(packageconfig[z] == '-' || packageconfig[z] == '~')
		{
			char cur = packageconfig[z];
			packageconfig[z] = 0;
			switch(entry)
			{
			case 0:
				current_file = 0;
				files = atoi(&packageconfig[start]);
				break;
			case 1:
				packagesize = atoi(&packageconfig[start]);
				break;
			}
			start = z+1;
			if(cur == '~')
			{
				packageoffset = z + 1;
				z = 100;
			}
			entry++;
		}
	}
	aceoffset=headerstart+strlen(headerbuf)+packageoffset;
	fseek(self, aceoffset, SEEK_SET);
	return TRUE;
}

/*
 * Reads the embedded .cfg data from the executable and place it in the global
 * INSTALL_* variables for use.
 */
int loadheader(void)
{
	char *buffer;
	long headerstart;
	int z, start=0, entry=0;

	buffer = malloc(8096*4);

    /* Decode DBSOFT-HEADER */
	if((headerstart = findtext(decode("EEECFDEPEGFECNEIEFEBEEEFFC"))) < 0)
	{
		mesg("Could not find Selfinstaller header in executable.");
		exit(2);
	}
	fseek(self, headerstart+13, SEEK_SET);

	fread(buffer, 1, 8096*4, self);
	for(z=0;z<8096*4;z++)
	{
		if(buffer[z] == '-' || buffer[z] == '~')
		{
			char cur = buffer[z];
			buffer[z] = 0;
			switch(entry)
			{
			case 0:
				INSTALLER_APPLICATION = (char *)strdup(&buffer[start]);
				break;
			case 1:
				INSTALLER_VERSION = (char *)strdup(&buffer[start]);
				break;
			case 2:
				INSTALLER_TITLE = (char *)strdup(&buffer[start]);
				break;
			case 3:
				INSTALLER_PATH = (char *)strdup(&buffer[start]);
				break;
			case 4:
				INSTALLER_FOLDER = (char *)strdup(&buffer[start]);
				break;
			case 5:
				INSTALLER_PROGRAM = (char *)strdup(&buffer[start]);
				break;
			case 6:
				INSTALLER_SHADOW = (char *)strdup(&buffer[start]);
				break;
			case 7:
				INSTALLER_OBJECT = (char *)strdup(&buffer[start]);
				break;
			case 8:
				INSTALLER_SETS = (char *)strdup(&buffer[start]);
				break;
			case 9:
				INSTALLER_SYSVAR = (char *)strdup(&buffer[start]);
				break;
			case 10:
				INSTALLER_SYSLINE = (char *)strdup(&buffer[start]);
				break;
			case 11:
				INSTALLER_CONFIRM_WPS = (char *)strdup(&buffer[start]);
				break;
			case 12:
				INSTALLER_CONFIRM_CONFIGSYS = (char *)strdup(&buffer[start]);
				break;
			case 13:
				INSTALLER_CONFIRM_OVERWRITE = (char *)strdup(&buffer[start]);
				break;
			case 14:
				INSTALLER_PACKAGE_COUNT = atoi(&buffer[start]);
				break;
			default:
				INSTALLER_PACKAGES[entry-15] = malloc((z-start)+1);
				strcpy(INSTALLER_PACKAGES[entry-15], &buffer[start]);
				break;
			}
			start = z+1;
			if(cur == '~')
			{
                free(buffer);
				return TRUE;
			}

			entry++;
		}
	}
	free(buffer);
	return FALSE;
}

/*
 * Functions to work on an ace file embedded within the archive in an
 * abstract manner.
 */
int aceread(void *buf, size_t count)
{
	unsigned long curpos = ftell(self);
	size_t readit;

	if(count >  (packagesize-(curpos-aceoffset)))
		readit = (packagesize-(curpos-aceoffset));
	else
		readit = count;

	return fread(buf, 1, readit, self);
}

off_t acelseek(off_t offset, int whence)
{
	switch(whence)
	{
	case SEEK_SET:
		fseek(self, aceoffset+offset, SEEK_SET);
		break;
	case SEEK_CUR:
		fseek(self, offset, SEEK_CUR);
		break;
	}
	return acepos;
}

int aceopen(const char *path, int flags)
{
	fseek(self, aceoffset, SEEK_SET);
	return 0;
}

int aceclose(int fd)
{
	fseek(self, aceoffset, SEEK_SET);
	return  0;
}

/*
 * Read the generated log file and remove any files installed.
 */
void delete_files(void)
{
	char tmpbuf[8196], *fileptr;
	FILE *tmplf;
	int linenum=0, found=-1, z;

	files_deleted=1;

	if((tmplf=fopen(instlog, "rb"))==NULL)
		return;

	while(!feof(tmplf))
	{
		fgets(tmpbuf, 8196, tmplf);
		linenum++;
		if(tmpbuf[0]=='[' && (char *)strstr(tmpbuf, INSTALLER_APPLICATION) != NULL && !feof(tmplf))
		{
			fgets(tmpbuf, 8196, tmplf);
			linenum++;
			if((char *)strstr(tmpbuf, "<Version>") != NULL && (char *)strstr(tmpbuf, INSTALLER_VERSION) != NULL)
				found=linenum;
		}
	}
	if(found != -1)
	{
		rewind(tmplf);
		for (z=0;z<found;z++)
			fgets(tmpbuf, 8196, tmplf);
		while(!feof(tmplf))
		{
			fgets(tmpbuf, 8196, tmplf);
			if((char *)strstr(tmpbuf, "<FileInst>") != NULL)
			{
				fileptr = (char *)strchr(tmpbuf, ',')+1;
				/* Remove trailing CRLFs */
				if(fileptr[strlen(fileptr)-1] == '\r' || fileptr[strlen(fileptr)-1] == '\n')
					fileptr[strlen(fileptr)-1]=0;
				if(fileptr[strlen(fileptr)-1] == '\r' || fileptr[strlen(fileptr)-1] == '\n')
					fileptr[strlen(fileptr)-1]=0;
				remove(fileptr);
				current_file--;
				WinSendMsg(mainhwnd, WM_USER, 0, 0);
			}
			if((char *)strstr(tmpbuf, "<End>") != NULL)
			{
				fclose(tmplf);
				return;
			}
		}
	}
	fclose(tmplf);
	return;
}

/*
 * Reads a config file into memory for editing with updatesys, updateset, etc.
 */
int readconfigfile(char *filename)
{
	char tmpbuf[8196];
	FILE *tmpcs;

    /* Reset this value when restarting */
	configfilecount = -1;

	if((tmpcs=fopen(filename, "rb"))==NULL)
	{
        strcpy(currentcf, empty_string);
		return 1;
	}
	else
        strcpy(currentcf, filename);

	while(!feof(tmpcs))
	{
		configfilecount++;
		fgets(tmpbuf, 8196, tmpcs);
		configsys[configfilecount] = malloc(strlen(tmpbuf)+1);
		strcpy(configsys[configfilecount], tmpbuf);
        stripcrlf(configsys[configfilecount]);
	}

	fclose(tmpcs);
	return 0;
}

/*
 * Write the updated config file to disk and backup the original.
 */
int writeconfigfile(char *filename, char *backup)
{
	FILE *tmpcs;
	int i;

	if(backup)
	{
		remove(backup);
		DosMove(filename, backup);
	}
	else
        remove(filename);

	if((tmpcs=fopen(filename, "wb"))==NULL)
		return 1;

	for(i=0;i<configfilecount;i++)
	{
		if(configsys[i])
		{
			fwrite(configsys[i], 1, strlen(configsys[i]), tmpcs);
            /* Add the CRLF that got stripped in the reading stage. */
            fwrite("\r\n", 1, 2, tmpcs);
			free(configsys[i]);
		}
	}

	fclose(tmpcs);
	return 0;
}
/*
 * Adds or replaces a SET variable based on the flags (CONFIG.SYS)
 */
void updateset(char *setname, char *newvalue, int flag)
{
	char *cmpbuf1, *cmpbuf2, *tmpptr, *tmpptr2, *nv;
	int i, z, t;

    nv=replaceem(newvalue);

	cmpbuf1=malloc(strlen(setname)+2);
	strcpy(cmpbuf1, setname);
	strcat(cmpbuf1, "=");
	for(i=0;i<configfilecount;i++)
	{
		if(strlen(cmpbuf1) <= strlen(configsys[i]))
		{
			tmpptr=(char *)strdup(configsys[i]);
			strupr(tmpptr);
			if((tmpptr2=(char*)strstr(tmpptr, "SET "))!=NULL)
			{
				tmpptr2 += 4;
				cmpbuf2=malloc(strlen(tmpptr2)+1);
				/* Remove any spaces from the string */
				z=0;
				for (t=0;t<strlen(tmpptr2) && z < strlen(cmpbuf1);t++)
				{
					if(tmpptr2[t] != ' ')
					{
						cmpbuf2[z]=tmpptr2[t];
						z++;
					}
				}
				cmpbuf2[z]=0;
				if(stricmp(cmpbuf1, cmpbuf2) == 0)
				{
					/* Ok we found the entry, and if UPDATE_ALWAYS change it to the
					 new entry, otherwise exit */
					if(flag == UPDATE_ALWAYS)
					{
#ifdef ENABLE_LOGGING
						fprintf(logfile, "<CFRemLine>,%s,%s\r\n", currentcf, configsys[i]);
#endif
						free(configsys[i]);
						configsys[i] = malloc(strlen(setname)+strlen(nv)+6);
                        strcpy(configsys[i], "SET ");
						strcat(configsys[i], setname);
                        strcat(configsys[i], "=");
						strcat(configsys[i], nv);
#ifdef ENABLE_LOGGING
						fprintf(logfile, "<CFAddLine>,%s,%s\r\n", currentcf, configsys[i]);
#endif
						free(cmpbuf1);free(cmpbuf2);free(tmpptr);
					}
					return;
				}
				free(cmpbuf2);
			}
			free(tmpptr);
		}
	}
	/* Couldn't find the line so we'll add it */
	configsys[configfilecount]=malloc(strlen(cmpbuf1)+strlen(nv)+6);
	strcpy(configsys[configfilecount], "SET ");
	strcat(configsys[configfilecount], setname);
	strcat(configsys[configfilecount], "=");
	strcat(configsys[configfilecount], nv);
#ifdef ENABLE_LOGGING
	fprintf(logfile, "<CFAddLine>,%s,%s\r\n", currentcf, configsys[configfilecount]);
#endif
	configfilecount++;
	free(cmpbuf1);
}     

/*
 * Adds an entry to a system variable (CONFIG.SYS)
 */
void updatesys(char *sysname, char *newvalue)
{
	char *cmpbuf1, *cmpbuf2, *tmpptr, *tmpptr2, *capbuf1, *capbuf2, *nv, *brian;
	int i, z, t;

	nv=replaceem(newvalue);

	cmpbuf1=malloc(strlen(sysname)+2);
	strcpy(cmpbuf1, sysname);
	strcat(cmpbuf1, "=");
	for(i=0;i<configfilecount;i++)
	{
		if(strlen(cmpbuf1) <= strlen(configsys[i]))
		{
			cmpbuf2=malloc(strlen(configsys[i])+1);
			/* Remove any spaces from the string */
			z=0;
			for (t=0;t<strlen(configsys[i]) && z < strlen(cmpbuf1);t++)
			{
				if(configsys[i][t] != ' ')
				{
					cmpbuf2[z]=configsys[i][t];
					z++;
				}
			}
			cmpbuf2[z]=0;
			if(stricmp(cmpbuf1, cmpbuf2) == 0)
			{
				/* Do a case insensitive comparison but preserve the case */
				tmpptr = &configsys[i][t];
				capbuf1=malloc(strlen(tmpptr)+1);
				capbuf2=malloc(strlen(nv)+1);
				strcpy(capbuf1, tmpptr);
				strcpy(capbuf2, nv);
				strupr(capbuf1);
				strupr(capbuf2);
				/* Ok, we found the line, and it doesn't have an entry so we'll add it */
				if((tmpptr2=(char *)strstr(capbuf1, capbuf2)) == NULL)
				{
#ifdef ENABLE_LOGGING
					fprintf(logfile, "<CFRemLine>,%s,%s\r\n", currentcf, configsys[i]);
#endif
					brian = configsys[i];
					configsys[i] = malloc(strlen(configsys[i])+strlen(nv)+4);
					strcpy(configsys[i], brian);
					free(brian);
					/* Remove any trailing CRLFs */
					if(configsys[i][strlen(configsys[i])-1]!=';')
						strcat(configsys[i], ";");
					strcat(configsys[i], nv);
					strcat(configsys[i], ";");
#ifdef ENABLE_LOGGING
					fprintf(logfile, "<CFAddLine>,%s,%s\r\n", currentcf, configsys[i]);
#endif
				}
				free(cmpbuf1);free(cmpbuf2);free(capbuf1);free(capbuf2);
				return;
			}
			free(cmpbuf2);
		}
	}
	/* Couldn't find the line so we'll add it */
	configsys[configfilecount]=malloc(strlen(cmpbuf1)+strlen(nv)+3);
	strcpy(configsys[configfilecount], cmpbuf1);
	strcat(configsys[configfilecount], nv);
	strcat(configsys[configfilecount], ";");
#ifdef ENABLE_LOGGING
	fprintf(logfile, "<CFAddLine>,%s,%s", currentcf, configsys[configfilecount]);
#endif
	configfilecount++;
	free(cmpbuf1);
	if(nv)
		free(nv);
}

/*
 * Removes a line from a config file.
 */
void removeline(char *text)
{
	int z;
	for(z=0;z<configfilecount;z++)
	{
		if(stricmp(configsys[z], text) == 0)
		{
			int t;

#ifdef ENABLE_LOGGING
			fprintf(logfile, "<CFRemLine>,%s,%s\r\n", currentcf, configsys[z]);
#endif
			free(configsys[z]);
			for(t=z;t<(configfilecount-1);t++)
				configsys[t] = configsys[t+1];
			configfilecount--;
		}
	}
}


/*
 * The Window peocedure for the confirmation dialog.
 */
MRESULT	EXPENTRY ConfirmDlgProc(HWND hWnd, ULONG msg, MPARAM mp1,	MPARAM mp2)
{
	SWP winpos;

	switch (msg)
	{
	case WM_INITDLG:
		WinSetWindowText(hWnd, INSTALLER_TITLE);
		WinEnableWindow(WinWindowFromID(mainhwnd, I_Cancel), FALSE);
		WinSetDlgItemText(hWnd,	I_Confirm, confirmstring);
		WinQueryWindowPos(mainhwnd, &winpos);
		WinSetWindowPos(hWnd, HWND_TOP, winpos.x+30, winpos.y+30, 0, 0, SWP_MOVE | SWP_ZORDER);
		break;
	case WM_COMMAND:
		WinEnableWindow(WinWindowFromID(mainhwnd, I_Cancel), TRUE);
		switch ( SHORT1FROMMP(mp1) )
		{
		case I_Ja:
			WinDismissDlg(hWnd, 0);
			break;
		case I_Alle:
			WinDismissDlg(hWnd, 1);
			break;
		case I_Nein:
			WinDismissDlg(hWnd, 2);
			break;
		case I_Halt:
			success=2;
			installstate=ABORTED;
			WinDismissDlg(hWnd, 3);
			break;
		}
		break;
	default :
		return(WinDefDlgProc(hWnd, msg, mp1, mp2));
	}
	return(0L);
}
/*
 * Display a confirmation dialog with the options: YES NO ALL CANCEL
 * Returns: 0 for YES, 1 for ALL, 2 for NO and 3 for CANCEL
 */
int confirm(char *format, ...) {
	va_list args;

	/* if no confirmation, return 1, meaning overwrite all */
	if (stricmp(INSTALLER_CONFIRM_OVERWRITE, "no") == 0)
		return 1;

	va_start(args, format);
	vsprintf(confirmstring, format, args);
	va_end(args);

	return WinDlgBox(HWND_DESKTOP, HWND_DESKTOP, &ConfirmDlgProc, NULLHANDLE, I_Karte, NULL);
}

/*
 * A function to grab a file from an embedded archive and extract it to the TEMP directory.
 */
void grabfile(char *filename)
{
    no_update = 1;
	settempdir();
    remove(filename);
	aceseek_entry(0);
	resetglobals();
	installer_unpack(filename, 2);
    no_update = 0;
}

/*
 * This thread runs along side the main thread allowing the user to cancel the process.
 */
void install_thread(void *param)
{
	HAB ihab = 0;
	HMQ ihmq = 0;
	char tmpinstallpath[1024];
	int  k, j, installcount=0, installed=0;

	(void)param;
    ihab = WinInitialize(0);
	ihmq = WinCreateMsgQueue(ihab, 0);

	installstate = INSTALLING;

#ifdef ENABLE_LOGGING
	if((logfile=fopen(instlog, "ab"))==NULL)
	{
		error("Log file \"%s\" open failed! Installation aborted!", instlog);
		exit(1);
	}

	fprintf(logfile, "[%s]\r\n<Version>,%s\r\n<Start>\r\n", INSTALLER_APPLICATION, INSTALLER_VERSION);
#endif

	/* Create nested subdirectories if necessary. */
	strcpy(tmpinstallpath, installdir);
	for(k=3;k<strlen(installdir);k++)
	{
		if(tmpinstallpath[k] == '\\')
		{
			tmpinstallpath[k] = 0;
			if(DosCreateDir(tmpinstallpath, NULL)==NO_ERROR)
#ifdef ENABLE_LOGGING
				fprintf(logfile, "<NewDir>,%s\r\n", tmpinstallpath);
#else
				;
#endif
			tmpinstallpath[k] = '\\';
		}
	}

	if(DosCreateDir(installdir, NULL)==NO_ERROR)
#ifdef ENABLE_LOGGING
		fprintf(logfile, "<NewDir>,%s\r\n", installdir);
#else
		;
#endif

	if(strlen(installdir) > 0 && installdir[0] > 'a'-1 && installdir[0] < 'z'+1)
		installdir[0]=installdir[0] - ('a'-'A');
	if(strlen(installdir)>2 && installdir[1]==':' && installdir[2]=='\\')
		DosSetDefaultDisk((int)(installdir[0]-'A'+1));

	DosSetCurrentDir(installdir);

	/* Unpack files to destination directory */
	for(j=0;j<INSTALLER_PACKAGE_COUNT;j++)
	{
		if(packagesselected[j] == TRUE)
			installcount++;
	}
	if(installcount == 0)
	{
		mesg("No packages selected for installation!");
	}
	else
	{
		for(j=0;j<INSTALLER_PACKAGE_COUNT;j++)
		{
			if(packagesselected[j] == TRUE)
			{
				char statustext[512];
				aceseek_entry(j);
				resetglobals();
#ifdef SDDINST
				strcpy(statustext, "Press \"Exit Installation\" to Abort.");
#else
				sprintf(statustext,"Copying Files for %s %d/%d, Press \"Exit Installation\" to Abort.", INSTALLER_PACKAGES[j], installed+1, installcount);
#endif
				WinSetDlgItemText(mainhwnd,	I_Info3, statustext);
				/* filename parameter when null is all files */
				installer_unpack(NULL, 2);
				installed++;
			}
		}
	}

	if(success==1)
	{
		WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, "Error unpacking files, Installer may be corrupt!", INSTALLER_TITLE, 0, MB_OK | MB_ERROR | MB_MOVEABLE | MB_SYSTEMMODAL);
	}

	if(success==2)
	{
		WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, "User aborted installation!", INSTALLER_TITLE, 0, MB_OK | MB_ERROR | MB_MOVEABLE | MB_SYSTEMMODAL);
	}

	if(installstate != ABORTED)
		installstate = COMPLETED;

#ifdef SDDINST
	DosCreateDir(replaceem("%BOOTDRIVE%:\\OS2\\DRIVERS\\NUCLEUS\\CONFIG\\MODES"), NULL);
	DosCreateDir(replaceem("%BOOTDRIVE%:\\OS2\\DRIVERS\\NUCLEUS\\CONFIG\\OPTIONS"), NULL);

	setdrivedir(replaceem("%USERPATH%\\disk"));
	if(usescitech)
	{
			char *t = replaceem("/c %USERPATH%\\disk\\setup.cmd sdd ");

			cmdrun(t);

			free(t);
	}
#endif

	WinSendMsg(mainhwnd, WM_USER+1, NULL, NULL);

	WinDestroyMsgQueue(ihmq);
	WinTerminate(ihab);
}
/*
 * Use the information from the .cfg file which is embedded in the EXE to update the
 * CONFIG.SYS settings.
 */
void configsys_update(void)
{
	char *arg1, *arg2, *arg3;
	char temp[5000];
	int z, argn=0;

	if(readconfigfile(csfile))
		return;

    /* Update Miscellaneous lines */
	if(strlen(INSTALLER_SYSLINE)>0)
	{
		char *tmpptr = &temp[0];
        int len;

		strcpy(temp, INSTALLER_SYSLINE);
		temp[4999] = 0;
		len = strlen(temp);

		for(z=0;z<len;z++)
		{
			if(temp[z]==',')
			{
				char *tmpptr2;

				temp[z] = 0;
				tmpptr2 = replaceem(tmpptr);
				tmpptr = &temp[z+1];
				removeline(tmpptr2);
				configsys[configfilecount] = tmpptr2;
#ifdef ENABLE_LOGGING
				fprintf(logfile, "<CFAddLine>,%s,%s\r\n", currentcf, tmpptr2);
#endif
				configfilecount++;
			}
		}
		if(tmpptr && *tmpptr)
		{
			char *tmpptr2;

			tmpptr2 = replaceem(tmpptr);
			removeline(tmpptr2);
			configsys[configfilecount] = tmpptr2;
#ifdef ENABLE_LOGGING
			fprintf(logfile, "<CFAddLine>,%s,%s\r\n", currentcf, tmpptr2);
#endif
			configfilecount++;
		}

	}
	/* Update SET variables */
	if(strlen(INSTALLER_SETS)>0)
	{
		strcpy(temp, INSTALLER_SETS);
        argn=0;
		arg1=&temp[0];
		arg2=arg3=NULL;
		for(z=0;z<strlen(INSTALLER_SETS);z++)
		{
			if(temp[z]==',')
			{
				argn++;
				temp[z]=0;
				switch(argn)
				{
				case 1:
					arg2=&temp[z+1];
					break;
				case 2:
					arg3=&temp[z+1];
					break;
				case 3:
					argn=0;
					updateset(arg1, arg2, (int)(arg3[0]-'0'));
					arg1=&temp[z+1];
					arg2=arg3=NULL;
					break;
				}
			}
		}
        if(arg3)
			updateset(arg1, arg2, (int)arg3-'0');
	}
	/* Update system variables */
	if(strlen(INSTALLER_SYSVAR)>0)
	{
		strcpy(temp, INSTALLER_SYSVAR);
        argn=0;
		arg1=&temp[0];
		arg2=NULL;
		for(z=0;z<strlen(INSTALLER_SYSVAR);z++)
		{
			if(temp[z]==',')
			{
				argn++;
				temp[z]=0;
				switch(argn)
				{
				case 1:
					arg2=&temp[z+1];
					break;
				case 2:
					argn=0;
					updatesys(arg1, arg2);
					arg1=&temp[z+1];
					arg2=NULL;
					break;
				}
			}
		}
        if(arg2)
			updatesys(arg1, arg2);
	}

	writeconfigfile(csfile, bufile);
}

void create_wps_objects(void)
{
	char *arg1, *arg2, *arg3, *arg4, *arg5, *arg6;
	char temp[5000];
	char zerotext[2] = "";
	int z, argn, len;

	/* Create Folder Objects */
	if(strlen(INSTALLER_FOLDER)>0)
	{
		strcpy(temp, replaceem(INSTALLER_FOLDER));
		argn=0;
		arg1=&temp[0];
		arg2=arg3=arg4=arg5=&zerotext[0];
        len = strlen(temp);
		for(z=0;z<len;z++)
		{
			if(temp[z]==',')
			{
				argn++;
				temp[z]=0;
				switch(argn)
				{
				case 1:
					arg2=&temp[z+1];
					break;
				case 2:
					arg3=&temp[z+1];
					break;
				case 3:
					arg4=&temp[z+1];
					break;
				case 4:
					arg5=&temp[z+1];
					break;
				case 5:
					argn=0;
					MakeFolder(arg1, arg2, arg3, arg4, arg5);
#ifdef ENABLE_LOGGING
					fprintf(logfile, "<WPSFolderAdd>,%s,%s,%s,%s,%s\r\n", arg1, arg2,arg3,arg4,arg5);
#endif
					arg1=&temp[z+1];
					arg2=arg3=arg4=arg5=&zerotext[0];
					break;
				}
			}
		}
		MakeFolder(arg1, arg2, arg3, arg4, arg5);
#ifdef ENABLE_LOGGING
		fprintf(logfile, "<WPSFolderAdd>,%s,%s,%s,%s,%s\r\n", arg1, arg2,arg3,arg4,arg5);
#endif
	}

	/* Create Program Objects */
	if(strlen(INSTALLER_PROGRAM)>0)
	{
		strcpy(temp, replaceem(INSTALLER_PROGRAM));
		argn=0;
		arg1=&temp[0];
		arg2=arg3=arg4=arg5=arg6=&zerotext[0];
        len = strlen(temp);
		for(z=0;z<len;z++)
		{
			if(temp[z]==',')
			{
				argn++;
				temp[z]=0;
				switch(argn)
				{
				case 1:
					arg2=&temp[z+1];
					break;
				case 2:
					arg3=&temp[z+1];
					break;
				case 3:
					arg4=&temp[z+1];
					break;
				case 4:
					arg5=&temp[z+1];
					break;
				case 5:
					arg6=&temp[z+1];
					break;
				case 6:
					argn=0;
					MakeProgram(arg1, arg2, arg3, arg4, arg5, arg6);
#ifdef ENABLE_LOGGING
					fprintf(logfile, "<WPSProgramAdd>,%s,%s,%s,%s,%s,%s\r\n", arg1,arg2,arg3,arg4,arg5,arg6);
#endif
					arg1=&temp[z+1];
					arg2=arg3=arg4=arg5=arg6=&zerotext[0];
					break;
				}
			}
		}
		MakeProgram(arg1, arg2, arg3, arg4, arg5, arg6);
#ifdef ENABLE_LOGGING
		fprintf(logfile, "<WPSProgramAdd>,%s,%s,%s,%s,%s,%s\r\n", arg1, arg2,arg3,arg4,arg5,arg6);
#endif
	}

	/* Create Shadow Objects */
	if(strlen(INSTALLER_SHADOW)>0)
	{
		strcpy(temp, replaceem(INSTALLER_SHADOW));
		argn=0;
		arg1=&temp[0];
		arg2=arg3=arg4=&zerotext[0];
        len = strlen(temp);
		for(z=0;z<len;z++)
		{
			if(temp[z]==',')
			{
				argn++;
				temp[z]=0;
				switch(argn)
				{
				case 1:
					arg2=&temp[z+1];
					break;
				case 2:
					arg3=&temp[z+1];
					break;
				case 3:
					arg4=&temp[z+1];
					break;
				case 4:
					argn=0;
					MakeShadow(arg1, arg2, arg3, arg4);
#ifdef ENABLE_LOGGING
					fprintf(logfile, "<WPSShadowAdd>,%s,%s,%s,%s\r\n", arg1,arg2,arg3,arg4);
#endif
					arg1=&temp[z+1];
					arg2=arg3=arg4=&zerotext[0];
					break;
				}
			}
		}
		MakeShadow(arg1, arg2, arg3, arg4);
#ifdef ENABLE_LOGGING
		fprintf(logfile, "<WPSShadowAdd>,%s,%s,%s,%s\r\n", arg1,arg2,arg3,arg4);
#endif
	}

	/* Create Generic Objects */
	if(strlen(INSTALLER_OBJECT)>0)
	{
		strcpy(temp, replaceem(INSTALLER_OBJECT));
		argn=0;
		arg1=&temp[0];
		arg2=arg3=arg4=arg5=&zerotext[0];
        len = strlen(temp);
		for(z=0;z<len;z++)
		{
			if(temp[z]==',')
			{
				argn++;
				temp[z]=0;
				switch(argn)
				{
				case 1:
					arg2=&temp[z+1];
					break;
				case 2:
					arg3=&temp[z+1];
					break;
				case 3:
					arg4=&temp[z+1];
					break;
				case 4:
					arg5=&temp[z+1];
					break;
				case 5:
					argn=0;
					MakeObject(arg1, arg2, arg3, arg4, arg5);
#ifdef ENABLE_LOGGING
					fprintf(logfile, "<WPSObjectAdd>,%s,%s,%s,%s,%s\r\n", arg1,arg2,arg3,arg4,arg5);
#endif
					arg1=&temp[z+1];
					arg2=arg3=arg4=arg5=&zerotext[0];
					break;
				}
			}
		}
		MakeObject(arg1, arg2, arg3, arg4, arg5);
#ifdef ENABLE_LOGGING
		fprintf(logfile, "<WPSObjectAdd>,%s,%s,%s,%s,%s\r\n", arg1, arg2,arg3,arg4,arg5);
#endif
	}
}

/*
 * Reads a line from a file and returns it in raw.
 */
void getline(FILE *f, char *raw)
{
	memset(raw, 0, 256);
	fgets(raw, 255, f);
    stripcrlf(raw);
}

/*
 * Removes a character from a buffer by advancing the buffer to the left.
 */
void removechar(char *buffer, int thisone, int len)
{
	int x;

	for(x=thisone;x<len;x++)
        buffer[x] = buffer[x+1];
}

/*
 * Breaks up a line in raw into it's components.
 */
void parseline(char *raw, char comment, char delimiter, char quotes, char *entry, char *entrydata, char *entrydata2)
{
    char in[256];
	int z, len, in_quotes = 0, entrynum=0, last = 0;

	strcpy(entry, empty_string);
	strcpy(entrydata, empty_string);
	strcpy(entrydata2, empty_string);
	strcpy(in, raw);

	if(in[strlen(in)-1] == '\n')
		in[strlen(in)-1] = 0;

	if(in[0] != comment)
	{
        len=strlen(in);
		for(z=0;z<len;z++)
		{
			if(!in_quotes && in[z] == delimiter)
			{
				in[z] = 0;
                /* Strip any other delimiters */
				z++;
				while(in[z] == delimiter && z < len)
					z++;
                if(!entrynum)
					strcpy(entry, in);
				else
				{
					strcpy(entrydata, &in[last]);
					strcpy(entrydata2, &in[z]);
				}
                last = z;
				if(entrynum)
					return;
                entrynum++;
			}
			if(in[z] == quotes)
			{
				removechar(in, z, len);
				z--;
                len--;
				if(in_quotes)
					in_quotes = 0;
				else
					in_quotes = 1;
			}
		}
		if(!entrynum)
			strcpy(entry, in);
		else
			strcpy(entrydata, &in[last]);
	}
}

/*
 * Reads a line from the file and splits it up into it's components.
 */
void getparseline(FILE *f, char comment, char delimiter, char quotes, char *raw, char *entry, char *entrydata, char *entrydata2)
{
	getline(f, raw);
    parseline(raw, comment, delimiter, quotes, entry, entrydata, entrydata2);
}

/*
 * Window procedure for the package selection dialog when there are multiple
 * packages included in an archive.
 */
MRESULT	EXPENTRY PackageDlgProc(HWND hWnd, ULONG msg, MPARAM mp1,	MPARAM mp2)
{
	int j, i, count = 0;

	switch(msg)
	{
	case WM_INITDLG:
		for(j=0;j<INSTALLER_PACKAGE_COUNT;j++)
			WinSendMsg(WinWindowFromID(hWnd, PACKAGES), LM_INSERTITEM, MPFROMSHORT(LIT_END), MPFROMP(INSTALLER_PACKAGES[j]));
		break;
		/* Process push button selections */
	case WM_CLOSE:
		for(j=0;j<INSTALLER_PACKAGE_COUNT;j++)
			packagesselected[j] = FALSE;
		i = (int)WinSendMsg(WinWindowFromID(hWnd, PACKAGES),
							LM_QUERYSELECTION,
							MPFROMSHORT(LIT_FIRST),0L);
		while(i!=LIT_NONE)
		{
			packagesselected[i] = TRUE;
			i = (int)WinSendMsg(WinWindowFromID(hWnd, PACKAGES),
								LM_QUERYSELECTION,
								(MPARAM)i,0L);
		}
		for(j=0;j<INSTALLER_PACKAGE_COUNT;j++)
		{
			if(packagesselected[j] == TRUE)
				count++;
		}
		if(count == 0)
			packagechosen=FALSE;
		else
			packagechosen=TRUE;

		WinDismissDlg(hWnd, FALSE);
		break;
	case WM_COMMAND:
		switch ( SHORT1FROMMP(mp1) )
		{
		case PB_OK:
			for(j=0;j<INSTALLER_PACKAGE_COUNT;j++)
				packagesselected[j] = FALSE;
			i = (int)WinSendMsg(WinWindowFromID(hWnd, PACKAGES),
								LM_QUERYSELECTION,
								MPFROMSHORT(LIT_FIRST),0L);
			while(i!=LIT_NONE)
			{
				packagesselected[i] = TRUE;
				i = (int)WinSendMsg(WinWindowFromID(hWnd, PACKAGES),
									LM_QUERYSELECTION,
									(MPARAM)i,0L);
			}
			for(j=0;j<INSTALLER_PACKAGE_COUNT;j++)
			{
				if(packagesselected[j] == TRUE)
					count++;
			}
			if(count == 0)
				packagechosen=FALSE;
			else
				packagechosen=TRUE;

			WinDismissDlg(hWnd, FALSE);
			break;
		case PB_CANCEL:
			WinDismissDlg(hWnd, FALSE);
			break;
		case PB_SELECTALL:
			for(j=0;j<INSTALLER_PACKAGE_COUNT;j++)
				WinSendMsg(WinWindowFromID(hWnd, PACKAGES), LM_SELECTITEM, MPFROMSHORT(j), (MPARAM)TRUE);
			break;
		case PB_DESELECTALL:
			WinSendMsg(WinWindowFromID(hWnd, PACKAGES), LM_SELECTITEM, MPFROMSHORT(LIT_NONE), FALSE);
			break;
		}
		break;
		/* Pass through unhandled messages */
	default :
		return(WinDefDlgProc(hWnd, msg, mp1, mp2));
	}
return(0L);
}

/*
 * Configures the container window passed to it for use with populatedir()
 */
void setdir(HWND hwnd)
{
	PFIELDINFO details, first, left = NULL;
	FIELDINFOINSERT detin;
	CNRINFO cnri;
	int z;
	ULONG flData[2] = {  CFA_BITMAPORICON | CFA_CENTER | CFA_HORZSEPARATOR | CFA_SEPARATOR,
	CFA_STRING | CFA_LEFT | CFA_HORZSEPARATOR };
	ULONG offStruct[2] = {
		offsetof(CnrEntry, hptrIcon),
		offsetof(CnrEntry, filename),
	};

    first = details = (PFIELDINFO)WinSendMsg(hwnd, CM_ALLOCDETAILFIELDINFO, MPFROMLONG(2), 0L);
	if(!first)
	{
		mesg("Error creating Directory container!");
		return;
	}
	for(z=0;z<2;z++)
	{
		if(z==1)
			left=details;
		details->cb = sizeof(FIELDINFO);
		details->flData = flData[z];
		details->flTitle = CFA_FITITLEREADONLY;
		switch(z)
		{
		case 0:
			details->pTitleData = "Icon";
			break;
		case 1:
			details->pTitleData = "Name";
			break;
		}
		details->offStruct = offStruct[z];
		details = details->pNextFieldInfo;
	}

	detin.cb = sizeof(FIELDINFOINSERT);
	detin.fInvalidateFieldInfo = FALSE;
	detin.pFieldInfoOrder = (PFIELDINFO) CMA_FIRST;
	detin.cFieldInfoInsert = 2;

	WinSendMsg(hwnd, CM_INSERTDETAILFIELDINFO, MPFROMP(first), MPFROMP(&detin));

	cnri.cb = sizeof(CNRINFO);
	cnri.pFieldInfoLast = left;
	cnri.xVertSplitbar  = 150;
	cnri.flWindowAttr = CV_DETAIL | CV_MINI;
	cnri.slBitmapOrIcon.cx = 15;
	cnri.slBitmapOrIcon.cy = 15;

	WinSendMsg(hwnd, CM_SETCNRINFO, MPFROMP(&cnri),  MPFROMLONG(CMA_FLWINDOWATTR | CMA_SLBITMAPORICON /*| CMA_PFIELDINFOLAST | CMA_XVERTSPLITBAR*/));
}
/*
 * Reads the directory list from the directory specified in the global variable
 * browserdir and populates the container window passed to it.
 */
void populatedir(HWND hwnd)
{
	FILEFINDBUF3 ffb;
    APIRET rc;
	HPOINTER fileicon, foldericon;
	RECORDINSERT recin;
	HDIR hdir = HDIR_CREATE;
	ULONG findcount = 1;
	CnrEntry *direntry, *first;
	int count = 0, j;
	char tmpbuf[201];

	fileicon = WinLoadPointer(HWND_DESKTOP,NULLHANDLE,FILEICON);
	foldericon = WinLoadPointer(HWND_DESKTOP,NULLHANDLE,FOLDERICON);

	strcpy(tmpbuf, browsedir);
	if(tmpbuf[strlen(tmpbuf)-1] == '\\')
		strcat(tmpbuf, "*");
	else
		strcat(tmpbuf, "\\*");

	WinSendMsg(hwnd, CM_REMOVERECORD, (MPARAM)0L, MPFROM2SHORT(0, CMA_INVALIDATE | CMA_FREE));

	if((rc = DosFindFirst(tmpbuf, &hdir, MUST_HAVE_DIRECTORY, &ffb, sizeof(FILEFINDBUF3), &findcount, FIL_STANDARD)) == NO_ERROR)
	{
		while(rc != ERROR_NO_MORE_FILES)
		{
            if(strcmp(ffb.achName, ".") != 0)
				count++;
			rc = DosFindNext(hdir, &ffb, sizeof(FILEFINDBUF3), &findcount);
		}
	}
	DosFindClose(hdir);

	for(j=2;j<27;j++)
	{
		if(drivefree(j) > 0)
            count++;
	}
	hdir = HDIR_CREATE;
	findcount = 1;

	first = direntry = (CnrEntry *)WinSendMsg(hwnd, CM_ALLOCRECORD, MPFROMLONG(sizeof(CnrEntry) - sizeof(RECORDCORE)), MPFROMLONG(count));

	if(!first)
	{
		mesg("Error populating directory");
		return;
	}

	if((rc = DosFindFirst(tmpbuf, &hdir, MUST_HAVE_DIRECTORY, &ffb, sizeof(FILEFINDBUF3), &findcount, FIL_STANDARD)) == NO_ERROR)
	{
		while(rc != ERROR_NO_MORE_FILES)
		{
			if(strcmp(ffb.achName, ".") != 0)
			{
				direntry->hptrIcon = direntry->rc.hptrIcon = foldericon;
				direntry->filename = (char *)strdup(ffb.achName);
				direntry->rc.pszIcon = direntry->filename;
				direntry->rc.pszName = direntry->filename;
				direntry->rc.pszText = direntry->filename;

				direntry = (CnrEntry *)direntry->rc.preccNextRecord;
			}

			rc = DosFindNext(hdir, &ffb, sizeof(FILEFINDBUF3), &findcount);
		}
	}

	DosFindClose(hdir);

	for(j=2;j<27;j++)
	{
		if(drivefree(j) > 0)
		{
			sprintf(tmpbuf, "Drive %c:", ('A'+j)-1);
			direntry->hptrIcon = direntry->rc.hptrIcon = foldericon;
			direntry->filename = (char *)strdup(tmpbuf);
			direntry->rc.pszIcon = direntry->filename;
			direntry->rc.pszName = direntry->filename;
			direntry->rc.pszText = direntry->filename;

			direntry = (CnrEntry *)direntry->rc.preccNextRecord;
		}
	}

	recin.cb = sizeof(RECORDINSERT);
	recin.pRecordOrder = (PRECORDCORE)CMA_END;
	recin.pRecordParent = NULL;
	recin.zOrder = CMA_TOP;
	recin.fInvalidateRecord = TRUE;
	recin.cRecordsInsert = count;

	WinSendMsg(hwnd, CM_INSERTRECORD, MPFROMP(first), MPFROMP(&recin));

	WinDestroyPointer(foldericon);
	WinDestroyPointer(fileicon);
}

/*
 * Thread to spawn the readme file.
 */
void readme(void *param)
{
	HAB zhab;
	HMQ zhmq;
	char *filename = (char *)param;

	zhab = WinInitialize(0);
	zhmq = WinCreateMsgQueue(zhab, 0);

	grabfile(filename); 
	viewfile(filename, zhab);
	remove(filename);

	while (WinGetMsg(zhab, &qmsg, (HWND)NULL, 0, 0))
		WinDispatchMsg(zhab, &qmsg);

	WinSendMsg(mainhwnd, WM_USER+2, NULL, NULL);
	WinDestroyMsgQueue(zhmq);
	WinTerminate(zhab);
}

/*
 * Thread to download the new version and start it up.
 */
void getupdate(void *param)
{
	if(strnicmp(sddurl[downloadsite], "ftp", 3)==0)
	{
		char site[256], *path = empty_string;

		if(strlen(sddurl[downloadsite]) > 6)
		{
			int z, len = strlen(&sddurl[downloadsite][6]);
			for(z = 6; z < len; z++)
			{
				if(sddurl[downloadsite][z] == '/')
				{
					strncpy(site, &sddurl[downloadsite][6], z-6);
					path = &sddurl[downloadsite][z];
					z = len;
				}

			}
			remove(sddfilename);
			if(!ftpget("ftp.scitechsoft.com", "anonymous", "install@scitechsoft.com", NULL, sddfilename, path, "w", T_BINARY))
				error("Error downloading new version.");
			else {
				spawnlp(P_NOWAIT, sddfilename, sddfilename, NULL);
				exit(-1);
				}
		}
		else
			error("Unable to determine path to file.");
	}
}

/*
 * Thread to download the status file and check the version.
 */
void checkforupdates(void *param)
{
	HAB xhab = 0;
	HMQ xhmq = 0;
    char *url = param;

    xhab = WinInitialize(0);
	xhmq = WinCreateMsgQueue(xhab, 0);

	settempdir();
	if(ftpget(url, "anonymous", "install@dbsoft-consulting.com", NULL, "install.ini", "/install.ini", "w", T_BINARY))
	{
        int savestate = installstate;
		error("Unable to connect to update server.  We cannot tell if you have the current version.");
		success=0;
		installstate=savestate;
	}
	else
	{
		FILE *f;

		if((f=fopen("install.ini", "r")) != NULL)
		{
			char raw[256], entry[256], entrydata[256], entrydata2[256];

			while(!feof(f))
			{
				getparseline(f, '#', '=', '\"', raw, entry, entrydata, entrydata2);
				if(stricmp(entry, "location1") == 0)
					strcpy(sddurl[0], entrydata);
				if(stricmp(entry, "location2") == 0)
					strcpy(sddurl[1], entrydata);
				if(stricmp(entry, "location3") == 0)
					strcpy(sddurl[2], entrydata);
				if(stricmp(entry, "location4") == 0)
					strcpy(sddurl[3], entrydata);
				if(stricmp(entry, "version") == 0)
					strcpy(sddversion, entrydata);
				if(stricmp(entry, "filename") == 0)
					strcpy(sddfilename, entrydata);
				if(stricmp(entry, "date") == 0)
					strcpy(sdddate, entrydata);
			}
			fclose(f);
			if(strcmp(OS2_VER, sddversion) != 0)
			{
                installstage++;
				newerver = 1;
				checking = 0;
                checkerror = 0;
				WinEnableWindow(WinWindowFromID(mainhwnd, I_Next), TRUE);
				WinEnableWindow(WinWindowFromID(mainhwnd, I_Cancel), TRUE);
				WinSendMsg(mainhwnd, WM_COMMAND, MPFROMSHORT(I_Next), NULL);
				WinDestroyMsgQueue(xhmq);
				WinTerminate(xhab);
				_endthread();
			}
		}
		else
		{
			int savestate = installstate;
			error("Unable to connect to update server.  We cannot tell if you have the current version.");
			success=0;
			installstate=savestate;
		}

	}

	installstage+=3;
	WinEnableWindow(WinWindowFromID(mainhwnd, I_Next), TRUE);
	WinEnableWindow(WinWindowFromID(mainhwnd, I_Cancel), TRUE);
	WinSendMsg(mainhwnd, WM_COMMAND, MPFROMSHORT(I_Next), NULL);

	WinDestroyMsgQueue(xhmq);
	WinTerminate(xhab);
	newerver = 0;
	checking = 0;
	checkerror = 1;
}

/*
 * Main Window Procedure.  This code handles all the installers dialogs.
 */
MRESULT EXPENTRY DynamicWindowsFilter(HWND hWnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
	ULONG sliderpos = 0;

	switch ( msg )
	{
	/* Process control selections			*/
	case	WM_CONTROL :
		{
			switch ( SHORT2FROMMP(mp1) )
			{
			case LN_SELECT:
                if(SHORT1FROMMP(mp1) == WinQueryWindowUShort(hwndcombo, QWS_ID))
				{
					char tmpbuf[400];
					int i = WinQueryLboxSelectedItem(hwndcombo);

					browsedir[0] = ('A'+drivelist[i])-1;
					populatedir(hwnddir);
					strcpy(tmpbuf, browsedir);
					if(tmpbuf[strlen(tmpbuf)-1] != '\\')
						strcat(tmpbuf, "\\");
					strcat(tmpbuf, &INSTALLER_PATH[3]);
					WinSetWindowText(hwndentry, tmpbuf);
				}
				break;
			case CN_ENTER:
				if(SHORT1FROMMP(mp1) == WinQueryWindowUShort(hwnddir, QWS_ID) && mp2)
				{
					PRECORDCORE current;
					char tmpbuf[400];

					current = ((PNOTIFYRECORDENTER)mp2)->pRecord;

					if(strlen(current->pszIcon) > 7 && strncmp(current->pszIcon, "Drive ", 6) == 0)
					{
						sprintf(browsedir, "%c:\\", current->pszIcon[6]);
					} else if(strcmp(current->pszIcon, "..") != 0)
					{
						if(browsedir[strlen(browsedir)-1] != '\\')
							strcat(browsedir, "\\");
						strcat(browsedir, current->pszIcon);
					}
					else
					{
						int i;

						for(i=strlen(browsedir);i>0;i--)
						{
							if(browsedir[i] == '\\')
							{
								browsedir[i] = 0;
								if(browsedir[1] == ':' && strlen(installdir2) == 2)
									strcat(browsedir, "\\");
								i=-1;
							}
						}
					}
					populatedir(hwnddir);
					strcpy(tmpbuf, browsedir);
					if(tmpbuf[strlen(tmpbuf)-1] != '\\')
						strcat(tmpbuf, "\\");
					strcat(tmpbuf, &INSTALLER_PATH[3]);
					WinSetWindowText(hwndentry, tmpbuf);
				}
				break;
			}
		}
		break;
	case WM_COMMAND:
		{
			int b;

			for(b=0;b<COMMANDMAX;b++)
			{
				if(rexxcommands[b].id &&
				   rexxcommands[b].id == COMMANDMSG(&msg)->cmd)
				{
					char tempbuf[50];

					strcpy(tempbuf, rexxcommands[b].file);
					grabfile(tempbuf);
					rexx_run(tempbuf);
					remove(tempbuf);
                    return (MRESULT)-1;
				}
			}
		}
        break;
	case WM_USER:
		if(!no_update)
		{
			if(pixels==0)
				pixels = SHORT2FROMMP(WinSendMsg(hwndper, SLM_QUERYSLIDERINFO, MPFROM2SHORT(SMA_SLIDERARMPOSITION,SMA_RANGEVALUE), 0));
			if(files!=0)
				sliderpos = (int)(((float)(current_file)/(float)files)*pixels);
			WinSendMsg(hwndper, SLM_SETSLIDERINFO, MPFROM2SHORT(SMA_SLIDERARMPOSITION,SMA_RANGEVALUE), MPFROMLONG(sliderpos-1));
		}
		break;
	case WM_USER+1:
		if(installstate == COMPLETED)
		{
			if(strlen(INSTALLER_PROGRAM) > 0 || strlen(INSTALLER_FOLDER) > 0 || strlen(INSTALLER_SHADOW) >0)
				if((stricmp(INSTALLER_CONFIRM_WPS, "no") == 0) || (WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, "Do you wish to make WPS items on your desktop?", INSTALLER_TITLE, 0, MB_YESNO | MB_INFORMATION | MB_MOVEABLE | MB_SYSTEMMODAL)==MBID_YES))
					create_wps_objects();
			if(strlen(INSTALLER_SETS) > 0 || strlen(INSTALLER_SYSVAR) > 0 || strlen(INSTALLER_SYSLINE) > 0)
				if((stricmp(INSTALLER_CONFIRM_CONFIGSYS, "no") == 0) || (WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, "Do you wish to add the required entries to your CONFIG.SYS?", INSTALLER_TITLE, 0, MB_YESNO | MB_INFORMATION | MB_MOVEABLE | MB_SYSTEMMODAL)==MBID_YES))
					configsys_update();
			grabfile(finishedscript);
			rexx_run(finishedscript);
			remove(finishedscript);
		}
		else
		{
#ifdef ENABLE_LOGGING
			if(WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, "Do you wish to delete the files that were already copied?", INSTALLER_TITLE, 0, MB_YESNO | MB_INFORMATION | MB_MOVEABLE | MB_SYSTEMMODAL)==MBID_YES)
			{
				fprintf(logfile, "<Removed>\r\n<End>\r\n");
				fclose(logfile);
				delete_files();
				current_file=0;
				WinPostMsg(mainhwnd, WM_USER, 0, 0);
			}
#endif
            exit(1);
		}
		break;
	}
	return (MRESULT)-1;
}

/*
 * Main function
 */
int main(int argc, char *argv[])
{
    HMODULE hmod;

	/* Initialization */
	hab = WinInitialize(0);
	hmq = WinCreateMsgQueue(hab, 0);

	if((self = fopen(argv[0], "rb")) == NULL)
	{
		mesg("Could not open SFX archive for reading!");
		exit(1);
	}
	if(loadheader() == FALSE)
	{
		mesg("Could not load all required variables!");
		exit(3);
	}
	strcpy(installdir, INSTALLER_PATH);

	getbootdrive();

	if(DosLoadModule(NULL, 0, "FTPAPI", &hmod) == NO_ERROR)
	{
			if(DosQueryProcAddr(hmod, 0, "ftpget", (PFN *)&ftpget) == NO_ERROR)
					ftpgetfound = 1;
            else
					ftpgetfound = 0;
			DosFreeModule(hmod);
	}

	dw_init(FALSE);
	rexx_init();

	rexx_run("page1.cmd");

    dw_main(0L, DynamicWindowsFilter);
	/* Cleanup */
    rexx_deinit();
	WinDestroyMsgQueue(hmq);
	WinTerminate(hab);
	return 0;
}
