/* $Id: dw.h,v 1.1 2000/03/27 04:52:53 ktk Exp $ */

#ifndef _H_DW
#define _H_DW

/* Used internally */
#define TYPEBOX  0
#define TYPEITEM 1

#define SIZESTATIC 0
#define SIZEEXPAND 1

#define BOXHORZ 0
#define BOXVERT 1

extern HAB dwhab;
extern HMQ dwhmq;

typedef struct _item {
    /* Item type - Box or Item */
	int type;
    /* Handle to Frame or Window */
	HWND hwnd;
    /* Width and Height of static size */
	int width, height, origwidth, origheight;
    /* Size Type - Static or Expand */
	int size;
	/* Padding */
	int pad;
	/* Ratio of current item */
    float xratio, yratio;
} Item;

typedef struct _box {
    /* Number of items in the box */
	int count;
	/* Box type - horizontal or vertical */
	int type;
	/* Padding */
	int pad, parentpad;
	/* Used as temporary storage in the calculation stage */
    int upx, upy, minheight, minwidth;
	/* Ratio in this box */
	float xratio, yratio, parentxratio, parentyratio;
	/* Used for calculating individual item ratios */
    int width, height;
    /* Array of item structures */
	struct _item *items;
} Box;

void dw_box_pack_start_stub(HWND box, HWND item, int width, int height, int size, int pad);
void dw_box_pack_end_stub(HWND box, HWND item, int width, int height, int size, int pad);

/* Public function prototypes */
void dw_box_pack_start(HWND box, HWND item, int width, int height, int size, int pad);
void dw_box_pack_end(HWND box, HWND item, int width, int height, int size, int pad);
int dw_init(int newthread);
void dw_main(HAB currenthab, int (* EXPENTRY func)(HWND, ULONG, MPARAM, MPARAM));
int dw_window_show(HWND handle);
int dw_window_hide(HWND handle);
int dw_window_destroy(HWND handle);
int dw_window_set_font(HWND handle, char *fontname);
int dw_window_set_color(HWND handle, ULONG fore, ULONG back);
HWND dw_window_new(HWND hwndOwner, PSZ title, ULONG flStyle);
HWND dw_box_new(int type, int pad);
HWND dw_groupbox_new(int type, int pad);
HWND dw_bitmap_new(ULONG id);
HWND dw_container_new(ULONG id);
HWND dw_text_new(char *text, ULONG id);
HWND dw_mle_new(ULONG id);
HWND dw_entryfield_new(char *text, ULONG id);
HWND dw_combobox_new(char *text, ULONG id);
HWND dw_button_new(char *text, ULONG id);
HWND dw_spinbutton_new(char *text, ULONG id);
HWND dw_slider_new(ULONG id);
HWND dw_checkbox_new(char *text, ULONG id);
HWND dw_listbox_new(ULONG id);
void dw_window_set_pos(HWND handle, ULONG x, ULONG y);
void dw_window_set_usize(HWND handle, ULONG width, ULONG height);
void dw_window_set_pos_size(HWND handle, ULONG x, ULONG y, ULONG width, ULONG height);
void dw_window_set_style(HWND handle, ULONG style, ULONG mask);
void dw_window_set_icon(HWND handle, ULONG id);
void dw_window_set_bitmap(HWND handle, ULONG id);
BOOL dw_window_set_bitmapfile(HWND handle, char *filename);
void dw_window_set_text(HWND handle, char *text);
void dw_window_disable(HWND handle);
void dw_window_enable(HWND handle);
int dw_screen_width(void);
int dw_screen_height(void);

#endif
