/*
 * romy.c - Mr Romy watchs you
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#define INCL_PM
#include <os2.h>

#define DEBUG

#include "shapewin.h"
#include "romy.h"
#include "romyres.h"
#include "romybmp.h"

/*
 * myname - adjust and save program names
 */

UCHAR   ProgramPath[256] ;
UCHAR   ProgramName[256] ;

static  void    myname(PSZ me)
{
    PUCHAR  p, last ;

    /*
     * full pathname of program
     */

    for (p = me, last = NULL ; *p ; p++) {
        if (*p == '/' || *p == '\\') {
            last = p ;
        }
    }
    if (last != NULL) {
        strcpy(ProgramPath, me) ;
    } else if (DosSearchPath(7, "PATH", me, ProgramPath, 256) != 0) {
        strcpy(ProgramPath, me) ;
    }

    /*
     * basename of program
     */

    for (p = ProgramPath, last = NULL ; *p ; p++) {
        if (*p == '/' || *p == '\\') {
            last = p ;
        }
    }
    if (last == NULL) {
        strcpy(ProgramName, ProgramPath) ;
    } else {
        strcpy(ProgramName, &last[1]) ;
    }
    if ((p = strrchr(ProgramName, '.')) != NULL) {
        *p = '\0' ;
    }
}

/*
 * Error Notify
 */

void    trMessage(PSZ msg)
{
    WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, msg, ProgramName, 0, MB_OK) ;
}

/*
 * initPos - initial Positions from argument (or default)
 */

static  void    initPos(int ac, char *av[], PSWP swp)
{
    POINTL  ptCur  ;
    int     i      ;

    TRACE("InitPos\n") ;
    
    /*
     * default position from Pointer
     */

    WinQueryPointerPos(HWND_DESKTOP, &ptCur) ;
    
    swp->x = ptCur.x ;
    swp->y = ptCur.y ;

    /*
     * change them if option specified
     */

    for (i = 1 ; i < ac ; i++) {
        if (av[i][0] != '-') {
	    continue ;
	}
	switch (av[i][1]) {
	case 'x' :
	case 'X' :
	    if (av[i][2] != '\0') {
	        swp->x = atoi(&av[i][2]) ;
	    } else if ((i + 1) < ac) {
	        swp->x = atoi(av[i+=1]) ;
	    }
	    break ;
	case 'y' :
	case 'Y' :
	    if (av[i][2] != '\0') {
	        swp->y = atoi(&av[i][2]) ;
	    } else if ((i + 1) < ac) {
	        swp->y = atoi(av[i+=1]) ;
	    }
	    break ;
	}
    }
}

/*
 * load/free Bitmap
 */

HDC     hdcBitmap = NULLHANDLE ;
HPS     hpsBitmap = NULLHANDLE ;
HBITMAP hbmBitmap = NULLHANDLE ;

static  void    loadBitmap(HAB hab)
{
    SIZEL   siz ;
    
    hdcBitmap =DevOpenDC(hab, OD_MEMORY, "*", 0, NULL, NULLHANDLE) ;
    siz.cx = siz.cy = 0 ;
    hpsBitmap = GpiCreatePS(hab, hdcBitmap, &siz,
            PU_PELS | GPIF_DEFAULT | GPIT_MICRO | GPIA_ASSOC) ;
    if (hdcBitmap == NULLHANDLE || hpsBitmap == NULLHANDLE) {
        return ;
    }
 
    hbmBitmap = GpiLoadBitmap(hpsBitmap, NULLHANDLE, ID_BITMAP, 0, 0) ;
    GpiSetBitmap(hpsBitmap, hbmBitmap) ;
}

static  void    freeBitmap(void)
{
    if (hbmBitmap != NULLHANDLE) {
        GpiDeleteBitmap(hbmBitmap) ;
	hbmBitmap = NULLHANDLE ;
    }
    if (hpsBitmap != NULLHANDLE) {
        GpiDestroyPS(hpsBitmap) ;
	hpsBitmap = NULLHANDLE ;
    }
    if (hdcBitmap != NULLHANDLE) {
        DevCloseDC(hdcBitmap) ;
	hdcBitmap = NULLHANDLE ;
    }
}

/*
 * Uses two window for control transparent bitmap
 */

HWND    hwndFrame = NULLHANDLE ;    /* Invisible Frame Window   */
HWND    hwndShape = NULLHANDLE ;    /* Shape Window for Bitmap  */

/*
 * drawEyes - draw eye balls on Bitmap (Memory PS)
 */

static  void    calcPos(PPOINTL base, PPOINTL ptr, PPOINTL eye)
{
    int     ix, iy, rad ;
    double  r ;
    
    ix = ptr->x - base->x ;
    iy = ptr->y - base->y ;
    rad = EYE_RO ;
    
    if (((ix *  ix) + (iy * iy)) <= (rad * rad)) {
        eye->x = ptr->x ;
	eye->y = ptr->y ;
    } else {
        r = atan2((double) ix, (double) iy) ;
	eye->x = base->x + (LONG) (sin(r) * (double) rad) ;
	eye->y = base->y + (LONG) (cos(r) * (double) rad) ;
    }
}

static  POINTL  ptLast  = { 0, 0 } ;
static  POINTL  ptCentL = { EYE_XL, EYE_Y } ;
static  POINTL  ptCentR = { EYE_XR, EYE_Y } ;
static  POINTL  ptLastL = { EYE_XL, EYE_Y } ;
static  POINTL  ptLastR = { EYE_XR, EYE_Y } ;
static  RECTL   rctUpdt = { RCT_XL, RCT_YB, RCT_XR, RCT_YT } ;

static  void    drawEyes(void)
{
    ARCPARAMS   arcParam ;
    POINTL      pt ;

    if (hwndFrame == NULLHANDLE || hwndShape == NULLHANDLE) {
        return ;
    }
    if (hpsBitmap == NULLHANDLE) {
        return ;
    }
    
    /*
     * get mouse position, do nothing if not changed
     */
     
    WinQueryPointerPos(HWND_DESKTOP, &pt) ;
    WinMapWindowPoints(HWND_DESKTOP, hwndFrame, &pt, 1) ;

    if (pt.x == ptLast.x && pt.y == ptLast.y) {
        return ;
    }
    ptLast.x = pt.x ;
    ptLast.y = pt.y ;
    
    /*
     * prepare arc params for eye balls
     */
     
    arcParam.lP = EYE_RI ;
    arcParam.lQ = EYE_RI ;
    arcParam.lR = 0 ;
    arcParam.lS = 0 ;
    GpiSetArcParams(hpsBitmap, &arcParam) ;
    
    /*
     * clear last position
     */

    GpiSetColor(hpsBitmap, CLR_BACK) ;
    GpiMove(hpsBitmap, &ptLastL) ;
    GpiFullArc(hpsBitmap, DRO_FILL, (FIXED) 0x10000) ;
    GpiMove(hpsBitmap, &ptLastR) ;
    GpiFullArc(hpsBitmap, DRO_FILL, (FIXED) 0x10000) ;

    /*
     * calc. new positions
     */
    
    calcPos(&ptCentL, &pt, &ptLastL) ;
    calcPos(&ptCentR, &pt, &ptLastR) ;

    /*
     * draw on new positions
     */
     
    GpiSetColor(hpsBitmap, CLR_BALL) ;
    GpiMove(hpsBitmap, &ptLastL) ;
    GpiFullArc(hpsBitmap, DRO_FILL, (FIXED) 0x10000) ;
    GpiMove(hpsBitmap, &ptLastR) ;
    GpiFullArc(hpsBitmap, DRO_FILL, (FIXED) 0x10000) ;

    /*
     * update shape window
     */
    
    WinSendMsg(hwndShape, SHAPEWIN_MSG_UPDATE, MPFROMP(&rctUpdt), NULL) ;
}
 
/*
 * createFrame - create frame window
 */

static  PFNWP   pfnFrame ;
static MRESULT EXPENTRY procFrame(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2) ;

static  void    createFrame(HAB hab)
{
    FRAMECDATA  fcd    ;

    memset(&fcd, 0, sizeof(fcd)) ;
    fcd.cb = sizeof(fcd) ;
    fcd.flCreateFlags = (FCF_TASKLIST | FCF_ICON) ;
    fcd.hmodResources = NULLHANDLE ;
    fcd.idResources   = ID_ROMY    ;   

    hwndFrame = WinCreateWindow(
            HWND_DESKTOP,           /* Parent window handle     */
            WC_FRAME,               /* Frame Window Class       */
            ProgramName,            /* as Title                 */
            0,                      /* Window Style             */
            0, 0, 0, 0,             /* Position & size          */
            NULLHANDLE,             /* Owner Window             */
            HWND_TOP,               /* Z-Order                  */
            0,                      /* Window ID                */
            &fcd,                   /* Control Data             */
            NULL) ;                 /* Presentation Parameter   */

    if (hwndFrame == NULLHANDLE) {
        return ;
    }

    pfnFrame = WinSubclassWindow(hwndFrame, procFrame) ;

    WinSendMsg(hwndFrame, WM_SETICON, 
        MPFROMP(WinLoadPointer(HWND_DESKTOP, NULLHANDLE, ID_ROMY)), NULL) ;
}

/*
 * createShape - create shape window
 */

static  void    createShape(HAB hab)
{
    BITMAPINFOHEADER2   bmi ;
    SHAPEWIN    shpctrl ;
    
    if (hwndFrame == NULLHANDLE) {
        return ;
    }
    if (hpsBitmap == NULLHANDLE || hbmBitmap == NULLHANDLE) {
        return ;
    }
    bmi.cbFix = sizeof(bmi) ;
    GpiQueryBitmapInfoHeader(hbmBitmap, &bmi) ;
    
    /*
     * Register Window Class
     */
     
    WinRegisterClass(hab, ShapeWinName, ShapeWinProc, 0L, sizeof(PVOID)) ;

    /*
     * Create Image Window
     */

    shpctrl.cx = bmi.cx ;
    shpctrl.cy = bmi.cy ;
    shpctrl.hpsDraw = hpsBitmap ;
    shpctrl.hpsMask = hpsBitmap ;
    
    hwndShape = WinCreateWindow(
            HWND_DESKTOP,           /* Parent Window    */
            ShapeWinName,           /* Window Class     */
	    NULL,                   /* Window Text      */
	    0,                      /* Window Style     */
	    0, 0, 0, 0,             /* Pos & Size       */
	    hwndFrame,              /* Owner Window     */
	    HWND_TOP,               /* Z-Order          */
	    0,                      /* Window ID        */
	    &shpctrl,               /* Control Data     */
	    NULL) ;                 /* Pres. Param.     */
    
    if (hwndShape == NULLHANDLE) {
        return ;
    }
}

/*
 * placeStartup - set startup position
 */

static  void    placeStartup(PSWP swp)
{
    SWP     swpScreen ;
    BITMAPINFOHEADER2   bmi ;
    SHORT   x, y ;
    
    if (hbmBitmap == NULLHANDLE || hwndFrame == NULLHANDLE || hwndShape == NULLHANDLE) {
        return ;
    }
    
    x = swp->x ;
    y = swp->y ;
    
    bmi.cbFix = sizeof(bmi) ;
    GpiQueryBitmapInfoHeader(hbmBitmap, &bmi) ;

    WinQueryWindowPos(HWND_DESKTOP, &swpScreen) ;

    if ((x + bmi.cx) > swpScreen.cx) {
        x = swpScreen.cx - bmi.cx ;
    }
    if ((y + bmi.cy) > swpScreen.cy) {
        y = swpScreen.cy - bmi.cy ;
    }
    
    WinSetWindowPos(hwndFrame, NULLHANDLE, 
                    x, y, bmi.cx, bmi.cy, (SWP_MOVE | SWP_SIZE | SWP_HIDE)) ;
    WinSetWindowPos(hwndShape, NULLHANDLE, 
                    x, y, bmi.cx, bmi.cy, (SWP_MOVE | SWP_SIZE | SWP_SHOW)) ;
}

/*
 * context menu
 */

static  HWND    hwndPopup = NULLHANDLE ;    /* context menu */
 
static  void    contextMenu(void)
{
    POINTL  pt   ;
    ULONG   opts ;
    
    if (hwndPopup == NULLHANDLE) {
        hwndPopup = WinLoadMenu(hwndFrame, NULLHANDLE, IDM_POPUP) ;
    }
    if (hwndPopup == NULLHANDLE) {
        printf("failed to load opup menu\n") ;
        return ;
    }
    
    WinQueryPointerPos(HWND_DESKTOP, &pt) ;

    opts = PU_HCONSTRAIN | PU_VCONSTRAIN |
	     PU_KEYBOARD | PU_MOUSEBUTTON1 | PU_MOUSEBUTTON2 ;

    WinPopupMenu(HWND_DESKTOP, hwndFrame, hwndPopup, 
                                pt.x, pt.y, IDM_HIDE, opts) ;
}

/*
 * ABOUT dialog box
 */

static  MRESULT EXPENTRY procAbout(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    HAB     hab ;
    UCHAR   buff[256] ;
    
    switch (msg) {
    
    case WM_INITDLG :
        hab = WinQueryAnchorBlock(hwnd) ;
	WinSendMsg(WinWindowFromID(hwnd, IDD_ROMYTTL), 
                    EM_SETTEXTLIMIT, MPFROMSHORT(128), NULL) ;
	WinSendMsg(WinWindowFromID(hwnd, IDD_ROMYURL), 
                    EM_SETTEXTLIMIT, MPFROMSHORT(128), NULL) ;
        WinLoadString(hab, NULLHANDLE, IDS_ROMYTTL, 256, buff) ;
	WinSetWindowText(WinWindowFromID(hwnd, IDD_ROMYTTL), buff) ;
        WinLoadString(hab, NULLHANDLE, IDS_ROMYURL, 256, buff) ;
	WinSetWindowText(WinWindowFromID(hwnd, IDD_ROMYURL), buff) ;
        return (MRESULT) 0 ;

    case WM_COMMAND :
        switch (SHORT1FROMMP(mp1)) {
	case DID_OK :
	case DID_CANCEL :
	    WinDismissDlg(hwnd, DID_OK) ;
	    return (MRESULT) 0 ;
        }
    }
    return WinDefDlgProc(hwnd, msg, mp1, mp2) ;
}
 
/*
 * procFrame - sub-classed frame window procedure
 */

static  BOOL    inDialog = FALSE ;

static MRESULT EXPENTRY procFrame(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    PSWP    pswp ;
    SHORT   x, y ;
    
    TRACE("frame %08x %08x %08x\n", msg, mp1, mp2) ;
    
    switch (msg) {
        
    case WM_ADJUSTWINDOWPOS :
        pswp = (PSWP) PVOIDFROMMP(mp1) ;
        if (! inDialog) {
            WinSetWindowPos(hwndShape, pswp->hwndInsertBehind,
        	    pswp->x, pswp->y, pswp->cx, pswp->cy, pswp->fl) ;
        }
	pswp->fl &= ~SWP_SHOW ;
	pswp->fl |=  SWP_HIDE ;
	return (*pfnFrame) (hwnd, msg, mp1, mp2) ;

    case WM_SINGLESELECT :
        WinSetWindowPos(hwndShape, HWND_TOP, 0, 0, 0, 0, SWP_ZORDER) ;
	return (MRESULT) 0 ;
	            
    case WM_BEGINDRAG :
        WinSendMsg(hwndFrame, WM_TRACKFRAME, 
	        MPFROMSHORT(TF_MOVE | TF_SETPOINTERPOS), NULL) ;
        return (MRESULT) 0 ;

    case WM_CONTEXTMENU :
        contextMenu() ;
        return (MRESULT) 0 ;
	
    case WM_COMMAND :
        switch (SHORT1FROMMP(mp1)) {
	case IDM_MOVE :
            WinSendMsg(hwndFrame, WM_TRACKFRAME, 
                    MPFROMSHORT(TF_MOVE | TF_SETPOINTERPOS), NULL) ;
            return (MRESULT) 0 ;
	case IDM_HIDE :
	    WinShowWindow(hwnd, FALSE) ;
	    return (MRESULT) 0 ;
	case IDM_ABOUT :
            inDialog = TRUE ;
	    WinDlgBox(HWND_DESKTOP, hwnd, procAbout, NULLHANDLE, IDD_ABOUT, NULL) ;
	    inDialog = FALSE ;
	    return (MRESULT) 0 ;
	case IDM_EXIT  :
	    WinPostMsg(hwnd, WM_CLOSE, NULL, NULL) ;
	    return (MRESULT) 0 ;
        }
        return (MRESULT) 0 ;

    case WM_TIMER :
        drawEyes() ;
	return (MRESULT) 0 ;
    }
    return (*pfnFrame) (hwnd, msg, mp1, mp2) ;
}
 
/*
 * main - program start here
 */

int     main(int ac, char *av[])
{
    HAB     hab  ;
    HMQ     hmq  ;
    QMSG    qmsg ;
    SWP     swp  ;
    
    myname(av[0]) ;
    _wildcard(&ac, &av) ;

    hab = WinInitialize(0) ;
    hmq = WinCreateMsgQueue(hab, 0) ;
    
    initPos(ac, av, &swp) ;

    loadBitmap(hab) ;
    
    if (hbmBitmap == NULLHANDLE) {
        trMessage("failed to load bitmap") ;
        freeBitmap() ;
        WinDestroyMsgQueue(hmq) ;
        WinTerminate(hab) ;
	return 1 ;
    }
    
    /*
     * Start Window Processing
     */

    createFrame(hab) ;
    createShape(hab) ;

    if (hwndFrame == NULLHANDLE || hwndShape == NULLHANDLE) {    
        trMessage("failed to create windows") ;
	if (hwndFrame != NULLHANDLE) WinDestroyWindow(hwndFrame) ;
	if (hwndShape != NULLHANDLE) WinDestroyWindow(hwndShape) ;
        freeBitmap() ;
        WinDestroyMsgQueue(hmq) ;
        WinTerminate(hab) ;
	return 1 ;
    }
    
    placeStartup(&swp) ;
    WinStartTimer(hab, hwndFrame, 1, 200) ;
    
    while (WinGetMsg(hab, &qmsg, 0, 0, 0)) {
        WinDispatchMsg(hab, &qmsg) ;
    }

    /*
     * dispose resources
     */
    
    WinDestroyWindow(hwndFrame)  ;
    WinDestroyWindow(hwndShape) ;

    freeBitmap() ;
    
    WinDestroyMsgQueue(hmq) ;
    WinTerminate(hab) ;
    
    return 0 ; 
}
