/*
** Module   :PLE_REXX.C
** Abstract :FDK Rexx library
**
** Copyright (C) Link Guard Solutions
** For conditions of distribution and use, see license in license.txt
**
** Log: Fri  23/02/2001 Created
**
*/
#define INCL_REXXSAA
#define INCL_DOS
#define INCL_DOSERRORS

#include <sftypes.h>

#include <os2.h>
#include <rexxsaa.h>
#include <stdlib.h>
#include <string.h>

#define EN_LOAD         1
#define EN_CONFIG       2
#define EN_WRITE        4
#define EN_DONE         8

#define SECT_MAXNAME    80

#define SNAME_VAR   	"script"

#define FNAME_QUERY 	"QUERY"
#define FNAME_LOAD  	"LOAD"
#define FNAME_CONFIG    "CONFIG"
#define FNAME_WRITE     "W"
#define FNAME_DONE      "DONE"

dword numinstances = 0;
HMTX  mutex = -1L;

typedef struct
{
    dword enabled;
    char  scriptname[CCHMAXPATH];
    char  sectname[SECT_MAXNAME];
    dword sectnamelen; //Cache value to produce RXSTRING faster

} scriptdata;

dword getenabled(scriptdata *d)
{
    if (d->enabled)
        return d->enabled;

    if (!d->scriptname[0])
        return 0;

    /* Try to load script */
    {
        RXSTRING retstr;
        RXSTRING argv[2];

        LONG startrc = 0;
        SHORT rexxrc = 0;

        char *retptr;

        retstr.strptr = 0;
        retstr.strlength = 0;

        MAKERXSTRING(argv[0], FNAME_QUERY, sizeof(FNAME_QUERY) - 1);

        if (mutex != -1L)
            startrc = DosRequestMutexSem(mutex, SEM_INDEFINITE_WAIT);

        if (startrc == NO_ERROR)
        {
            startrc = RexxStart(1,
                                argv,
                                d->scriptname,
                                0,
                                "CMD",
                                RXCOMMAND,
                                0,
                                &rexxrc,
                                &retstr);

            retptr = RXSTRPTR(retstr);

            if (retptr)
            {
                if (!startrc)
                    d->enabled = atol(retptr);

                DosFreeMem(retptr);
            }

            if (d->enabled & EN_LOAD)
            {
                /* Call load */
                retstr.strptr = 0;
                retstr.strlength = 0;

                rexxrc = 0;

                MAKERXSTRING(argv[0], FNAME_LOAD, sizeof(FNAME_LOAD) - 1);
                MAKERXSTRING(argv[1], d->sectname, d->sectnamelen);

                startrc = RexxStart(2,
                                    argv,
                                    d->scriptname,
                                    0,
                                    "CMD",
                                    RXCOMMAND,
                                    0,
                                    &rexxrc,
                                    &retstr);

	            retptr = RXSTRPTR(retstr);

                if (retptr)
	                DosFreeMem(retptr);

            }

            if (mutex != -1L)
	            DosReleaseMutexSem(mutex);
        }
    }

    if (d->enabled == 0)
    {
        //This is WRONG script. Clear it's name
        d->scriptname[0] = 0;
    }

    return d->enabled;
}

void APIENTRY Init11(char *name, dword *plidx)
{
    scriptdata *d = malloc(sizeof(scriptdata));
    d->enabled = 0;
    strncpy(d->sectname, name, SECT_MAXNAME);
    d->sectname[SECT_MAXNAME - 1] = 0;
    d->sectnamelen = strlen(d->sectname);
    d->scriptname[0] = 0;
    *plidx = (dword)d;

    if (!numinstances)
    {
        /* Create Mutex */
        if (DosCreateMutexSem(0, &mutex, 0, FALSE))
            mutex = -1L;
    }
    numinstances++;
}

void APIENTRY Config11(dword plidx, char *var, char *val)
{
    scriptdata *d = (scriptdata *)plidx;

    if (!stricmp(var, SNAME_VAR))
    {
        /* New script */
        d->enabled = 0;
        strncpy(d->scriptname, val, CCHMAXPATH);
        d->scriptname[CCHMAXPATH - 1] = 0;
    }
    if (getenabled(d) & EN_CONFIG)
    {
        /* Pass configuration to plugin */
        RXSTRING retstr;
        RXSTRING argv[4];

        LONG startrc = 0;
        SHORT rexxrc = 0;

        char *retptr;

        retstr.strptr = 0;
        retstr.strlength = 0;

        MAKERXSTRING(argv[0], FNAME_CONFIG, sizeof(FNAME_CONFIG) - 1);
        MAKERXSTRING(argv[1], d->sectname, d->sectnamelen);
        MAKERXSTRING(argv[2], var, strlen(var));
        MAKERXSTRING(argv[3], val, strlen(val));

        if (mutex != -1L)
            startrc = DosRequestMutexSem(mutex, SEM_INDEFINITE_WAIT);

        if (startrc == NO_ERROR)
        {
            startrc = RexxStart(4,
                                argv,
                                d->scriptname,
                                0,
                                "CMD",
                                RXCOMMAND,
                                0,
                                &rexxrc,
                                &retstr);

            retptr = RXSTRPTR(retstr);

            if (retptr)
                DosFreeMem(retptr);

            if (mutex != -1L)
                DosReleaseMutexSem(mutex);
        }
    }
}

dword APIENTRY Write11(dword plidx, Bool source, dword proto, char *packet, dword psize, dword idx)
{
    scriptdata *d = (scriptdata *)plidx;
    dword rc = 0;

    if (getenabled(d) & EN_WRITE)
    {
        /* Pass configuration to plugin */
        RXSTRING retstr;
        RXSTRING argv[6];
        char     pstr[33];

        LONG startrc = 0;
        SHORT rexxrc = 0;

        char *retptr;

        retstr.strptr = 0;
        retstr.strlength = 0;

        MAKERXSTRING(argv[0], FNAME_WRITE, sizeof(FNAME_WRITE) - 1);
        MAKERXSTRING(argv[1], d->sectname, d->sectnamelen);
        MAKERXSTRING(argv[2], source ? "IN2" : "IN1", 3);
        MAKERXSTRING(argv[3], &proto, 4);
        MAKERXSTRING(argv[4], packet, psize);
        MAKERXSTRING(argv[5], &idx, 4);

        if (mutex != -1L)
            startrc = DosRequestMutexSem(mutex, SEM_INDEFINITE_WAIT);

        if (startrc == NO_ERROR)
        {
            startrc = RexxStart(6,
                                argv,
                                d->scriptname,
                                0,
                                "CMD",
                                RXCOMMAND,
                                0,
                                &rexxrc,
                                &retstr);

            retptr = RXSTRPTR(retstr);

            if (retptr)
            {
                rc = atol(retptr);
                DosFreeMem(retptr);
            }

            if (mutex != -1L)
                DosReleaseMutexSem(mutex);
        }
    }
    return rc;
}

void APIENTRY Done11(dword plidx)
{
    scriptdata *d = (scriptdata *)plidx;

    if (getenabled(d) & EN_DONE)
    {
        /* Call load */
        RXSTRING retstr;
        RXSTRING argv[2];

        LONG startrc = 0;
        SHORT rexxrc = 0;

        char *retptr;

        retstr.strptr = 0;
        retstr.strlength = 0;

        rexxrc = 0;

        MAKERXSTRING(argv[0], FNAME_DONE, sizeof(FNAME_DONE) - 1);
        MAKERXSTRING(argv[1], d->sectname, d->sectnamelen);

        startrc = RexxStart(2,
                            argv,
                            d->scriptname,
                            0,
                            "CMD",
                            RXCOMMAND,
                            0,
                            &rexxrc,
                            &retstr);

        retptr = RXSTRPTR(retstr);

        if (retptr)
            DosFreeMem(retptr);
    }

    free(d);

    numinstances--;
    if (numinstances == 0)
    {
        DosCloseMutexSem(mutex);
        mutex = -1L;
    }
}


