/*
** Module   :SFPROTO.H
** Abstract :SafeFire Plugin Manager Protocol numbering
**
** Copyright (C) Link Guard Solutions
** For conditions of distribution and use, see license in license.txt
**
** Log: Thu  21/12/2000 Created
**
*/

#ifndef __SFPROTO_H
#define __SFPROTO_H


/* Next ranges of protocols are defined */

/* PPP Range from 0x0000 to 0xFFFF */
#define PPLOPT_PPPBASE     0

/* PPP IP protocol */
#define PPPNUM_IP   (PPLOPT_PPPBASE + 0x0021)

/* Ethernet Range from 0x10000 to 0x1FFFF */
#define PPLOPT_ETHERBASE   0x10000

/* Ethernet IP protocol */
#define ETHNUM_IP   (PPLOPT_ETHERBASE + 0x0800)

/* Special protocols that need single protocol number. 0x20000 to 0x2FFFF */
#define PPLOPT_SPECIAL     0x20000

/* Stream protocol to pass not packets, but data stream */
#define PPLOPT_STREAM      (PPLOPT_SPECIAL + 1)

/* SafeFire Plugin Manager options start from 0x10000000 */
#define PPLOPT_BASE        0x10000000

// IP Options
#define PPLIPOPT_BASE      (PPLOPT_BASE + 0x1000)

// Your IP (4 bytes)
#define PPLIPOPT_IP         (1 + PPLIPOPT_BASE)
// Peer's IP (4 bytes)
#define PPLIPOPT_PEERIP     (2 + PPLIPOPT_BASE)
// Netmask (4 bytes)
#define PPLIPOPT_NETMASK    (3 + PPLIPOPT_BASE)
// Primary DNS (4 bytes)
#define PPLIPOPT_PRIDNS     (4 + PPLIPOPT_BASE)
// Secondary DNS (4 bytes)
#define PPLIPOPT_SECDNS     (5 + PPLIPOPT_BASE)

//  LCP options
#define PPLLCPOPT_BASE      (PPLOPT_BASE + 0x2000)

/*
If peer will send self-described padding packets
Protocols that specified to know SDP must
Remove padding by themselves
Data is dword contains either MPV if padding is on
Or 0 if there will be no padding
*/
#define PPLLCPOPT_SDPAD     (1 + PPLLCPOPT_BASE)

//Ethernet options
#define PPLETHER_BASE      (PPLOPT_BASE + PPLOPT_ETHERBASE)

/*
MAC Transfers single multicast address to be registered by Protocol Driver
Data is Multicast address
*/
#define PPLETHER_MCAST     (PPLETHER_BASE + 1)

/*
Protocol transfers address to be set to MAC
*/
#define PPLETHER_MACADDR   (PPLETHER_BASE + 2)



#endif  /*__SFPROTO_H*/

