/*
** Module   :ENTRIES.H
** Abstract :Describes DLL entry points
**
** Copyright (C) Link Guard Solutions
** For conditions of distribution and use, see license in license.txt
**
** Log: Thu  21/12/2000 Created
**
*/

#include "sftypes.h"

#ifndef __ENTRIES_H
#define __ENTRIES_H

#ifndef APIENTRY
#define APIENTRY    _System
#endif

typedef void APIENTRY DLLinit(char *name); //DLLinit v.1.0 definition
typedef DLLinit *pDLLinit;
typedef void APIENTRY NDLLinit(char *name, dword *plidx); //DLLinit v.1.1 definition
typedef NDLLinit *pNDLLinit;
#define nDLLinit    200 //DLLinit v.1.0 ordinal
#define nNDLLinit   205 //DLLinit v.1.1 ordinal

typedef void APIENTRY DLLsconfig(char *var, char *val); //DLLsconfig v.1.0 definition
typedef DLLsconfig *pDLLsconfig;
typedef void APIENTRY NDLLsconfig(dword plidx, char *var, char *val); //DLLsconfig v.1.1 definition
typedef NDLLsconfig *pNDLLsconfig;
#define nDLLsconfig 201 //DLLsconfig v.1.0 ordinal
#define nNDLLsconfig 206 //DLLsconfig v.1.1 ordinal

typedef dword APIENTRY DLLwrite(Bool source, dword proto, char *packet, dword psize, dword idx); //DLLwrite v.1.0 definition
typedef DLLwrite *pDLLwrite;
typedef dword APIENTRY NDLLwrite(dword plidx, Bool source, dword proto, char *packet, dword psize, dword idx); //DLLwrite v.1.1 definition
typedef NDLLwrite *pNDLLwrite;
#define nDLLwrite   202 //DLLwrite v.1.0 ordinal
#define nNDLLwrite  207 //DLLwrite v.1.1 ordinal

typedef void APIENTRY NDLLdone(dword plidx); //DLLdone v.1.1 definition
typedef NDLLdone *pNDLLdone;
#define nNDLLdone   208

#endif  /*__ENTRIES_H*/

